/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.memory;

import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.ui.memory.PICLMemoryBlock;
import com.ibm.debug.pdt.internal.ui.preferences.PreferenceUI;
import com.ibm.debug.pdt.ui.IOrderableMemoryRenderingType;
import java.util.ArrayList;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.memory.IMemoryRenderingType;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;

public class DefaultRenderingDialog
extends MessageDialog {
    private IMemoryRenderingType[] fRenderingTypes;
    private List fList;
    private int fSelected = -1;

    public DefaultRenderingDialog(Shell parentShell) {
        super(parentShell, PICLLabels.SelectDefaultRendering, null, null, 0, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
        IMemoryRenderingType[] types2 = DebugUITools.getMemoryRenderingManager().getRenderingTypes((IMemoryBlock)new PICLMemoryBlock());
        ArrayList<IMemoryRenderingType> acceptableTypes = new ArrayList<IMemoryRenderingType>();
        IMemoryRenderingType[] iMemoryRenderingTypeArray = types2;
        int n = types2.length;
        int n2 = 0;
        while (n2 < n) {
            IMemoryRenderingType type = iMemoryRenderingTypeArray[n2];
            if (!(type instanceof IOrderableMemoryRenderingType)) {
                acceptableTypes.add(type);
            }
            ++n2;
        }
        this.fRenderingTypes = acceptableTypes.toArray(new IMemoryRenderingType[acceptableTypes.size()]);
    }

    protected Control createCustomArea(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(PICLLabels.SelectDefaultRenderingText);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)label);
        this.fList = new List(parent, 2052);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.fList);
        this.fList.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DefaultRenderingDialog.this.fSelected = DefaultRenderingDialog.this.fList.getSelectionIndex();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                DefaultRenderingDialog.this.fSelected = DefaultRenderingDialog.this.fList.getSelectionIndex();
                DefaultRenderingDialog.this.okPressed();
            }
        });
        int defaultIdx = -1;
        int i = 0;
        String defaultRenderingId = PreferenceUI.getDefaultRenderingId();
        IMemoryRenderingType[] iMemoryRenderingTypeArray = this.fRenderingTypes;
        int n = this.fRenderingTypes.length;
        int n2 = 0;
        while (n2 < n) {
            IMemoryRenderingType rendering = iMemoryRenderingTypeArray[n2];
            this.fList.add(rendering.getLabel());
            if (rendering.getId().equals(defaultRenderingId)) {
                defaultIdx = i;
            }
            ++i;
            ++n2;
        }
        if (defaultIdx != -1) {
            this.fList.select(defaultIdx);
        }
        return parent;
    }

    public String getSelectedRenderingId() {
        if (this.fSelected != -1) {
            return this.fRenderingTypes[this.fSelected].getId();
        }
        return "";
    }
}

