/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.launchconfig;

import com.ibm.debug.pdt.internal.core.PDTDebugTarget;
import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.core.util.PDTCoreUtils;
import com.ibm.debug.pdt.internal.ui.PICLDebugPlugin;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import com.ibm.debug.xmlui.api.XUIAttribute;
import com.ibm.debug.xmlui.api.XUIAttributeList;
import com.ibm.debug.xmlui.ui.XUIBuilder;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationListener;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.part.PageBook;

public class EnginePreferenceTab
extends AbstractLaunchConfigurationTab {
    private Listener fWidgetListener;
    private ILaunchConfigurationListener fLaunchConfigListener;
    private ILaunchConfiguration fOriginalConfiguration;
    private PageBook fPageBook;
    private Composite fBlankPage;
    private Map<ILaunchConfiguration, XMLComposite> fXMLPages = new HashMap<ILaunchConfiguration, XMLComposite>();

    public void createControl(Composite parent) {
        this.fPageBook = new PageBook(parent, 0);
        this.setControl((Control)this.fPageBook);
        this.fBlankPage = new Composite((Composite)this.fPageBook, 0);
        GridLayout layout = new GridLayout();
        this.fBlankPage.setLayout((Layout)layout);
        this.fBlankPage.setLayoutData((Object)new GridData(1808));
        Label blankLabel = new Label(this.fBlankPage, 64);
        blankLabel.setText(PICLLabels.EnginePreferencesTab_not_available_label);
        blankLabel.setLayoutData((Object)new GridData(768));
        this.fWidgetListener = new Listener(){

            public void handleEvent(Event event) {
                if (EnginePreferenceTab.this.fXMLPages == null || !EnginePreferenceTab.this.fXMLPages.containsKey(EnginePreferenceTab.this.fOriginalConfiguration)) {
                    return;
                }
                EnginePreferenceTab.this.setDirty(true);
                EnginePreferenceTab.this.updateLaunchConfigurationDialog();
            }
        };
        this.fLaunchConfigListener = new ILaunchConfigurationListener(){

            public void launchConfigurationRemoved(ILaunchConfiguration configuration) {
            }

            public void launchConfigurationAdded(ILaunchConfiguration configuration) {
            }

            public void launchConfigurationChanged(ILaunchConfiguration configuration) {
                if (configuration instanceof ILaunchConfigurationWorkingCopy) {
                    return;
                }
                if (!EnginePreferenceTab.this.fOriginalConfiguration.contentsEqual(configuration)) {
                    return;
                }
                if (EnginePreferenceTab.this.isDirty()) {
                    if (PICLDebugPlugin.fPDT) {
                        PICLUtils.logString(this, " tab has been modified and saved, sending changes to engine(s) for:  " + configuration.getName());
                    }
                    EnginePreferenceTab.this.setDirty(false);
                    EnginePreferenceTab.this.updateEnginesWithModifiedPreferences(configuration);
                    return;
                }
            }
        };
        DebugPlugin.getDefault().getLaunchManager().addLaunchConfigurationListener(this.fLaunchConfigListener);
    }

    public void dispose() {
        this.fPageBook = null;
        this.fBlankPage = null;
        this.fXMLPages = null;
        this.fOriginalConfiguration = null;
        this.fWidgetListener = null;
        if (this.fLaunchConfigListener != null) {
            DebugPlugin.getDefault().getLaunchManager().removeLaunchConfigurationListener(this.fLaunchConfigListener);
        }
        super.dispose();
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            XMLComposite xmlComp;
            if (PICLDebugPlugin.fPDT) {
                PICLUtils.logString((Object)this, " initializeFrom " + configuration.getName());
            }
            this.setDirty(false);
            boolean isOriginalConfig = true;
            this.fOriginalConfiguration = configuration;
            if (configuration instanceof ILaunchConfigurationWorkingCopy) {
                isOriginalConfig = false;
                this.fOriginalConfiguration = ((ILaunchConfigurationWorkingCopy)configuration).getOriginal();
            }
            if (isOriginalConfig || !this.fXMLPages.containsKey(this.fOriginalConfiguration)) {
                String prefXML;
                if (PICLDebugPlugin.fPDT) {
                    PICLUtils.logString((Object)this, " building new XML UI " + configuration.getName());
                }
                if ((prefXML = PICLUtils.getPreferencePageXML(configuration)) == null || prefXML.length() == 0) {
                    this.fPageBook.showPage((Control)this.fBlankPage);
                    return;
                }
                Composite comp = new Composite((Composite)this.fPageBook, 0);
                GridLayout layout = new GridLayout();
                comp.setLayout((Layout)layout);
                comp.setLayoutData((Object)new GridData(1808));
                XUIBuilder builder = new XUIBuilder((InputStream)new ByteArrayInputStream(prefXML.getBytes()));
                builder.createContents(comp);
                this.recursivelyAddListeners(comp);
                this.fXMLPages.put(this.fOriginalConfiguration, new XMLComposite(builder, comp));
            }
            if ((xmlComp = this.fXMLPages.get(this.fOriginalConfiguration)) == null) {
                return;
            }
            this.fPageBook.showPage((Control)xmlComp.fXMLComposite);
            Map attributeMap = PDTCoreUtils.getEventAttributes((ILaunchConfiguration)configuration);
            XUIAttributeList attributeList = new XUIAttributeList();
            for (Map.Entry e : attributeMap.entrySet()) {
                attributeList.addAttribute(new XUIAttribute((String)e.getKey(), (String)e.getValue()));
            }
            xmlComp.fXMLBuilder.reconcileAttributes(attributeList);
        }
        catch (Exception e) {
            PDTCoreUtils.logError((Exception)e);
        }
    }

    private void recursivelyAddListeners(Composite parentControl) {
        Control[] children;
        Control[] controlArray = children = parentControl.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            if (control instanceof Composite) {
                this.recursivelyAddListeners((Composite)control);
            } else if (control instanceof Button) {
                control.addListener(13, this.fWidgetListener);
            } else {
                control.addListener(24, this.fWidgetListener);
            }
            ++n2;
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        if (!this.fXMLPages.containsKey(configuration.getOriginal())) {
            return;
        }
        XUIAttributeList xmlAttributes = this.fXMLPages.get((Object)configuration.getOriginal()).fXMLBuilder.getAttributes();
        HashMap<String, String> attributes = new HashMap<String, String>();
        int i = 0;
        while (i < xmlAttributes.size()) {
            XUIAttribute xmlAttribute = xmlAttributes.getAttribute(i);
            attributes.put(xmlAttribute.getName(), xmlAttribute.getValue());
            ++i;
        }
        try {
            PDTCoreUtils.setEventAttributes((ILaunchConfiguration)configuration, attributes, (boolean)false);
        }
        catch (CoreException e) {
            PDTCoreUtils.logError((Exception)((Object)e));
        }
    }

    public String getName() {
        return PICLLabels.EnginePreferencesTab_label;
    }

    public void updateEnginesWithModifiedPreferences(final ILaunchConfiguration configuration) {
        ILaunch[] launches;
        ArrayList<PDTDebugTarget> targetList = new ArrayList<PDTDebugTarget>();
        ILaunch[] iLaunchArray = launches = DebugPlugin.getDefault().getLaunchManager().getLaunches();
        int n = launches.length;
        int n2 = 0;
        while (n2 < n) {
            PDTDebugTarget target;
            ILaunch launch = iLaunchArray[n2];
            if (launch.getLaunchConfiguration().equals(configuration) && launch.getDebugTarget() instanceof PDTDebugTarget && (target = (PDTDebugTarget)launch.getDebugTarget()).getEngineSession() != null && target.getEngineSession().supportsEventContent()) {
                targetList.add(target);
            }
            ++n2;
        }
        if (!targetList.isEmpty()) {
            final PDTDebugTarget[] targets = targetList.toArray(new PDTDebugTarget[0]);
            try {
                ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                    public void run(IProgressMonitor monitor) throws CoreException {
                        PDTDebugTarget[] pDTDebugTargetArray = targets;
                        int n = targets.length;
                        int n2 = 0;
                        while (n2 < n) {
                            PDTDebugTarget target = pDTDebugTargetArray[n2];
                            try {
                                Map attributes = PDTCoreUtils.getEventAttributes((ILaunchConfiguration)configuration);
                                target.sendEventAttributes((short)300, attributes, 0);
                            }
                            catch (Exception e) {
                                PDTCoreUtils.logError((Exception)e);
                            }
                            ++n2;
                        }
                    }
                }, null, 1, null);
            }
            catch (CoreException e) {
                PDTCoreUtils.logError((Exception)((Object)e));
            }
        }
    }

    static class XMLComposite {
        public XUIBuilder fXMLBuilder;
        public Composite fXMLComposite;

        public XMLComposite(XUIBuilder builder, Composite comp) {
            this.fXMLBuilder = builder;
            this.fXMLComposite = comp;
        }
    }
}

