/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.launchconfig;

import com.ibm.debug.daemon.CoreDaemon;
import com.ibm.debug.daemon.IDaemonDebugTarget2;
import com.ibm.debug.daemon.IOldDaemonDefaultSupport;
import com.ibm.debug.daemon.IOldDaemonSupport;
import com.ibm.debug.daemon.internal.core.DaemonCore;
import com.ibm.debug.pdt.core.IPDTDebugTarget;
import com.ibm.debug.pdt.internal.core.EngineParameters;
import com.ibm.debug.pdt.internal.core.IDebugSessionStartupInfo;
import com.ibm.debug.pdt.internal.core.OldEngineParameters;
import com.ibm.debug.pdt.internal.core.PDTCorePlugin;
import com.ibm.debug.pdt.internal.core.PDTDebugTarget;
import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.core.PICLMessages;
import com.ibm.debug.pdt.internal.core.launch.IPICLAttachInfo;
import com.ibm.debug.pdt.internal.core.launch.IPICLLoadInfo;
import com.ibm.debug.pdt.internal.core.launch.PICLAbstractStartupInfo;
import com.ibm.debug.pdt.internal.core.launch.PICLAttachInfo;
import com.ibm.debug.pdt.internal.core.launch.PICLLoadInfo;
import com.ibm.debug.pdt.internal.core.model.DebuggeeProcess;
import com.ibm.debug.pdt.internal.core.util.PDTCoreUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.ui.PICLDebugPlugin;
import com.ibm.debug.pdt.internal.ui.PICLDebugTarget;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import com.ibm.debug.pdt.internal.ui.dialogs.PDTLaunchConfigListDialog;
import com.ibm.debug.pdt.internal.ui.preferences.PreferenceUI;
import com.ibm.debug.pdt.internal.ui.preferences.PreferenceUIConstants;
import com.ibm.debug.pdt.internal.ui.util.StatusInfo;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchDelegate;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationManager;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchHistory;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.ui.PlatformUI;

public class DaemonLaunchConfigurationDelegate
implements IOldDaemonDefaultSupport,
ILaunchConfigurationDelegate {
    public static final String DAEMON_INCOMING_CONFIG_TYPE = "com.ibm.debug.PDTDaemonApplication";
    private static final String DAEMON_LOAD_CONFIG_TYPE = "com.ibm.debug.loadPICLApplicationDaemon";
    private static final String DAEMON_ATTACH_CONFIG_TYPE = "com.ibm.debug.attachPICLApplicationDaemon";
    private static final String DEFAULT_CONFIG_NAME = "com.ibm.debug.default";
    private static final String LAUNCH_CONFIG_SOURCE_LOCATOR_KEY = "org.eclipse.debug.core.source_locator_id";
    private static final String GOOD_SOURCE_LOCATOR_ID = "com.ibm.debug.pdt.PDTSourceLocator";
    private static final String BAD_SOURCE_LOCATOR_ID = "com.ibm.debug.pdt.ui.PDTSourceLocator";
    private static final String CODE_COVERAGE_MODE = "compiled_coverage";
    private static final ILaunchConfiguration[] EMPTY_LAUNCHCONFIGS = new ILaunchConfiguration[0];
    private static final String CODE_COVERAGE_LAUNCH_GROUP = "com.ibm.debug.launch.pdt.coverage";
    public static final String CONFIG_PERSPECTIVE = "Perspective";
    private static volatile Map<ILaunchConfigurationType, Map<String, String>> fOldPerspectivesMap = null;

    protected static PICLAbstractStartupInfo createPICLStartupInfo(OldEngineParameters engineParameters) {
        Object startupInfo = null;
        if (engineParameters != null) {
            startupInfo = engineParameters.isAttach() ? new PICLAttachInfo((EngineParameters)engineParameters) : new PICLLoadInfo((EngineParameters)engineParameters);
            if (engineParameters.getConnection() != null) {
                startupInfo.setEngineConnection(engineParameters.getConnection());
                startupInfo.setEngineWaiting(true);
            } else {
                startupInfo.setEngineWaiting(false);
            }
        }
        return startupInfo;
    }

    protected static IPDTDebugTarget createDebugTarget(PICLAbstractStartupInfo startupInfo, ILaunchConfiguration launchConfig, int key) {
        Socket socket = startupInfo.getEngineConnection();
        startupInfo.setLaunchConfig(launchConfig);
        Object target = PDTCorePlugin.getSpecializedDebugTarget(null, (IDebugSessionStartupInfo)startupInfo, (ILaunchConfiguration)launchConfig, (int)key);
        if (target == null) {
            target = new PICLDebugTarget(null, startupInfo, socket, key);
        }
        if (target instanceof IDaemonDebugTarget2) {
            ((IDaemonDebugTarget2)target).engineIsWaiting(socket, socket.getPort() == 0);
        }
        return target;
    }

    protected static String getProgramName(PICLAbstractStartupInfo startInfo) {
        String pgmName;
        String[] startKeyParms;
        String programName = null;
        EngineParameters engineParameters = startInfo.getEngineParms();
        programName = engineParameters.getTitle();
        if (!PDTCoreUtils.isEmpty((String)programName)) {
            return programName;
        }
        String startupKey = engineParameters.getStartupKey();
        if (startupKey != null && (startKeyParms = startupKey.split(",", 3)).length > 1 && !(pgmName = startKeyParms[1]).isEmpty()) {
            return pgmName.trim();
        }
        if (startInfo instanceof IPICLLoadInfo && !PDTCoreUtils.isEmpty((String)(programName = ((IPICLLoadInfo)startInfo).getProgramName()))) {
            return programName;
        }
        return engineParameters.getAttribute("com.ibm.debug.pdt.team.profileName");
    }

    protected static ILaunch startConfig(ILaunchConfiguration delegateLaunchConfig, int key) {
        return DaemonLaunchConfigurationDelegate.startConfig(delegateLaunchConfig, key, "debug");
    }

    protected static ILaunch startConfig(ILaunchConfiguration delegateLaunchConfig, int key, String mode) {
        try {
            ILaunchConfigurationWorkingCopy workingConfig = delegateLaunchConfig.getWorkingCopy();
            workingConfig.setAttribute("Key", key);
            DaemonLaunchConfigurationDelegate.fixupSourceLocatorId(workingConfig);
            workingConfig.doSave();
            if (!DaemonLaunchConfigurationDelegate.isCustomPerpectiveRegistered(delegateLaunchConfig, mode) && PreferenceUIConstants.SHOW_SWITCHPERSPECTIVEIDPREF) {
                String perspectiveID = PreferenceUI.getSwitchPerspectiveID();
                DebugUITools.setLaunchPerspective((ILaunchConfigurationType)workingConfig.getType(), (String)mode, (String)perspectiveID);
            }
            return delegateLaunchConfig.launch(mode, null);
        }
        catch (CoreException e) {
            PICLUtils.logError((Exception)((Object)e));
            return null;
        }
    }

    private static void fixupSourceLocatorId(ILaunchConfigurationWorkingCopy workingConfig) throws CoreException {
        String locatorId = workingConfig.getAttribute(LAUNCH_CONFIG_SOURCE_LOCATOR_KEY, PICLLabels.debug_element_unknown);
        if (locatorId.equals(BAD_SOURCE_LOCATOR_ID)) {
            workingConfig.setAttribute(LAUNCH_CONFIG_SOURCE_LOCATOR_KEY, GOOD_SOURCE_LOCATOR_ID);
        }
    }

    protected static ILaunchConfiguration findExistingLaunchConfig(String programName, OldEngineParameters engineParameters) {
        if (PDTCoreUtils.isEmpty((String)programName)) {
            return null;
        }
        ILaunchConfiguration[] matchingIncomingLaunchConfigs = DaemonLaunchConfigurationDelegate.findExistingIncomingLaunchConfigs(programName);
        if (matchingIncomingLaunchConfigs.length == 1) {
            return matchingIncomingLaunchConfigs[0];
        }
        if (matchingIncomingLaunchConfigs.length > 1) {
            final ILaunchConfiguration[] displayArray = matchingIncomingLaunchConfigs;
            final PDTLaunchConfigListDialog dialog = new PDTLaunchConfigListDialog(PICLUtils.getShell(), programName);
            PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    dialog.setInput(displayArray);
                    dialog.open();
                }
            });
            if (dialog.getReturnCode() == 0) {
                Object[] selectedConfigs = dialog.getResult();
                if (selectedConfigs != null && selectedConfigs.length > 0) {
                    return (ILaunchConfiguration)selectedConfigs[0];
                }
            } else {
                return null;
            }
        }
        try {
            ILaunchConfiguration[] configs;
            String configName = programName.replace('*', '_');
            ILaunchConfigurationType configType = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType(engineParameters.isAttach() ? DAEMON_ATTACH_CONFIG_TYPE : DAEMON_LOAD_CONFIG_TYPE);
            ILaunchConfiguration[] iLaunchConfigurationArray = configs = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(configType);
            int n = configs.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunchConfiguration config = iLaunchConfigurationArray[n2];
                if (configName.equals(config.getName())) {
                    return config;
                }
                ++n2;
            }
        }
        catch (CoreException ce) {
            PICLUtils.logError((Exception)((Object)ce));
        }
        return null;
    }

    public static ILaunchConfiguration[] findExistingIncomingLaunchConfigs(String programName) {
        if (PDTCoreUtils.isEmpty((String)programName)) {
            return EMPTY_LAUNCHCONFIGS;
        }
        ArrayList<ILaunchConfiguration> matches = new ArrayList<ILaunchConfiguration>();
        try {
            ILaunchConfiguration[] configs;
            ILaunchConfiguration[] iLaunchConfigurationArray = configs = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType(DAEMON_INCOMING_CONFIG_TYPE));
            int n = configs.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunchConfiguration config = iLaunchConfigurationArray[n2];
                if (programName.equals(config.getAttribute("ProgramName", "none"))) {
                    matches.add(config);
                }
                ++n2;
            }
        }
        catch (CoreException ce) {
            PICLUtils.logError((Exception)((Object)ce));
            return EMPTY_LAUNCHCONFIGS;
        }
        return matches.size() > 0 ? matches.toArray(new ILaunchConfiguration[matches.size()]) : EMPTY_LAUNCHCONFIGS;
    }

    protected static ILaunchConfiguration createLaunchConfig(String configID, CoreDaemon.OldDaemonInput input, OldEngineParameters engineParameters, String configNameBase) {
        return DaemonLaunchConfigurationDelegate.createLaunchConfig(configID, configNameBase);
    }

    public static ILaunchConfiguration createLaunchConfig(String configID, String configNameBase) {
        ILaunchConfigurationType configType = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType(configID);
        ILaunchConfiguration savedConfig = null;
        String programName = configNameBase;
        if (configType == null) {
            return null;
        }
        configNameBase = configNameBase.replace('*', '_');
        configNameBase = configNameBase.replace('@', '_');
        try {
            IStatus status = ResourcesPlugin.getWorkspace().validateName(configNameBase, 1);
            if (!status.isOK()) {
                PICLUtils.logString(configNameBase, "Launch configuration name " + configNameBase + " was specified on the debug daemon connect, but is invalid for the filesystem");
                configNameBase = DEFAULT_CONFIG_NAME;
            }
            if (DebugPlugin.getDefault().getLaunchManager().isExistingLaunchConfigurationName(configNameBase)) {
                configNameBase = DebugPlugin.getDefault().getLaunchManager().generateLaunchConfigurationName(configNameBase);
            }
            ILaunchConfigurationWorkingCopy workingConfig = configType.newInstance(null, configNameBase);
            workingConfig.setAttribute("ProgramName", programName);
            savedConfig = workingConfig.doSave();
        }
        catch (CoreException ce) {
            PICLUtils.logError((Exception)((Object)ce));
        }
        return savedConfig;
    }

    public synchronized boolean figureOutWhatToDo(IOldDaemonSupport.IOldDaemonInput input) {
        if (PICLDebugPlugin.fPDT) {
            PICLUtils.logString(this, "In default Launcher");
        }
        OldEngineParameters engineParameters = new OldEngineParameters();
        Socket socket = input.getSocket().getSocket();
        engineParameters.setInfo(input.getInputArray(), socket);
        if (this.usePreLaunchedConfig(socket, engineParameters)) {
            return true;
        }
        if (input instanceof CoreDaemon.OldDaemonInput) {
            return this.useDelegateLaunchConfig((CoreDaemon.OldDaemonInput)input, engineParameters);
        }
        return false;
    }

    private boolean usePreLaunchedConfig(Socket socket, OldEngineParameters engineParameters) {
        if (engineParameters.isStartupKeyAnInteger()) {
            PDTDebugTarget pdtTarget;
            PICLAbstractStartupInfo startupInfo;
            IDebugTarget debugTarget;
            int key = Integer.parseInt(engineParameters.getStartupKey());
            if (PICLDebugPlugin.fPDT) {
                PICLUtils.logString(this, "Startup key [" + key + "] found");
            }
            if ((debugTarget = CoreDaemon.retrieveDebugTarget((int)key)) == null) {
                return false;
            }
            if (debugTarget instanceof IPDTDebugTarget) {
                ((IPDTDebugTarget)debugTarget).updateStartupInfo((EngineParameters)engineParameters);
            }
            if (debugTarget instanceof PDTDebugTarget && (startupInfo = (pdtTarget = (PDTDebugTarget)debugTarget).getStartupInfo()) instanceof IPICLLoadInfo) {
                IPICLLoadInfo loadInfo = (IPICLLoadInfo)startupInfo;
                ILaunch launch = pdtTarget.getLaunch();
                if (launch == null) {
                    return false;
                }
                ILaunchConfiguration launchConfig = launch.getLaunchConfiguration();
                IPDTDebugTarget specialTarget = PDTCorePlugin.getSpecializedDebugTarget((ILaunch)launch, (IDebugSessionStartupInfo)loadInfo, (ILaunchConfiguration)launchConfig, (int)pdtTarget.getKey());
                if (specialTarget instanceof IDaemonDebugTarget2) {
                    launch.addDebugTarget((IDebugTarget)specialTarget);
                    launch.removeDebugTarget((IDebugTarget)pdtTarget);
                    pdtTarget.doCleanup();
                    debugTarget = specialTarget;
                }
            }
            if (debugTarget instanceof IDaemonDebugTarget2) {
                if (PICLDebugPlugin.fPDT) {
                    PICLUtils.logString(this, "calling debug target.engineIsWaiting()");
                }
                ((IDaemonDebugTarget2)debugTarget).engineIsWaiting(socket, socket.getLocalPort() != 0);
                return true;
            }
        } else {
            PICLAbstractStartupInfo info = DaemonLaunchConfigurationDelegate.createPICLStartupInfo(engineParameters);
            IPDTDebugTarget debugTarget = PDTCorePlugin.getSpecializedDebugTarget(null, (IDebugSessionStartupInfo)info, null, (int)-1);
            if (debugTarget != null) {
                debugTarget.updateStartupInfo((EngineParameters)engineParameters);
            }
            if (debugTarget instanceof IDaemonDebugTarget2) {
                if (PICLDebugPlugin.fPDT) {
                    PICLUtils.logString(this, "calling debug target.engineIsWaiting()");
                }
                ((IDaemonDebugTarget2)debugTarget).engineIsWaiting(socket, socket.getLocalPort() != 0);
                return true;
            }
        }
        return false;
    }

    private boolean useDelegateLaunchConfig(CoreDaemon.OldDaemonInput input, OldEngineParameters engineParameters) {
        int key = CoreDaemon.generateKey();
        CoreDaemon.storeOldDaemonInput((int)key, (DaemonCore.OldDaemonInput)input);
        PICLAbstractStartupInfo startupInfo = DaemonLaunchConfigurationDelegate.createPICLStartupInfo(engineParameters);
        ILaunchConfiguration delegateLaunchConfig = null;
        String programName = DaemonLaunchConfigurationDelegate.getProgramName(startupInfo);
        IPDTDebugTarget target = null;
        if (programName == null) {
            target = DaemonLaunchConfigurationDelegate.createDebugTarget(startupInfo, delegateLaunchConfig, key);
            if (target == null || !(target.getProcess() instanceof DebuggeeProcess)) {
                return false;
            }
            programName = PDTCoreUtils.getValidFileNameOldEscape((String)((DebuggeeProcess)target.getProcess()).getBasePgmProfileName());
        }
        if (programName != null) {
            delegateLaunchConfig = DaemonLaunchConfigurationDelegate.findExistingLaunchConfig(programName, engineParameters);
        }
        if (delegateLaunchConfig == null) {
            delegateLaunchConfig = DaemonLaunchConfigurationDelegate.createLaunchConfig(DAEMON_INCOMING_CONFIG_TYPE, input, engineParameters, programName);
        }
        if (startupInfo instanceof IPICLLoadInfo) {
            ((IPICLLoadInfo)startupInfo).setProgramName(programName);
        }
        if (delegateLaunchConfig != null) {
            if (target == null) {
                target = DaemonLaunchConfigurationDelegate.createDebugTarget(startupInfo, delegateLaunchConfig, key);
            }
            String launchMode = "debug";
            if (startupInfo.isCodeCoverage()) {
                launchMode = CODE_COVERAGE_MODE;
            }
            ILaunch launch = DaemonLaunchConfigurationDelegate.startConfig(delegateLaunchConfig, key, launchMode);
            target.setLaunch(launch);
            launch.addDebugTarget((IDebugTarget)target);
        }
        return true;
    }

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        int key;
        this.removeFromHistory(launch);
        if (PICLDebugPlugin.fPDT) {
            PICLUtils.logString(this, "Got to the daemon launch config delegate");
        }
        if ((key = configuration.getAttribute("Key", -99999)) == -99999) {
            StatusInfo status = new StatusInfo();
            status.setError(PICLMessages.Load_unsupportedDaemonLaunch);
            throw new CoreException((IStatus)status);
        }
        ILaunchConfigurationWorkingCopy workingCopy = configuration.getWorkingCopy();
        workingCopy.setAttribute("Key", -99999);
        workingCopy.doSave();
        CoreDaemon.OldDaemonInput input = CoreDaemon.retrieveOldDaemonInput((int)key);
        if (input == null) {
            StatusInfo status = new StatusInfo();
            status.setError(PICLLabels.Load_errorTitle);
            throw new CoreException((IStatus)status);
        }
        PDTCorePlugin.getInstance();
        IPDTDebugTarget target = PDTCorePlugin.getDebugTarget((int)key);
        if (target != null) {
            target.setLaunch(launch);
            if (target instanceof PICLDebugTarget) {
                PICLDebugTarget piclTarget = (PICLDebugTarget)target;
                EPDC_EngineSession engineSession = piclTarget.getEngineSession();
                if (engineSession.iszTPFengine() || piclTarget.getStartupInfo() instanceof IPICLAttachInfo) {
                    piclTarget.fireSuspendEvent(256);
                }
                piclTarget.processAdded(null);
            }
            launch.addDebugTarget((IDebugTarget)target);
        }
    }

    public void removeFromHistory(ILaunch launch) {
        if (launch != null && launch.getLaunchConfiguration() != null) {
            LaunchHistory history = DebugUIPlugin.getDefault().getLaunchConfigurationManager().getLaunchHistory("org.eclipse.debug.ui.launchGroup.debug");
            if (history != null) {
                history.removeFromHistory(launch.getLaunchConfiguration());
            }
            if ((history = DebugUIPlugin.getDefault().getLaunchConfigurationManager().getLaunchHistory(CODE_COVERAGE_LAUNCH_GROUP)) != null) {
                history.removeFromHistory(launch.getLaunchConfiguration());
            }
        }
    }

    private static boolean isCustomPerpectiveRegistered(ILaunchConfiguration config, String mode) {
        try {
            DaemonLaunchConfigurationDelegate.restoreOldPerspective(config, mode);
            String perspectiveId = DaemonLaunchConfigurationDelegate.getCustomPerspectiveId(config, mode);
            if (perspectiveId != null) {
                DaemonLaunchConfigurationDelegate.saveOldPerspective(config, mode);
                HashSet<String> modes = new HashSet<String>();
                modes.add(mode);
                DebugUITools.setLaunchPerspective((ILaunchConfigurationType)config.getType(), (ILaunchDelegate)DaemonLaunchConfigurationDelegate.getDelegate(config, modes), modes, (String)perspectiveId);
                return true;
            }
        }
        catch (CoreException e) {
            PICLUtils.logError((Exception)((Object)e));
        }
        return false;
    }

    private static ILaunchDelegate getDelegate(ILaunchConfiguration config, HashSet<String> modes) {
        ILaunchDelegate delegate = null;
        try {
            ILaunchDelegate[] delegates = LaunchConfigurationManager.filterLaunchDelegates((ILaunchConfigurationType)config.getType(), modes);
            if (delegates.length == 1) {
                delegate = delegates[0];
            } else if (delegates.length > 1 && (delegate = config.getPreferredDelegate(modes)) == null) {
                delegate = config.getType().getPreferredDelegate(modes);
            }
        }
        catch (CoreException e) {
            PICLUtils.logError((Exception)((Object)e));
        }
        return delegate;
    }

    private static void saveOldPerspective(ILaunchConfiguration config, String mode) throws CoreException {
        Map<String, String> pMap;
        ILaunchConfigurationType type = config.getType();
        if (fOldPerspectivesMap == null) {
            fOldPerspectivesMap = new HashMap<ILaunchConfigurationType, Map<String, String>>();
        }
        if ((pMap = fOldPerspectivesMap.get(type)) == null) {
            pMap = new HashMap<String, String>();
        }
        HashSet<String> modes = new HashSet<String>();
        modes.add(mode);
        pMap.put(mode, DebugUITools.getLaunchPerspective((ILaunchConfigurationType)type, (ILaunchDelegate)DaemonLaunchConfigurationDelegate.getDelegate(config, modes), modes));
        fOldPerspectivesMap.put(type, pMap);
    }

    private static void restoreOldPerspective(ILaunchConfiguration config, String mode) {
        if (fOldPerspectivesMap != null) {
            try {
                String perspectiveId;
                ILaunchConfigurationType type = config.getType();
                Map<String, String> pMap = fOldPerspectivesMap.get(type);
                if (pMap != null && (perspectiveId = pMap.get(mode)) != null) {
                    HashSet<String> modes = new HashSet<String>();
                    modes.add(mode);
                    DebugUITools.setLaunchPerspective((ILaunchConfigurationType)type, (ILaunchDelegate)DaemonLaunchConfigurationDelegate.getDelegate(config, modes), modes, (String)perspectiveId);
                }
            }
            catch (CoreException e) {
                PICLUtils.logError((Exception)((Object)e));
            }
        }
    }

    private static String getCustomPerspectiveId(ILaunchConfiguration config, String mode) {
        if (PreferenceUIConstants.SHOW_CUSTOMSWITCHPERSPECTIVEIDPREF) {
            try {
                return config.getAttribute(CONFIG_PERSPECTIVE, null);
            }
            catch (CoreException e) {
                PICLUtils.logError((Exception)((Object)e));
            }
        }
        return null;
    }
}

