/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.hover;

import com.ibm.debug.pdt.internal.core.PDTDebugElement;
import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.core.model.EngineRequestException;
import com.ibm.debug.pdt.internal.core.model.ExprNodeBase;
import com.ibm.debug.pdt.internal.core.model.ExpressionBase;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import com.ibm.debug.pdt.internal.ui.hover.PDTHoverDetailPane;
import com.ibm.debug.pdt.internal.ui.hover.PDTHoverDetailPaneAssignValueAction;
import com.ibm.debug.pdt.internal.ui.hover.PDTInformationControlCreator;
import com.ibm.debug.pdt.internal.ui.preferences.PreferenceUI;
import com.ibm.debug.pdt.internal.ui.views.PDTVariableLabelProvider;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.AbstractInformationControl;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IInformationControlExtension2;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.texteditor.ITextEditor;

public class PDTInformationControl
extends AbstractInformationControl
implements IInformationControlExtension2,
IDebugEventSetListener,
IDoubleClickListener {
    private TreeViewer fTreeViewer;
    private ExpressionBase fExpression;
    private static final int MAX_ELEMENTS_TO_SHOW = 100;
    private static final Object fLock = new Object();
    private static int[] fSashWeights = new int[]{PreferenceUI.getHoverSashWeight1(), PreferenceUI.getHoverSashWeight2()};
    private PDTHoverDetailPane fDetailPane;
    private SashForm fSashForm;
    private Composite fTreeViewerComposite;
    private ITextEditor fEditor;
    private IVariable fExpressionToMonitor;
    private ToolBarManager fToolbarManager;
    private PDTHoverDetailPaneAssignValueAction fAssignValueAction;
    private IStructuredSelection fSelection;
    private ISelection fDetailSelection;
    private MoreItem fMore = null;
    private DetailListener fDetailListener;
    private Control fDetailPaneControl;

    public PDTInformationControl(Shell parentShell, ITextEditor editor, String message) {
        super(parentShell, message);
        this.fEditor = editor;
        this.create();
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
    }

    public PDTInformationControl(Shell parentShell, ITextEditor editor, IStructuredSelection selection, ISelection detailSelection) {
        super(parentShell, new ToolBarManager());
        this.fEditor = editor;
        this.fSelection = selection;
        this.fDetailSelection = detailSelection;
        this.create();
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
    }

    public boolean hasContents() {
        return true;
    }

    protected void createContent(Composite parent) {
        Color background = JFaceResources.getColorRegistry().get("org.eclipse.ui.workbench.INFORMATION_BACKGROUND");
        if (background == null) {
            background = this.getShell().getDisplay().getSystemColor(29);
        }
        parent.setBackground(background);
        Composite composite = new Composite(parent, 0);
        composite.setBackground(background);
        this.fSashForm = new SashForm(composite, 66048);
        this.fTreeViewerComposite = new Composite((Composite)this.fSashForm, 0);
        this.fTreeViewerComposite.setBackground(background);
        this.fTreeViewer = new TreeViewer(this.fTreeViewerComposite);
        this.fTreeViewer.getControl().setBackground(background);
        Control sashFormChild = this.fSashForm.getChildren()[0];
        sashFormChild.addControlListener(new ControlListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void controlResized(ControlEvent arg0) {
                Object object = fLock;
                synchronized (object) {
                    fSashWeights = PDTInformationControl.this.fSashForm.getWeights();
                }
            }

            public void controlMoved(ControlEvent arg0) {
            }
        });
        ISelectionChangedListener listener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                PDTInformationControl.this.fDetailPane.display(selection);
                if (PDTInformationControl.this.fAssignValueAction != null) {
                    PDTInformationControl.this.fAssignValueAction.updateCurrentVariable(selection);
                    PDTInformationControl.this.fDetailPane.getSourceViewer().getControl().setEnabled(PDTInformationControl.this.fAssignValueAction.canModify());
                }
            }
        };
        this.fTreeViewer.addSelectionChangedListener(listener);
        this.fTreeViewer.addDoubleClickListener((IDoubleClickListener)this);
        GridLayoutFactory.fillDefaults().generateLayout(this.fTreeViewerComposite);
        GridDataFactory.fillDefaults().align(4, 1).grab(true, false).applyTo((Control)this.fTreeViewerComposite);
        this.fDetailPane = new PDTHoverDetailPane(this);
        this.fDetailPane.init((IWorkbenchPartSite)(this.fEditor != null ? this.fEditor.getEditorSite() : null));
        this.fDetailPaneControl = this.fDetailPane.createControl((Composite)this.fSashForm);
        this.fDetailPaneControl.setBackground(background);
        this.fTreeViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public boolean hasChildren(Object element) {
                if (element instanceof MoreItem) {
                    return false;
                }
                return ((PDTDebugElement)element).hasChildren();
            }

            public Object getParent(Object element) {
                if (element instanceof MoreItem) {
                    return null;
                }
                return ((PDTDebugElement)element).getParentElement();
            }

            public Object[] getElements(Object inputElement) {
                try {
                    return ((PDTDebugElement)inputElement).getChildren();
                }
                catch (EngineRequestException e) {
                    return PDTDebugElement.EMPTYCHILDREN;
                }
            }

            public Object[] getChildren(Object parentElement) {
                ExprNodeBase node = (ExprNodeBase)parentElement;
                ArrayList<Object> children = new ArrayList<Object>();
                int curMax = Math.min(100, node.getNumChildren());
                if (PDTInformationControl.this.fMore != null) {
                    while (node.getChild(curMax - 1) != null && curMax < node.getNumChildren()) {
                        curMax = Math.min(curMax + 100, node.getNumChildren());
                    }
                }
                children.addAll(Arrays.asList(node.getChildren(node.getBaseIndex(), curMax)));
                if (node.getNumChildren() > curMax) {
                    if (PDTInformationControl.this.fMore == null) {
                        PDTInformationControl.this.fMore = new MoreItem();
                    }
                    PDTInformationControl.this.fMore.fLabel = NLS.bind((String)PICLLabels.hover_more, (Object)(node.getNumChildren() - curMax));
                    children.add(PDTInformationControl.this.fMore);
                }
                return children.toArray();
            }
        });
        PDTVariableLabelProvider labelProvider = new PDTVariableLabelProvider(){

            @Override
            public Image getImage(Object element) {
                if (element instanceof MoreItem) {
                    return PICLUtils.getImage("PICL_ICON_MORE");
                }
                return super.getImage(element);
            }
        };
        labelProvider.setAttribute("org.eclipse.debug.ui.displayVariableTypeNames", PreferenceUI.isDisplayHoverTypes());
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        GridLayoutFactory.fillDefaults().generateLayout((Composite)this.fSashForm);
        GridDataFactory.fillDefaults().align(4, 1).grab(true, true).applyTo((Control)this.fSashForm);
        this.fToolbarManager = this.getToolBarManager();
        if (this.fToolbarManager != null) {
            this.fAssignValueAction = new PDTHoverDetailPaneAssignValueAction(this, (ITextViewer)this.fDetailPane.getSourceViewer());
            this.fAssignValueAction.setEnabled(false);
            this.fToolbarManager.add((IAction)this.fAssignValueAction);
            this.fToolbarManager.update(true);
        }
        SourceViewer sourceViewer = this.fDetailPane.getSourceViewer();
        this.fDetailListener = new DetailListener();
        sourceViewer.addTextListener((ITextListener)this.fDetailListener);
        sourceViewer.addTextInputListener((ITextInputListener)this.fDetailListener);
        GridLayoutFactory.fillDefaults().applyTo(composite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.fSashForm);
        this.setBackgroundColor(background);
    }

    public void setInput(Object input) {
        if (input instanceof ExpressionBase) {
            this.fExpression = (ExpressionBase)input;
            this.fExpression.resetChanged();
            this.fTreeViewer.setInput((Object)this.fExpression);
            this.fTreeViewer.expandToLevel(2);
        }
        if (this.fSelection != null) {
            this.fTreeViewer.setSelection((ISelection)this.fSelection);
        } else {
            TreeItem item = this.fTreeViewer.getTree().getItem(0);
            if (item != null && item.getData() instanceof PDTDebugElement) {
                this.fTreeViewer.setSelection((ISelection)new TreeSelection(new TreePath(new Object[]{item.getData()})));
            }
        }
        if (this.fTreeViewer.getSelection() instanceof IStructuredSelection) {
            this.fDetailPane.display((IStructuredSelection)this.fTreeViewer.getSelection());
            if (this.fDetailSelection != null) {
                this.fDetailPane.getSelectionProvider().setSelection(this.fDetailSelection);
            }
        }
        this.fSashForm.setWeights(fSashWeights);
    }

    public void dispose() {
        PreferenceUI.setHoverSashWeight1(this.fSashForm.getWeights()[0]);
        PreferenceUI.setHoverSashWeight2(this.fSashForm.getWeights()[1]);
        if (this.fDetailListener != null) {
            this.fDetailPane.getSourceViewer().removeTextListener((ITextListener)this.fDetailListener);
            this.fDetailPane.getSourceViewer().removeTextInputListener((ITextInputListener)this.fDetailListener);
            this.fDetailListener = null;
        }
        this.fDetailPane.dispose();
        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
        super.dispose();
        if (this.fExpression == null) {
            return;
        }
        Job job = new Job("Remove Expression"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    ExpressionBase expr = PDTInformationControl.this.fExpression;
                    PDTInformationControl.this.fExpression = null;
                    expr.remove();
                }
                catch (EngineRequestException engineRequestException) {
                    // empty catch block
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    public IInformationControlCreator getInformationPresenterControlCreator() {
        IStructuredSelection selection = (IStructuredSelection)this.fTreeViewer.getSelection();
        return new PDTInformationControlCreator(this.fEditor, selection, this.fDetailSelection != null ? this.fDetailSelection : this.fDetailPane.getSourceViewer().getSelection(), true);
    }

    public void handleDebugEvents(DebugEvent[] events) {
        DebugEvent[] debugEventArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            DebugEvent event = debugEventArray[n2];
            this.handleDebugEvent(event);
            ++n2;
        }
    }

    protected void setMonitoredExpression(IVariable expr) {
        this.fExpressionToMonitor = expr;
    }

    private void handleDebugEvent(DebugEvent event) {
        if (event.getKind() == 16 && event.getDetail() == 256 && this.fExpressionToMonitor != null && event.getSource() == this.fExpressionToMonitor) {
            this.fExpressionToMonitor = null;
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    PDTInformationControl.this.fTreeViewer.refresh();
                    PDTInformationControl.this.fAssignValueAction.setEnabled(false);
                }
            });
        }
    }

    public void setSizeConstraints(int maxWidth, int maxHeight) {
        super.setSizeConstraints(Math.max(602, maxWidth), Math.max(182, maxHeight));
    }

    public void doubleClick(DoubleClickEvent event) {
        Object item;
        if (event.getSelection() instanceof IStructuredSelection && (item = ((IStructuredSelection)event.getSelection()).getFirstElement()) instanceof MoreItem) {
            ((MoreItem)item).fLabel = PICLLabels.PendingValues;
            this.fTreeViewer.refresh((Object)this.fMore);
            this.fTreeViewer.refresh();
        }
    }

    public void setBackgroundColor(Color background) {
        super.setBackgroundColor(background);
        this.fTreeViewerComposite.getParent().setBackground(background);
        this.fTreeViewerComposite.setBackground(background);
        this.fTreeViewer.getControl().setBackground(background);
        this.fDetailPaneControl.setBackground(background);
    }

    class DetailListener
    implements ITextListener,
    ITextInputListener {
        String text = null;

        DetailListener() {
        }

        public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
        }

        public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
            this.text = newInput != null ? newInput.get() : null;
        }

        public void textChanged(TextEvent event) {
            if (event.getReplacedText() != null && PDTInformationControl.this.fAssignValueAction != null && !event.getDocumentEvent().getDocument().get().equals(this.text)) {
                PDTInformationControl.this.fAssignValueAction.setModified();
            }
        }
    }

    private static class MoreItem {
        String fLabel = "";

        private MoreItem() {
        }

        public String toString() {
            return this.fLabel;
        }
    }
}

