/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.hover;

import com.ibm.debug.pdt.internal.core.PICLMessages;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import com.ibm.debug.pdt.internal.ui.hover.PDTInformationControl;
import org.eclipse.debug.core.model.IValueModification;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.internal.ui.actions.ActionMessages;
import org.eclipse.debug.internal.ui.actions.variables.details.DetailPaneAssignValueAction;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class PDTHoverDetailPaneAssignValueAction
extends Action {
    private PDTInformationControl fInformationControl;
    private ITextViewer fTextViewer;
    private IStructuredSelection fCurrentSelection;
    private boolean fCanModify = false;
    private boolean fModified = false;

    public PDTHoverDetailPaneAssignValueAction(PDTInformationControl informationControl, ITextViewer textViewer) {
        super(ActionMessages.DetailPaneAssignValueAction_1, 1);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.debug.ui.detail_pane_assign_value_action_context");
        this.fInformationControl = informationControl;
        this.fTextViewer = textViewer;
        this.setImageDescriptor(PICLUtils.getImageDescriptor("PICL_ICON_ELCL_ASSIGN_VALUE"));
        this.setEnabled(false);
    }

    private void assignValue(Shell shell, IVariable variable, String newValueExpression) {
        this.fInformationControl.setMonitoredExpression(variable);
        DetailPaneAssignValueAction.assignValue((Shell)shell, (IVariable)variable, (String)newValueExpression);
    }

    protected void updateCurrentVariable(IStructuredSelection selection) {
        IValueModification valMod;
        this.fCanModify = false;
        this.fModified = false;
        if (selection.size() == 1 && selection.getFirstElement() instanceof IValueModification && (valMod = (IValueModification)selection.getFirstElement()).supportsValueModification()) {
            this.fCurrentSelection = selection;
            this.fCanModify = true;
        }
        this.setEnabled(false);
        this.setText(this.fCanModify ? ActionMessages.DetailPaneAssignValueAction_1 : PICLMessages.CRRDG3253);
    }

    public void run() {
        if (this.fCurrentSelection == null || this.fCurrentSelection.isEmpty()) {
            return;
        }
        IVariable variable = (IVariable)this.fCurrentSelection.getFirstElement();
        Point selection = this.fTextViewer.getSelectedRange();
        String value = null;
        if (selection.y == 0) {
            value = this.fTextViewer.getDocument().get();
        } else {
            try {
                value = this.fTextViewer.getDocument().get(selection.x, selection.y);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        Shell activeShell = null;
        if (window != null) {
            activeShell = window.getShell();
        }
        this.assignValue(activeShell, variable, value);
    }

    public void setModified() {
        if (this.fCanModify) {
            this.fModified = true;
            this.setEnabled(this.fCanModify && this.fModified);
        }
    }

    public boolean canModify() {
        return this.fCanModify;
    }
}

