/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.hover;

import com.ibm.debug.pdt.internal.ui.hover.PDTHoverDetailPaneAssignValueAction;
import com.ibm.debug.pdt.internal.ui.hover.PDTInformationControl;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.views.variables.details.DefaultDetailPane;
import org.eclipse.debug.internal.ui.views.variables.details.DetailMessages;
import org.eclipse.debug.ui.IDebugView;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.StatusLineContributionItem;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.console.actions.TextViewerAction;

public class PDTHoverDetailPane
extends DefaultDetailPane {
    private PDTInformationControl fInformationControl;
    private IEditorSite fEditorSite;
    private StatusLineContributionItem fStatusLineItem;
    private ICursorListener fCursorListener;
    private boolean fHasFocus;

    public PDTHoverDetailPane(PDTInformationControl informationControl) {
        this.fInformationControl = informationControl;
    }

    public void init(IWorkbenchPartSite site) {
        this.fEditorSite = (IEditorSite)site;
    }

    public Control createControl(Composite parent) {
        Control control = super.createControl(parent);
        this.createViewSpecificComponents();
        this.createActions();
        DebugUIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        JFaceResources.getFontRegistry().addListener((IPropertyChangeListener)this);
        return control;
    }

    private void createViewSpecificComponents() {
        this.getDetailDocument().addDocumentListener(new IDocumentListener(){

            public void documentAboutToBeChanged(DocumentEvent documentevent) {
            }

            public void documentChanged(DocumentEvent event) {
                PDTHoverDetailPane.this.updateSelectionDependentActions();
            }
        });
        SourceViewer sourceViewer = this.getSourceViewer();
        sourceViewer.getSelectionProvider().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                PDTHoverDetailPane.this.updateSelectionDependentActions();
            }
        });
        sourceViewer.getControl().addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                PDTHoverDetailPane.this.setGlobalAction(IDebugView.SELECT_ALL_ACTION, PDTHoverDetailPane.this.getAction(DETAIL_SELECT_ALL_ACTION));
                PDTHoverDetailPane.this.setGlobalAction(IDebugView.CUT_ACTION, PDTHoverDetailPane.this.getAction(DETAIL_CUT_ACTION));
                PDTHoverDetailPane.this.setGlobalAction(IDebugView.COPY_ACTION, PDTHoverDetailPane.this.getAction(DETAIL_COPY_ACTION));
                PDTHoverDetailPane.this.setGlobalAction(IDebugView.PASTE_ACTION, PDTHoverDetailPane.this.getAction(DETAIL_PASTE_ACTION));
                PDTHoverDetailPane.this.fEditorSite.getActionBars().updateActionBars();
                PDTHoverDetailPane.this.fHasFocus = true;
            }

            public void focusLost(FocusEvent e) {
                PDTHoverDetailPane.this.setGlobalAction(IDebugView.SELECT_ALL_ACTION, null);
                PDTHoverDetailPane.this.setGlobalAction(IDebugView.CUT_ACTION, null);
                PDTHoverDetailPane.this.setGlobalAction(IDebugView.COPY_ACTION, null);
                PDTHoverDetailPane.this.setGlobalAction(IDebugView.PASTE_ACTION, null);
                PDTHoverDetailPane.this.fEditorSite.getActionBars().updateActionBars();
                PDTHoverDetailPane.this.fHasFocus = false;
            }
        });
        sourceViewer.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (PDTHoverDetailPane.this.fHasFocus) {
                    PDTHoverDetailPane.this.setGlobalAction(IDebugView.SELECT_ALL_ACTION, null);
                    PDTHoverDetailPane.this.setGlobalAction(IDebugView.CUT_ACTION, null);
                    PDTHoverDetailPane.this.setGlobalAction(IDebugView.COPY_ACTION, null);
                    PDTHoverDetailPane.this.setGlobalAction(IDebugView.PASTE_ACTION, null);
                }
            }
        });
        this.fStatusLineItem = new StatusLineContributionItem("ModeContributionItem");
        IStatusLineManager manager = this.fEditorSite.getActionBars().getStatusLineManager();
        manager.add((IContributionItem)this.fStatusLineItem);
        sourceViewer.getTextWidget().addMouseListener((MouseListener)this.getCursorListener());
        sourceViewer.getTextWidget().addKeyListener((KeyListener)this.getCursorListener());
        this.createDetailContextMenu((Control)sourceViewer.getTextWidget());
    }

    protected void setGlobalAction(String actionID, IAction action) {
        this.fEditorSite.getActionBars().setGlobalActionHandler(actionID, action);
    }

    protected void createDetailContextMenu(Control menuControl) {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                PDTHoverDetailPane.this.fillDetailContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(menuControl);
        menuControl.setMenu(menu);
        SourceViewer sourceViewer = this.getSourceViewer();
        this.fEditorSite.registerContextMenu("com.ibm.debug.pdt.ui.hover.detail", menuMgr, sourceViewer.getSelectionProvider());
    }

    protected void fillDetailContextMenu(IMenuManager menu) {
        menu.add((IContributionItem)new Separator("variableGroup"));
        menu.add(this.getAction("AssignValue"));
        menu.add((IContributionItem)new Separator());
        menu.add(this.getAction(DETAIL_CUT_ACTION));
        menu.add(this.getAction(DETAIL_COPY_ACTION));
        menu.add(this.getAction(DETAIL_PASTE_ACTION));
        menu.add(this.getAction(DETAIL_SELECT_ALL_ACTION));
    }

    public void display(IStructuredSelection selection) {
        IAction assignAction = this.getAction("AssignValue");
        if (assignAction instanceof PDTHoverDetailPaneAssignValueAction) {
            ((PDTHoverDetailPaneAssignValueAction)assignAction).updateCurrentVariable(selection);
        }
        super.display(selection);
        SourceViewer sourceViewer = this.getSourceViewer();
        if (sourceViewer != null) {
            sourceViewer.setEditable(true);
        }
    }

    public void dispose() {
        this.fEditorSite.getActionBars().getStatusLineManager().remove((IContributionItem)this.fStatusLineItem);
        DebugUIPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        JFaceResources.getFontRegistry().removeListener((IPropertyChangeListener)this);
        super.dispose();
    }

    protected void configureDetailsViewer() {
        super.configureDetailsViewer();
        this.updateAction("AssignValue");
    }

    private ICursorListener getCursorListener() {
        if (this.fCursorListener == null) {
            this.fCursorListener = new ICursorListener(){

                public void keyPressed(KeyEvent e) {
                    PDTHoverDetailPane.this.fStatusLineItem.setText(PDTHoverDetailPane.this.getCursorPosition());
                }

                public void keyReleased(KeyEvent keyevent) {
                }

                public void mouseDoubleClick(MouseEvent mouseevent) {
                }

                public void mouseDown(MouseEvent mouseevent) {
                }

                public void mouseUp(MouseEvent e) {
                    PDTHoverDetailPane.this.fStatusLineItem.setText(PDTHoverDetailPane.this.getCursorPosition());
                }
            };
        }
        return this.fCursorListener;
    }

    protected SourceViewer getSourceViewer() {
        return (SourceViewer)this.getAdapter(ITextViewer.class);
    }

    private void createActions() {
        SourceViewer sourceViewer = this.getSourceViewer();
        if (sourceViewer != null) {
            TextViewerAction textAction = new TextViewerAction((ITextViewer)sourceViewer, 7);
            textAction.configureAction(DetailMessages.DefaultDetailPane_Select__All_5, "", "");
            textAction.setActionDefinitionId("org.eclipse.ui.edit.selectAll");
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)textAction, "org.eclipse.debug.ui.detail_pane_select_all_action_context");
            this.setAction(DETAIL_SELECT_ALL_ACTION, (IAction)textAction);
            textAction = new TextViewerAction((ITextViewer)sourceViewer, 4);
            textAction.configureAction(DetailMessages.DefaultDetailPane__Copy_8, "", "");
            textAction.setActionDefinitionId("org.eclipse.ui.edit.copy");
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)textAction, "org.eclipse.debug.ui.detail_pane_copy_action_context");
            this.setAction(DETAIL_COPY_ACTION, (IAction)textAction);
            textAction = new TextViewerAction((ITextViewer)sourceViewer, 3);
            textAction.configureAction(DetailMessages.DefaultDetailPane_Cu_t_11, "", "");
            textAction.setActionDefinitionId("org.eclipse.ui.edit.cut");
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)textAction, "org.eclipse.debug.ui.detail_pane_cut_action_context");
            this.setAction(DETAIL_CUT_ACTION, (IAction)textAction);
            textAction = new TextViewerAction((ITextViewer)sourceViewer, 5);
            textAction.configureAction(DetailMessages.DefaultDetailPane__Paste_14, "", "");
            textAction.setActionDefinitionId("org.eclipse.ui.edit.paste");
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)textAction, "org.eclipse.debug.ui.detail_pane_paste_action_context");
            this.setAction(ActionFactory.PASTE.getId(), (IAction)textAction);
            this.setSelectionDependantAction(DETAIL_COPY_ACTION);
            this.setSelectionDependantAction(DETAIL_CUT_ACTION);
            this.setSelectionDependantAction(DETAIL_PASTE_ACTION);
            this.updateSelectionDependentActions();
            PDTHoverDetailPaneAssignValueAction action = new PDTHoverDetailPaneAssignValueAction(this.fInformationControl, (ITextViewer)sourceViewer);
            this.setAction("AssignValue", (IAction)action);
        }
    }

    static interface ICursorListener
    extends MouseListener,
    KeyListener {
    }
}

