/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.editor;

import com.ibm.debug.pdt.internal.core.model.IdentifierParser;
import com.ibm.debug.pdt.internal.core.model.ViewFile;
import com.ibm.debug.pdt.internal.ui.EngineSuppliedViewEditorInput;
import com.ibm.debug.pdt.internal.ui.editor.DebuggerEditor;
import com.ibm.debug.pdt.internal.ui.preferences.PreferenceUI;
import com.ibm.debug.pdt.internal.ui.util.MonitorUtils;
import com.ibm.lpex.core.LpexCommonParser;
import com.ibm.lpex.core.LpexDocumentLocation;
import com.ibm.lpex.core.LpexPaletteAttributes;
import com.ibm.lpex.core.LpexView;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.texteditor.ITextEditor;

public class DebuggerParser
extends LpexCommonParser {
    protected static final String PREFIX = "AddSnippetToMonitorAction.";
    static final String CLASS_EXECUTABLE = "executable";
    static final String CLASS_NONEXECUTABLE = "nonexecutable";
    private long classExecutable;
    private long classNonExecutable;
    private long classAll;
    private ITextEditor fEditor = null;
    private EngineSuppliedViewEditorInput fEngineSuppliedEditorInput;
    private boolean fExecutableInfoAvailable = false;

    public DebuggerParser(LpexView lpexView) {
        super(lpexView);
        this.setColors();
        this.classExecutable = this.view.registerClass(CLASS_EXECUTABLE);
        this.classNonExecutable = this.view.registerClass(CLASS_NONEXECUTABLE);
        this.classAll = this.classExecutable | this.classNonExecutable;
    }

    private void setColors() {
        String toBackground = LpexPaletteAttributes.background((LpexView)this.view);
        String blue = DebuggerEditor.isDarkTheme() ? "255 100 0" : "0 0 255";
        String attributes = LpexPaletteAttributes.convert((String)(blue + " 255 255 255"), (String)"255 255 255", (String)toBackground);
        if (DebuggerEditor.isHighContrastTheme()) {
            RGB foreground = Display.getCurrent().getSystemColor(36).getRGB();
            RGB background = Display.getCurrent().getSystemColor(25).getRGB();
            attributes = String.format("%s %s %s %s %s %s", foreground.red, foreground.green, foreground.blue, background.red, background.green, background.blue);
        }
        this.view.doDefaultCommand("set styleAttributes.e " + attributes);
        String green = DebuggerEditor.isDarkTheme() ? "150 150 150" : "0 128 128";
        attributes = LpexPaletteAttributes.convert((String)(green + " 255 255 255"), (String)"255 255 255", (String)toBackground);
        if (DebuggerEditor.isHighContrastTheme()) {
            RGB foreground = Display.getCurrent().getSystemColor(21).getRGB();
            RGB background = Display.getCurrent().getSystemColor(25).getRGB();
            attributes = String.format("%s %s %s %s %s %s", foreground.red, foreground.green, foreground.blue, background.red, background.green, background.blue);
        }
        this.view.doDefaultCommand("set styleAttributes.n " + attributes);
    }

    public void setEditor(ITextEditor editor) {
        this.fEditor = editor;
        if (this.fEditor.getEditorInput() instanceof EngineSuppliedViewEditorInput) {
            this.fExecutableInfoAvailable = true;
            this.fEngineSuppliedEditorInput = (EngineSuppliedViewEditorInput)this.fEditor.getEditorInput();
        }
    }

    public void parseElement(int element) {
        this.parseOneElement(element);
    }

    public void parseAll() {
        this.setColors();
        if (this.fExecutableInfoAvailable) {
            int element = 1;
            while (element <= this.view.elements()) {
                this.parseOneElement(element);
                ++element;
            }
        }
    }

    private void parseOneElement(int element) {
        String text = this.view.elementText(element);
        long classes = this.view.elementClasses(element) & (this.classAll ^ 0xFFFFFFFFFFFFFFFFL);
        String styles = "";
        if (!this.fExecutableInfoAvailable) {
            return;
        }
        if (this.fEngineSuppliedEditorInput.isLineExecutable(element)) {
            styles = this.styleString('e', text.length());
            classes |= this.classExecutable;
        } else {
            styles = this.styleString('n', text.length());
            classes |= this.classNonExecutable;
        }
        this.view.setElementStyle(element, styles);
        this.view.setElementClasses(element, classes);
    }

    protected void blockMarkWord() {
        this.view.doDefaultCommand("block clear");
        LpexDocumentLocation cursorLoc = this.view.documentLocation();
        if (this.fEditor == null) {
            return;
        }
        if (!(this.fEditor.getEditorInput() instanceof EngineSuppliedViewEditorInput)) {
            super.blockMarkWord();
            return;
        }
        ViewFile viewFile = ((EngineSuppliedViewEditorInput)this.fEditor.getEditorInput()).getViewFile();
        if (viewFile == null) {
            return;
        }
        IdentifierParser parser = null;
        try {
            parser = viewFile.getPart().getLanguage().getIdentifierParser();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (parser == null) {
            return;
        }
        int prefixLength = ((EngineSuppliedViewEditorInput)this.fEditor.getEditorInput()).getPrefixLength();
        parser.setPrefixLength(prefixLength);
        parser.setViewInfoID(((EngineSuppliedViewEditorInput)this.fEditor.getEditorInput()).getViewInformation().getKind());
        String lineText = this.view.elementText(cursorLoc.element);
        int[] identifierInString = parser.identifierInString(viewFile, cursorLoc.element, lineText, cursorLoc.position - 1);
        if (identifierInString == null || identifierInString[0] < 0) {
            return;
        }
        LpexDocumentLocation start = new LpexDocumentLocation(cursorLoc.element, identifierInString[0] + 1);
        LpexDocumentLocation end = new LpexDocumentLocation(cursorLoc.element, identifierInString[1] + 1);
        String type = this.view.query("current.block.defaultType");
        if (type.equals("element")) {
            type = "stream";
        }
        if (type.equals("stream")) {
            ++end.position;
        }
        this.view.jump(end);
        this.view.doDefaultCommand(start, "block set " + type);
        this.view.doDefaultCommand("block set");
        if (PreferenceUI.isDoubleClickAddMonitor()) {
            MonitorUtils.addMonitor(this.fEditor);
        }
    }
}

