/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.dialogs;

import com.ibm.debug.pdt.internal.core.OptionalBreakpointData;
import com.ibm.debug.pdt.internal.core.PDTDebugTarget;
import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.core.PICLMessages;
import com.ibm.debug.pdt.internal.core.model.Breakpoint;
import com.ibm.debug.pdt.internal.core.model.DebuggeeProcess;
import com.ibm.debug.pdt.internal.core.model.EngineRequestErrorException;
import com.ibm.debug.pdt.internal.core.model.EngineRequestException;
import com.ibm.debug.pdt.internal.core.model.Watchpoint;
import com.ibm.debug.pdt.internal.core.util.PDTCoreUtils;
import com.ibm.debug.pdt.internal.epdc.EStdView;
import com.ibm.debug.pdt.internal.ui.PICLDebugPlugin;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import com.ibm.debug.pdt.internal.ui.dialogs.BreakpointWizard;
import com.ibm.debug.pdt.internal.ui.dialogs.ConditionalBreakpointWizardPage;
import com.ibm.debug.pdt.internal.ui.dialogs.WatchBPWizardPage;
import com.ibm.debug.pdt.internal.ui.util.StatusInfo;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.progress.WorkbenchJob;

public class WatchBPWizard
extends BreakpointWizard {
    protected static final String DIALOG = "WatchBPWizard.dialog";
    protected static final String PAGE_1 = "WatchBPWizard.page1";
    protected static final String PAGE_2 = "BreakpointWizard.optional";
    private Watchpoint existingBP;

    public WatchBPWizard(PDTDebugTarget debugTarget) {
        super(debugTarget);
        this.fEditing = false;
        this.existingBP = null;
        this.initializeWizard();
    }

    public WatchBPWizard(PDTDebugTarget debugTarget, Watchpoint breakpoint) {
        super(debugTarget);
        this.fEditing = true;
        this.existingBP = breakpoint;
        this.initializeWizard();
    }

    private void initializeWizard() {
        if (!this.fEditing) {
            this.setWindowTitle(PICLLabels.WatchBPWizard_dialog_title);
        } else {
            this.setWindowTitle(PICLLabels.WatchBPWizard_dialog_title2);
        }
        this.setDefaultPageImageDescriptor(PICLUtils.getImageDescriptor("PICL_ICON_BREAKPOINT_WIZARD"));
        this.setNeedsProgressMonitor(false);
        IDialogSettings dialogSettings = PICLDebugPlugin.getInstance().getDialogSettings();
        IDialogSettings section = dialogSettings.getSection(DIALOG);
        if (section == null) {
            section = dialogSettings.addNewSection(DIALOG);
        }
        this.setDialogSettings(section);
    }

    public void addPages() {
        this.fMainPageName = PICLLabels.WatchBPWizard_page1_pageName;
        this.addPage((IWizardPage)new WatchBPWizardPage(this.fMainPageName, PICLLabels.WatchBPWizard_page1_title, null, this.fDebugTarget, this.existingBP));
        if (this.areOptionalParametersSupported()) {
            ConditionalBreakpointWizardPage condPage = new ConditionalBreakpointWizardPage(this.fCondPageName, PICLLabels.BreakpointWizard_optional_title, null, this.fDebugTarget, (Breakpoint)this.existingBP);
            condPage.setSupportsExpressionField(this.fDebugTarget.supportsExpressionOnConditionalBkp() && this.fDebugTarget.supportsChgAddrContionalBkp());
            this.addPage((IWizardPage)condPage);
        }
    }

    @Override
    public boolean performFinish() {
        if (this.checkFinishButtonClicked()) {
            return false;
        }
        final WatchBPWizardPage mainPage = (WatchBPWizardPage)this.getPage(this.fMainPageName);
        final ConditionalBreakpointWizardPage condPage = this.areOptionalParametersSupported() ? (ConditionalBreakpointWizardPage)this.getPage(this.fCondPageName) : new ConditionalBreakpointWizardPage("", "", null, this.fDebugTarget, (Breakpoint)this.existingBP);
        final EStdView esv = mainPage.getEStdView();
        final WatchBPWizardPage.PageData mainPageData = mainPage.getPageData();
        final OptionalBreakpointData condPageData = condPage.getPageData();
        condPageData.setUserLabel(mainPageData.userLabel);
        Job job = new Job(PICLLabels.BreakpointWizard_jobname_CreateModify){

            protected IStatus run(IProgressMonitor monitor) {
                StatusInfo created;
                final StatusInfo processResult = created = WatchBPWizard.this.processBreakpoint(esv, mainPageData, condPageData);
                if (!mainPage.getControl().isDisposed()) {
                    WatchBPWizard.this.wbJob = new WorkbenchJob(PICLLabels.BreakpointWizard_jobname_Update){

                        public IStatus runInUIThread(IProgressMonitor wbMonitor) {
                            WatchBPWizard.this.updateWizardPostProcessing(processResult, mainPage, condPage);
                            return Status.OK_STATUS;
                        }
                    };
                    WatchBPWizard.this.wbJob.setSystem(true);
                    WatchBPWizard.this.wbJob.schedule();
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
        return false;
    }

    private StatusInfo processBreakpoint(EStdView esv, WatchBPWizardPage.PageData mainPageData, OptionalBreakpointData optData) {
        StatusInfo status = new StatusInfo();
        if (PDTCoreUtils.isEmpty((String)mainPageData.startAddress)) {
            status.setError(PICLMessages.WatchBPWizard_page1_addressError);
            return status;
        }
        if (mainPageData.numBytes < -1) {
            status.setError(PICLMessages.WatchBPWizard_page1_bytesError);
            return status;
        }
        if (this.fDebugTarget == null) {
            status.setError(PICLMessages.BreakpointWizard_targetError);
            return status;
        }
        try {
            if (!this.fEditing) {
                ((DebuggeeProcess)this.fDebugTarget.getProcess()).setWatchpoint(false, true, mainPageData.startAddress, mainPageData.numBytes, optData, null, esv, null, null, null, null);
            } else {
                this.existingBP.modify(mainPageData.startAddress, mainPageData.numBytes, optData);
            }
        }
        catch (EngineRequestErrorException ere) {
            if (ere.getReturnCode() == 323) {
                status.setWarning(ere.getMessage());
            } else {
                status.setError(ere.getMessage());
            }
        }
        catch (EngineRequestException engineRequestException) {
            // empty catch block
        }
        return status;
    }
}

