/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.dialogs;

import com.ibm.debug.pdt.core.breakpoints.GenericLineBreakpoint;
import com.ibm.debug.pdt.internal.core.OptionalBreakpointData;
import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.core.PICLMessages;
import com.ibm.debug.pdt.internal.ui.PICLDebugPlugin;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import com.ibm.debug.pdt.internal.ui.dialogs.ConditionalBreakpointWizardPage;
import com.ibm.debug.pdt.internal.ui.dialogs.GenericLineBPWizard;
import com.ibm.debug.pdt.internal.ui.dialogs.GenericLineBPWizardPage;
import com.ibm.debug.pdt.internal.ui.dialogs.ISettingsWriter;
import com.ibm.debug.pdt.internal.ui.util.StatusInfo;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.wizard.IWizardPage;

public class SourceLineBPWizard
extends GenericLineBPWizard {
    public SourceLineBPWizard() {
        this.fEditing = false;
        this.existingBP = null;
        this.initializeWizard();
    }

    public SourceLineBPWizard(GenericLineBreakpoint breakpoint) {
        this.fEditing = true;
        this.existingBP = breakpoint;
        this.initializeWizard();
    }

    @Override
    public void addPages() {
        super.addPages();
        ConditionalBreakpointWizardPage condPage = new ConditionalBreakpointWizardPage(this.fCondPageName, PICLLabels.BreakpointWizard_optional_title, null, this.fDebugTarget, this.existingBP);
        condPage.setSupportsExpressionField(true);
        condPage.setSupportsActionField(false);
        condPage.setSupportsFrequencyFields(true);
        condPage.setSupportsThreadField(false);
        condPage.setSupportsSyncStopControl(true);
        this.addPage((IWizardPage)condPage);
    }

    @Override
    public boolean performFinish() {
        GenericLineBPWizardPage page = (GenericLineBPWizardPage)this.getStartingPage();
        ConditionalBreakpointWizardPage conditionalPage = (ConditionalBreakpointWizardPage)this.getPage(this.fCondPageName);
        StatusInfo status = null;
        IMarker marker = page.getMarker();
        String executableInfo = page.getExecutableName();
        String objectInfo = page.getObjectName();
        String fileNameInfo = page.getFileName();
        int lineNumberInfo = page.getLineNumber();
        OptionalBreakpointData conditionalData = conditionalPage.getPageData();
        conditionalData.setUserLabel(page.getUserLabel());
        if (this.fEditing) {
            status = this.updateMarker(marker, executableInfo, objectInfo, fileNameInfo, lineNumberInfo, conditionalData);
        }
        if (status.isError()) {
            page.setErrorMessage(status.getMessage());
            this.showPage(page);
            this.resetAlreadyClicked();
            return false;
        }
        IWizardPage[] pages = this.getPages();
        int i = 0;
        while (i < this.getPageCount()) {
            if (pages[i] instanceof ISettingsWriter) {
                ((ISettingsWriter)pages[i]).writeSettings();
            }
            ++i;
        }
        PICLDebugPlugin.getInstance().saveDialogSettings();
        PICLUtils.refreshPropertiesView();
        return true;
    }

    private StatusInfo updateMarker(final IMarker marker, final String executableName, final String objectName, String sourceName, final int lineNumber, final OptionalBreakpointData conditionalData) {
        StatusInfo status = new StatusInfo();
        if (marker == null) {
            status.setError(PICLMessages.LineBPWizard_page1_resourceError);
            return status;
        }
        if (lineNumber <= 0) {
            status.setError(PICLMessages.LineBPWizard_page1_lineError);
            return status;
        }
        try {
            IWorkspaceRunnable body = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    Map attributes = marker.getAttributes();
                    attributes.put("lineNumber", lineNumber);
                    if (executableName == null || executableName.trim().length() == 0) {
                        attributes.put("moduleName", null);
                    } else {
                        attributes.put("moduleName", executableName);
                    }
                    if (objectName == null || objectName.trim().length() == 0) {
                        attributes.put("objectName", null);
                    } else {
                        attributes.put("objectName", objectName);
                    }
                    conditionalData.putAttributes(attributes);
                    marker.setAttributes(attributes);
                    PICLUtils.updateResourceSourceLineBPInfoMarker(marker.getResource(), executableName, objectName);
                }
            };
            ResourcesPlugin.getWorkspace().run(body, (ISchedulingRule)marker.getResource(), 1, null);
        }
        catch (CoreException ce) {
            status.setError(PICLMessages.LineBPWizard_page1_resourceError);
            return status;
        }
        return status;
    }
}

