/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.dialogs;

import com.ibm.debug.pdt.core.ProcessDetail;
import com.ibm.debug.pdt.core.ProcessList;
import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.core.PICLMessages;
import com.ibm.debug.pdt.internal.ui.PICLDebugPlugin;
import com.ibm.debug.pdt.internal.ui.PICLDebugTarget;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import com.ibm.debug.pdt.internal.ui.dialogs.DebugTrayDialog;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class ProcessSelectionDialog
extends DebugTrayDialog {
    private Table fTable;
    private TableViewer fTableViewer;
    private ProcessSelectionContentProvider fContentProvider;
    private Text fFilterText;
    private ProcessList fProcessList;
    private ProcessDetail[] fProcessDetails;
    private String fSelectedProcessID = null;
    private static final String SETTINGSSECTION = PICLDebugPlugin.getPluginID() + ".processSelectionDialog2";

    public ProcessSelectionDialog(Shell parent) {
        super(parent);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    public int open() {
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            @Override
            public void run() {
                ProcessSelectionDialog.this.access$superOpen();
            }
        });
        return this.getReturnCode();
    }

    void access$superOpen() {
        super.open();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(PICLLabels.ProcessSelectionDialog_title);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 8, PICLLabels.ProcessSelectionDialog_refreshButton, false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 8) {
            this.fTable.setRedraw(false);
            this.fTable.removeAll();
            PICLDebugTarget pdt = new PICLDebugTarget();
            this.fProcessDetails = pdt.getProcessDetailList().getProcessDetails();
            this.createTableEntries();
            this.fSelectedProcessID = null;
            this.fTable.setRedraw(true);
        } else {
            super.buttonPressed(buttonId);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        ((GridLayout)composite.getLayout()).numColumns = 1;
        Label label = new Label(composite, 0);
        label.setText(PICLLabels.ProcessSelectionDialog_filterDesc);
        this.fFilterText = new Text(composite, 2048);
        this.fFilterText.setLayoutData((Object)new GridData(4, 4, true, false));
        this.fFilterText.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                ProcessSelectionDialog.this.fTableViewer.refresh();
            }
        });
        this.createTable(composite);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 1;
        gridData.heightHint = 250;
        this.fTable.setLayoutData((Object)gridData);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getShell(), PICLUtils.getHelpResourceString("browse_process"));
        return composite;
    }

    private void createTable(Composite parent) {
        this.fTable = new Table(parent, 68100);
        this.fTable.setHeaderVisible(true);
        this.fTableViewer = new TableViewer(this.fTable);
        this.fContentProvider = new ProcessSelectionContentProvider();
        this.fTableViewer.setContentProvider((IContentProvider)this.fContentProvider);
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)this.fContentProvider);
        this.fTableViewer.setComparator((ViewerComparator)new ProcessSelectionComparator());
        this.fTableViewer.addFilter((ViewerFilter)new ProcessSelectionFilter());
        TableLayout tableLayout = new TableLayout();
        PICLDebugTarget pdt = new PICLDebugTarget();
        this.fProcessList = pdt.getProcessDetailList();
        if (this.fProcessList == null) {
            PICLDebugPlugin.showMessageDialog(null, 1, PICLLabels.Attach_errorTitle, PICLMessages.picl_debug_target_error_engineNotLaunched, false);
            return;
        }
        this.fProcessDetails = this.fProcessList.getProcessDetails();
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(10));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(10));
        TableColumn column = new TableColumn(this.fTable, 16384);
        column.setText(this.fProcessList.getProcessIDColName());
        column.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                ProcessSelectionDialog.this.fTable.setSortColumn(ProcessSelectionDialog.this.fTable.getColumn(0));
                if (ProcessSelectionDialog.this.fTable.getSortDirection() == 128) {
                    ProcessSelectionDialog.this.fTable.setSortDirection(1024);
                } else {
                    ProcessSelectionDialog.this.fTable.setSortDirection(128);
                }
                ProcessSelectionDialog.this.fTableViewer.refresh();
            }
        });
        column = new TableColumn(this.fTable, 16384);
        column.setText(this.fProcessList.getExecutableColName());
        column.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                ProcessSelectionDialog.this.fTable.setSortColumn(ProcessSelectionDialog.this.fTable.getColumn(1));
                if (ProcessSelectionDialog.this.fTable.getSortDirection() == 128) {
                    ProcessSelectionDialog.this.fTable.setSortDirection(1024);
                } else {
                    ProcessSelectionDialog.this.fTable.setSortDirection(128);
                }
                ProcessSelectionDialog.this.fTableViewer.refresh();
            }
        });
        this.fTable.setSortDirection(128);
        this.fTable.setSortColumn(this.fTable.getColumn(1));
        this.fTable.setLayout((Layout)tableLayout);
        this.fTable.setEnabled(true);
        this.fTable.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                TableItem[] selection = ProcessSelectionDialog.this.fTable.getSelection();
                ProcessSelectionDialog.this.fSelectedProcessID = selection != null && selection.length == 1 ? selection[0].getText(0) : null;
            }
        });
        this.createTableEntries();
    }

    private void createTableEntries() {
        this.fTableViewer.setInput((Object)this.fProcessDetails);
    }

    public String getSelectedProcess() {
        return this.fSelectedProcessID;
    }

    @Override
    protected Control createContents(Composite parent) {
        Control composite = super.createContents(parent);
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings settings = PICLDebugPlugin.getInstance().getDialogSettings();
        IDialogSettings section = settings.getSection(SETTINGSSECTION);
        if (section == null) {
            section = settings.addNewSection(SETTINGSSECTION);
        }
        return section;
    }

    public class ProcessSelectionComparator
    extends ViewerComparator {
        public int compare(Viewer viewer, Object e1, Object e2) {
            ProcessDetail a1 = (ProcessDetail)e1;
            ProcessDetail a2 = (ProcessDetail)e2;
            if (ProcessSelectionDialog.this.fTable.getColumn(0).equals(ProcessSelectionDialog.this.fTable.getSortColumn())) {
                if (ProcessSelectionDialog.this.fTable.getSortDirection() == 128) {
                    return Integer.valueOf(a1.getProcessID()).compareTo(Integer.valueOf(a2.getProcessID()));
                }
                return Integer.valueOf(a2.getProcessID()).compareTo(Integer.valueOf(a1.getProcessID()));
            }
            if (ProcessSelectionDialog.this.fTable.getSortDirection() == 128) {
                return a1.getExecutableName().compareTo(a2.getExecutableName());
            }
            return a2.getExecutableName().compareTo(a1.getExecutableName());
        }
    }

    public static class ProcessSelectionContentProvider
    extends LabelProvider
    implements IStructuredContentProvider,
    ITableLabelProvider {
        public Object[] getElements(Object inputElement) {
            return (ProcessDetail[])inputElement;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return ((ProcessDetail)element).getProcessID();
            }
            return ((ProcessDetail)element).getExecutableName();
        }
    }

    public class ProcessSelectionFilter
    extends ViewerFilter {
        boolean fIgnoreCase = true;

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            String filterText = ProcessSelectionDialog.this.fFilterText.getText();
            filterText = filterText.replaceAll("\\*", ".*");
            filterText = filterText.replaceAll("\\?", ".");
            String regex = filterText + ".*";
            Pattern pattern = null;
            try {
                pattern = this.fIgnoreCase ? Pattern.compile(regex, 2) : Pattern.compile(regex);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            if (pattern != null) {
                Matcher matcher = pattern.matcher(((ProcessDetail)element).getProcessID());
                if (matcher.matches()) {
                    return true;
                }
                matcher = pattern.matcher(((ProcessDetail)element).getExecutableName());
                if (matcher.matches()) {
                    return true;
                }
            }
            return false;
        }
    }
}

