/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.dialogs;

import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.core.model.Function;
import com.ibm.debug.pdt.internal.ui.PICLDebugPlugin;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import com.ibm.debug.pdt.internal.ui.dialogs.DebugTrayDialog;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;

public class OverloadedDialog
extends DebugTrayDialog {
    private Function[] fFunctionArray;
    private static final String SETTINGSSECTION = PICLDebugPlugin.getPluginID() + ".overloadedDialog";
    private Table list;
    private Function fChoice;
    SelectionListener listListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent evt) {
        }

        public void widgetDefaultSelected(SelectionEvent evt) {
            OverloadedDialog.this.okPressed();
        }
    };

    public OverloadedDialog(Shell parentShell, Function[] functions) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fFunctionArray = functions;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(PICLLabels.OverloadedDialog_title);
    }

    public void create() {
        super.create();
        this.list.setFocus();
    }

    protected Control createDialogArea(Composite ancestor) {
        Composite parent = new Composite(ancestor, 0);
        parent.setLayout((Layout)new GridLayout());
        GridData gd = new GridData(1808);
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.widthHint = this.convertWidthInCharsToPixels(65);
        gd.heightHint = this.convertHeightInCharsToPixels(20);
        parent.setLayoutData((Object)gd);
        Label l = new Label(parent, 0);
        l.setText(PICLLabels.OverloadedDialog_message);
        l = new Label(parent, 0);
        l.setText(PICLLabels.OverloadedDialog_instruction);
        this.list = new Table(parent, 2052);
        this.list.addSelectionListener(this.listListener);
        this.list.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                OverloadedDialog.this.list.removeSelectionListener(OverloadedDialog.this.listListener);
            }
        });
        gd = new GridData(1808);
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        this.list.setLayoutData((Object)gd);
        this.initializeFunctionList();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getShell(), PICLUtils.getHelpResourceString("overloaded_dialog"));
        Dialog.applyDialogFont((Control)parent);
        return parent;
    }

    private void initializeFunctionList() {
        if (this.fFunctionArray == null) {
            return;
        }
        int i = 0;
        while (i < this.fFunctionArray.length) {
            TableItem tableItem = new TableItem(this.list, i);
            tableItem.setText(this.fFunctionArray[i].getViewFile().getPart().getModule().getName() + "." + this.fFunctionArray[i].getViewFile().getPart().getName() + "." + this.fFunctionArray[i].getName());
            ++i;
        }
        this.list.setSelection(0);
    }

    protected void okPressed() {
        this.fChoice = this.fFunctionArray[this.list.getSelectionIndex()];
        super.okPressed();
    }

    public Function getChoice() {
        return this.fChoice;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings settings = PICLDebugPlugin.getInstance().getDialogSettings();
        IDialogSettings section = settings.getSection(SETTINGSSECTION);
        if (section == null) {
            section = settings.addNewSection(SETTINGSSECTION);
        }
        return section;
    }
}

