/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.dialogs;

import com.ibm.debug.pdt.internal.core.PDTDebugTarget;
import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.core.model.OccurrenceBreakpoint;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import com.ibm.debug.pdt.internal.ui.dialogs.BreakpointWizardPage;
import com.ibm.debug.pdt.internal.ui.dialogs.ISettingsWriter;
import com.ibm.debug.pdt.internal.ui.util.DialogField;
import com.ibm.debug.pdt.internal.ui.util.IDialogFieldListener;
import com.ibm.debug.pdt.internal.ui.util.StringDialogField;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class OccurrenceBPWizardPage
extends BreakpointWizardPage
implements IDialogFieldListener,
ISettingsWriter {
    private OccurrenceBreakpoint fExistingBP = null;
    private StringDialogField conditionField;
    private StringDialogField fUserLabelField;
    private static final String PAGE_NAME = "OccurrenceBPWizard.page1";
    private static IDialogSettings section;
    private static final String CONDITIONNAME = "ConditionName";

    protected OccurrenceBPWizardPage(String pageName, String title, ImageDescriptor titleImage, OccurrenceBreakpoint editBreakpoint) {
        super(pageName, title, titleImage, null, editBreakpoint != null);
        this.fExistingBP = editBreakpoint;
        this.setDescription(PICLLabels.OccurrenceBPWizard_page1_description);
    }

    protected OccurrenceBPWizardPage(String pageName, String title, ImageDescriptor titleImage, PDTDebugTarget tgt, OccurrenceBreakpoint editBreakpoint) {
        super(pageName, title, titleImage, tgt, editBreakpoint != null);
        this.fExistingBP = editBreakpoint;
        this.setDescription(PICLLabels.OccurrenceBPWizard_page1_description);
    }

    public String getCondition() {
        return this.conditionField.getText();
    }

    public void createControl(Composite parent) {
        int nColumns = 3;
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        composite.setLayout((Layout)layout);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
        this.conditionField = new StringDialogField();
        this.conditionField.setLabelText(this.getConditionLabel());
        this.conditionField.setDialogFieldListener(this);
        this.conditionField.doFillIntoGrid(composite, nColumns);
        this.fUserLabelField = new StringDialogField();
        this.fUserLabelField.setLabelText(PICLLabels.OccurrenceBPWizard_page1_userLabel);
        this.fUserLabelField.doFillIntoGrid(composite, nColumns);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, PICLUtils.getHelpResourceString("occurrence_bp_wizard"));
        this.restoreSettings();
    }

    @Override
    public void dialogFieldChanged(DialogField field) {
        this.setErrorMessage(null);
        if (this.conditionField.getText().equals("")) {
            this.setPageComplete(false);
        } else {
            this.setPageComplete(true);
        }
    }

    private void initUsingOldBreakpoint() {
        this.conditionField.setText(this.fExistingBP.getCondition());
        if (this.fExistingBP.getUserLabel() != null) {
            this.fUserLabelField.setText(this.fExistingBP.getUserLabel());
        }
    }

    private void restoreSettings() {
        IDialogSettings dialogSettings;
        if (section == null && (section = (dialogSettings = this.getDialogSettings()).getSection(PAGE_NAME)) == null) {
            section = dialogSettings.addNewSection(PAGE_NAME);
        }
        if (this.fEditing) {
            this.initUsingOldBreakpoint();
            return;
        }
        String text = section.get(CONDITIONNAME);
        if (text != null) {
            this.conditionField.setText(text);
        }
    }

    @Override
    public void writeSettings() {
        section.put(CONDITIONNAME, this.conditionField.getText());
    }

    private String getConditionLabel() {
        return PICLLabels.OccurrenceBPWizard_page1_conditionLabel;
    }

    public String getUserLabel() {
        return this.fUserLabelField.getText();
    }
}

