/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.dialogs;

import com.ibm.debug.pdt.internal.core.OptionalBreakpointData;
import com.ibm.debug.pdt.internal.core.PDTDebugTarget;
import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.core.PICLMessages;
import com.ibm.debug.pdt.internal.core.model.Breakpoint;
import com.ibm.debug.pdt.internal.core.model.EngineRequestErrorException;
import com.ibm.debug.pdt.internal.core.model.EngineRequestException;
import com.ibm.debug.pdt.internal.core.model.OccurrenceBreakpoint;
import com.ibm.debug.pdt.internal.ui.PICLDebugPlugin;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import com.ibm.debug.pdt.internal.ui.dialogs.BreakpointWizard;
import com.ibm.debug.pdt.internal.ui.dialogs.ConditionalBreakpointWizardPage;
import com.ibm.debug.pdt.internal.ui.dialogs.OccurrenceBPWizardPage;
import com.ibm.debug.pdt.internal.ui.util.StatusInfo;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.progress.WorkbenchJob;

public class OccurrenceBPWizard
extends BreakpointWizard {
    protected static final String DIALOG = "OccurrenceBPWizard.dialog";
    protected static final String PAGE_1 = "OccurrenceBPWizard.page1";
    protected static final String PAGE_2 = "BreakpointWizard.optional";
    private OccurrenceBreakpoint existingBP;

    public OccurrenceBPWizard(PDTDebugTarget debugTarget) {
        super(debugTarget);
        this.fEditing = false;
        this.existingBP = null;
        this.initializeWizard();
    }

    public OccurrenceBPWizard(PDTDebugTarget debugTarget, OccurrenceBreakpoint breakpoint) {
        super(debugTarget);
        this.fEditing = true;
        this.existingBP = breakpoint;
        this.initializeWizard();
    }

    private void initializeWizard() {
        if (this.fEditing) {
            this.setWindowTitle(PICLLabels.OccurrenceBPWizard_dialog_title2);
        } else {
            this.setWindowTitle(PICLLabels.OccurrenceBPWizard_dialog_title);
        }
        this.setDefaultPageImageDescriptor(PICLUtils.getImageDescriptor("PICL_ICON_BREAKPOINT_WIZARD"));
        this.setNeedsProgressMonitor(false);
        IDialogSettings dialogSettings = PICLDebugPlugin.getInstance().getDialogSettings();
        IDialogSettings section = dialogSettings.getSection(DIALOG);
        if (section == null) {
            section = dialogSettings.addNewSection(DIALOG);
        }
        this.setDialogSettings(section);
    }

    public void addPages() {
        this.fMainPageName = PICLLabels.OccurrenceBPWizard_page1_pageName;
        this.addPage((IWizardPage)new OccurrenceBPWizardPage(this.fMainPageName, PICLLabels.OccurrenceBPWizard_page1_title, null, this.fDebugTarget, this.existingBP));
        if (this.areOptionalParametersSupported()) {
            ConditionalBreakpointWizardPage condPage = new ConditionalBreakpointWizardPage(this.fCondPageName, PICLLabels.BreakpointWizard_optional_title, null, this.fDebugTarget, (Breakpoint)this.existingBP);
            condPage.setSupportsExpressionField(false);
            condPage.setSupportsActionField(true);
            this.addPage((IWizardPage)condPage);
        }
    }

    @Override
    public boolean performFinish() {
        if (this.checkFinishButtonClicked()) {
            return false;
        }
        final OccurrenceBPWizardPage mainPage = (OccurrenceBPWizardPage)this.getPage(this.fMainPageName);
        final ConditionalBreakpointWizardPage condPage = this.areOptionalParametersSupported() ? (ConditionalBreakpointWizardPage)this.getPage(this.fCondPageName) : new ConditionalBreakpointWizardPage("", "", null, this.fDebugTarget, (Breakpoint)this.existingBP);
        final String condition = mainPage.getCondition();
        final OptionalBreakpointData optData = condPage.getPageData();
        optData.setUserLabel(mainPage.getUserLabel());
        Job job = new Job(PICLLabels.BreakpointWizard_jobname_CreateModify){

            protected IStatus run(IProgressMonitor monitor) {
                StatusInfo created;
                final StatusInfo processResult = created = OccurrenceBPWizard.this.processBreakpoint(condition, optData);
                if (!mainPage.getControl().isDisposed()) {
                    WorkbenchJob wbJob = new WorkbenchJob(PICLLabels.BreakpointWizard_jobname_Update){

                        public IStatus runInUIThread(IProgressMonitor wbMonitor) {
                            OccurrenceBPWizard.this.updateWizardPostProcessing(processResult, mainPage, condPage);
                            return Status.OK_STATUS;
                        }
                    };
                    wbJob.setSystem(true);
                    wbJob.schedule();
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
        return false;
    }

    private StatusInfo processBreakpoint(String condition, OptionalBreakpointData optData) {
        StatusInfo status = new StatusInfo();
        if (condition == null || condition.equals("")) {
            status.setError(PICLMessages.OccurrenceBPWizard_page1_conditionError);
            return status;
        }
        if (this.fDebugTarget == null) {
            status.setError(PICLMessages.BreakpointWizard_targetError);
            return status;
        }
        try {
            if (this.fEditing) {
                this.existingBP.modify(condition, optData);
            } else {
                this.fDebugTarget.createOccurrenceBreakpoint(true, condition, optData, null);
            }
        }
        catch (EngineRequestErrorException ere) {
            if (ere.getReturnCode() == 255) {
                status.setWarning(ere.getMessage());
            } else {
                status.setError(ere.getMessage());
            }
        }
        catch (EngineRequestException engineRequestException) {
            // empty catch block
        }
        return status;
    }
}

