/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.dialogs;

import com.ibm.debug.pdt.core.PDTDebugUtils;
import com.ibm.debug.pdt.internal.core.PDTDebugElement;
import com.ibm.debug.pdt.internal.core.PDTDebugTarget;
import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.core.PICLModule;
import com.ibm.debug.pdt.internal.core.model.DebugEngine;
import com.ibm.debug.pdt.internal.core.model.DebuggeeThread;
import com.ibm.debug.pdt.internal.core.model.EngineRequestException;
import com.ibm.debug.pdt.internal.core.model.LineBreakpoint;
import com.ibm.debug.pdt.internal.core.model.Location;
import com.ibm.debug.pdt.internal.core.model.Part;
import com.ibm.debug.pdt.internal.core.model.View;
import com.ibm.debug.pdt.internal.core.model.ViewFile;
import com.ibm.debug.pdt.internal.core.model.ViewInformation;
import com.ibm.debug.pdt.internal.core.util.PDTCoreUtils;
import com.ibm.debug.pdt.internal.ui.PICLDebugPlugin;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import com.ibm.debug.pdt.internal.ui.dialogs.BreakpointWizardPage;
import com.ibm.debug.pdt.internal.ui.dialogs.ISettingsWriter;
import com.ibm.debug.pdt.internal.ui.util.FieldTextAssist;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.fieldassist.ComboContentAdapter;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;

public class LineBPWizardPage
extends BreakpointWizardPage
implements ISettingsWriter {
    private static final String EMPTY = "";
    LineBreakpoint fExistingBP = null;
    Combo fExecutableField = null;
    private Label fExecutableLabel = null;
    Combo fObjectField = null;
    private Label fObjectLabel = null;
    Combo fFileField = null;
    Label fFileLabel = null;
    Text fLineNumberField = null;
    private Label fLineNumberLabel = null;
    private Text fUserLabelField = null;
    private Label fUserLabelLabel = null;
    private FieldTextAssist fAssistExecutable;
    private FieldTextAssist fAssistObject;
    private FieldTextAssist fAssistFile;
    private Button fDeferButton;
    private Part fChosenPart = null;
    private HashMap<ViewInformation, Button> fViewButtons = null;
    ViewInformation fChosenView = null;
    private static final String PAGE_NAME = "LineBPWizard.page1";
    private static final String EXECUTABLE = "executable";
    private static final String OBJECT = "object";
    private static final String FILE = "file";
    private static final String DEFER = "defer";
    private static final String LINE = "line";
    private static final String VIEW = "view";
    private boolean fSupportsDeferred = false;

    protected LineBPWizardPage(String pageName, String title, ImageDescriptor titleImage, PDTDebugTarget tgt, LineBreakpoint editBreakpoint) {
        super(pageName, title, titleImage, tgt, editBreakpoint != null);
        this.fExistingBP = editBreakpoint;
        this.setDescription(PICLLabels.LineBPWizard_page1_description);
        this.fSupportsDeferred = tgt.supportsDeferredBreakpoints();
    }

    public void createControl(Composite parent) {
        int n;
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        this.setControl((Control)composite);
        if (this.fSupportsDeferred && (this.fExistingBP == null || !this.fExistingBP.isSourceLineBreakpoint())) {
            this.fDeferButton = new Button(composite, 32);
            this.fDeferButton.setText(PICLLabels.LineBPWizard_page1_deferLabel);
            this.fDeferButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    LineBPWizardPage.this.fFileLabel.setText(LineBPWizardPage.this.getFileLabel());
                    String temp = LineBPWizardPage.this.fExecutableField.getText();
                    LineBPWizardPage.this.fExecutableField.removeAll();
                    LineBPWizardPage.this.fExecutableField.setText(temp);
                    temp = LineBPWizardPage.this.fObjectField.getText();
                    LineBPWizardPage.this.fObjectField.removeAll();
                    LineBPWizardPage.this.fObjectField.setText(temp);
                    temp = LineBPWizardPage.this.fFileField.getText();
                    LineBPWizardPage.this.fFileField.removeAll();
                    LineBPWizardPage.this.fFileField.setText(temp);
                    LineBPWizardPage.this.checkIfComplete();
                }
            });
        }
        this.fExecutableLabel = new Label(composite, 16384);
        this.fExecutableLabel.setText(this.getExecutableLabel());
        this.fExecutableField = new Combo(composite, 4);
        GridData gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        this.fExecutableField.setLayoutData((Object)gd);
        this.fAssistExecutable = new FieldTextAssist((Control)this.fExecutableField, (IControlContentAdapter)new ComboContentAdapter(), this.filter(this.fExecutableField.getItems(), this.fExecutableField.getText()));
        this.fExecutableField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LineBPWizardPage.this.fAssistExecutable.setProposals(LineBPWizardPage.this.filter(LineBPWizardPage.this.fExecutableField.getItems(), LineBPWizardPage.this.fExecutableField.getText()));
                LineBPWizardPage.this.checkIfComplete();
            }
        });
        this.fExecutableField.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                if (!LineBPWizardPage.this.isDeferred()) {
                    String currentText = LineBPWizardPage.this.fExecutableField.getText();
                    LineBPWizardPage.this.fillExecutables(LineBPWizardPage.this.fExecutableField, true);
                    LineBPWizardPage.this.fExecutableField.setText(currentText);
                    LineBPWizardPage.this.fAssistExecutable.setProposals(LineBPWizardPage.this.filter(LineBPWizardPage.this.fExecutableField.getItems(), LineBPWizardPage.this.fExecutableField.getText()));
                }
            }
        });
        this.fObjectLabel = new Label(composite, 16384);
        this.fObjectLabel.setText(this.getObjectLabel());
        this.fObjectField = new Combo(composite, 4);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        this.fObjectField.setLayoutData((Object)gd);
        this.fAssistObject = new FieldTextAssist((Control)this.fObjectField, (IControlContentAdapter)new ComboContentAdapter(), this.filter(this.fObjectField.getItems(), this.fObjectField.getText()));
        this.fObjectField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LineBPWizardPage.this.fAssistObject.setProposals(LineBPWizardPage.this.filter(LineBPWizardPage.this.fObjectField.getItems(), LineBPWizardPage.this.fObjectField.getText()));
                LineBPWizardPage.this.checkIfComplete();
            }
        });
        this.fObjectField.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                if (!LineBPWizardPage.this.isDeferred()) {
                    String currentText = LineBPWizardPage.this.fObjectField.getText();
                    LineBPWizardPage.this.fillObjects(LineBPWizardPage.this.fObjectField, true, LineBPWizardPage.this.fExecutableField.getText());
                    LineBPWizardPage.this.fObjectField.setText(currentText);
                    LineBPWizardPage.this.fAssistObject.setProposals(LineBPWizardPage.this.filter(LineBPWizardPage.this.fObjectField.getItems(), LineBPWizardPage.this.fObjectField.getText()));
                }
            }
        });
        DebugEngine de = this.fDebugTarget == null ? null : this.fDebugTarget.getDebugEngine();
        ViewInformation[] vinfos = de == null ? null : de.getSupportedViews();
        int numViewsLineBkpCapable = 0;
        if (vinfos != null) {
            ViewInformation[] viewInformationArray = vinfos;
            n = vinfos.length;
            int n2 = 0;
            while (n2 < n) {
                ViewInformation vinfo = viewInformationArray[n2];
                if (vinfo != null && vinfo.isLineBreakpointCapable()) {
                    ++numViewsLineBkpCapable;
                    this.fChosenView = vinfo;
                }
                ++n2;
            }
        }
        if (numViewsLineBkpCapable > 1) {
            this.fViewButtons = new HashMap();
            Group fileGrp = new Group(composite, 0);
            fileGrp.setText(PICLLabels.LineBPWizard_page1_views);
            fileGrp.setLayout((Layout)new GridLayout());
            ViewInformation[] viewInformationArray = vinfos;
            int n3 = vinfos.length;
            n = 0;
            while (n < n3) {
                ViewInformation vinfo = viewInformationArray[n];
                if (vinfo != null && vinfo.isLineBreakpointCapable()) {
                    ViewInformation viewInfo = vinfo;
                    Button b = new Button((Composite)fileGrp, 16);
                    this.fViewButtons.put(viewInfo, b);
                    b.setText(viewInfo.getName());
                    b.addSelectionListener(new SelectionListener(viewInfo){
                        private ViewInformation buttonViewInfo;
                        {
                            this.buttonViewInfo = viewInformation;
                        }

                        public void widgetSelected(SelectionEvent e) {
                            LineBPWizardPage.this.fChosenView = this.buttonViewInfo;
                            LineBPWizardPage.this.fFileField.removeAll();
                            if (LineBPWizardPage.this.fExistingBP != null) {
                                if (!LineBPWizardPage.this.fExistingBP.isDeferred()) {
                                    Location loc = null;
                                    loc = LineBPWizardPage.this.fExistingBP.getLocationWithinView(LineBPWizardPage.this.fChosenView);
                                    if (loc != null) {
                                        LineBPWizardPage.this.fillFiles(LineBPWizardPage.this.fFileField, LineBPWizardPage.this.fObjectField.getText(), LineBPWizardPage.this.fChosenView, loc.getViewFile());
                                        String text = String.valueOf(loc.getLineNumber());
                                        if (text != null) {
                                            LineBPWizardPage.this.fLineNumberField.setText(text);
                                        }
                                    }
                                } else {
                                    String text = LineBPWizardPage.this.fExistingBP.getFileName();
                                    if (text == null) {
                                        LineBPWizardPage.this.fFileField.setText(LineBPWizardPage.EMPTY);
                                    } else {
                                        LineBPWizardPage.this.fFileField.setText(text);
                                    }
                                    int lineNumber = 0;
                                    ViewInformation tmpVi = LineBPWizardPage.this.fExistingBP.getViewInformation();
                                    lineNumber = LineBPWizardPage.this.fExistingBP.getDeferredBreakpointLineNumber(tmpVi);
                                    if (lineNumber > 0) {
                                        LineBPWizardPage.this.fLineNumberField.setText(String.valueOf(lineNumber));
                                    } else {
                                        LineBPWizardPage.this.fLineNumberField.setText(LineBPWizardPage.EMPTY);
                                    }
                                }
                            } else {
                                LineBPWizardPage.this.fillFiles(LineBPWizardPage.this.fFileField, LineBPWizardPage.this.fObjectField.getText(), LineBPWizardPage.this.fChosenView, null);
                                if (LineBPWizardPage.this.fFileField.getItemCount() == 1) {
                                    LineBPWizardPage.this.fFileField.setText(LineBPWizardPage.this.fFileField.getItem(0));
                                }
                            }
                        }

                        public void widgetDefaultSelected(SelectionEvent e) {
                        }
                    });
                }
                ++n;
            }
        }
        this.fFileLabel = new Label(composite, 16384);
        this.fFileLabel.setText(this.getFileLabel());
        this.fFileField = new Combo(composite, 4);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        this.fFileField.setLayoutData((Object)gd);
        this.fAssistFile = new FieldTextAssist((Control)this.fFileField, (IControlContentAdapter)new ComboContentAdapter(), this.filter(this.fFileField.getItems(), this.fFileField.getText()));
        this.fFileField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LineBPWizardPage.this.fAssistFile.setProposals(LineBPWizardPage.this.filter(LineBPWizardPage.this.fFileField.getItems(), LineBPWizardPage.this.fFileField.getText()));
                LineBPWizardPage.this.checkIfComplete();
            }
        });
        this.fFileField.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                if (!LineBPWizardPage.this.isDeferred()) {
                    String currentText = LineBPWizardPage.this.fFileField.getText();
                    LineBPWizardPage.this.fillFiles(LineBPWizardPage.this.fFileField, LineBPWizardPage.this.fObjectField.getText(), LineBPWizardPage.this.fChosenView, null);
                    LineBPWizardPage.this.fFileField.setText(currentText);
                    LineBPWizardPage.this.fAssistFile.setProposals(LineBPWizardPage.this.filter(LineBPWizardPage.this.fFileField.getItems(), LineBPWizardPage.this.fFileField.getText()));
                }
            }
        });
        this.fLineNumberLabel = new Label(composite, 16384);
        this.fLineNumberLabel.setText(this.getLineOrStatementLabel());
        this.fLineNumberField = new Text(composite, 2052);
        gd = new GridData();
        gd.widthHint = 100;
        this.fLineNumberField.setLayoutData((Object)gd);
        this.fLineNumberField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LineBPWizardPage.this.checkIfComplete();
            }
        });
        this.fUserLabelLabel = new Label(composite, 16384);
        this.fUserLabelLabel.setText(PICLLabels.LineBPWizard_page1_userLabel);
        this.fUserLabelField = new Text(composite, 2052);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        this.fUserLabelField.setLayoutData((Object)gd);
        this.initializePage();
        this.checkIfComplete();
        if (this.fDebugTarget != null && this.fDebugTarget.supportsStatementBreakpoints()) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, PICLUtils.getHelpResourceString("statement_bp_wizard"));
        } else {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, PICLUtils.getHelpResourceString("line_bp_wizard"));
        }
        Dialog.applyDialogFont((Control)composite);
    }

    public String getStatementNumber() {
        if (this.fDebugTarget != null && this.fDebugTarget.supportsStatementBreakpoints()) {
            return this.fLineNumberField.getText();
        }
        return null;
    }

    public int getLineNumber() {
        int errorRC = -1;
        if (this.fDebugTarget != null && this.fDebugTarget.is390()) {
            errorRC = Integer.parseInt("3FFFFFFF", 16);
        }
        if (this.fDebugTarget != null && this.fDebugTarget.supportsStatementBreakpoints()) {
            ViewFile viewFile = this.getViewFileField();
            if (viewFile == null) {
                return errorRC;
            }
            int searchedLineNumber = viewFile.getLineNumberFromCache(this.fLineNumberField.getText());
            return searchedLineNumber;
        }
        try {
            return Integer.parseInt(this.fLineNumberField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            return errorRC;
        }
    }

    public String getExecutableName() {
        return this.fExecutableField.getText();
    }

    public String getObjectName() {
        return this.fObjectField.getText();
    }

    public String getFileName() {
        if (this.fFileField.getText().contains("[")) {
            return this.fFileField.getText().substring(0, this.fFileField.getText().indexOf(91) - 1);
        }
        return this.fFileField.getText();
    }

    public ViewFile getViewFileField() {
        if (this.isDeferred()) {
            return null;
        }
        String chosenExecutable = this.fExecutableField.getText();
        PICLModule chosenExecutableObj = null;
        if (chosenExecutable == null || chosenExecutable.equals(EMPTY)) {
            return null;
        }
        PDTDebugElement[] executables = null;
        try {
            executables = this.fDebugTarget.getModuleParent().getChildren();
        }
        catch (EngineRequestException engineRequestException) {
            // empty catch block
        }
        if (executables == null || executables.length == 0) {
            return null;
        }
        int i = 0;
        while (i < executables.length) {
            if (executables[i] != null && ((PICLModule)executables[i]).getModule().getName().equals(chosenExecutable)) {
                chosenExecutableObj = (PICLModule)executables[i];
            }
            ++i;
        }
        if (chosenExecutableObj == null) {
            return null;
        }
        String chosenObject = this.fObjectField.getText();
        Part chosenObjectObj = null;
        if (chosenObject == null || chosenObject.equals(EMPTY)) {
            return null;
        }
        PDTDebugElement[] objects = null;
        try {
            objects = chosenExecutableObj.getChildren();
        }
        catch (EngineRequestException engineRequestException) {
            // empty catch block
        }
        if (objects == null || objects.length == 0) {
            return null;
        }
        int i2 = 0;
        while (i2 < objects.length) {
            if (objects[i2] != null && ((Part)objects[i2]).getName().equals(chosenObject)) {
                chosenObjectObj = (Part)objects[i2];
            }
            ++i2;
        }
        if (chosenObjectObj == null) {
            return null;
        }
        String chosenFile = this.fFileField.getText();
        ViewFile chosenFileObj = null;
        ArrayList<ViewFile> lineBPAbleFiles = new ArrayList<ViewFile>();
        Part part = chosenObjectObj;
        ViewInformation viewInfo = this.fChosenView;
        try {
            ViewFile[] viewFiles = part.getView(viewInfo).getViewFiles();
            int i3 = 0;
            while (i3 < viewFiles.length) {
                lineBPAbleFiles.add(viewFiles[i3]);
                ++i3;
            }
        }
        catch (NullPointerException viewFiles) {
            // empty catch block
        }
        if (lineBPAbleFiles.isEmpty()) {
            return null;
        }
        Iterator filesIter = lineBPAbleFiles.iterator();
        ViewFile file = null;
        if (chosenFile.equals(EMPTY)) {
            while (filesIter.hasNext()) {
                file = (ViewFile)filesIter.next();
                if (file == null) continue;
                chosenFileObj = file;
                break;
            }
        } else {
            String baseFile = chosenFile;
            String path = EMPTY;
            if (chosenFile.contains("[")) {
                int begin = chosenFile.indexOf(91);
                int end = chosenFile.indexOf(93);
                baseFile = chosenFile.substring(0, begin - 1);
                path = chosenFile.substring(begin + 1, end);
            }
            while (filesIter.hasNext()) {
                file = (ViewFile)filesIter.next();
                if (file == null || !file.getBaseFileName().equals(baseFile)) continue;
                if (!path.isEmpty()) {
                    if (!file.getFileName().endsWith(path)) continue;
                    chosenFileObj = file;
                } else {
                    chosenFileObj = file;
                }
                break;
            }
        }
        return chosenFileObj;
    }

    public boolean isDeferred() {
        if (this.fSupportsDeferred && this.fDeferButton != null) {
            return this.fDeferButton.getSelection();
        }
        return false;
    }

    private void initializePage() {
        this.setPageComplete(false);
        if (this.fExistingBP == null) {
            int lineNumber = this.getInitialLineNumber();
            String lineOrStmtNumber = EMPTY;
            ViewFile vf = this.getViewFile();
            if (lineNumber > 0) {
                lineOrStmtNumber = String.valueOf(lineNumber);
            }
            if (vf != null) {
                this.fChosenView = vf.getView().getViewInformation();
                if (this.fViewButtons != null) {
                    this.fViewButtons.get(this.fChosenView).setSelection(true);
                }
                try {
                    String stmtNumber;
                    String moduleName = vf.getPart().getModule().getName();
                    String partName = vf.getPart().getName();
                    String fileName = vf.getBaseFileName();
                    if (moduleName != null) {
                        this.fExecutableField.setText(moduleName);
                    }
                    if (partName != null) {
                        this.fObjectField.setText(partName);
                    }
                    if (vf.getView().isLineBreakpointCapable() && fileName != null) {
                        this.fFileField.setText(fileName);
                    }
                    if (this.fDebugTarget.supportsStatementBreakpoints() && (stmtNumber = PDTCoreUtils.getStatementNumberFromLine((ViewFile)vf, (int)lineNumber)) != null && !stmtNumber.trim().equals(EMPTY)) {
                        lineOrStmtNumber = stmtNumber.trim();
                    }
                }
                catch (Exception e) {
                    PICLUtils.logError(e);
                }
                this.fLineNumberField.setText(lineOrStmtNumber);
                return;
            }
            if (this.getSettings() != null) {
                String text = this.getSettings().get(EXECUTABLE);
                if (text != null) {
                    this.fExecutableField.setText(text);
                }
                if ((text = this.getSettings().get(OBJECT)) != null) {
                    this.fObjectField.setText(text);
                }
                if ((text = this.getSettings().get(FILE)) != null) {
                    this.fFileField.setText(text);
                }
                if ((text = this.getSettings().get(LINE)) != null) {
                    this.fLineNumberField.setText(text);
                }
                if ((text = this.getSettings().get(VIEW)) != null) {
                    DebugEngine de = this.fDebugTarget.getDebugEngine();
                    ViewInformation[] vi = de.getSupportedViews();
                    int i = 0;
                    while (i < vi.length) {
                        if (vi[i] != null && vi[i].isLineBreakpointCapable() && vi[i].getName().equals(text)) {
                            if (this.fViewButtons != null) {
                                this.fViewButtons.get(vi[i]).setSelection(true);
                            }
                            this.fChosenView = vi[i];
                        }
                        ++i;
                    }
                }
            }
        } else {
            if (this.fDeferButton != null) {
                this.fDeferButton.setSelection(this.fExistingBP.isDeferred());
            }
            if (this.fExistingBP.isDeferred() || this.fExistingBP.isSourceLineBreakpoint()) {
                String stmtNumber;
                String lineOrStmtNumber = EMPTY;
                String text = this.fExistingBP.getModuleName();
                if (text == null) {
                    this.fExecutableField.setText(EMPTY);
                } else {
                    this.fExecutableField.setText(text);
                }
                text = this.fExistingBP.getPartName();
                if (text == null) {
                    this.fObjectField.setText(EMPTY);
                } else {
                    this.fObjectField.setText(text);
                }
                text = this.fExistingBP.getFileName();
                if (text == null) {
                    this.fFileField.setText(EMPTY);
                } else {
                    this.fFileField.setText(text);
                }
                if (this.fExistingBP.isSourceLineBreakpoint()) {
                    this.fExecutableField.setEnabled(false);
                    this.fObjectField.setEnabled(false);
                }
                int lineNumber = 0;
                this.fChosenView = this.fExistingBP.getViewInformation();
                lineNumber = this.fExistingBP.getDeferredBreakpointLineNumber(this.fChosenView);
                if (lineNumber > 0) {
                    lineOrStmtNumber = String.valueOf(lineNumber);
                }
                if ((stmtNumber = this.fExistingBP.getStatementNumber()) != null && !stmtNumber.trim().equals(EMPTY)) {
                    lineOrStmtNumber = stmtNumber;
                }
                if (this.fViewButtons != null) {
                    this.fViewButtons.get(this.fChosenView).setSelection(true);
                }
                this.fLineNumberField.setText(lineOrStmtNumber);
            } else {
                String stmtNumber;
                this.fExecutableField.setText(this.fExistingBP.getPart().getModule().getName());
                this.fObjectField.setText(this.fExistingBP.getPart().getName());
                ViewFile vf = this.getViewFile();
                this.fChosenView = vf != null ? vf.getView().getViewInformation() : this.fExistingBP.getViewInformation();
                if (this.fViewButtons != null) {
                    this.fViewButtons.get(this.fChosenView).setSelection(true);
                }
                String lineOrStmtNumber = EMPTY;
                Location loc = this.fExistingBP.getLocationWithinView(this.fChosenView);
                if (loc != null) {
                    this.fillFiles(this.fFileField, this.fObjectField.getText(), this.fChosenView, loc.getViewFile());
                    if (loc.getLineNumber() > 0) {
                        lineOrStmtNumber = String.valueOf(loc.getLineNumber());
                    }
                }
                if ((stmtNumber = this.fExistingBP.getStatementNumber()) != null && !stmtNumber.trim().equals(EMPTY)) {
                    lineOrStmtNumber = stmtNumber;
                }
                this.fLineNumberField.setText(lineOrStmtNumber);
            }
            String userLabel = this.fExistingBP.getUserLabel();
            if (userLabel != null) {
                this.fUserLabelField.setText(userLabel);
            }
        }
    }

    @Override
    public void writeSettings() {
        IDialogSettings settings = this.getSettings();
        if (settings == null) {
            this.getDialogSettings().addNewSection(PAGE_NAME);
        }
        settings = this.getSettings();
        settings.put(EXECUTABLE, this.fExecutableField.getText());
        settings.put(OBJECT, this.fObjectField.getText());
        settings.put(FILE, this.fFileField.getText());
        settings.put(VIEW, this.fChosenView.getName());
        if (this.fDeferButton != null) {
            settings.put(DEFER, this.fDeferButton.getSelection());
        }
    }

    private IDialogSettings getSettings() {
        IDialogSettings ds = this.getDialogSettings();
        if (ds == null) {
            return null;
        }
        return ds.getSection(PAGE_NAME);
    }

    private String getObjectLabel() {
        if (PDTDebugUtils.isiSeriesEngine((IDebugTarget)this.fDebugTarget)) {
            return PICLLabels.LineBPWizard_page1_object_400;
        }
        if (PDTDebugUtils.isDebugToolEngine((IDebugTarget)this.fDebugTarget) || PDTDebugUtils.iszPICLEngine((IDebugTarget)this.fDebugTarget)) {
            return PICLLabels.LineBPWizard_page1_object_debugTool;
        }
        return PICLLabels.LineBPWizard_page1_object;
    }

    private String getExecutableLabel() {
        if (PDTDebugUtils.isiSeriesEngine((IDebugTarget)this.fDebugTarget)) {
            return PICLLabels.LineBPWizard_page1_executable_400;
        }
        if (PDTDebugUtils.isDebugToolEngine((IDebugTarget)this.fDebugTarget) || PDTDebugUtils.iszPICLEngine((IDebugTarget)this.fDebugTarget)) {
            return PICLLabels.LineBPWizard_page1_executable_debugTool;
        }
        return PICLLabels.LineBPWizard_page1_executable;
    }

    protected String getFileLabel() {
        if (this.isDeferred()) {
            return PICLLabels.LineBPWizard_page1_sourceLabel;
        }
        return PICLLabels.LineBPWizard_page1_optionalSourceLabel;
    }

    private String getLineOrStatementLabel() {
        if (this.fDebugTarget != null && this.fDebugTarget.supportsStatementBreakpoints() && !this.isDeferred()) {
            return PICLLabels.LineBPWizard_page1_lineLabel2;
        }
        return PICLLabels.LineBPWizard_page1_lineLabel;
    }

    void checkIfComplete() {
        this.setErrorMessage(null);
        if (this.fExistingBP != null && this.fExistingBP.isSourceLineBreakpoint() && !this.fLineNumberField.getText().equals(EMPTY)) {
            this.setPageComplete(true);
        } else if (!(!this.isDeferred() || this.fExecutableField.getText().equals(EMPTY) || this.fObjectField.getText().equals(EMPTY) || this.fFileField.getText().equals(EMPTY) || this.fLineNumberField.getText().equals(EMPTY))) {
            this.setPageComplete(true);
        } else if (!(this.isDeferred() || this.fExecutableField.getText().equals(EMPTY) || this.fObjectField.getText().equals(EMPTY) || this.fLineNumberField.getText().equals(EMPTY) || this.getViewFileField() == null)) {
            this.setPageComplete(true);
        } else {
            this.setPageComplete(false);
        }
    }

    protected void fillFiles(Combo field, String chosenObject, ViewInformation chosenView, ViewFile currentFile) {
        field.removeAll();
        this.fChosenPart = this.getChosenPart(chosenObject);
        if (this.fChosenPart == null) {
            return;
        }
        ViewInformation viewInfo = chosenView;
        View view = this.fChosenPart.getView(viewInfo);
        if (view == null) {
            return;
        }
        ViewFile[] viewFiles = view.getViewFiles();
        if (viewFiles.length == 0) {
            return;
        }
        ArrayList<Object> viewFileNames = new ArrayList<Object>();
        int i = 0;
        while (i < viewFiles.length) {
            if (viewFiles[i] != null) {
                viewFileNames.add(viewFiles[i].getFileName());
            }
            ++i;
        }
        String root = EMPTY;
        if (viewFileNames.size() > 0 && ((String)viewFileNames.get(0)).contains("/")) {
            root = (String)viewFileNames.get(0);
            int i2 = 1;
            while (i2 < viewFileNames.size()) {
                root = this.commonPath(root, (String)viewFileNames.get(i2));
                ++i2;
            }
        }
        HashMap mp = new HashMap();
        String currentPath = EMPTY;
        ViewFile[] viewFileArray = viewFiles;
        int n = viewFiles.length;
        int n2 = 0;
        while (n2 < n) {
            ViewFile vf = viewFileArray[n2];
            if (mp.get(vf.getBaseFileName()) == null) {
                mp.put(vf.getBaseFileName(), new ArrayList());
            }
            ((ArrayList)mp.get(vf.getBaseFileName())).add(root.length() > 0 ? vf.getFileName().substring(root.length()) : vf.getFileName());
            if (currentFile != null && vf.getFileName().equals(currentFile.getFileName())) {
                currentPath = (String)((ArrayList)mp.get(vf.getBaseFileName())).get(((ArrayList)mp.get(vf.getBaseFileName())).size() - 1);
            }
            ++n2;
        }
        viewFileNames.clear();
        for (Map.Entry entry : mp.entrySet()) {
            if (((ArrayList)entry.getValue()).size() > 1) {
                for (String path : (ArrayList)entry.getValue()) {
                    viewFileNames.add((String)entry.getKey() + " [" + path + "]");
                }
                continue;
            }
            viewFileNames.add((String)entry.getKey());
        }
        Collections.sort(viewFileNames);
        Iterator namesIter = viewFileNames.iterator();
        String viewFileName = null;
        while (namesIter.hasNext()) {
            viewFileName = (String)namesIter.next();
            field.add(viewFileName);
        }
        if (currentFile != null) {
            if (((ArrayList)mp.get(currentFile.getBaseFileName())).size() > 1) {
                this.fFileField.setText(currentFile.getBaseFileName() + " [" + currentPath + "]");
            } else {
                this.fFileField.setText(currentFile.getBaseFileName());
            }
        }
    }

    private String commonPath(String p1, String p2) {
        int i = 0;
        while (i < Math.min(p1.length(), p2.length())) {
            if (p1.charAt(i) != p2.charAt(i)) {
                String s = p1.substring(0, i);
                return s.contains("/") ? s.substring(0, s.lastIndexOf(47)) : s;
            }
            ++i;
        }
        return p1.substring(0, Math.min(p1.length(), p2.length()));
    }

    private Part getChosenPart(String chosenObject) {
        if (this.fParts == null) {
            this.fillObjects(null, true, this.fExecutableField.getText());
            if (this.fParts == null) {
                return null;
            }
        }
        int i = 0;
        while (i < this.fParts.length) {
            if (this.fParts[i] != null && this.fParts[i].getName().equals(chosenObject)) {
                return this.fParts[i];
            }
            ++i;
        }
        return null;
    }

    private int getInitialLineNumber() {
        ITextEditor editor = PICLDebugPlugin.getActiveTextEditor();
        if (editor == null) {
            DebuggeeThread stoppingThread = this.fDebugTarget.getStoppingThread();
            if (stoppingThread == null) {
                return -1;
            }
            Location loc = stoppingThread.getLocation();
            return loc == null ? -1 : loc.getLineNumber();
        }
        return PICLUtils.getLineNumber((IEditorPart)editor);
    }

    public String getUserLabel() {
        return this.fUserLabelField.getText();
    }
}

