/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.dialogs;

import com.ibm.debug.pdt.core.breakpoints.GenericLineBreakpoint;
import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.core.PICLMessages;
import com.ibm.debug.pdt.internal.ui.PICLDebugPlugin;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import com.ibm.debug.pdt.internal.ui.dialogs.BreakpointWizard;
import com.ibm.debug.pdt.internal.ui.dialogs.GenericLineBPWizardPage;
import com.ibm.debug.pdt.internal.ui.dialogs.ISettingsWriter;
import com.ibm.debug.pdt.internal.ui.util.StatusInfo;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.IWizardPage;

public class GenericLineBPWizard
extends BreakpointWizard {
    protected static final String DIALOG = "LineBPWizard.dialog";
    protected static final String PAGE_1 = "LineBPWizard.page1";
    protected static final String PAGE_2 = "BreakpointWizard.optional";
    protected GenericLineBreakpoint existingBP;

    public GenericLineBPWizard() {
        super(null);
        this.existingBP = null;
        this.fEditing = false;
        this.initializeWizard();
    }

    public GenericLineBPWizard(GenericLineBreakpoint breakpoint) {
        super(null);
        this.fEditing = true;
        this.existingBP = breakpoint;
        this.initializeWizard();
    }

    protected void initializeWizard() {
        if (!this.fEditing) {
            this.setWindowTitle(PICLLabels.LineBPWizard_dialog_title);
        } else {
            this.setWindowTitle(PICLLabels.LineBPWizard_dialog_title2);
        }
        this.setDefaultPageImageDescriptor(PICLUtils.getImageDescriptor("PICL_ICON_BREAKPOINT_WIZARD"));
        this.setNeedsProgressMonitor(false);
        IDialogSettings dialogSettings = PICLDebugPlugin.getInstance().getDialogSettings();
        IDialogSettings section = dialogSettings.getSection(DIALOG);
        if (section == null) {
            section = dialogSettings.addNewSection(DIALOG);
        }
        this.setDialogSettings(section);
    }

    public void addPages() {
        this.fMainPageName = PICLLabels.LineBPWizard_page1_pageName;
        this.addPage((IWizardPage)new GenericLineBPWizardPage(this.fMainPageName, PICLLabels.LineBPWizard_page1_title, this.existingBP));
    }

    @Override
    public boolean performFinish() {
        GenericLineBPWizardPage page = (GenericLineBPWizardPage)this.getStartingPage();
        StatusInfo status = null;
        IMarker marker = page.getMarker();
        String executableInfo = page.getExecutableName();
        String objectInfo = page.getObjectName();
        String fileNameInfo = page.getFileName();
        int lineNumberInfo = page.getLineNumber();
        String userLabel = page.getUserLabel();
        status = this.fEditing ? this.updateMarker(marker, executableInfo, objectInfo, fileNameInfo, lineNumberInfo, userLabel) : this.createMarker(executableInfo, objectInfo, fileNameInfo, lineNumberInfo, userLabel);
        if (status.isError()) {
            page.setErrorMessage(status.getMessage());
            this.showPage(page);
            this.resetAlreadyClicked();
            return false;
        }
        IWizardPage[] pages = this.getPages();
        int i = 0;
        while (i < this.getPageCount()) {
            if (pages[i] instanceof ISettingsWriter) {
                ((ISettingsWriter)pages[i]).writeSettings();
            }
            ++i;
        }
        PICLDebugPlugin.getInstance().saveDialogSettings();
        super.performFinish();
        return true;
    }

    private StatusInfo updateMarker(final IMarker marker, final String executableName, final String objectName, String sourceName, final int lineNumber, final String userLabel) {
        StatusInfo status = new StatusInfo();
        if (marker == null) {
            status.setError(PICLMessages.LineBPWizard_page1_resourceError);
            return status;
        }
        if (lineNumber <= 0) {
            status.setError(PICLMessages.LineBPWizard_page1_lineError);
            return status;
        }
        try {
            IWorkspaceRunnable body = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    Map attributes = marker.getAttributes();
                    attributes.put("lineNumber", lineNumber);
                    if (executableName == null || executableName.trim().length() == 0) {
                        attributes.put("moduleName", null);
                    } else {
                        attributes.put("moduleName", executableName);
                    }
                    if (objectName == null || objectName.trim().length() == 0) {
                        attributes.put("objectName", null);
                    } else {
                        attributes.put("objectName", objectName);
                    }
                    if (userLabel == null || userLabel.trim().length() == 0) {
                        attributes.put("userLabel", null);
                    } else {
                        attributes.put("userLabel", userLabel);
                    }
                    marker.setAttributes(attributes);
                }
            };
            ResourcesPlugin.getWorkspace().run(body, (ISchedulingRule)marker.getResource(), 1, null);
        }
        catch (CoreException ce) {
            status.setError(PICLMessages.LineBPWizard_page1_resourceError);
            return status;
        }
        return status;
    }

    private StatusInfo createMarker(String executableName, String objectName, String sourceName, int lineNumber, String userLabel) {
        StatusInfo status = new StatusInfo();
        IWorkspaceRoot resource = ResourcesPlugin.getWorkspace().getRoot();
        if (resource == null) {
            status.setError(PICLMessages.LineBPWizard_page1_resourceError);
            return status;
        }
        if (lineNumber <= 0) {
            status.setError(PICLMessages.LineBPWizard_page1_lineError);
            return status;
        }
        return status;
    }
}

