/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.dialogs;

import com.ibm.debug.pdt.core.PDTDebugUtils;
import com.ibm.debug.pdt.internal.core.PDTDebugTarget;
import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.core.model.DebuggeeProcess;
import com.ibm.debug.pdt.internal.core.model.EntryBreakpoint;
import com.ibm.debug.pdt.internal.core.util.EntryListItem;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import com.ibm.debug.pdt.internal.ui.dialogs.BreakpointWizardPage;
import com.ibm.debug.pdt.internal.ui.dialogs.ISettingsWriter;
import com.ibm.debug.pdt.internal.ui.util.EntryFilterList;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;

public class EntrySelectBPWizardPage
extends BreakpointWizardPage
implements ISettingsWriter {
    private EntryListItem fSelectedItem;
    private EntryListItem[] fFunctionList;
    protected EntryFilterList fEntryFilterControl = null;
    protected List fFileList;
    private Button fCaseButton;
    protected Label fMatches;
    protected Button fFilterDebugButton;
    private static final String PAGE_NAME = "EntrySelectBPWizard.page1";
    private static final String FILTER = "filter";

    protected EntrySelectBPWizardPage(String pageName, String title, ImageDescriptor titleImage, PDTDebugTarget tgt, EntryBreakpoint editBreakpoint) {
        super(pageName, title, titleImage, tgt, editBreakpoint != null);
        if (PDTDebugUtils.isiSeriesEngine((IDebugTarget)this.fDebugTarget)) {
            this.setDescription(PICLLabels.EntryBPWizard_page1_description_400);
        } else {
            this.setDescription(PICLLabels.EntryBPWizard_page1_description);
        }
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        this.setControl((Control)composite);
        Composite optionsComposite = new Composite(composite, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        optionsComposite.setLayout((Layout)layout);
        optionsComposite.setLayoutData((Object)new GridData(768));
        this.fFilterDebugButton = new Button(optionsComposite, 32);
        this.fFilterDebugButton.setText(PICLLabels.EntryBPWizard_page1_debugInfoLabel);
        this.fFilterDebugButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                EntrySelectBPWizardPage.this.fEntryFilterControl.initializeFunctions();
                EntrySelectBPWizardPage.this.fillFunctions();
            }
        });
        new Label(optionsComposite, 0);
        this.fCaseButton = new Button(optionsComposite, 32);
        this.fCaseButton.setText(PICLLabels.EntryBPWizard_page1_caseLabel);
        GridData gd = new GridData();
        this.fCaseButton.setLayoutData((Object)gd);
        this.fCaseButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                EntrySelectBPWizardPage.this.fEntryFilterControl.setIgnoreCase(!EntrySelectBPWizardPage.this.fCaseButton.getSelection());
            }
        });
        this.fMatches = new Label(optionsComposite, 0);
        this.fMatches.setLayoutData((Object)new GridData(4, 1, true, false));
        this.updateListCount(0);
        this.fEntryFilterControl = new EntryFilterList(this, true);
        this.fEntryFilterControl.addWidgets(composite);
        this.fFileList = new List(composite, 2820);
        gd = new GridData(4, 1, true, false);
        gd.minimumHeight = 100;
        this.fFileList.setLayoutData((Object)gd);
        this.initializePage();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, PICLUtils.getHelpResourceString("entry_select_bp_wizard"));
        Dialog.applyDialogFont((Control)composite);
        UIJob uij = new UIJob("Fill Entry List"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                EntrySelectBPWizardPage.this.fillFunctions();
                return Status.OK_STATUS;
            }
        };
        uij.schedule();
    }

    private void initializePage() {
        this.setPageComplete(false);
        this.initializeFunctions();
        this.checkIfComplete();
    }

    public String getFunctionName() {
        if (this.fSelectedItem != null) {
            return this.fSelectedItem.getFunctionName();
        }
        return "";
    }

    public int getSelectedFunctionEntryId() {
        if (this.fSelectedItem != null) {
            return this.fSelectedItem.getEntryId();
        }
        return 0;
    }

    public String getSelectedFunctionOriginalName() {
        if (this.fSelectedItem != null) {
            return this.fSelectedItem.getOriginalName();
        }
        return "";
    }

    public void setFunctionItem(EntryListItem functionItem) {
        this.fSelectedItem = functionItem;
        if (functionItem == null) {
            this.fFileList.removeAll();
        } else if (functionItem.getFileList() != null) {
            this.fFileList.setItems(functionItem.getFileList());
            this.fFileList.setSelection(0);
        } else {
            this.fFileList.removeAll();
        }
        this.checkIfComplete();
    }

    protected boolean isFilterOnDebug() {
        return this.fFilterDebugButton.getSelection();
    }

    public boolean isCaseSensitive() {
        return this.fCaseButton.getSelection();
    }

    @Override
    public void writeSettings() {
        IDialogSettings settings = this.getSettings();
        if (settings == null) {
            this.getDialogSettings().addNewSection(PAGE_NAME);
        }
        settings = this.getSettings();
        settings.put(FILTER, this.fFilterDebugButton.getSelection());
    }

    protected void initializeFunctions() {
        this.fEntryFilterControl.initializeFunctions();
        this.fFilterDebugButton.setSelection(true);
    }

    public void fillFunctions() {
        this.fEntryFilterControl.setFilterEntryEnabled(false);
        final DebuggeeProcess process = (DebuggeeProcess)this.fDebugTarget.getProcess();
        final boolean isFilterDebug = this.isFilterOnDebug();
        EPDC_EngineSession engineSession = process.getDebugEngine().getEngineSession();
        int timeout = engineSession.getConnectionTimeout();
        int newTimeout = 0;
        engineSession.setConnectionTimeout(newTimeout);
        try {
            this.getContainer().run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    monitor.beginTask(PICLLabels.EntrySelectBPWizard_page1_loading_entry_list, -1);
                    EntrySelectBPWizardPage.this.fFunctionList = process.getFunctionList(isFilterDebug);
                    monitor.done();
                }
            });
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        engineSession.setConnectionTimeout(timeout);
        this.fEntryFilterControl.setElements(this.fFunctionList);
        this.fEntryFilterControl.setFilter(this.fEntryFilterControl.getFilter(), true);
        this.fEntryFilterControl.setFilterEntryEnabled(true);
        this.fEntryFilterControl.setFocus();
    }

    private IDialogSettings getSettings() {
        IDialogSettings ds = this.getDialogSettings();
        if (ds == null) {
            return null;
        }
        return ds.getSection(PAGE_NAME);
    }

    protected void checkIfComplete() {
        this.setErrorMessage(null);
        if (this.fSelectedItem != null && this.fSelectedItem.getOriginalName().length() > 0) {
            this.setPageComplete(true);
            return;
        }
        this.setPageComplete(false);
    }

    boolean checkFunction() {
        this.setErrorMessage(null);
        if (this.fSelectedItem == null) {
            this.fEntryFilterControl.forceSelection();
        }
        return this.fSelectedItem != null;
    }

    public void updateListCount(int count) {
        this.fMatches.setText(PICLLabels.FileFilterDialog_matches + " " + count);
    }

    public void processDialog() {
        if (this.isPageComplete()) {
            this.getWizard().performFinish();
        }
    }

    public void dispose() {
        this.fEntryFilterControl.cleanup();
        super.dispose();
    }
}

