/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.dialogs;

import com.ibm.debug.pdt.internal.core.PDTDebugElement;
import com.ibm.debug.pdt.internal.core.PDTDebugTarget;
import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.core.PICLMessages;
import com.ibm.debug.pdt.internal.core.PICLRegisterGroup;
import com.ibm.debug.pdt.internal.core.model.EngineRequestException;
import com.ibm.debug.pdt.internal.core.model.EnhancedWatchpoint;
import com.ibm.debug.pdt.internal.core.model.EventBreakpoint;
import com.ibm.debug.pdt.internal.core.util.PDTCoreUtils;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import com.ibm.debug.pdt.internal.ui.dialogs.AbstractWatchBPWizardPage;
import com.ibm.debug.pdt.internal.ui.util.DialogField;
import com.ibm.debug.pdt.internal.ui.util.StringCombo;
import com.ibm.debug.pdt.internal.ui.util.StringDialogField;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;
import org.eclipse.core.runtime.Assert;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IRegister;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class EnhancedWatchBPWizardPage
extends AbstractWatchBPWizardPage
implements SelectionListener {
    private static final int MAX_REGISTER_BYTES_TO_MONITOR = 8;
    private String[] fRegisterBytesToMonitor;
    private EnhancedWatchpoint fExistingBP = null;
    private static final String[] WATCH_SELECTIONS = new String[]{PICLLabels.WatchBPWizard_page1_addressLabel, PICLLabels.EnhancedWatchBPWizard_page1_RegisterSelection};
    private Button[] fWatchRadios = new Button[WATCH_SELECTIONS.length];
    private Combo fRegisterList;
    private Button fEqualityCheck;
    private StringDialogField fEqualityField;
    private Button fRangeCheck;
    private static final String[] RANGE_SELECTIONS = new String[]{PICLLabels.EnhancedWatchBPWizard_page1_ModuleSelection, PICLLabels.EnhancedWatchBPWizard_page1_AddressRangeSelection};
    private Button[] fRangeRadios = new Button[RANGE_SELECTIONS.length];
    private StringCombo fModuleChoice;
    private StringCombo fObjectChoice;
    private StringDialogField fFromAddrField;
    private StringDialogField fToAddrField;
    private boolean isControlCompletelyCreated;
    private HashMap<String, PDTDebugElement> modulesLookup = new HashMap();
    private static final String PAGE_NAME = "EnhancedWatchBPWizard.page1";
    private static final String ADDRESS = "Address";
    private static final String REGISTER = "Register";
    private static final String WATCH_SELECTION = "WatchSelection";
    private static final String BYTES = "Bytes";
    private static final String EQUALTO = "EqualTo";
    private static final String EQUALITY_CHOICE = "EqualityChoice";
    private static final String MODULE = "Module";
    private static final String OBJECT = "Object";
    private static final String FROMADR = "FromAdr";
    private static final String TOADR = "ToAdr";
    private static final String RANGE_SELECTION = "RangeSelection";
    private static final String RANGE_CHOICE = "RangeChoice";

    public EnhancedWatchBPWizardPage(String pageName, String title, ImageDescriptor titleImage, PDTDebugTarget tgt, EnhancedWatchpoint editBreakpoint) {
        super(pageName, title, titleImage, tgt, (EventBreakpoint)editBreakpoint);
        this.fExistingBP = editBreakpoint;
        this.setDescription(PICLLabels.WatchBPWizard_page1_description);
        this.setRegisterBytesToMonitor();
    }

    private void setRegisterBytesToMonitor() {
        String[] defaults = this.getDefaultBytesToMonitor();
        if (defaults.length < 2) {
            this.fRegisterBytesToMonitor = defaults;
            return;
        }
        Vector<String> elements = new Vector<String>();
        elements.add(defaults[0]);
        int cur = 1;
        int val = Integer.parseInt(defaults[cur]);
        while (cur < defaults.length && val <= 8) {
            elements.add(String.valueOf(val));
            val = Integer.parseInt(defaults[++cur]);
        }
        this.fRegisterBytesToMonitor = elements.toArray(new String[elements.size()]);
    }

    @Override
    public void dialogFieldChanged(DialogField field) {
        this.setErrorMessage(null);
        this.isComplete();
        if (field == this.fModuleChoice) {
            this.populateObjectChoice();
        }
    }

    private void isComplete() {
        if (this.isControlCompletelyCreated) {
            boolean equalityIncomplete = this.fEqualityCheck.getSelection() && PDTCoreUtils.isEmpty((String)this.fEqualityField.getText());
            boolean rangeModuleComplete = this.isRangeModuleOptionSelected() && !PDTCoreUtils.isEmpty((String)this.fModuleChoice.getText());
            boolean rangeAddressComplete = this.isRangeAddressOptionSelected() && !PDTCoreUtils.isEmpty((String)this.fFromAddrField.getText()) && !PDTCoreUtils.isEmpty((String)this.fToAddrField.getText());
            boolean rangeIncomplete = this.fRangeCheck.getSelection() && !rangeModuleComplete && !rangeAddressComplete;
            this.setPageComplete((this.isAddressComplete() || this.isRegisterComplete()) && !equalityIncomplete && !rangeIncomplete);
        } else {
            this.setPageComplete(false);
        }
    }

    private final boolean isAddressComplete() {
        return this.fWatchRadios[0].getSelection() && !PDTCoreUtils.isEmpty((String)this.fAddrOrExprField.getText());
    }

    private final boolean isRegisterComplete() {
        return this.fWatchRadios[1].getSelection() && !PDTCoreUtils.isEmpty((String)this.fRegisterList.getText());
    }

    private final boolean isRangeModuleOptionSelected() {
        return this.fRangeCheck.getSelection() && this.fRangeRadios[0].getSelection();
    }

    private final boolean isRangeAddressOptionSelected() {
        return this.fRangeCheck.getSelection() && this.fRangeRadios[1].getSelection();
    }

    @Override
    public void writeSettings() {
        IDialogSettings section = this.getDialogSettings(PAGE_NAME);
        section.put(ADDRESS, this.fAddrOrExprField.getText());
        section.put(REGISTER, this.fRegisterList.getText());
        section.put(WATCH_SELECTION, this.fWatchRadios[0].getSelection() ? 0 : 1);
        section.put(BYTES, this.fBytesToMonitorList.getText());
        section.put(EQUALTO, this.fEqualityField.getText());
        section.put(EQUALITY_CHOICE, this.fEqualityCheck.getSelection());
        section.put(MODULE, this.fModuleChoice.getText());
        section.put(OBJECT, this.fObjectChoice.getText());
        section.put(FROMADR, this.fFromAddrField.getText());
        section.put(TOADR, this.fToAddrField.getText());
        section.put(RANGE_SELECTION, this.fRangeRadios[0].getSelection() ? 0 : 1);
        section.put(RANGE_CHOICE, this.fRangeCheck.getSelection());
    }

    private void initUsingSavedDialogSettings() {
        if (this.fDebugTarget.getDebugEngine().getEngineID() == 9 || this.fDebugTarget.getDebugEngine().getEngineID() == 11) {
            return;
        }
        IDialogSettings section = this.getDialogSettings(PAGE_NAME);
        String addr = section.get(ADDRESS);
        String reg = section.get(REGISTER);
        if (PDTCoreUtils.isEmpty((String)addr) && PDTCoreUtils.isEmpty((String)reg)) {
            return;
        }
        this.fAddrOrExprField.setTextWithoutUpdate(addr);
        this.fRegisterList.setText(reg);
        this.setRadioGroupSelection(this.fWatchRadios, section.getInt(WATCH_SELECTION));
        this.fBytesToMonitorList.setTextWithoutUpdate(section.get(BYTES));
        this.fEqualityField.setTextWithoutUpdate(section.get(EQUALTO));
        this.fEqualityCheck.setSelection(section.getBoolean(EQUALITY_CHOICE));
        this.fModuleChoice.setTextWithoutUpdate(section.get(MODULE));
        this.fObjectChoice.setTextWithoutUpdate(section.get(OBJECT));
        this.fFromAddrField.setTextWithoutUpdate(section.get(FROMADR));
        this.fToAddrField.setTextWithoutUpdate(section.get(TOADR));
        this.setRadioGroupSelection(this.fRangeRadios, section.getInt(RANGE_SELECTION));
        this.fRangeCheck.setSelection(section.getBoolean(RANGE_CHOICE));
    }

    private void setRadioGroupSelection(Button[] radioGroup, int selection) {
        int i = 0;
        while (i < radioGroup.length) {
            radioGroup[i].setSelection(selection == i);
            ++i;
        }
    }

    private void restoreSettings() {
        if (this.fEditing) {
            this.initUsingExistingBreakpoint();
        } else if (!this.doGetAddressFromEditor()) {
            this.initUsingSavedDialogSettings();
        }
        this.handleAllEvents();
        this.isComplete();
    }

    private boolean doGetAddressFromEditor() {
        String addrFromEditor = PICLUtils.getAddrOrExprFromActiveEditor();
        if (!PDTCoreUtils.isEmpty((String)addrFromEditor)) {
            this.fAddrOrExprField.setTextWithoutUpdate(addrFromEditor);
            return true;
        }
        return false;
    }

    private void initUsingExistingBreakpoint() {
        this.setItemToWatchUsingExistingBreakpoint();
        this.setEqualityOptionUsingExistingBreakpoint();
        this.setRangeOptionUsingExistingBreakpoint();
        if (this.fExistingBP.getUserLabel() != null) {
            this.fUserLabelField.setText(this.fExistingBP.getUserLabel());
        }
    }

    private void setItemToWatchUsingExistingBreakpoint() {
        String addr = this.fExistingBP.getAddrOrExpr();
        String reg = this.fExistingBP.getRegister();
        boolean usingAddrOrExpr = !PDTCoreUtils.isEmpty((String)addr);
        boolean usingRegister = !usingAddrOrExpr && !PDTCoreUtils.isEmpty((String)reg);
        this.assertMutualExclusion(usingAddrOrExpr, usingRegister);
        this.fWatchRadios[0].setSelection(usingAddrOrExpr);
        this.fWatchRadios[1].setSelection(usingRegister);
        if (usingAddrOrExpr) {
            this.fAddrOrExprField.setTextWithoutUpdate(addr);
        } else {
            this.fRegisterList.setText(reg);
        }
        this.fBytesToMonitorList.setTextWithoutUpdate(String.valueOf(this.fExistingBP.getByteCount()));
    }

    private void assertMutualExclusion(boolean pred1, boolean pred2) {
        Assert.isTrue((pred1 || pred2 ? 1 : 0) != 0);
        Assert.isTrue((!pred1 || !pred2 ? 1 : 0) != 0);
    }

    private void setEqualityOptionUsingExistingBreakpoint() {
        String match = this.fExistingBP.getMatchContents();
        if (!PDTCoreUtils.isEmpty((String)match)) {
            this.fEqualityCheck.setSelection(true);
            this.fEqualityField.setTextWithoutUpdate(match);
        }
    }

    private void setRangeOptionUsingExistingBreakpoint() {
        boolean usingManualRange;
        String modName = this.fExistingBP.getMatchModuleName();
        String objName = this.fExistingBP.getMatchPartName();
        String fromAddr = this.fExistingBP.getFromAddrRange();
        String toAddr = this.fExistingBP.getToAddrRange();
        boolean usingObjectAndModule = !PDTCoreUtils.isEmpty((String)modName);
        boolean bl = usingManualRange = !PDTCoreUtils.isEmpty((String)fromAddr) && !PDTCoreUtils.isEmpty((String)toAddr);
        if (usingObjectAndModule || usingManualRange) {
            this.assertMutualExclusion(usingObjectAndModule, usingManualRange);
            this.fRangeCheck.setSelection(true);
            this.fRangeRadios[0].setSelection(usingObjectAndModule);
            this.fRangeRadios[1].setSelection(usingManualRange);
            if (usingObjectAndModule) {
                this.fModuleChoice.setTextWithoutUpdate(modName);
                if (!PDTCoreUtils.isEmpty((String)objName)) {
                    this.fObjectChoice.setTextWithoutUpdate(objName);
                }
            } else {
                this.fFromAddrField.setTextWithoutUpdate(fromAddr);
                this.fToAddrField.setTextWithoutUpdate(toAddr);
            }
        }
    }

    @Override
    public void createControl(Composite parent) {
        Composite mainComposite = this.putNewCompositeWithGridLayoutInParent(parent, 1);
        this.setControl((Control)mainComposite);
        int watchGroupColumns = 3;
        Group watchGroup = this.putNewGroupWithLayoutGridLayoutInParent(PICLLabels.EnhancedWatchBPWizard_page1_ItemToWatchLabel, mainComposite, watchGroupColumns);
        this.fWatchRadios[0] = this.putNewRadioInComposite(WATCH_SELECTIONS[0], (Composite)watchGroup);
        this.createAddrOrExprFieldAsChildWidget((Composite)watchGroup, watchGroupColumns - 1, "");
        this.fWatchRadios[1] = this.putNewRadioInComposite(WATCH_SELECTIONS[1], (Composite)watchGroup);
        DialogField.createEmptySpace((Composite)watchGroup);
        this.fRegisterList = new Combo((Composite)watchGroup, 12);
        this.setControlToFillHorizontally((Control)this.fRegisterList);
        this.createAddAndPopulateBytesToMonitorListAsChildWidget((Composite)watchGroup, watchGroupColumns, null);
        Group conditionsGroup = this.putNewGroupWithLayoutGridLayoutInParent(PICLLabels.EnhancedWatchBPWizard_page1_ConditionsOnWatchedItemContentLabel, mainComposite, 1);
        this.fEqualityCheck = this.putNewCheckboxInComposite(PICLLabels.EnhancedWatchBPWizard_page1_StopIfContentsEqualLabel, (Composite)conditionsGroup);
        int equalityColumns = 2;
        Composite equalityComposite = this.putNewCompositeWithGridLayoutInParent((Composite)conditionsGroup, equalityColumns);
        this.setControlToFillHorizontally((Control)equalityComposite);
        this.fEqualityField = this.putNewStringDialogFieldInComposite("", equalityComposite, equalityColumns, true);
        this.fRangeCheck = this.putNewCheckboxInComposite(PICLLabels.EnhancedWatchBPWizard_page1_StopIfAddressInRangeLabel, (Composite)conditionsGroup);
        int rangeColumns = 4;
        Composite rangeComposite = this.putNewCompositeWithGridLayoutInParent((Composite)conditionsGroup, rangeColumns);
        this.setControlToFillHorizontally((Control)rangeComposite);
        DialogField.createEmptySpace(rangeComposite);
        this.fRangeRadios[0] = this.putNewRadioInComposite(RANGE_SELECTIONS[0], rangeComposite);
        this.setControlToSpanGridLayoutColumns((Control)this.fRangeRadios[0], rangeColumns - 1);
        DialogField.createEmptySpace(rangeComposite);
        DialogField.createEmptySpace(rangeComposite);
        this.fModuleChoice = this.putNewStringComboInComposite(PICLLabels.EnhancedWatchBPWizard_page1_ModuleLabel, rangeComposite, rangeColumns - 2, true, true);
        DialogField.createEmptySpace(rangeComposite);
        DialogField.createEmptySpace(rangeComposite);
        this.fObjectChoice = this.putNewStringComboInComposite(PICLLabels.EnhancedWatchBPWizard_page1_ObjectLabel, rangeComposite, rangeColumns - 2, true, true);
        DialogField.createEmptySpace(rangeComposite);
        this.fRangeRadios[1] = this.putNewRadioInComposite(RANGE_SELECTIONS[1], rangeComposite);
        this.setControlToSpanGridLayoutColumns((Control)this.fRangeRadios[1], rangeColumns - 1);
        DialogField.createEmptySpace(rangeComposite);
        DialogField.createEmptySpace(rangeComposite);
        this.fFromAddrField = this.putNewStringDialogFieldInComposite(PICLLabels.EnhancedWatchBPWizard_page1_FromLabel, rangeComposite, rangeColumns - 2, true);
        DialogField.createEmptySpace(rangeComposite);
        DialogField.createEmptySpace(rangeComposite);
        this.fToAddrField = this.putNewStringDialogFieldInComposite(PICLLabels.EnhancedWatchBPWizard_page1_ToLabel, rangeComposite, rangeColumns - 2, true);
        this.createUserLabelField(mainComposite, 3);
        this.initializeSelections();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)mainComposite, PICLUtils.getHelpResourceString("watch_bp_wizard"));
        this.restoreSettings();
        Dialog.applyDialogFont((Control)this.getControl());
    }

    private Group putNewGroupWithLayoutGridLayoutInParent(String groupTitle, Composite parent, int nColumns) {
        Group group = new Group(parent, 32);
        group.setText(groupTitle);
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        group.setLayout((Layout)layout);
        this.setControlToFillHorizontally((Control)group);
        return group;
    }

    private void setControlToFillHorizontally(Control c) {
        c.setLayoutData((Object)new GridData(768));
    }

    private Button putNewRadioInComposite(String title, Composite composite) {
        Button radio = new Button(composite, 16);
        radio.setText(title);
        radio.addSelectionListener((SelectionListener)this);
        return radio;
    }

    private void initializeSelections() {
        this.setRadioGroupSelection(this.fWatchRadios, 0);
        this.populateRegisterList();
        this.fEqualityCheck.setSelection(false);
        this.fRangeCheck.setSelection(false);
        this.setRadioGroupSelection(this.fRangeRadios, 0);
        this.populateModuleChoice();
        this.populateObjectChoice();
        this.isControlCompletelyCreated = true;
    }

    private void populateRegisterList() {
        PICLRegisterGroup[] regGroups = this.fDebugTarget.getDebugEngine().getCurrentThread().getRegisterGroups();
        try {
            PICLRegisterGroup rgrp = regGroups[0];
            IRegister[] iRegisterArray = rgrp.getRegisters();
            int n = iRegisterArray.length;
            int n2 = 0;
            while (n2 < n) {
                IRegister reg = iRegisterArray[n2];
                this.fRegisterList.add(reg.getName());
                ++n2;
            }
        }
        catch (DebugException e) {
            PICLUtils.logError((Exception)((Object)e));
            this.fRegisterList.add(PICLMessages.EnhancedWatchBPWizard_page1_RegisterGetError);
        }
        this.fRegisterList.setText(this.fRegisterList.getItem(0));
    }

    private Button putNewCheckboxInComposite(String title, Composite composite) {
        Button check = new Button(composite, 32);
        check.setText(title);
        check.addSelectionListener((SelectionListener)this);
        return check;
    }

    private void setControlToSpanGridLayoutColumns(Control ctrl, int cols) {
        GridData gd = new GridData();
        gd.horizontalSpan = cols;
        gd.grabExcessHorizontalSpace = true;
        ctrl.setLayoutData((Object)gd);
    }

    private void populateModuleChoice() {
        PDTDebugElement[] modules;
        try {
            modules = this.fDebugTarget.getModuleParent().getChildren();
        }
        catch (EngineRequestException e) {
            PICLUtils.logError((Exception)((Object)e));
            this.fModuleChoice.setTextWithoutUpdate(PICLMessages.EnhancedWatchBPWizard_page1_ModuleListGetError);
            return;
        }
        ArrayList<String> moduleNames = new ArrayList<String>();
        PDTDebugElement[] pDTDebugElementArray = modules;
        int n = modules.length;
        int n2 = 0;
        while (n2 < n) {
            PDTDebugElement module = pDTDebugElementArray[n2];
            moduleNames.add(module.getLabel());
            this.modulesLookup.put(module.getLabel(), module);
            ++n2;
        }
        this.fModuleChoice.setItems(moduleNames.toArray(new String[moduleNames.size()]));
        this.fModuleChoice.setTextWithoutUpdate((String)moduleNames.get(0));
    }

    private void populateObjectChoice() {
        ArrayList<String> objectNames = new ArrayList<String>();
        objectNames.add("");
        PDTDebugElement module = this.modulesLookup.get(this.fModuleChoice.getText());
        if (module != null) {
            try {
                PDTDebugElement[] pDTDebugElementArray = module.getChildren();
                int n = pDTDebugElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    PDTDebugElement object = pDTDebugElementArray[n2];
                    objectNames.add(object.getLabel());
                    ++n2;
                }
            }
            catch (EngineRequestException e) {
                PICLUtils.logError((Exception)((Object)e));
                this.fObjectChoice.setTextWithoutUpdate(PICLMessages.EnhancedWatchBPWizard_page1_ModuleObjectsListGetError);
                return;
            }
        }
        this.fObjectChoice.setItems(objectNames.toArray(new String[objectNames.size()]));
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        Button rb;
        boolean eventHandled = false;
        Button[] buttonArray = this.fWatchRadios;
        int n = this.fWatchRadios.length;
        int n2 = 0;
        while (n2 < n) {
            rb = buttonArray[n2];
            if (e.widget == rb) {
                this.handleWatchRadioSelection();
                eventHandled = true;
            }
            ++n2;
        }
        if (!eventHandled) {
            if (e.widget == this.fEqualityCheck) {
                this.handleEqualityCheckOption();
                eventHandled = true;
            } else if (e.widget == this.fRangeCheck) {
                this.handleRangeCheckOption();
                eventHandled = true;
            }
        }
        if (!eventHandled) {
            buttonArray = this.fRangeRadios;
            n = this.fRangeRadios.length;
            n2 = 0;
            while (n2 < n) {
                rb = buttonArray[n2];
                if (e.widget == rb) {
                    this.handleRangeRadioSelection();
                    eventHandled = true;
                }
                ++n2;
            }
        }
        this.isComplete();
    }

    private void handleWatchRadioSelection() {
        this.fAddrOrExprField.setEnabled(this.fWatchRadios[0].getSelection());
        this.fRegisterList.setEnabled(this.fWatchRadios[1].getSelection());
        this.updateByteListChoices(this.fWatchRadios[0].getSelection());
    }

    private void updateByteListChoices(boolean isDefaultSelected) {
        String selected = this.fBytesToMonitorList.getText();
        String[] replacementList = isDefaultSelected ? this.getDefaultBytesToMonitor() : this.fRegisterBytesToMonitor;
        this.populateByteList(replacementList, this.getIndex(replacementList, selected));
    }

    private int getIndex(String[] replacementList, String selected) {
        int i = 0;
        while (i < replacementList.length) {
            if (replacementList[i].equals(selected)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void handleEqualityCheckOption() {
        this.fEqualityField.setEnabled(this.fEqualityCheck.getSelection());
    }

    private void handleRangeCheckOption() {
        Button[] buttonArray = this.fRangeRadios;
        int n = this.fRangeRadios.length;
        int n2 = 0;
        while (n2 < n) {
            Button rb = buttonArray[n2];
            rb.setEnabled(this.fRangeCheck.getSelection());
            ++n2;
        }
        this.handleRangeRadioSelection();
    }

    private void handleRangeRadioSelection() {
        boolean isRangeOptionSelected = this.fRangeCheck.getSelection();
        boolean isModuleSuboptionSelected = this.fRangeRadios[0].getSelection();
        boolean isAddressSuboptionSelected = this.fRangeRadios[1].getSelection();
        this.fModuleChoice.setEnabled(isModuleSuboptionSelected && isRangeOptionSelected);
        this.fObjectChoice.setEnabled(isModuleSuboptionSelected && isRangeOptionSelected);
        this.fFromAddrField.setEnabled(isAddressSuboptionSelected && isRangeOptionSelected);
        this.fToAddrField.setEnabled(isAddressSuboptionSelected && isRangeOptionSelected);
    }

    private void handleAllEvents() {
        this.handleWatchRadioSelection();
        this.handleEqualityCheckOption();
        this.handleRangeCheckOption();
    }

    PageData getPageData() {
        return new PageData(this.getAddressOrExpressionOfTheItemToWatch(), this.getRegisterOfTheItemToWatch(), this.getNumBytes(), this.getEqualityCondition(), this.getRangeModule(), this.getRangeOptionalObject(), this.getRangeAddressFrom(), this.getRangeAddressTo(), this.getUserLabel());
    }

    public String getAddressOrExpressionOfTheItemToWatch() {
        if (this.isAddressComplete()) {
            return this.fAddrOrExprField.getText();
        }
        return null;
    }

    public String getRegisterOfTheItemToWatch() {
        if (this.isRegisterComplete()) {
            return this.fRegisterList.getText();
        }
        return null;
    }

    public String getEqualityCondition() {
        if (this.fEqualityCheck.getSelection()) {
            return this.fEqualityField.getText();
        }
        return null;
    }

    public String getRangeModule() {
        if (this.isRangeModuleOptionSelected()) {
            return this.fModuleChoice.getText();
        }
        return null;
    }

    public String getRangeOptionalObject() {
        if (this.isRangeModuleOptionSelected()) {
            return this.fObjectChoice.getText();
        }
        return null;
    }

    public String getRangeAddressFrom() {
        if (this.isRangeAddressOptionSelected()) {
            return this.fFromAddrField.getText();
        }
        return null;
    }

    public String getRangeAddressTo() {
        if (this.isRangeAddressOptionSelected()) {
            return this.fToAddrField.getText();
        }
        return null;
    }

    static class PageData {
        final String watchAddr;
        final String watchReg;
        final int numBytes;
        final String equalCond;
        final String rangeMod;
        final String rangeObj;
        final String rangeFrom;
        final String rangeTo;
        final String userLabel;

        private PageData(String watchAddr, String watchReg, int numBytes, String equalCond, String rangeMod, String rangeObj, String rangeFrom, String rangeTo, String userLabel) {
            this.watchAddr = watchAddr;
            this.watchReg = watchReg;
            this.numBytes = numBytes;
            this.equalCond = equalCond;
            this.rangeMod = rangeMod;
            this.rangeObj = rangeObj;
            this.rangeFrom = rangeFrom;
            this.rangeTo = rangeTo;
            this.userLabel = userLabel;
        }
    }
}

