/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.dialogs;

import com.ibm.debug.pdt.core.breakpoints.GenericLineBreakpoint;
import com.ibm.debug.pdt.internal.core.OptionalBreakpointData;
import com.ibm.debug.pdt.internal.core.PDTDebugTarget;
import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.core.PICLMessages;
import com.ibm.debug.pdt.internal.core.model.Breakpoint;
import com.ibm.debug.pdt.internal.core.model.DebuggeeProcess;
import com.ibm.debug.pdt.internal.core.model.DebuggeeThread;
import com.ibm.debug.pdt.internal.core.util.PDTCoreUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.ui.PICLDebugPlugin;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import com.ibm.debug.pdt.internal.ui.contentassist.ContentAssistProvider;
import com.ibm.debug.pdt.internal.ui.preferences.PreferenceUI;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class ConditionalBreakpointWizardPage
extends WizardPage
implements ModifyListener {
    private static final String PAGE_NAME = "BreakpointWizard.optional";
    private boolean fSupportsExpressionField;
    private boolean fSupportsFrequencyFields;
    private boolean fSupportsThreadField;
    private boolean fSupportsActionField;
    private boolean fSupportsSyncStopControl;
    private Combo fThreadCombo;
    private Text fFromText;
    private Text fToText;
    private Text fEveryText;
    private Text fExpressionText;
    private Text fActionText;
    private ContentAssistProvider fActionFieldAssist;
    private Button fStopSyncCheckBox;
    private static IDialogSettings fDialogSettingsSection;
    private static final String EXPRESSION = "Expression";
    private static final String ACTION = "Action";
    private static final String TO = "To";
    private static final String FROM = "From";
    private static final String EVERY = "Every";
    private static final String THREAD = "Thread";
    private Breakpoint fExistingPICLModelBP;
    private GenericLineBreakpoint fExistingSourceLineBP;
    private boolean fEditing;
    private static final IThread[] EMPTYTHREADS;
    private static final String[] EMPTYTHREADNAMES;
    private PDTDebugTarget fDebugTarget;
    private int fCurrentThreadIndex = 0;
    private IThread[] fThreads = EMPTYTHREADS;

    static {
        EMPTYTHREADS = new IThread[0];
        EMPTYTHREADNAMES = new String[0];
    }

    private ConditionalBreakpointWizardPage(String pageName, String title, ImageDescriptor titleImage, PDTDebugTarget target) {
        super(pageName, title, titleImage);
        this.setDescription(PICLLabels.BreakpointWizard_optional_description);
        if (titleImage != null) {
            this.setImageDescriptor(titleImage);
        }
        this.fDebugTarget = target;
        if (this.fDebugTarget != null) {
            this.fSupportsExpressionField = this.fDebugTarget.supportsExpressionOnConditionalBkp();
            this.fSupportsActionField = this.fDebugTarget.supportsBreakpointActions();
            this.fSupportsFrequencyFields = this.fDebugTarget.supportsFreqOnConditionalBkp();
            this.fSupportsThreadField = this.fDebugTarget.supportsThreadOnConditionalBkp();
            this.fSupportsSyncStopControl = this.fDebugTarget.supportsBreakpointSyncAsyncStopControl();
        }
    }

    ConditionalBreakpointWizardPage(String pageName, String title, ImageDescriptor titleImage, PDTDebugTarget target, Breakpoint breakpoint) {
        this(pageName, title, titleImage, target);
        if (breakpoint != null) {
            this.fEditing = true;
            this.fExistingPICLModelBP = breakpoint;
        }
    }

    ConditionalBreakpointWizardPage(String pageName, String title, ImageDescriptor titleImage, PDTDebugTarget target, GenericLineBreakpoint breakpoint) {
        this(pageName, title, titleImage, target);
        if (breakpoint != null) {
            this.fEditing = true;
            this.fExistingSourceLineBP = breakpoint;
        }
    }

    void setSupportsExpressionField(boolean value) {
        this.fSupportsExpressionField = value;
    }

    void setSupportsFrequencyFields(boolean value) {
        this.fSupportsFrequencyFields = value;
    }

    void setSupportsThreadField(boolean value) {
        this.fSupportsThreadField = value;
    }

    void setSupportsActionField(boolean value) {
        this.fSupportsActionField = value;
    }

    void setSupportsSyncStopControl(boolean value) {
        this.fSupportsSyncStopControl = value;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && this.fSupportsThreadField) {
            this.fThreadCombo.setFocus();
        } else if (visible && this.fSupportsFrequencyFields) {
            this.fFromText.setFocus();
        } else if (this.fSupportsExpressionField) {
            this.fExpressionText.setFocus();
        } else if (this.fSupportsActionField) {
            this.fActionText.setFocus();
        }
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        composite.setLayout((Layout)layout);
        this.setControl((Control)composite);
        int THREADHELP = 4;
        int FREQHELP = 2;
        boolean EXPRHELP = true;
        int helpContents = 0;
        if (this.fSupportsThreadField) {
            helpContents = (byte)(helpContents ^ 4);
            Label threadLabel = new Label(composite, 0);
            threadLabel.setText(PICLLabels.BreakpointWizard_optional_threadLabel);
            threadLabel.setLayoutData((Object)this.getGridData(32, 1, 0));
            this.fThreadCombo = new Combo(composite, 12);
            String[] threads = this.getThreads();
            this.fThreadCombo.setItems(threads);
            this.fThreadCombo.setText(threads[this.fCurrentThreadIndex]);
            this.fThreadCombo.setLayoutData((Object)this.getGridData(768, 1, 0));
            this.fThreadCombo.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent arg0) {
                    ConditionalBreakpointWizardPage.this.validatePage();
                    ConditionalBreakpointWizardPage.this.setPageComplete(ConditionalBreakpointWizardPage.this.isPageComplete());
                }

                public void widgetDefaultSelected(SelectionEvent arg0) {
                    this.widgetSelected(arg0);
                }
            });
            Label spacer = new Label(composite, 0);
            spacer.setLayoutData((Object)this.getGridData(768, 1, 200));
        }
        if (this.fSupportsFrequencyFields) {
            helpContents = (byte)(helpContents ^ 2);
            Group frequencyGroup = new Group(composite, 4);
            frequencyGroup.setText(PICLLabels.BreakpointWizard_optional_frequencyLabel);
            frequencyGroup.setLayoutData((Object)this.getGridData(768, 2, 0));
            Label spacer = new Label(composite, 0);
            spacer.setLayoutData((Object)this.getGridData(768, 1, 0));
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = 2;
            frequencyGroup.setLayout((Layout)gridLayout);
            Label fromLabel = new Label((Composite)frequencyGroup, 0);
            fromLabel.setText(PICLLabels.BreakpointWizard_optional_fromLabel);
            fromLabel.setLayoutData((Object)this.getGridData(32, 1, 0));
            this.fFromText = new Text((Composite)frequencyGroup, 2052);
            this.fFromText.setText("1");
            this.fFromText.setLayoutData((Object)this.getGridData(768, 1, 0));
            Label toLabel = new Label((Composite)frequencyGroup, 0);
            toLabel.setText(PICLLabels.BreakpointWizard_optional_toLabel);
            toLabel.setLayoutData((Object)this.getGridData(32, 1, 0));
            this.fToText = new Text((Composite)frequencyGroup, 2052);
            this.fToText.setText(PICLLabels.BreakpointWizard_optional_defaultInfinity);
            this.fToText.setLayoutData((Object)this.getGridData(768, 1, 0));
            Label everyLabel = new Label((Composite)frequencyGroup, 0);
            everyLabel.setText(PICLLabels.BreakpointWizard_optional_everyLabel);
            everyLabel.setLayoutData((Object)this.getGridData(32, 1, 0));
            this.fEveryText = new Text((Composite)frequencyGroup, 2052);
            this.fEveryText.setText("1");
            this.fEveryText.setLayoutData((Object)this.getGridData(768, 1, 0));
            this.fFromText.addModifyListener((ModifyListener)this);
            this.fToText.addModifyListener((ModifyListener)this);
            this.fEveryText.addModifyListener((ModifyListener)this);
        }
        if (this.fSupportsExpressionField) {
            helpContents = (byte)(helpContents ^ 1);
            Label expressionLabel = new Label(composite, 0);
            expressionLabel.setText(PICLLabels.BreakpointWizard_optional_expressionLabel);
            expressionLabel.setLayoutData((Object)this.getGridData(32, 1, 0));
            this.fExpressionText = new Text(composite, 2052);
            this.fExpressionText.setLayoutData((Object)this.getGridData(768, 2, 0));
            this.fExpressionText.addModifyListener((ModifyListener)this);
        }
        if (this.fSupportsActionField) {
            Label actionLabel = new Label(composite, 0);
            actionLabel.setText(PICLLabels.BreakpointWizard_optional_actionLabel);
            actionLabel.setLayoutData((Object)this.getGridData(32, 1, 0));
            this.fActionText = new Text(composite, 2052);
            this.fActionText.setLayoutData((Object)this.getGridData(768, 2, 0));
            this.fActionText.addModifyListener((ModifyListener)this);
            EPDC_EngineSession engineSession = this.fDebugTarget.getDebugEngine().getEngineSession();
            if (engineSession.isDebugTool()) {
                this.fActionFieldAssist = new ContentAssistProvider((Control)this.fActionText);
                this.fActionFieldAssist.setProposals(this.fActionFieldAssist.getProposals(engineSession.getEngineVersionString(), "_BREAKPOINT"));
            }
        }
        if (this.fSupportsSyncStopControl) {
            this.fStopSyncCheckBox = new Button(composite, 32);
            this.fStopSyncCheckBox.setText(PICLLabels.BreakpointWizard_optional_syncStopLabel);
            this.fStopSyncCheckBox.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 3, 1));
            this.fStopSyncCheckBox.setSelection(PreferenceUI.isBrkptSuspendAllThreads());
        }
        Dialog.applyDialogFont((Control)composite);
        switch (helpContents) {
            case 1: {
                PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, PICLUtils.getHelpResourceString("cond_bp_wizard_expronly"));
                break;
            }
            case 2: {
                PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, PICLUtils.getHelpResourceString("cond_bp_wizard_freqonly"));
                break;
            }
            case 3: {
                PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, PICLUtils.getHelpResourceString("cond_bp_wizard_expr_freq"));
                break;
            }
            case 4: {
                PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, PICLUtils.getHelpResourceString("cond_bp_wizard_threadonly"));
                break;
            }
            case 5: {
                PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, PICLUtils.getHelpResourceString("cond_bp_wizard_thrd_expr"));
                break;
            }
            case 6: {
                PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, PICLUtils.getHelpResourceString("cond_bp_wizard_thrd_freq"));
                break;
            }
            default: {
                PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, PICLUtils.getHelpResourceString("cond_bp_wizard"));
            }
        }
        if (this.fEditing) {
            this.restoreSettings();
        }
    }

    public void flipToMe() {
        this.getWizard().getContainer().showPage((IWizardPage)this);
    }

    private void restoreSettings() {
        IDialogSettings dialogSettings;
        if (fDialogSettingsSection == null && (fDialogSettingsSection = (dialogSettings = this.getDialogSettings()).getSection(PAGE_NAME)) == null) {
            fDialogSettingsSection = dialogSettings.addNewSection(PAGE_NAME);
        }
        if (this.fEditing && (this.fExistingPICLModelBP != null || this.fExistingSourceLineBP != null)) {
            this.initUsingOldBreakpoint();
            return;
        }
        String text = "";
        if (this.fSupportsFrequencyFields) {
            text = fDialogSettingsSection.get(TO);
            if (text != null) {
                this.fToText.setText(text);
            }
            if ((text = fDialogSettingsSection.get(FROM)) != null) {
                this.fFromText.setText(text);
            }
            if ((text = fDialogSettingsSection.get(EVERY)) != null) {
                this.fEveryText.setText(text);
            }
        }
        if (this.fSupportsExpressionField && (text = fDialogSettingsSection.get(EXPRESSION)) != null) {
            this.fExpressionText.setText(text);
        }
        if (this.fSupportsActionField && (text = fDialogSettingsSection.get(ACTION)) != null) {
            this.fActionText.setText(text);
        }
    }

    OptionalBreakpointData getPageData() {
        return new OptionalBreakpointData(this.getExpression(), this.getBkpAction(), this.getThreadId(), this.getEveryValue(), this.getFromValue(), this.getToValue(), this.isBreakpointSynchronous());
    }

    @Deprecated
    public String getThreadValue() {
        if (this.fSupportsThreadField) {
            return this.fThreadCombo.getText();
        }
        return PICLLabels.BreakpointWizard_optional_defaultEvery;
    }

    public int getThreadId() {
        if (this.fSupportsThreadField) {
            int index = this.fThreadCombo.getSelectionIndex();
            if (!this.fDebugTarget.supportsThreadSpecificOnlyBreakpoints()) {
                --index;
            }
            if (index < 0) {
                return 0;
            }
            return ((DebuggeeThread)this.fThreads[index]).getId();
        }
        return 0;
    }

    public int getFromValue() {
        if (!this.fSupportsFrequencyFields) {
            return 1;
        }
        try {
            return Integer.parseInt(this.fFromText.getText());
        }
        catch (NumberFormatException e) {
            return 1;
        }
    }

    public int getToValue() {
        if (!this.fSupportsFrequencyFields) {
            return 0;
        }
        if (this.fToText.getText().equals(PICLLabels.BreakpointWizard_optional_defaultInfinity)) {
            return 0;
        }
        try {
            return Integer.parseInt(this.fToText.getText());
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public int getEveryValue() {
        if (!this.fSupportsFrequencyFields) {
            return 1;
        }
        try {
            return Integer.parseInt(this.fEveryText.getText());
        }
        catch (NumberFormatException e) {
            return 1;
        }
    }

    public boolean isExpressionFieldSupported() {
        return this.fSupportsExpressionField;
    }

    public boolean isActionFieldSupported() {
        return this.fSupportsActionField;
    }

    public boolean isSyncStopControlSupported() {
        return this.fSupportsSyncStopControl;
    }

    public String getExpression() {
        if (this.isExpressionFieldSupported()) {
            if (PDTCoreUtils.isEmpty((String)this.fExpressionText.getText())) {
                return null;
            }
            return this.fExpressionText.getText();
        }
        return null;
    }

    public String getBkpAction() {
        if (this.isActionFieldSupported()) {
            if (PDTCoreUtils.isEmpty((String)this.fActionText.getText())) {
                return null;
            }
            return this.fActionText.getText();
        }
        return null;
    }

    public boolean isBreakpointSynchronous() {
        return this.isSyncStopControlSupported() && this.fStopSyncCheckBox.getSelection();
    }

    public void initUsingOldValues(OptionalBreakpointData optData) {
        if (this.fSupportsThreadField) {
            if (optData.getThreadId() == 0) {
                this.fThreadCombo.setText(PICLLabels.BreakpointWizard_optional_defaultEvery);
            } else {
                DebuggeeProcess process;
                DebuggeeThread thread;
                PDTDebugTarget debugTarget = this.fDebugTarget;
                if (debugTarget != null && (thread = (process = (DebuggeeProcess)debugTarget.getProcess()).getThread(optData.getThreadId())) != null) {
                    try {
                        this.fThreadCombo.setText(thread.getName());
                    }
                    catch (DebugException debugException) {
                        // empty catch block
                    }
                }
            }
        }
        if (this.fSupportsFrequencyFields) {
            if (optData.getToValue() == 0) {
                this.fToText.setText(PICLLabels.BreakpointWizard_optional_defaultInfinity);
            } else {
                this.fToText.setText(Integer.toString(optData.getToValue()));
            }
            this.fFromText.setText(Integer.toString(optData.getFromValue()));
            this.fEveryText.setText(Integer.toString(optData.getEveryValue()));
        }
        if (this.fSupportsExpressionField) {
            if (optData.getStopIfExpression() == null) {
                this.fExpressionText.setText("");
            } else {
                this.fExpressionText.setText(optData.getStopIfExpression());
            }
        }
        if (this.fSupportsActionField) {
            if (optData.getBreakpointAction() == null) {
                this.fActionText.setText("");
            } else {
                this.fActionText.setText(optData.getBreakpointAction());
            }
        }
        if (this.fSupportsSyncStopControl) {
            this.fStopSyncCheckBox.setSelection(optData.isStopSynchronous());
        }
    }

    public void initUsingOldBreakpoint() {
        OptionalBreakpointData optData = null;
        if (this.fExistingPICLModelBP != null) {
            optData = new OptionalBreakpointData(this.fExistingPICLModelBP);
        } else if (this.fExistingSourceLineBP != null) {
            optData = new OptionalBreakpointData(this.fExistingSourceLineBP.getMarker());
        }
        if (optData == null) {
            optData = new OptionalBreakpointData();
        }
        this.initUsingOldValues(optData);
    }

    private String[] getThreads() {
        this.fCurrentThreadIndex = 0;
        if (this.fDebugTarget == null || this.fDebugTarget.isTerminated()) {
            return EMPTYTHREADNAMES;
        }
        try {
            this.fThreads = this.fDebugTarget.getThreads();
        }
        catch (DebugException debugException) {
            // empty catch block
        }
        boolean supportsEveryThread = !this.fDebugTarget.supportsThreadSpecificOnlyBreakpoints();
        int numThreads = this.fThreads.length;
        if (supportsEveryThread) {
            ++numThreads;
        }
        String[] threadNames = new String[numThreads];
        int threadIndex = 0;
        if (supportsEveryThread) {
            threadNames[threadIndex] = PICLLabels.BreakpointWizard_optional_defaultEvery;
            ++threadIndex;
        }
        if (this.fThreads.length == 0) {
            return threadNames;
        }
        DebuggeeThread currentThread = null;
        if (this.fExistingPICLModelBP != null) {
            currentThread = this.fExistingPICLModelBP.getThread();
        } else if (!supportsEveryThread) {
            currentThread = PICLDebugPlugin.getCurrentThread();
        }
        IThread[] iThreadArray = this.fThreads;
        int n = this.fThreads.length;
        int n2 = 0;
        while (n2 < n) {
            String threadName;
            IThread thread = iThreadArray[n2];
            if (thread == currentThread) {
                this.fCurrentThreadIndex = threadIndex;
            }
            try {
                threadName = thread.getName();
            }
            catch (DebugException e) {
                threadName = "*error*";
            }
            threadNames[threadIndex] = threadName;
            ++threadIndex;
            ++n2;
        }
        return threadNames;
    }

    public void writeSettings() {
        if (this.fSupportsThreadField) {
            fDialogSettingsSection.put(THREAD, this.fThreadCombo.getText());
        } else {
            fDialogSettingsSection.put(THREAD, fDialogSettingsSection.get(THREAD));
        }
        if (this.fSupportsFrequencyFields) {
            fDialogSettingsSection.put(TO, this.fToText.getText());
            fDialogSettingsSection.put(FROM, this.fFromText.getText());
            fDialogSettingsSection.put(EVERY, this.fEveryText.getText());
        } else {
            fDialogSettingsSection.put(TO, fDialogSettingsSection.get(TO));
            fDialogSettingsSection.put(FROM, fDialogSettingsSection.get(FROM));
            fDialogSettingsSection.put(EVERY, fDialogSettingsSection.get(EVERY));
        }
        if (this.fSupportsExpressionField) {
            fDialogSettingsSection.put(EXPRESSION, this.fExpressionText.getText());
        } else {
            fDialogSettingsSection.put(EXPRESSION, fDialogSettingsSection.get(EXPRESSION));
        }
        if (this.fSupportsActionField) {
            fDialogSettingsSection.put(ACTION, this.fActionText.getText());
        } else {
            fDialogSettingsSection.put(ACTION, fDialogSettingsSection.get(ACTION));
        }
    }

    public boolean isPageComplete() {
        return this.getErrorMessage() == null;
    }

    private void validatePage() {
        int fromValue = -1;
        int toValue = -1;
        int everyValue = -1;
        this.setErrorMessage(null);
        if (this.fSupportsFrequencyFields) {
            try {
                fromValue = Integer.parseInt(this.fFromText.getText());
                if (fromValue < 1) {
                    this.setErrorMessage(PICLMessages.BreakpointWizard_optional_fromError);
                    return;
                }
            }
            catch (NumberFormatException e) {
                this.setErrorMessage(PICLMessages.BreakpointWizard_optional_fromError);
                return;
            }
            try {
                toValue = Integer.parseInt(this.fToText.getText());
                if (toValue < fromValue) {
                    this.setErrorMessage(PICLMessages.BreakpointWizard_optional_toError);
                    return;
                }
            }
            catch (NumberFormatException e) {
                if (!PICLLabels.BreakpointWizard_optional_defaultInfinity.equals(this.fToText.getText())) {
                    this.setErrorMessage(PICLMessages.BreakpointWizard_optional_toError);
                    return;
                }
                toValue = 0;
            }
            try {
                everyValue = Integer.parseInt(this.fEveryText.getText());
                if (toValue != 0 && (everyValue < 1 || everyValue > toValue - fromValue + 1)) {
                    this.setErrorMessage(PICLMessages.BreakpointWizard_optional_everyError);
                    return;
                }
            }
            catch (NumberFormatException e) {
                this.setErrorMessage(PICLMessages.BreakpointWizard_optional_everyError);
                return;
            }
        }
    }

    public void modifyText(ModifyEvent e) {
        this.validatePage();
        this.setPageComplete(this.isPageComplete());
    }

    private GridData getGridData(int style, int horizontalSpan, int widthHint) {
        GridData gridData = new GridData(style);
        gridData.horizontalSpan = horizontalSpan;
        if (widthHint > 0) {
            gridData.widthHint = widthHint;
        }
        return gridData;
    }
}

