/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.dialogs;

import com.ibm.debug.pdt.internal.core.IValueDetail;
import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.core.model.ExprNodeBase;
import com.ibm.debug.pdt.internal.ui.PICLDebugPlugin;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import com.ibm.debug.pdt.internal.ui.dialogs.DebugTrayDialog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class ChangeVariableDialog
extends DebugTrayDialog {
    private ExprNodeBase fVariable;
    private StyledText fValue;
    private Label fOffset;
    private Label fLength;
    private static final String SETTINGSSECTION = PICLDebugPlugin.getPluginID() + ".changeVariableDialog";
    private static final int OFFSETSIZE = 8;

    public ChangeVariableDialog(Shell parentShell, ExprNodeBase variable) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fVariable = variable;
    }

    protected Control createDialogArea(Composite parent) {
        String varType;
        String varValue;
        String varName;
        Composite comp = (Composite)super.createDialogArea(parent);
        try {
            varName = this.fVariable.getName();
            varValue = ((IValueDetail)this.fVariable.getValue()).getDetailsValue();
            varType = this.fVariable.getReferenceTypeName();
        }
        catch (DebugException e1) {
            varName = "*error*";
            varValue = "*error*";
            varType = "*error*";
        }
        GridLayout gl = new GridLayout(4, false);
        comp.setLayout((Layout)gl);
        Label l = new Label(comp, 0);
        l.setText(PICLLabels.ChangeVariableDialog_variableName);
        GridData gd = new GridData();
        gd.horizontalAlignment = 3;
        l.setLayoutData((Object)gd);
        l = new Label(comp, 0);
        if (varType != null) {
            l.setText(varType + " " + varName);
        } else {
            l.setText(varName);
        }
        gd = new GridData();
        gd.horizontalSpan = 3;
        gd.horizontalAlignment = 4;
        l.setLayoutData((Object)gd);
        l = new Label(comp, 0);
        l.setText(PICLLabels.ChangeVariableDialog_offset);
        gd = new GridData();
        gd.horizontalAlignment = 3;
        l.setLayoutData((Object)gd);
        this.fOffset = new Label(comp, 0);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.widthHint = this.convertWidthInCharsToPixels(8);
        this.fOffset.setLayoutData((Object)gd);
        l = new Label(comp, 0);
        l.setText(PICLLabels.ChangeVariableDialog_length);
        gd = new GridData();
        gd.horizontalAlignment = 3;
        l.setLayoutData((Object)gd);
        this.fLength = new Label(comp, 0);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        this.fLength.setLayoutData((Object)gd);
        gd = new GridData(768);
        gd.horizontalSpan = 4;
        gd.widthHint = this.convertHorizontalDLUsToPixels(200);
        this.fValue = new StyledText(comp, 2306);
        this.fValue.setLayoutData((Object)gd);
        this.fValue.setText(varValue);
        if (this.fVariable.getEditOffset() < this.fValue.getContent().getCharCount()) {
            this.fValue.setSelection(this.fVariable.getEditOffset());
        }
        this.updateDialog();
        this.fValue.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                char keyChar = e.character;
                if (keyChar == '\r') {
                    String crlfValue = ChangeVariableDialog.this.fValue.getText();
                    String lineDelimiter = System.getProperty("line.separator");
                    if (lineDelimiter == null) {
                        lineDelimiter = "\r\n";
                    }
                    crlfValue = crlfValue.replaceAll(lineDelimiter, "");
                    ChangeVariableDialog.this.fValue.setText(crlfValue);
                    ChangeVariableDialog.this.okPressed();
                } else {
                    ChangeVariableDialog.this.updateDialog();
                }
            }

            public void keyReleased(KeyEvent e) {
                ChangeVariableDialog.this.updateDialog();
            }
        });
        this.fValue.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                ChangeVariableDialog.this.updateDialog();
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        Dialog.applyDialogFont((Control)parent);
        return comp;
    }

    private boolean hasQuotes(String value) {
        if (value == null) {
            return false;
        }
        return value.startsWith("'") && value.endsWith("'") || value.startsWith("\"") && value.endsWith("\"");
    }

    protected void updateDialog() {
        int caretPosn = this.fValue.getCaretOffset();
        int textLength = this.fValue.getText().length();
        if (this.hasQuotes(this.fValue.getText())) {
            --caretPosn;
            textLength -= 2;
        }
        this.fLength.setText(String.valueOf(textLength));
        if (caretPosn < 0 || caretPosn > textLength) {
            this.fOffset.setText("");
        } else {
            this.fOffset.setText(String.valueOf(caretPosn));
        }
    }

    protected void okPressed() {
        final Shell shell = this.getParentShell();
        final String text = this.fValue.getText();
        this.fVariable.setEditOffset(this.fValue.getCaretOffset());
        Job saveVariableJob = new Job("Changing Variable Value"){

            protected IStatus run(IProgressMonitor arg0) {
                try {
                    ChangeVariableDialog.this.fVariable.setValue(text);
                }
                catch (DebugException e) {
                    PICLDebugPlugin.showMessageDialog(shell.isDisposed() ? null : shell, 1, e.getMessage(), false);
                }
                return Status.OK_STATUS;
            }
        };
        saveVariableJob.setSystem(true);
        saveVariableJob.schedule();
        super.okPressed();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(PICLLabels.ChangeVariableDialog_title);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)newShell, PICLUtils.getHelpResourceString("change_variable_dialog"));
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings settings = PICLDebugPlugin.getInstance().getDialogSettings();
        IDialogSettings section = settings.getSection(SETTINGSSECTION);
        if (section == null) {
            section = settings.addNewSection(SETTINGSSECTION);
        }
        return section;
    }
}

