/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.dialogs;

import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.core.model.ExprNode;
import com.ibm.debug.pdt.internal.ui.PICLDebugPlugin;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import com.ibm.debug.pdt.internal.ui.dialogs.DebugStatusDialog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class ChangeIndexRangeDialog
extends DebugStatusDialog {
    private Label fStartIndexLabel = null;
    Text fStartIndexField = null;
    private Label fEndIndexLabel = null;
    Text fEndIndexField = null;
    private ExprNode fVariable;
    private Button fDefaultButton;

    public ChangeIndexRangeDialog(Shell parentShell, ExprNode variable) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.setTitle(PICLLabels.ChangeIndexRangeDialog_label_title);
        this.fVariable = variable;
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parentShell, PICLUtils.getHelpResourceString("change_index_range_dialog"));
    }

    protected Control createDialogArea(Composite ancestor) {
        Composite parent = new Composite(ancestor, 0);
        GridLayout layout = new GridLayout();
        parent.setLayout((Layout)layout);
        GridData spec2 = new GridData();
        spec2.grabExcessVerticalSpace = true;
        spec2.grabExcessHorizontalSpace = true;
        spec2.widthHint = 300;
        spec2.horizontalAlignment = 4;
        spec2.verticalAlignment = 4;
        parent.setLayoutData((Object)spec2);
        this.fStartIndexLabel = new Label(parent, 16384);
        this.fStartIndexLabel.setText(PICLLabels.ChangeIndexRangeDialog_label_first);
        this.fStartIndexField = new Text(parent, 2052);
        GridData gd = new GridData();
        gd.widthHint = 100;
        this.fStartIndexField.setLayoutData((Object)gd);
        this.fStartIndexField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ChangeIndexRangeDialog.this.checkIfComplete();
            }
        });
        this.fEndIndexLabel = new Label(parent, 16384);
        this.fEndIndexLabel.setText(PICLLabels.ChangeIndexRangeDialog_label_last);
        this.fEndIndexField = new Text(parent, 2052);
        gd = new GridData();
        gd.widthHint = 100;
        this.fEndIndexField.setLayoutData((Object)gd);
        this.fEndIndexField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ChangeIndexRangeDialog.this.checkIfComplete();
            }
        });
        this.fDefaultButton = new Button(parent, 8);
        this.fDefaultButton.setText(PICLLabels.ChangeIndexRangeDialog_label_usedefault);
        this.fDefaultButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ChangeIndexRangeDialog.this.resetPage();
            }
        });
        this.initializePage();
        this.checkIfComplete();
        ChangeIndexRangeDialog.applyDialogFont((Control)parent);
        return parent;
    }

    private void initializePage() {
        this.fStartIndexField.setText(Integer.toString(this.fVariable.getBaseIndex()));
        this.fEndIndexField.setText(Integer.toString(this.fVariable.getBaseIndex() + this.fVariable.getNumChildren() - 1));
    }

    private void resetPage() {
        this.fStartIndexField.setText(Integer.toString(this.fVariable.getOrigBaseIndex()));
        this.fEndIndexField.setText(Integer.toString(this.fVariable.getOrigBaseIndex() + this.fVariable.getOrigNumChildren() - 1));
    }

    private void checkIfComplete() {
        int end;
        int start;
        try {
            start = Integer.parseInt(this.fStartIndexField.getText());
            end = Integer.parseInt(this.fEndIndexField.getText());
        }
        catch (NumberFormatException nfe) {
            this.updateStatus((IStatus)new Status(4, PICLDebugPlugin.getPluginID(), PICLLabels.ChangeIndexRangeDialog_error_invalid_integer));
            return;
        }
        if (!this.fVariable.isUnlimitedRange() && start < this.fVariable.getOrigBaseIndex()) {
            this.updateStatus((IStatus)new Status(4, PICLDebugPlugin.getPluginID(), PICLLabels.ChangeIndexRangeDialog_error_invalid_first));
            return;
        }
        if (!this.fVariable.isUnlimitedRange() && end >= this.fVariable.getOrigBaseIndex() + this.fVariable.getOrigNumChildren()) {
            this.updateStatus((IStatus)new Status(4, PICLDebugPlugin.getPluginID(), PICLLabels.ChangeIndexRangeDialog_error_invalid_last));
            return;
        }
        if (end < start) {
            this.updateStatus((IStatus)new Status(4, PICLDebugPlugin.getPluginID(), PICLLabels.ChangeIndexRangeDialog_error_invalid_order));
            return;
        }
        this.updateStatus((IStatus)new Status(0, PICLDebugPlugin.getPluginID(), ""));
    }

    private int getStartIndex() {
        try {
            return Integer.parseInt(this.fStartIndexField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    private int getNumElements() {
        try {
            return Integer.parseInt(this.fEndIndexField.getText()) - Integer.parseInt(this.fStartIndexField.getText()) + 1;
        }
        catch (NumberFormatException numberFormatException) {
            return 1;
        }
    }

    protected void okPressed() {
        this.fVariable.setIndexRange(this.getStartIndex(), this.getNumElements());
        super.okPressed();
    }
}

