/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.dialogs;

import com.ibm.debug.pdt.internal.core.PDTDebugTarget;
import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.ui.PICLDebugPlugin;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import com.ibm.debug.pdt.internal.ui.dialogs.BreakpointWizardPage;
import com.ibm.debug.pdt.internal.ui.dialogs.ConditionalBreakpointWizardPage;
import com.ibm.debug.pdt.internal.ui.dialogs.ISettingsWriter;
import com.ibm.debug.pdt.internal.ui.util.StatusInfo;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.ui.progress.WorkbenchJob;

public abstract class BreakpointWizard
extends Wizard {
    protected PDTDebugTarget fDebugTarget;
    protected boolean fEditing;
    protected String fMainPageName;
    protected String fCondPageName = PICLLabels.BreakpointWizard_optional_pageName;
    protected WorkbenchJob wbJob;
    private boolean fAlreadyClicked = false;

    protected BreakpointWizard(PDTDebugTarget debugTarget) {
        this.fDebugTarget = debugTarget;
    }

    @Deprecated
    protected boolean supportsConditionalFields() {
        return this.fDebugTarget.supportsExpressionOnConditionalBkp() || this.fDebugTarget.supportsFreqOnConditionalBkp() || this.fDebugTarget.supportsThreadOnConditionalBkp();
    }

    protected boolean areOptionalParametersSupported() {
        return this.fDebugTarget.supportsExpressionOnConditionalBkp() || this.fDebugTarget.supportsFreqOnConditionalBkp() || this.fDebugTarget.supportsThreadOnConditionalBkp() || this.fDebugTarget.supportsBreakpointSyncAsyncStopControl();
    }

    public static String getPluginIdentifier() {
        return PICLUtils.getModelIdentifier();
    }

    public void showPage(WizardPage page) {
        IWizardContainer container = this.getContainer();
        if (container != null && container.getCurrentPage() != page) {
            IWizardPage toMaintainPreviousPage = page.getPreviousPage();
            container.showPage((IWizardPage)page);
            page.setPreviousPage(toMaintainPreviousPage);
            container.updateButtons();
        }
    }

    boolean isConditionalPageError(int errorCode) {
        return errorCode == 130;
    }

    public boolean performFinish() {
        PICLUtils.refreshPropertiesView();
        return true;
    }

    protected boolean updateWizardPostProcessing(StatusInfo processResult, BreakpointWizardPage page, ConditionalBreakpointWizardPage condPage) {
        if (processResult.isError()) {
            if (this.isConditionalPageError(this.fDebugTarget.getLastError()) && condPage != null) {
                condPage.setErrorMessage(processResult.getMessage());
                condPage.setPageComplete(processResult.getMessage() == null);
                this.showPage(condPage);
            } else {
                page.setErrorMessage(processResult.getMessage());
                page.setPageComplete(processResult.getMessage() == null);
                this.showPage(page);
            }
            this.resetAlreadyClicked();
            return false;
        }
        if (processResult.isInfo() || processResult.isWarning()) {
            PICLDebugPlugin.showMessageDialog(this.getShell(), 4, processResult.getMessage(), true);
        }
        IWizardPage[] pages = this.getPages();
        int i = 0;
        while (i < this.getPageCount()) {
            if (pages[i] instanceof ISettingsWriter) {
                ((ISettingsWriter)pages[i]).writeSettings();
            }
            ++i;
        }
        PICLDebugPlugin.getInstance().saveDialogSettings();
        ((WizardDialog)this.getContainer()).close();
        return true;
    }

    public void dispose() {
        super.dispose();
        if (this.wbJob != null) {
            this.wbJob.cancel();
        }
    }

    protected boolean checkFinishButtonClicked() {
        if (this.fAlreadyClicked) {
            return true;
        }
        this.fAlreadyClicked = true;
        return false;
    }

    public void resetAlreadyClicked() {
        this.fAlreadyClicked = false;
    }
}

