/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.dialogs;

import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.core.PICLMessages;
import com.ibm.debug.pdt.internal.core.launch.PICLAbstractStartupInfo;
import com.ibm.debug.pdt.internal.ui.PICLDebugPlugin;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import com.ibm.debug.pdt.internal.ui.dialogs.DebugStatusDialog;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AuthenticateDialog
extends DebugStatusDialog {
    private PICLAbstractStartupInfo fStartInfo;
    private Text fUserId;
    private Text fPassword;
    private String fHostIP;

    public AuthenticateDialog(Shell shell, PICLAbstractStartupInfo startInfo, String hostIP) {
        super(shell);
        this.fStartInfo = startInfo;
        this.fHostIP = hostIP;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        new Label(composite, 8).setText(PICLLabels.SecureConnectDialog_UserID);
        this.fUserId = new Text(composite, 4);
        this.fUserId.setLayoutData((Object)new GridData(4, 4, true, false));
        this.fUserId.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Status status = null;
                if (AuthenticateDialog.this.fUserId.getText().trim().length() <= 0) {
                    String errorMsg = PICLMessages.SecureConnectDialog_InvalidUserID;
                    status = new Status(4, PICLDebugPlugin.getPluginID(), errorMsg);
                } else {
                    status = new Status(0, PICLDebugPlugin.getPluginID(), "");
                }
                AuthenticateDialog.this.updateStatus((IStatus)status);
            }
        });
        new Label(composite, 8).setText(PICLLabels.SecureConnectDialog_Password);
        this.fPassword = new Text(composite, 0x400000);
        this.fPassword.setLayoutData((Object)new GridData(4, 4, true, false));
        this.fPassword.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Status status = null;
                if (AuthenticateDialog.this.fPassword.getText().trim().length() <= 0) {
                    String errorMsg = PICLMessages.SecureConnectDialog_InvalidPassword;
                    status = new Status(4, PICLDebugPlugin.getPluginID(), errorMsg);
                } else {
                    status = new Status(0, PICLDebugPlugin.getPluginID(), "");
                }
                AuthenticateDialog.this.updateStatus((IStatus)status);
            }
        });
        return composite;
    }

    protected Control createButtonBar(Composite parent) {
        Control ctrl = super.createButtonBar(parent);
        if (this.getButton(0) != null) {
            this.getButton(0).setEnabled(false);
        }
        return ctrl;
    }

    protected void okPressed() {
        String userID = this.fUserId.getText();
        char[] password = this.fPassword.getText().toCharArray();
        PICLUtils.addCredentialToSecureStorage(PICLDebugPlugin.getInstance().getSecurePreferences(), this.fHostIP, userID, password);
        this.fStartInfo.setUserId(Base64.getEncoder().encodeToString(userID.getBytes(StandardCharsets.ISO_8859_1)));
        this.fStartInfo.setPassword(Base64.getEncoder().encodeToString(String.valueOf(password).getBytes(StandardCharsets.ISO_8859_1)).toCharArray());
        super.okPressed();
    }

    private void setOKButtonEnablement() {
        if (this.fUserId.getText().trim().length() <= 0 || this.fPassword.getText().trim().length() <= 0) {
            this.getButton(0).setEnabled(false);
        } else {
            this.getButton(0).setEnabled(true);
        }
    }

    public void updateButtonsEnableState(IStatus status) {
        super.updateButtonsEnableState(status);
        this.setOKButtonEnablement();
    }
}

