/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.dialogs;

import com.ibm.debug.pdt.internal.core.PDTDebugTarget;
import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.core.PICLMessages;
import com.ibm.debug.pdt.internal.core.model.DebuggeeException;
import com.ibm.debug.pdt.internal.core.model.EngineRequestException;
import com.ibm.debug.pdt.internal.ui.ExceptionItem;
import com.ibm.debug.pdt.internal.ui.PICLDebugPlugin;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import com.ibm.debug.pdt.internal.ui.dialogs.DebugTrayDialog;
import com.ibm.debug.pdt.internal.ui.util.CheckedList;
import com.ibm.debug.pdt.internal.ui.util.StatusInfo;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.osgi.service.prefs.BackingStoreException;

public class AddExceptionDialog
extends DebugTrayDialog {
    protected CheckedList fExceptionListControl;
    private DebuggeeException[] fExceptionArray;
    private ExceptionItem[] fExceptionList;
    private Button fCheckAllButton;
    private Button fUncheckAllButton;
    private Button fRestoreDefaultsButton;
    private boolean fSaveAsDefault = false;
    private static final String SETTINGSSECTION = PICLDebugPlugin.getPluginID() + ".addExceptionDialog";
    private PDTDebugTarget fTarget;

    public AddExceptionDialog(Shell parentShell, PDTDebugTarget target) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fTarget = target;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(PICLLabels.AddEventDialog_title);
    }

    public boolean isMutuallyExclusive() {
        return this.fTarget.is390() && !this.fTarget.isPICL();
    }

    public boolean checkEngineSupport() {
        if (!this.fTarget.isAcceptingRequests()) {
            StatusInfo status = new StatusInfo();
            status.setError(PICLMessages.AddExceptionDialog_unsupported);
            ErrorDialog.openError((Shell)this.getShell(), (String)PICLLabels.ErrorDialog_error, null, (IStatus)status);
            return false;
        }
        this.fExceptionArray = this.fTarget.getSupportedExceptions();
        if (this.fExceptionArray == null) {
            StatusInfo status = new StatusInfo();
            status.setError(PICLMessages.AddExceptionDialog_unsupported);
            ErrorDialog.openError((Shell)this.getShell(), (String)PICLLabels.ErrorDialog_error, null, (IStatus)status);
            return false;
        }
        return true;
    }

    protected Control createDialogArea(Composite ancestor) {
        Label l = new Label(ancestor, 0);
        l.setText(PICLLabels.AddEventDialog_label);
        GridData gd = new GridData(4, 4, true, true);
        gd.widthHint = this.convertWidthInCharsToPixels(65);
        gd.heightHint = this.convertHeightInCharsToPixels(20);
        this.fExceptionListControl = new CheckedList(ancestor, true, this.isMutuallyExclusive());
        this.fExceptionListControl.setLayoutData(gd);
        this.initializeExceptionList(this.fTarget.getDebugEngine().isGlobalExceptionDefaults());
        Composite buttonParent = new Composite(ancestor, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        buttonParent.setLayout((Layout)layout);
        if (!this.isMutuallyExclusive()) {
            this.fCheckAllButton = new Button(buttonParent, 8);
            this.fCheckAllButton.setText(PICLLabels.AddExceptionDialog_checkAllButton);
            this.fCheckAllButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    AddExceptionDialog.this.fExceptionListControl.checkAll();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            this.fUncheckAllButton = new Button(buttonParent, 8);
            this.fUncheckAllButton.setText(PICLLabels.AddExceptionDialog_uncheckAllButton);
            this.fUncheckAllButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    AddExceptionDialog.this.fExceptionListControl.uncheckAll();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
        this.fRestoreDefaultsButton = new Button(buttonParent, 8);
        this.fRestoreDefaultsButton.setText(PICLLabels.AddExceptionDialog_restoreDefaultsButton);
        this.fRestoreDefaultsButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AddExceptionDialog.this.fExceptionListControl.restoreDefaults();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Button saveAsDefault = new Button(buttonParent, 8);
        saveAsDefault.setText(PICLLabels.AddExceptionDialog_setAsDefaultButton);
        saveAsDefault.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AddExceptionDialog.this.fSaveAsDefault = true;
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getShell(), PICLUtils.getHelpResourceString("add_exception_dialog"));
        this.fExceptionListControl.selectFilterText();
        Dialog.applyDialogFont((Control)ancestor);
        return ancestor;
    }

    private void saveExceptionDefaults() {
        IEclipsePreferences prefConfig = ConfigurationScope.INSTANCE.getNode("com.ibm.debug.pdt.core/exceptionsDefault");
        String exceptionPreferenceKey = this.fTarget.getEngineSession().getUniqueEngineKey();
        int numExceptions = this.fExceptionArray.length;
        StringBuilder prefValues = new StringBuilder(String.valueOf(numExceptions));
        int i = 0;
        while (i < numExceptions) {
            if (this.fExceptionArray[i].getPendingEnabled()) {
                prefValues.append(",1");
                this.fExceptionArray[i].setDefaultEnabled(true);
            } else {
                prefValues.append(",0");
                this.fExceptionArray[i].setDefaultEnabled(false);
            }
            ++i;
        }
        prefConfig.put(exceptionPreferenceKey, prefValues.toString());
        try {
            prefConfig.flush();
        }
        catch (BackingStoreException e1) {
            PICLUtils.logString((Object)this, "Problem saving exception defaults", 2, (Exception)((Object)e1));
        }
        this.fTarget.getDebugEngine().setGlobalExceptionDefaults(true);
    }

    private boolean initializeExceptionList(boolean showDefault) {
        this.fExceptionList = new ExceptionItem[this.fExceptionArray.length];
        int i = 0;
        while (i < this.fExceptionArray.length) {
            this.fExceptionList[i] = new ExceptionItem(this.fExceptionArray[i], showDefault);
            ++i;
        }
        this.fExceptionListControl.setElements(this.fExceptionList);
        this.fExceptionListControl.setFilter("*", true);
        return true;
    }

    protected void okPressed() {
        int i = 0;
        while (i < this.fExceptionList.length) {
            this.fExceptionList[i].commitChanges();
            ++i;
        }
        if (this.fSaveAsDefault) {
            this.saveExceptionDefaults();
        }
        try {
            this.fTarget.commitExceptionChanges(true);
        }
        catch (EngineRequestException e) {
            PICLDebugPlugin.showMessageDialog(this.getShell(), e.getMessage(), true);
        }
        super.okPressed();
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings settings = PICLDebugPlugin.getInstance().getDialogSettings();
        IDialogSettings section = settings.getSection(SETTINGSSECTION);
        if (section == null) {
            section = settings.addNewSection(SETTINGSSECTION);
        }
        return section;
    }
}

