/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.dialogs;

import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.ui.PICLDebugPlugin;
import com.ibm.debug.pdt.internal.ui.contentassist.ContentAssistProvider;
import com.ibm.debug.pdt.internal.ui.dialogs.DebugDialog;
import com.ibm.debug.pdt.internal.ui.views.DebugConsoleSession;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AddDebugConsoleDialog
extends DebugDialog {
    private static final String SECTION = "AddDebugConsoleDialog";
    private DebugConsoleSession fDebugConsoleSession;
    private String fValue = null;
    private Text fText;

    public AddDebugConsoleDialog(Shell parentShell, DebugConsoleSession consoleSession, String initialCommand) {
        super(parentShell);
        this.fDebugConsoleSession = consoleSession;
        this.fValue = initialCommand;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(PICLLabels.AddDebugConsoleDialog_Title);
    }

    protected boolean isResizable() {
        return true;
    }

    public String getValue() {
        return this.fValue;
    }

    protected void okPressed() {
        this.fValue = this.fText.getText();
        super.okPressed();
    }

    public Control createDialogArea(Composite parent) {
        EPDC_EngineSession engineSession;
        Composite composite = (Composite)super.createDialogArea(parent);
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData(16384, 128, true, false));
        label.setText(PICLLabels.AddDebugConsoleDialog_Label);
        this.fText = new Text(composite, 2624);
        GridData gd = new GridData(4, 4, true, true);
        gd.heightHint = 200;
        gd.widthHint = 400;
        this.fText.setLayoutData((Object)gd);
        if (this.fValue != null && this.fValue.length() > 0) {
            this.fText.append(this.fValue);
        }
        if ((engineSession = this.fDebugConsoleSession.getTarget().getDebugEngine().getEngineSession()).isDebugTool()) {
            ContentAssistProvider contentAssist = new ContentAssistProvider((Control)this.fText);
            contentAssist.setProposals(contentAssist.getProposals(engineSession.getEngineVersionString(), null));
        }
        return composite;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings ds = PICLDebugPlugin.getInstance().getDialogSettings().getSection(SECTION);
        if (ds == null) {
            return PICLDebugPlugin.getInstance().getDialogSettings().addNewSection(SECTION);
        }
        return ds;
    }
}

