/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.actions;

import com.ibm.debug.pdt.internal.core.PDTDebugTarget;
import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.core.model.Breakpoint;
import com.ibm.debug.pdt.internal.core.model.BreakpointChangedEvent;
import com.ibm.debug.pdt.internal.core.model.EngineRequestException;
import com.ibm.debug.pdt.internal.core.model.Location;
import com.ibm.debug.pdt.internal.core.model.LocationBreakpoint;
import com.ibm.debug.pdt.internal.core.model.Part;
import com.ibm.debug.pdt.internal.core.model.ViewFile;
import com.ibm.debug.pdt.internal.core.model.ViewInformation;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;

public class SwitchViewAction
extends Action {
    private ViewFile fViewFile = null;
    private ViewInformation fViewInfo = null;
    private ITextEditor fEditor = null;

    public SwitchViewAction(ViewInformation vi, ViewFile viewfile, ITextEditor editor, boolean enabled) {
        this.setId("com.ibm.debug.pdt.SwitchViewAction");
        this.fEditor = editor;
        this.fViewFile = viewfile;
        this.fViewInfo = vi;
        this.setText(NLS.bind((String)PICLLabels.DebugViewMenuListener_showView2, (Object)this.fViewInfo.getName()));
        boolean isSupported = this.fViewFile.getPart().getView(this.fViewInfo) != null;
        boolean isCurrentView = this.fViewFile.getView().getViewInformation() == this.fViewInfo;
        boolean isMixedCCEnabled = this.fViewFile.getDebugTarget() instanceof PDTDebugTarget && ((PDTDebugTarget)this.fViewFile.getDebugTarget()).wasMixedCCEverEnabled();
        boolean isSwitchViewAllowed = isCurrentView || !isMixedCCEnabled || isMixedCCEnabled && this.fViewFile.getDebugEngine().getEngineSession().supportsSwitchViewWithMixedCC();
        this.setEnabled(isSupported && enabled && isSwitchViewAllowed);
        if (isCurrentView) {
            this.setChecked(true);
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, PICLUtils.getHelpResourceString("switch_view_action"));
    }

    public void run() {
        Location newLocation;
        if (this.fEditor == null || this.fViewFile == null || this.fViewFile.getView().getViewInformation() == this.fViewInfo) {
            return;
        }
        Location currentLocation = new Location(this.fViewFile, PICLUtils.getLineNumber((IEditorPart)this.fEditor));
        try {
            newLocation = this.fViewFile.getDebugEngine().switchView(currentLocation, this.fViewInfo);
        }
        catch (EngineRequestException e) {
            newLocation = currentLocation;
        }
        Part part = this.fViewFile.getPart();
        part.setCurrentView(part.getView(this.fViewInfo));
        this.updateBreakpointMarkers();
        Object context = this.fViewFile.getContext();
        if (context == null) {
            return;
        }
        IWorkbenchPage page = this.fEditor.getEditorSite().getPage();
        PICLUtils.resetEditor(context, page, newLocation.getLineNumber());
    }

    private void updateBreakpointMarkers() {
        LocationBreakpoint[] modelBPs;
        PDTDebugTarget debugTarget = (PDTDebugTarget)this.fViewFile.getDebugEngine().getDebugTarget();
        LocationBreakpoint[] locationBreakpointArray = modelBPs = this.fViewFile.getBreakpoints();
        int n = modelBPs.length;
        int n2 = 0;
        while (n2 < n) {
            LocationBreakpoint modelBP = locationBreakpointArray[n2];
            debugTarget.breakpointChanged(new BreakpointChangedEvent((Object)modelBP, (Breakpoint)modelBP));
            ++n2;
        }
    }
}

