/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.actions;

import com.ibm.debug.pdt.internal.core.PDTDebugTarget;
import com.ibm.debug.pdt.internal.core.PICLMessages;
import com.ibm.debug.pdt.internal.core.model.DebugEngine;
import com.ibm.debug.pdt.internal.core.model.ViewFile;
import com.ibm.debug.pdt.internal.core.model.ViewInformation;
import com.ibm.debug.pdt.internal.ui.PICLDebugPlugin;
import com.ibm.debug.pdt.internal.ui.actions.SwitchViewAction;
import org.eclipse.ui.texteditor.ITextEditor;

public class SwitchDefaultViewAction
extends SwitchViewAction {
    private ViewInformation fViewInfo;
    private int fIndex;
    private boolean fIsSupported;
    private DebugEngine fEngine;

    public SwitchDefaultViewAction(ViewInformation vi, ViewFile viewfile, ITextEditor editor, boolean enabled, DebugEngine engine, int index) {
        super(vi, viewfile, editor, enabled);
        this.setId("com.ibm.debug.pdt.SwitchDefaultViewAction");
        this.fViewInfo = vi;
        this.fIndex = index;
        this.fIsSupported = viewfile.getPart().getView(this.fViewInfo) != null;
        this.fEngine = engine;
        this.setText(this.fViewInfo.getName());
        boolean isMixedCCEnabled = viewfile.getDebugTarget() instanceof PDTDebugTarget && ((PDTDebugTarget)viewfile.getDebugTarget()).wasMixedCCEverEnabled();
        boolean isSetDefaultViewAllowed = !isMixedCCEnabled || isMixedCCEnabled && viewfile.getDebugEngine().getEngineSession().supportsSwitchViewWithMixedCC();
        this.setEnabled(enabled && isSetDefaultViewAllowed);
        this.setChecked(ViewInformation.getPreferredView((DebugEngine)engine) == this.fIndex);
    }

    @Override
    public void run() {
        if (this.fIsSupported) {
            super.run();
        }
        if (this.isChecked()) {
            if (ViewInformation.getPreferredView((DebugEngine)this.fEngine) != this.fIndex) {
                PICLDebugPlugin.showMessageDialog(null, 2, PICLMessages.CRRDG3252, true);
            }
            ViewInformation.setPreferredView((DebugEngine)this.fEngine, (int)this.fIndex);
        }
    }
}

