/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.actions;

import com.ibm.debug.pdt.internal.core.PDTDebugTarget;
import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.core.PICLModule;
import com.ibm.debug.pdt.internal.core.model.EngineRequestException;
import com.ibm.debug.pdt.internal.ui.PICLDebugPlugin;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import com.ibm.debug.pdt.internal.ui.dialogs.FontReflowUtil;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;

public class SetModuleSideFileLocationAction
extends Action {
    private TreeViewer fTreeViewer;

    public SetModuleSideFileLocationAction(TreeViewer treeViewer) {
        super(PICLLabels.SetSideFileActionLabel);
        this.fTreeViewer = treeViewer;
        this.setImageDescriptor(PICLUtils.getImageDescriptor("PICL_ICON_MODULE_WITH_SIDEFILE"));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, PICLUtils.getHelpResourceString("set_sidefile"));
    }

    private PICLModule getModule() {
        StructuredSelection sel = (StructuredSelection)this.fTreeViewer.getSelection();
        if (sel != StructuredSelection.EMPTY && sel.size() == 1 && sel.getFirstElement() instanceof PICLModule) {
            return (PICLModule)sel.getFirstElement();
        }
        return null;
    }

    public void update() {
        PICLModule module = this.getModule();
        if (module == null || module.getModule() == null || module.getModule().hasSideFileDataSet()) {
            this.setEnabled(false);
            return;
        }
        this.setEnabled(true);
    }

    public void run() {
        PICLModule module = this.getModule();
        if (module == null) {
            return;
        }
        InputDialog dialog = new InputDialog(this.fTreeViewer.getTree().getShell(), PICLLabels.SetSideFileDialogTitle, PICLLabels.SetSideFileDialogText, "", null){

            protected boolean isResizable() {
                return true;
            }

            protected Control createDialogArea(Composite parent) {
                ScrolledComposite scrolled = new ScrolledComposite(parent, 768);
                scrolled.setShowFocusedControl(true);
                scrolled.setExpandHorizontal(true);
                scrolled.setExpandVertical(true);
                GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)scrolled);
                Control contents = super.createDialogArea((Composite)scrolled);
                scrolled.setContent(contents);
                scrolled.setMinSize(contents.computeSize(-1, -1));
                FontReflowUtil.installListeners(scrolled);
                return scrolled;
            }
        };
        int dialogButtonChoice = dialog.open();
        if (dialogButtonChoice == 1) {
            return;
        }
        String moduleSideFileLocation = dialog.getValue();
        try {
            ((PDTDebugTarget)module.getDebugTarget()).getDebugEngine().setModuleSideFileLocation(module.getModule().getId(), moduleSideFileLocation);
        }
        catch (EngineRequestException e) {
            PICLDebugPlugin.showMessageDialog(null, e.getMessage(), true);
        }
    }
}

