/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.actions;

import com.ibm.debug.pdt.internal.core.PDTDebugTarget;
import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.core.model.DebuggeeThread;
import com.ibm.debug.pdt.internal.core.model.EngineRequestException;
import com.ibm.debug.pdt.internal.core.model.Location;
import com.ibm.debug.pdt.internal.core.model.ViewFile;
import com.ibm.debug.pdt.internal.core.util.PDTCoreUtils;
import com.ibm.debug.pdt.internal.ui.EngineSuppliedViewEditorInput;
import com.ibm.debug.pdt.internal.ui.PICLDebugPlugin;
import com.ibm.debug.pdt.internal.ui.PICLDebugTarget;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.IUpdate;

public class RunJumpToLocationBaseAction
extends Action
implements IUpdate {
    private ITextEditor fEditor = null;
    private IVerticalRulerInfo fRulerInfo = null;
    protected boolean fIsRulerAction = false;
    protected boolean fIsJumpAction = false;

    public RunJumpToLocationBaseAction(ITextEditor textEditor, IVerticalRulerInfo verticalRulerInfo, boolean setAsRulerAction, boolean setAsJumpAction) {
        this.fEditor = textEditor;
        this.fRulerInfo = verticalRulerInfo;
        this.fIsJumpAction = setAsJumpAction;
        this.fIsRulerAction = setAsRulerAction;
        if (this.fIsJumpAction) {
            this.setText(PICLLabels.RunJumpToLocationBaseAction_jumpaction);
            if (!this.fIsRulerAction) {
                this.setActionDefinitionId("com.ibm.debug.pdt.ui.jumpToLocationAction");
            }
        } else {
            this.setText(PICLLabels.RunJumpToLocationBaseAction_runaction);
            if (!this.fIsRulerAction) {
                this.setActionDefinitionId("com.ibm.debug.pdt.ui.runToLocationAction");
            }
        }
        this.update();
    }

    protected int getLineNumber() {
        if (this.fIsRulerAction) {
            if (this.fRulerInfo == null) {
                if (PICLDebugPlugin.fPDT) {
                    PICLUtils.logString((Object)this, "RunJumpToLocationBaseAction: ruler is null, failing", 4);
                }
                return 0;
            }
            return PICLUtils.getRealLineNumber(this.fEditor.getEditorInput(), this.fRulerInfo.getLineOfLastMouseButtonActivity() + 1);
        }
        return PICLUtils.getLineNumber((IEditorPart)this.fEditor);
    }

    public void run() {
        final int lineNumber = this.getLineNumber();
        Job job = new Job("Jump to location"){

            protected IStatus run(IProgressMonitor monitor) {
                int line = lineNumber;
                if (RunJumpToLocationBaseAction.this.fEditor == null) {
                    if (PICLDebugPlugin.fPDT) {
                        PICLUtils.logString((Object)this, "RunJumpToLocationBaseAction: editor is null, failing", 4);
                    }
                    return Status.OK_STATUS;
                }
                ViewFile viewFile = null;
                DebuggeeThread thread = PICLDebugPlugin.getCurrentThread();
                if (thread == null) {
                    return Status.OK_STATUS;
                }
                PDTDebugTarget viewDbgTgt = (PDTDebugTarget)thread.getDebugTarget();
                IEditorInput input = RunJumpToLocationBaseAction.this.fEditor.getEditorInput();
                if (input instanceof EngineSuppliedViewEditorInput) {
                    EngineSuppliedViewEditorInput viewEI = (EngineSuppliedViewEditorInput)input;
                    viewFile = viewEI.getViewFile();
                    PICLDebugTarget editorDbgTgt = viewEI.getPICLDebugTarget();
                    if (viewDbgTgt != editorDbgTgt && (thread = editorDbgTgt.getStoppingThread()) == null) {
                        thread = PICLDebugPlugin.getCurrentThread();
                    }
                } else if (viewDbgTgt != null && viewDbgTgt.isAcceptingRequests()) {
                    viewFile = PICLUtils.getViewFile(input);
                }
                if (viewFile != null) {
                    Location location = new Location(viewFile, line);
                    if (thread != null) {
                        block21: {
                            if (RunJumpToLocationBaseAction.this.fIsJumpAction) {
                                try {
                                    if (thread.canJumpToLocation()) {
                                        thread.jumpToLocation(location);
                                    }
                                }
                                catch (EngineRequestException e) {
                                    PICLDebugPlugin.showMessageDialog(null, (PDTDebugTarget)thread.getDebugTarget(), e, false);
                                }
                            } else {
                                boolean skipBPsOnRunToLoc = DebugUITools.getPreferenceStore().getBoolean("org.eclipse.debug.ui.skip_breakpoints_during_run_to_line");
                                try {
                                    if (!thread.canRunToLocation()) break block21;
                                    boolean skipProcessed = ((PDTDebugTarget)thread.getDebugTarget()).enterRunToLocationMode(skipBPsOnRunToLoc);
                                    if (skipProcessed) {
                                        try {
                                            Job.getJobManager().join((Object)"SkipJobFamily", null);
                                        }
                                        catch (OperationCanceledException e) {
                                            PDTCoreUtils.logError((Exception)((Object)e));
                                        }
                                        catch (InterruptedException e) {
                                            PDTCoreUtils.logError((Exception)e);
                                        }
                                    }
                                    thread.runToLocation(location);
                                }
                                catch (EngineRequestException e) {
                                    PICLDebugPlugin.showMessageDialog(null, (PDTDebugTarget)thread.getDebugTarget(), e, false);
                                }
                            }
                        }
                        return Status.OK_STATUS;
                    }
                }
                if (PICLDebugPlugin.fPDT) {
                    PICLUtils.logString((Object)this, "RunJumpToLocationBaseAction invalid context (debug target, thread or file), failing ", 4);
                }
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    public void update() {
        if (this.fIsJumpAction) {
            if (this.fIsRulerAction) {
                PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, PICLUtils.getHelpResourceString("jump_to_location_ruler_action"));
            } else {
                PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, PICLUtils.getHelpResourceString("jump_to_location_action"));
            }
        } else if (this.fIsRulerAction) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, PICLUtils.getHelpResourceString("run_to_location_ruler_action"));
        } else {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, PICLUtils.getHelpResourceString("run_to_location_action"));
        }
    }
}

