/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.actions;

import com.ibm.debug.pdt.internal.common.CommonUtils;
import com.ibm.debug.pdt.internal.core.model.ExprNodeBase;
import com.ibm.debug.pdt.internal.ui.PICLDebugPlugin;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import com.ibm.debug.pdt.rsecommon.IInlineVariableTreeEditor;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.internal.ui.viewers.model.provisional.TreeModelViewer;
import org.eclipse.debug.ui.AbstractDebugView;
import org.eclipse.debug.ui.actions.IVariableValueEditor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IViewPart;

public class PICLVariableValueEditorDelegator
implements IVariableValueEditor {
    public boolean editVariable(IVariable variable, Shell shell) {
        if (variable instanceof ExprNodeBase) {
            StructuredViewer viewer;
            block7: {
                ExprNodeBase nodeVar = (ExprNodeBase)variable;
                if (!nodeVar.supportsValueModification() || nodeVar.getValueString() == null) {
                    return true;
                }
                if (nodeVar.getValueString().length() > 25) {
                    Dialog dialog = PICLDebugPlugin.getEditWidgetFactory().getVariableEditDialog(shell, (IVariable)nodeVar);
                    dialog.open();
                    return true;
                }
                try {
                    IViewPart debugViewPart = CommonUtils.getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.debug.ui.VariableView");
                    StructuredViewer structuredViewer = viewer = debugViewPart == null ? null : (StructuredViewer)((AbstractDebugView)debugViewPart).getViewer();
                    if (!(viewer instanceof TreeModelViewer) || !((TreeModelViewer)viewer).isShowColumns()) break block7;
                    Dialog dialog = PICLDebugPlugin.getEditWidgetFactory().getVariableEditDialog(shell, (IVariable)nodeVar);
                    dialog.open();
                    return true;
                }
                catch (Exception e) {
                    PICLUtils.logError(e);
                    return false;
                }
            }
            if (viewer != null) {
                Tree fTree = (Tree)viewer.getControl();
                IInlineVariableTreeEditor inlineEditor = PICLDebugPlugin.getEditWidgetFactory().getInlineVariableTreeEditor();
                inlineEditor.editVariable(fTree, variable);
                return true;
            }
        }
        return false;
    }

    public boolean saveVariable(IVariable variable, final String expression, final Shell shell) {
        if (variable instanceof ExprNodeBase) {
            final ExprNodeBase nodeVar = (ExprNodeBase)variable;
            Job saveVariableJob = new Job("Changing Variable Value"){

                protected IStatus run(IProgressMonitor arg0) {
                    if (!nodeVar.supportsValueModification() || nodeVar.getValueString() == null) {
                        return Status.OK_STATUS;
                    }
                    if (!nodeVar.getValueString().equals(expression)) {
                        try {
                            nodeVar.setValue(expression);
                        }
                        catch (DebugException de) {
                            PICLDebugPlugin.showMessageDialog(shell.isDisposed() ? null : shell, 1, de.getMessage(), false);
                        }
                        catch (Exception e) {
                            PICLUtils.logError(e);
                        }
                    }
                    return Status.OK_STATUS;
                }
            };
            saveVariableJob.setSystem(true);
            saveVariableJob.schedule();
            return true;
        }
        return false;
    }
}

