/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.actions;

import com.ibm.debug.pdt.internal.core.PDTDebugTarget;
import com.ibm.debug.pdt.internal.ui.PICLDebugPlugin;
import com.ibm.debug.pdt.internal.ui.actions.DateBreakpointAction;
import com.ibm.debug.pdt.internal.ui.actions.HeapCheckAction;
import com.ibm.debug.pdt.internal.ui.actions.StopAtAllEntryPointsAction;
import com.ibm.debug.pdt.internal.ui.actions.TerminateWithOptionAction;
import com.ibm.debug.pdt.internal.ui.actions.ZeroAddressBreakpointAction;
import java.util.Iterator;
import java.util.List;
import org.eclipse.debug.ui.AbstractDebugView;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class OptionsActionDelegate
implements IObjectActionDelegate {
    private IMenuManager fMenuManager;
    private PDTDebugTarget fDebugTarget;
    private IAction fAction;
    private String fOriginalLabel = null;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        AbstractDebugView adv;
        List managers;
        if (this.fOriginalLabel == null) {
            this.fOriginalLabel = action.getText();
        }
        this.fMenuManager = null;
        if (targetPart instanceof AbstractDebugView && (managers = (adv = (AbstractDebugView)targetPart).getContextMenuManagers()) != null && !managers.isEmpty()) {
            Iterator iter = managers.iterator();
            while (iter.hasNext() && this.fMenuManager == null) {
                this.fMenuManager = ((IMenuManager)iter.next()).findMenuUsingPath("com.ibm.debug.pdt.ui.actions.DebugTargetOptions.menu");
            }
        }
    }

    public void run(IAction action) {
        if (this.fAction != null) {
            this.fAction.run();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        Action newAction;
        this.fDebugTarget = PICLDebugPlugin.getPDTDebugTarget(selection);
        this.fAction = null;
        action.setText(this.fOriginalLabel);
        action.setChecked(false);
        action.setEnabled(true);
        if (this.fDebugTarget == null) {
            return;
        }
        if (this.fDebugTarget.isTerminated()) {
            return;
        }
        if (this.fMenuManager == null) {
            return;
        }
        if (this.fDebugTarget.supportsTerminateType()) {
            this.fAction = new TerminateWithOptionAction(action, this.fDebugTarget, 2);
        }
        if (this.fDebugTarget.supportsStorageUsageCheck()) {
            if (this.fAction == null) {
                this.fAction = new HeapCheckAction(action, this.fDebugTarget);
            } else {
                newAction = new HeapCheckAction(null, this.fDebugTarget);
                this.fMenuManager.add((IAction)newAction);
            }
        }
        if (this.fDebugTarget.supportsDateBreakpoints()) {
            if (this.fAction == null) {
                this.fAction = new DateBreakpointAction(action, this.fDebugTarget);
            } else {
                newAction = new DateBreakpointAction(null, this.fDebugTarget);
                this.fMenuManager.add((IAction)newAction);
            }
        }
        if (this.fDebugTarget.supportsEntryAutoSet()) {
            if (this.fAction == null) {
                this.fAction = new StopAtAllEntryPointsAction(action, this.fDebugTarget);
            } else {
                newAction = new StopAtAllEntryPointsAction(null, this.fDebugTarget);
                this.fMenuManager.add((IAction)newAction);
            }
        }
        if (this.fDebugTarget.supportsZeroAddressBreakpoints()) {
            if (this.fAction == null) {
                this.fAction = new ZeroAddressBreakpointAction(action, this.fDebugTarget);
            } else {
                newAction = new ZeroAddressBreakpointAction(null, this.fDebugTarget);
                this.fMenuManager.add((IAction)newAction);
            }
        }
    }
}

