/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.actions;

import com.ibm.debug.pdt.internal.core.PDTDebugTarget;
import com.ibm.debug.pdt.internal.core.model.LocalFilter;
import com.ibm.debug.pdt.internal.ui.PICLDebugPlugin;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import com.ibm.debug.pdt.internal.ui.actions.LocalFilterAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.debug.ui.AbstractDebugView;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class LocalsFilterActionDelegate
implements IObjectActionDelegate {
    private AbstractDebugView fDebugView = null;
    private IAction fAction = null;
    private String fOriginalLabel = null;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        if (this.fOriginalLabel == null) {
            this.fOriginalLabel = action.getText();
        }
        this.fDebugView = targetPart instanceof AbstractDebugView ? (AbstractDebugView)targetPart : null;
    }

    public void run(IAction action) {
        if (this.fAction != null) {
            this.fAction.run();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.fAction = null;
        action.setText(this.fOriginalLabel);
        action.setChecked(false);
        action.setEnabled(true);
        PDTDebugTarget debugTarget = PICLDebugPlugin.getPDTDebugTarget(selection);
        if (debugTarget == null) {
            return;
        }
        if (debugTarget.isTerminated()) {
            return;
        }
        if (!debugTarget.supportsLocalFilters()) {
            return;
        }
        int langID = this.getLangIDFromCurrentStackFrame();
        LocalFilter[] filters = this.getLangSpecFilters(debugTarget, langID);
        if (filters.length == 0) {
            return;
        }
        IMenuManager menuManager = null;
        List managers = this.fDebugView.getContextMenuManagers();
        if (managers != null && !managers.isEmpty()) {
            Iterator iter = managers.iterator();
            while (iter.hasNext() && menuManager == null) {
                menuManager = ((IMenuManager)iter.next()).findMenuUsingPath("com.ibm.debug.pdt.ui.actions.LocalsFilterMenu.menu");
            }
        }
        if (menuManager == null) {
            return;
        }
        int i = 0;
        while (i < filters.length) {
            if (this.fAction == null) {
                this.fAction = new LocalFilterAction(filters[i], i, debugTarget);
                action.setText(this.fAction.getText());
                action.setEnabled(this.fAction.isEnabled());
                action.setChecked(this.fAction.isChecked());
            } else {
                menuManager.add((IAction)new LocalFilterAction(filters[i], i, debugTarget));
            }
            ++i;
        }
    }

    private LocalFilter[] getLangSpecFilters(PDTDebugTarget debugTarget, int langID) {
        ArrayList<LocalFilter> filterList = new ArrayList<LocalFilter>();
        LocalFilter[] allFilters = debugTarget.getDebugEngine().getLocalFilters();
        int i = 0;
        while (i < allFilters.length) {
            LocalFilter localFilter = allFilters[i];
            int filterLangID = localFilter.getLanguageID();
            if (filterLangID == 0 || filterLangID == langID) {
                filterList.add(localFilter);
            }
            ++i;
        }
        return filterList.toArray(new LocalFilter[filterList.size()]);
    }

    private int getLangIDFromCurrentStackFrame() {
        int langID = -1;
        try {
            langID = PICLDebugPlugin.getCurrentStackFrame().getLocation().getPart().getLanguage().getId();
        }
        catch (NullPointerException npe) {
            PICLUtils.logError(npe);
        }
        return langID;
    }
}

