/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.actions;

import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.core.model.Location;
import com.ibm.debug.pdt.internal.ui.EngineSuppliedViewEditorInput;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import com.ibm.debug.pdt.internal.ui.editor.DebuggerEditor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.IUpdate;

public class FindNextAction
extends Action
implements IUpdate {
    private DebuggerEditor fEditor;

    public FindNextAction() {
        super(PICLLabels.FindNextAction_label1);
        this.setActionDefinitionId("org.eclipse.ui.edit.findNext");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, PICLUtils.getHelpResourceString("find_next_action"));
    }

    public FindNextAction(DebuggerEditor editor) {
        super(PICLLabels.FindNextAction_label1);
        this.fEditor = editor;
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, PICLUtils.getHelpResourceString("find_next_action"));
    }

    public void setEditor(DebuggerEditor editor) {
        this.fEditor = editor;
        this.update();
    }

    public void update() {
        IEditorInput input = this.fEditor.getEditorInput();
        if (input instanceof EngineSuppliedViewEditorInput && ((EngineSuppliedViewEditorInput)input).getViewFile().getSearchString() != null) {
            this.setEnabled(true);
            return;
        }
        this.setEnabled(false);
    }

    public void run() {
        Location stringLocation = this.fEditor.findNext();
        if (stringLocation == null) {
            return;
        }
        this.fEditor.gotoLine(stringLocation.getLineNumber(), false);
        this.fEditor.hiliteWord(stringLocation.getLineNumber(), stringLocation.getColumnNumber(), stringLocation.getViewFile().getSearchString().length());
    }
}

