/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.actions;

import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.core.model.DebuggeeThread;
import com.ibm.debug.pdt.internal.core.model.EngineRequestException;
import com.ibm.debug.pdt.internal.ui.PICLDebugPlugin;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class EnableDisableThreadDelegate
implements IObjectActionDelegate {
    DebuggeeThread fCurrentElement = null;

    public void run(IAction action) {
        new Job("Freeze/thaw thead"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    if (EnableDisableThreadDelegate.this.fCurrentElement.isDisabled()) {
                        EnableDisableThreadDelegate.this.fCurrentElement.thaw();
                    } else {
                        EnableDisableThreadDelegate.this.fCurrentElement.freeze();
                    }
                }
                catch (EngineRequestException e) {
                    PICLDebugPlugin.showMessageDialog(null, e.getMessage(), true);
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (PICLDebugPlugin.fPDT) {
            PICLUtils.logString(this, ".selectionChanged");
        }
        action.setEnabled(false);
        if (selection instanceof IStructuredSelection) {
            DebuggeeThread pt;
            if (((IStructuredSelection)selection).size() > 1) {
                return;
            }
            Object sel = ((IStructuredSelection)selection).getFirstElement();
            if (sel instanceof DebuggeeThread && (pt = (DebuggeeThread)sel).canEnableDisableThread()) {
                action.setEnabled(true);
                PlatformUI.getWorkbench().getHelpSystem().setHelp(action, PICLUtils.getHelpResourceString("enable_disable_thread"));
                if (!pt.isDisabled()) {
                    action.setText(PICLLabels.DisableThreadAction_label);
                    action.setDisabledImageDescriptor(PICLUtils.getImageDescriptor("PICL_ICON_DLCL_THREAD_DISABLE"));
                    action.setHoverImageDescriptor(PICLUtils.getImageDescriptor("PICL_ICON_CLCL_THREAD_DISABLE"));
                    action.setImageDescriptor(PICLUtils.getImageDescriptor("PICL_ICON_ELCL_THREAD_DISABLE"));
                } else {
                    action.setText(PICLLabels.EnableThreadAction_label);
                    action.setDisabledImageDescriptor(PICLUtils.getImageDescriptor("PICL_ICON_DLCL_THREAD_ENABLE"));
                    action.setHoverImageDescriptor(PICLUtils.getImageDescriptor("PICL_ICON_CLCL_THREAD_ENABLE"));
                    action.setImageDescriptor(PICLUtils.getImageDescriptor("PICL_ICON_ELCL_THREAD_ENABLE"));
                }
                this.fCurrentElement = pt;
            }
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }
}

