/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.actions;

import com.ibm.debug.pdt.core.breakpoints.GenericLineBreakpoint;
import com.ibm.debug.pdt.core.breakpoints.PICLBreakpoint;
import com.ibm.debug.pdt.core.breakpoints.PICLSourceLineBreakpoint;
import com.ibm.debug.pdt.internal.core.PDTDebugTarget;
import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.core.model.AddressBreakpoint;
import com.ibm.debug.pdt.internal.core.model.Breakpoint;
import com.ibm.debug.pdt.internal.core.model.EnhancedWatchpoint;
import com.ibm.debug.pdt.internal.core.model.EntryBreakpoint;
import com.ibm.debug.pdt.internal.core.model.LineBreakpoint;
import com.ibm.debug.pdt.internal.core.model.MacroBreakpoint;
import com.ibm.debug.pdt.internal.core.model.ModuleLoadBreakpoint;
import com.ibm.debug.pdt.internal.core.model.OccurrenceBreakpoint;
import com.ibm.debug.pdt.internal.core.model.Watchpoint;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import com.ibm.debug.pdt.internal.ui.dialogs.AddressBPWizard;
import com.ibm.debug.pdt.internal.ui.dialogs.DebugWizardDialog;
import com.ibm.debug.pdt.internal.ui.dialogs.EnhancedWatchBPWizard;
import com.ibm.debug.pdt.internal.ui.dialogs.EntryBPWizard;
import com.ibm.debug.pdt.internal.ui.dialogs.GenericLineBPWizard;
import com.ibm.debug.pdt.internal.ui.dialogs.LineBPWizard;
import com.ibm.debug.pdt.internal.ui.dialogs.LoadBPWizard;
import com.ibm.debug.pdt.internal.ui.dialogs.MacroBreakpointWizard;
import com.ibm.debug.pdt.internal.ui.dialogs.OccurrenceBPWizard;
import com.ibm.debug.pdt.internal.ui.dialogs.SourceLineBPWizard;
import com.ibm.debug.pdt.internal.ui.dialogs.WatchBPWizard;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class EditBreakpointAction
extends Action {
    private IBreakpoint fSelectedBP = null;

    public EditBreakpointAction(boolean enabled) {
        this.setId("com.ibm.debug.pdt.internal.ui.actions.EditBreakpointAction");
        this.setText(PICLLabels.EditBreakpointAction_label);
        this.setEnabled(false);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, PICLUtils.getHelpResourceString("edit_breakpoint_action"));
        try {
            if (enabled) {
                ISelection selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection("org.eclipse.debug.ui.BreakpointView");
                this.updateEnabledState(selection);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private Wizard createWizard() {
        if (this.fSelectedBP instanceof PICLBreakpoint) {
            PDTDebugTarget pdt = ((PICLBreakpoint)this.fSelectedBP).getDebugTarget();
            if (pdt != null && !pdt.isTerminated() && pdt.isAcceptingRequests()) {
                Breakpoint breakpoint = ((PICLBreakpoint)this.fSelectedBP).getModelBreakpoint();
                return this.openWizard(pdt, breakpoint);
            }
        } else {
            if (this.fSelectedBP instanceof PICLSourceLineBreakpoint) {
                return new SourceLineBPWizard((GenericLineBreakpoint)((PICLSourceLineBreakpoint)this.fSelectedBP));
            }
            if (this.fSelectedBP instanceof GenericLineBreakpoint) {
                return new GenericLineBPWizard((GenericLineBreakpoint)this.fSelectedBP);
            }
        }
        return null;
    }

    private Wizard openWizard(PDTDebugTarget debugTarget, Breakpoint breakpoint) {
        if (breakpoint instanceof LineBreakpoint) {
            return new LineBPWizard(debugTarget, (LineBreakpoint)breakpoint);
        }
        if (breakpoint instanceof MacroBreakpoint) {
            return new MacroBreakpointWizard(debugTarget, (MacroBreakpoint)breakpoint);
        }
        if (breakpoint instanceof EntryBreakpoint) {
            return new EntryBPWizard(debugTarget, (EntryBreakpoint)breakpoint);
        }
        if (breakpoint instanceof EnhancedWatchpoint) {
            return new EnhancedWatchBPWizard(debugTarget, (EnhancedWatchpoint)breakpoint);
        }
        if (breakpoint instanceof Watchpoint) {
            return new WatchBPWizard(debugTarget, (Watchpoint)breakpoint);
        }
        if (breakpoint instanceof ModuleLoadBreakpoint) {
            return new LoadBPWizard(debugTarget, (ModuleLoadBreakpoint)breakpoint);
        }
        if (breakpoint instanceof OccurrenceBreakpoint) {
            return new OccurrenceBPWizard(debugTarget, (OccurrenceBreakpoint)breakpoint);
        }
        if (breakpoint instanceof AddressBreakpoint) {
            return new AddressBPWizard(debugTarget, (AddressBreakpoint)breakpoint);
        }
        return null;
    }

    public void updateEnabledState(ISelection selection) {
        if (selection == null || selection.isEmpty()) {
            return;
        }
        if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() > 1) {
            return;
        }
        Object element = ((IStructuredSelection)selection).getFirstElement();
        if (element instanceof GenericLineBreakpoint) {
            this.setEnabled(true);
            this.fSelectedBP = (GenericLineBreakpoint)element;
            return;
        }
        if (!(element instanceof PICLBreakpoint)) {
            return;
        }
        PICLBreakpoint piclBP = (PICLBreakpoint)element;
        try {
            if (piclBP.isReadOnly()) {
                return;
            }
        }
        catch (Exception ce) {
            return;
        }
        this.setEnabled(true);
        this.fSelectedBP = (PICLBreakpoint)element;
    }

    public void run() {
        if (this.fSelectedBP == null) {
            return;
        }
        Wizard wizard = this.createWizard();
        if (wizard == null) {
            return;
        }
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        DebugWizardDialog dialog = new DebugWizardDialog(window.getShell(), (IWizard)wizard);
        dialog.create();
        dialog.open();
    }
}

