/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.actions;

import com.ibm.debug.pdt.internal.core.PDTDebugTarget;
import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.core.model.EngineRequestException;
import com.ibm.debug.pdt.internal.core.model.ExprNodeBase;
import com.ibm.debug.pdt.internal.ui.PICLDebugPlugin;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.SelectionProviderAction;

public class DisableVariableMonitorAction
extends SelectionProviderAction {
    public DisableVariableMonitorAction(ISelectionProvider provider) {
        super(provider, PICLLabels.DisableVariableMonitorAction_label_disable);
        this.setToolTipText(PICLLabels.DisableVariableMonitorAction_tooltip_disable);
        this.setEnabled(!this.getStructuredSelection().isEmpty());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, PICLUtils.getHelpResourceString("disable_variable_monitor_action"));
    }

    public void run() {
        final IStructuredSelection selections = this.getStructuredSelection();
        if (selections.isEmpty()) {
            return;
        }
        final boolean state = this.isChecked();
        new Job("Enable/Disable monitor"){

            protected IStatus run(IProgressMonitor monitor) {
                Object[] objectArray = selections.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object mon = objectArray[n2];
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    if (mon instanceof ExprNodeBase) {
                        ExprNodeBase node = (ExprNodeBase)mon;
                        try {
                            if (state) {
                                node.getExpression().disable();
                            } else {
                                node.getExpression().enable();
                            }
                        }
                        catch (EngineRequestException e) {
                            PICLDebugPlugin.showMessageDialog(null, e.getMessage(), true);
                        }
                    }
                    ++n2;
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    public void setChecked(boolean value) {
        super.setChecked(value);
        this.setToolTipText(value ? PICLLabels.DisableVariableMonitorAction_tooltip_enable : PICLLabels.DisableVariableMonitorAction_tooltip_disable);
    }

    public void selectionChanged(IStructuredSelection sel) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, PICLUtils.getHelpResourceString("disable_variable_monitor_action"));
        this.setEnabled(false);
        this.setChecked(false);
        if (sel.isEmpty()) {
            return;
        }
        PDTDebugTarget target = PICLDebugPlugin.getPDTDebugTarget((ISelection)sel);
        if (target == null || !target.supportsEnableDisableMonitors()) {
            return;
        }
        boolean allDisabled = true;
        boolean allRootNodes = true;
        Iterator vars = sel.iterator();
        while (vars.hasNext() && allRootNodes) {
            Object item = vars.next();
            if (item instanceof ExprNodeBase) {
                ExprNodeBase node = (ExprNodeBase)item;
                if (!node.isRootNode()) {
                    allRootNodes = false;
                    continue;
                }
                if (!node.getExpression().isEnabled()) continue;
                allDisabled = false;
                continue;
            }
            allRootNodes = false;
        }
        if (allRootNodes) {
            this.setEnabled(true);
        }
        if (allDisabled) {
            this.setChecked(true);
        }
    }
}

