/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.actions;

import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.core.util.PDTCoreUtils;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;

public class CopyTableViewToClipboardAction
extends Action {
    private static final String EMPTY = "";
    protected static final String PREFIX = "CopyViewToClipboardAction.";
    protected TableViewer fViewer;

    public CopyTableViewToClipboardAction(TableViewer viewer) {
        super(PICLLabels.CopyViewToClipboardAction_label);
        this.setToolTipText(PICLLabels.CopyViewToClipboardAction_tooltip);
        this.fViewer = viewer;
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, PICLUtils.getHelpResourceString("copy_view_to_clipboard_action"));
    }

    private String concatenateTableAsString(TableItem[] itemList) {
        if (itemList.length == 0) {
            return null;
        }
        StringBuilder tableContents = new StringBuilder();
        int numColumns = ((Table)this.fViewer.getControl()).getColumnCount();
        ITableLabelProvider labelProvider = (ITableLabelProvider)this.fViewer.getLabelProvider();
        TableColumn[] columns = ((Table)this.fViewer.getControl()).getColumns();
        int k = 0;
        while (k < numColumns) {
            tableContents.append(columns[k].getText());
            ++k;
        }
        tableContents.append(PDTCoreUtils.LINE_SEPARATOR);
        int i = 0;
        while (i < itemList.length) {
            int j = 0;
            while (j < numColumns) {
                tableContents.append("  ");
                tableContents.append(labelProvider.getColumnText(itemList[i].getData(), j));
                ++j;
            }
            tableContents.append(PDTCoreUtils.LINE_SEPARATOR);
            ++i;
        }
        return tableContents.toString();
    }

    public void run() {
        Clipboard clip = new Clipboard(this.fViewer.getControl().getDisplay());
        TableItem[] tableItems = ((Table)this.fViewer.getControl()).getItems();
        String tableAsString = EMPTY;
        tableAsString = this.concatenateTableAsString(tableItems);
        if (!tableAsString.equals(EMPTY)) {
            TextTransfer plainTextTransfer = TextTransfer.getInstance();
            clip.setContents(new Object[]{tableAsString}, new Transfer[]{plainTextTransfer});
        }
        this.setChecked(false);
    }

    public void setChecked(boolean value) {
        super.setChecked(value);
    }
}

