/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.actions;

import com.ibm.debug.pdt.core.breakpoints.PICLSourceLineBreakpoint;
import com.ibm.debug.pdt.internal.core.PDTDebugTarget;
import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.ui.PICLDebugPlugin;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import com.ibm.debug.pdt.internal.ui.actions.AbstractOpenWizardAction;
import com.ibm.debug.pdt.internal.ui.actions.AddAddressBreakpointAction;
import com.ibm.debug.pdt.internal.ui.actions.AddAddressRangeBreakpointAction;
import com.ibm.debug.pdt.internal.ui.actions.AddEnhancedWatchBreakpointAction;
import com.ibm.debug.pdt.internal.ui.actions.AddEntryBreakpointAction;
import com.ibm.debug.pdt.internal.ui.actions.AddLineBreakpointAction;
import com.ibm.debug.pdt.internal.ui.actions.AddLoadBreakpointAction;
import com.ibm.debug.pdt.internal.ui.actions.AddMacroBreakpointAction;
import com.ibm.debug.pdt.internal.ui.actions.AddOccurrenceBreakpointAction;
import com.ibm.debug.pdt.internal.ui.actions.AddWatchBreakpointAction;
import com.ibm.debug.pdt.internal.ui.actions.DateBreakpointAction;
import com.ibm.debug.pdt.internal.ui.actions.EditBreakpointAction;
import com.ibm.debug.pdt.internal.ui.actions.SpecialBreakpointActionDelegate;
import com.ibm.debug.pdt.internal.ui.actions.ZeroAddressBreakpointAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.ui.PlatformUI;

public class BreakpointsViewMenuListener
implements IMenuListener {
    public void menuAboutToShow(IMenuManager manager) {
        AbstractOpenWizardAction action;
        PDTDebugTarget target = PICLDebugPlugin.getCurrentPDTDebugTarget();
        boolean actionsEnabled = target != null && target.isAcceptingRequests() && !target.isTerminated();
        String addBkptId = "com.ibm.debug.pdt.internal.ui.actions.AddBreakpoint";
        MenuManager addBkptMenu = new MenuManager(PICLLabels.AddBP_label, addBkptId);
        manager.insertAfter("emptyBreakpointGroup", (IContributionItem)addBkptMenu);
        ISelection selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection("org.eclipse.debug.ui.BreakpointView");
        if (selection instanceof TreeSelection) {
            Object obj = ((TreeSelection)selection).getFirstElement();
            if (obj instanceof PICLSourceLineBreakpoint) {
                editBPAction = new EditBreakpointAction(true);
                manager.insertAfter(addBkptId, (IAction)editBPAction);
            } else if (target != null && target.supportsModifyingBreakpoints()) {
                editBPAction = new EditBreakpointAction(actionsEnabled);
                manager.insertAfter(addBkptId, (IAction)editBPAction);
            }
        }
        if (target == null) {
            return;
        }
        if (target.supportsBrkptType("com.ibm.debug.pdt.core.PICLAddressBreakpoint")) {
            action = new AddAddressBreakpointAction(target);
            action = this.setupAction(action, PICLLabels.AddressBPAction_label, actionsEnabled, target);
            addBkptMenu.add((IAction)action);
        }
        if (target.supportsBrkptType("com.ibm.debug.pdt.core.PICLAddressRangeBreakpoint")) {
            action = new AddAddressRangeBreakpointAction(target);
            action = this.setupAction(action, PICLLabels.AddressRangeBPAction_label, actionsEnabled, target);
            addBkptMenu.add((IAction)action);
        }
        if (target.supportsBrkptType("com.ibm.debug.pdt.core.PICLEntryBreakpoint")) {
            action = new AddEntryBreakpointAction(target);
            action = this.setupAction(action, PICLLabels.EntryBPAction_label, actionsEnabled, target);
            addBkptMenu.add((IAction)action);
        }
        if (target.supportsBrkptType("com.ibm.debug.pdt.core.PICLLineBreakpoint")) {
            action = new AddLineBreakpointAction(target);
            action = this.setupAction(action, PICLLabels.LineBPAction_label, actionsEnabled, target);
            addBkptMenu.add((IAction)action);
        }
        if (target.supportsBrkptType("com.ibm.debug.pdt.core.PICLLoadBreakpoint")) {
            action = new AddLoadBreakpointAction(target);
            action = this.setupAction(action, PICLLabels.LoadBPAction_label, actionsEnabled, target);
            addBkptMenu.add((IAction)action);
        }
        if (target.supportsBrkptType("com.ibm.debug.pdt.core.PICLOccurrenceBreakpoint")) {
            action = new AddOccurrenceBreakpointAction(target);
            action = this.setupAction(action, PICLLabels.OccurrenceBPAction_label, actionsEnabled, target);
            addBkptMenu.add((IAction)action);
        }
        if (target.supportsMacroBreakpoints()) {
            action = new AddMacroBreakpointAction(target);
            action = this.setupAction(action, PICLLabels.MacroBPAction_label, actionsEnabled, target);
            addBkptMenu.add((IAction)action);
        }
        if (target.supportsEnhancedWatchpointBreakpoints()) {
            action = new AddEnhancedWatchBreakpointAction(target);
            action = this.setupAction(action, PICLLabels.WatchBPAction_label, actionsEnabled, target);
            addBkptMenu.add((IAction)action);
        } else if (target.supportsChangeAddrBreakpoints()) {
            action = new AddWatchBreakpointAction(target);
            action = this.setupAction(action, PICLLabels.WatchBPAction_label, actionsEnabled, target);
            addBkptMenu.add((IAction)action);
        }
        boolean supportsDate = target.supportsDateBreakpoints();
        boolean stopAtAllEntry = target.supportsEntryAutoSet();
        if (supportsDate || stopAtAllEntry) {
            addBkptMenu.add((IContributionItem)new Separator());
            if (supportsDate) {
                DateBreakpointAction dateBkptAction = new DateBreakpointAction(null, target);
                addBkptMenu.add((IAction)dateBkptAction);
            }
            if (stopAtAllEntry) {
                try {
                    SpecialBreakpointActionDelegate stopAtAllEntryAction = new SpecialBreakpointActionDelegate(target, actionsEnabled);
                    addBkptMenu.add((IAction)stopAtAllEntryAction);
                }
                catch (Exception e) {
                    PICLUtils.logError(e);
                }
            }
        }
        if (target.supportsZeroAddressBreakpoints()) {
            ZeroAddressBreakpointAction zaction = new ZeroAddressBreakpointAction(target, actionsEnabled);
            addBkptMenu.add((IAction)zaction);
        }
    }

    private AbstractOpenWizardAction setupAction(AbstractOpenWizardAction action, String text, boolean enabled, PDTDebugTarget target) {
        action.setText(text);
        action.setEnabled(enabled);
        action.updateHelpAndLabel(target);
        return action;
    }
}

