/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.actions;

import com.ibm.debug.pdt.internal.common.CommonUtils;
import com.ibm.debug.pdt.internal.core.PDTDebugTarget;
import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.core.PICLMessages;
import com.ibm.debug.pdt.internal.core.model.DebuggeeThread;
import com.ibm.debug.pdt.internal.core.model.EngineRequestErrorException;
import com.ibm.debug.pdt.internal.core.model.EngineRequestException;
import com.ibm.debug.pdt.internal.core.model.IdentifierParser;
import com.ibm.debug.pdt.internal.core.model.Location;
import com.ibm.debug.pdt.internal.core.model.ViewFile;
import com.ibm.debug.pdt.internal.ui.EngineSuppliedViewEditorInput;
import com.ibm.debug.pdt.internal.ui.PICLDebugPlugin;
import com.ibm.debug.pdt.internal.ui.PICLDebugTarget;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import com.ibm.debug.pdt.internal.ui.dialogs.MonitorExpressionDialog;
import com.ibm.lpex.alef.LpexAbstractTextEditor;
import com.ibm.lpex.core.LpexDocumentLocation;
import com.ibm.lpex.core.LpexView;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.IUpdate;

public class AddSnippetToMonitorAction
extends Action
implements IUpdate {
    private ITextEditor editor;

    public AddSnippetToMonitorAction(ITextEditor textEditor) {
        super(PICLLabels.AddSnippetToMonitorAction_label);
        this.editor = textEditor;
        this.update();
    }

    public void run() {
        if (this.editor != null) {
            ITextSelection textSelection = (ITextSelection)this.editor.getSelectionProvider().getSelection();
            String snippet = textSelection.getText().trim();
            int lineNum = -1;
            if (this.editor instanceof LpexAbstractTextEditor) {
                LpexView lpexView = ((LpexAbstractTextEditor)this.editor).getLpexView();
                lineNum = lpexView.lineOfElement(lpexView.currentElement());
            } else {
                lineNum = textSelection.getStartLine() + 1;
            }
            if (lineNum < 0) {
                PICLDebugPlugin.showMessageDialog(null, NLS.bind((String)PICLMessages.AddSnippetToMonitorAction_error_invalid_line, (Object)Integer.toString(lineNum)), true);
                return;
            }
            IEditorInput editorInput = this.editor.getEditorInput();
            DebuggeeThread thread = PICLDebugPlugin.getCurrentThread();
            if (thread == null) {
                return;
            }
            ViewFile viewFile = null;
            PDTDebugTarget viewDbgTgt = (PDTDebugTarget)thread.getDebugTarget();
            if (editorInput instanceof EngineSuppliedViewEditorInput) {
                PICLDebugTarget editorDbgTgt = ((EngineSuppliedViewEditorInput)editorInput).getPICLDebugTarget();
                if (viewDbgTgt != editorDbgTgt && (thread = editorDbgTgt.getStoppingThread()) == null) {
                    thread = PICLDebugPlugin.getCurrentThread();
                }
                viewFile = ((EngineSuppliedViewEditorInput)editorInput).getViewFile();
                lineNum = PICLUtils.getRealLineNumber(editorInput, lineNum);
            } else if (viewDbgTgt != null && viewDbgTgt.isAcceptingRequests()) {
                viewFile = PICLUtils.getViewFile(editorInput);
            }
            if (thread == null || thread.isTerminated()) {
                if (PICLDebugPlugin.fPDT) {
                    PICLUtils.logString((Object)this, "AddSnippetToMonitorAction: invalid thread");
                }
                PICLDebugPlugin.showMessageDialog(null, PICLMessages.AddSnippetToMonitorAction_error_invalid_selection, true);
                return;
            }
            if (viewFile == null) {
                if (PICLDebugPlugin.fPDT) {
                    PICLUtils.logString((Object)this, "AddSnippetToMonitorAction: invalid viewfile");
                }
                PICLDebugPlugin.showMessageDialog(null, PICLMessages.AddSnippetToMonitorAction_error_invalid_viewfile, true);
                return;
            }
            IdentifierParser parser = null;
            try {
                parser = viewFile.getPart().getLanguage().getIdentifierParser();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            if (this.editor instanceof LpexAbstractTextEditor && parser != null) {
                int[] identifierInString;
                LpexView lpexView = ((LpexAbstractTextEditor)this.editor).getLpexView();
                LpexDocumentLocation cursorLoc = lpexView.documentLocation();
                String lineText = lpexView.elementText(cursorLoc.element);
                if (editorInput instanceof EngineSuppliedViewEditorInput) {
                    int prefixLength = ((EngineSuppliedViewEditorInput)editorInput).getPrefixLength();
                    parser.setPrefixLength(prefixLength);
                    parser.setViewInfoID(((EngineSuppliedViewEditorInput)this.editor.getEditorInput()).getViewInformation().getKind());
                } else {
                    parser.setViewInfoID((short)2);
                }
                if (snippet.length() == 0 && (identifierInString = parser.identifierInString(lineText, cursorLoc.position - 1)) != null && identifierInString[0] >= 0) {
                    snippet = lineText.substring(identifierInString[0], identifierInString[1] + 1);
                }
                snippet = parser.doLanguageSpecifics(snippet, lineText, cursorLoc.position - 1);
            }
            if (snippet == null || snippet.length() == 0) {
                PICLDebugPlugin.showMessageDialog(null, PICLMessages.AddSnippetToMonitorAction_error_invalid_text, true);
                return;
            }
            final DebuggeeThread theThread = thread;
            final Location location = new Location(viewFile, lineNum);
            final String theSnippet = snippet;
            Job monExprJob = new Job("Monitor Expression"){

                protected IStatus run(IProgressMonitor arg0) {
                    try {
                        if (theSnippet.length() > 1024) {
                            int status = 4;
                            String message = NLS.bind((String)PICLMessages.AddSnippetToMonitorAction_error_toolong, (Object)1024);
                            return new Status(status, PICLDebugPlugin.getPluginID(), message, null);
                        }
                        theThread.monitorExpression(location, theSnippet);
                    }
                    catch (EngineRequestErrorException e) {
                        String message;
                        int status;
                        switch (e.getReturnCode()) {
                            case 322: {
                                status = 1;
                                message = PICLMessages.AddSnippetToMonitorAction_error_ambiguous_monitor;
                                break;
                            }
                            case 130: {
                                status = 1;
                                message = PICLMessages.AddSnippetToMonitorAction_error_invalid_expression;
                                PICLDebugPlugin.showMessageDialog(null, e.getMessage(), true);
                                break;
                            }
                            default: {
                                status = 4;
                                message = PICLMessages.AddSnippetToMonitorAction_error_general;
                            }
                        }
                        return new Status(status, PICLDebugPlugin.getPluginID(), message, (Throwable)e);
                    }
                    catch (EngineRequestException e) {
                        return new Status(4, PICLDebugPlugin.getPluginID(), PICLMessages.AddSnippetToMonitorAction_error_general, (Throwable)e);
                    }
                    MonitorExpressionDialog.addExpressionHistory(theSnippet);
                    CommonUtils.asyncShowView((String)"com.ibm.debug.pdt.ui.MonitorView");
                    return Status.OK_STATUS;
                }
            };
            monExprJob.schedule();
        } else {
            if (PICLDebugPlugin.fPDT) {
                PICLUtils.logString((Object)this, "AddSnippetToMonitorAction: editor is null");
            }
            PICLDebugPlugin.showMessageDialog(null, PICLMessages.AddSnippetToMonitorAction_error_editor_not_found, true);
        }
    }

    public void update() {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, PICLUtils.getHelpResourceString("add_snippet_to_monitor_action"));
    }
}

