/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui;

import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.core.util.DebuggerProfileNameUtil;
import com.ibm.debug.pdt.internal.epdc.IEPDCConstants;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import com.ibm.debug.pdt.internal.ui.dialogs.ICheckedListItem;
import java.io.File;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.swt.graphics.Image;
import org.osgi.service.prefs.BackingStoreException;

public class ProfileItem
implements ICheckedListItem {
    private boolean fEnabled = false;
    private String fLabel;
    private File fFile;
    private File fSecondFile;
    private boolean fIsGlobalProfile;
    private IEclipsePreferences fPref;
    private String fKey;
    private static final String GLOBALPROFILEPREFIX = "esro@";
    private static final String GLOBALPROFILEOLDPREFIX = "esro.@";

    public ProfileItem(File file) {
        this.fFile = file;
        this.fLabel = this.initializeLabel(this.fFile.getName());
    }

    public ProfileItem(IEclipsePreferences pref, String key) {
        this.fPref = pref;
        this.fKey = key;
        this.fLabel = PICLLabels.GlobalExceptionDefaults + " " + this.getPlatformLabel(key);
    }

    @Override
    public boolean isEnabled() {
        return this.fEnabled;
    }

    public boolean isGlobalProfile() {
        return this.fIsGlobalProfile;
    }

    @Override
    public String getLabel() {
        return this.fLabel;
    }

    @Override
    public void setEnabled(boolean state) {
        this.fEnabled = state;
    }

    @Override
    public Image getImage() {
        return null;
    }

    @Override
    public int compareTo(ICheckedListItem o) {
        if (o instanceof ProfileItem) {
            return this.getLabel().compareToIgnoreCase(((ProfileItem)o).getLabel());
        }
        return 0;
    }

    @Override
    public void setDefaultEnabledState() {
        this.fEnabled = false;
    }

    public void addSecondFile(File file) {
        this.fSecondFile = file;
    }

    public void process() {
        if (this.isEnabled()) {
            if (this.fFile != null && this.fFile.exists() && !this.fFile.delete()) {
                PICLUtils.logString(this, "Unable to delete file: " + String.valueOf(this.fFile));
            }
            if (this.fSecondFile != null && this.fSecondFile.exists() && !this.fSecondFile.delete()) {
                PICLUtils.logString(this, "Unable to delete second file: " + String.valueOf(this.fSecondFile));
            }
            if (this.fPref != null) {
                this.fPref.remove(this.fKey);
                try {
                    this.fPref.flush();
                }
                catch (BackingStoreException backingStoreException) {
                    // empty catch block
                }
            }
        }
    }

    private String initializeLabel(String fileName) {
        int atIndex = fileName.indexOf(64);
        if (atIndex == -1 && atIndex < fileName.length() - 3) {
            return fileName;
        }
        StringBuilder label = new StringBuilder();
        if (fileName.startsWith(GLOBALPROFILEPREFIX) || fileName.startsWith(GLOBALPROFILEOLDPREFIX)) {
            label.append(PICLLabels.PICLDebugProfileDeleteDialog_GlobalProfileLabel2);
            this.fIsGlobalProfile = true;
        } else {
            int end = atIndex;
            if (atIndex > 1 && fileName.charAt(atIndex - 1) == '.') {
                end = atIndex - 1;
            }
            label.append(DebuggerProfileNameUtil.unEscapeFileName((String)fileName.substring(0, end)));
        }
        label.append(" ");
        label.append(this.getPlatformLabel(fileName.substring(atIndex + 1, atIndex + 4)));
        return label.toString();
    }

    private String getPlatformLabel(String encodedString) {
        StringBuilder label = new StringBuilder("[");
        char OS = encodedString.charAt(0);
        int i = 0;
        while (i < IEPDCConstants.PLATFORM_OS_CHAR.length) {
            if (IEPDCConstants.PLATFORM_OS_CHAR[i] == OS) {
                label.append(IEPDCConstants.PLATFORM_OS_String[i]);
                break;
            }
            ++i;
        }
        label.append(" ");
        char hardware = encodedString.charAt(2);
        int i2 = 0;
        while (i2 < IEPDCConstants.PLATFORM_HDW_CHAR.length) {
            if (IEPDCConstants.PLATFORM_HDW_CHAR[i2] == hardware) {
                label.append(IEPDCConstants.PLATFORM_HDW_String[i2]);
                break;
            }
            ++i2;
        }
        label.append("]");
        return label.toString();
    }
}

