/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui;

import com.ibm.debug.pdt.common.DebugImageDescriptor;
import com.ibm.debug.pdt.core.ISourceBreakpointAdapter;
import com.ibm.debug.pdt.core.breakpoints.PICLBreakpoint;
import com.ibm.debug.pdt.internal.core.IDebugLocationProvider;
import com.ibm.debug.pdt.internal.core.PDTCorePlugin;
import com.ibm.debug.pdt.internal.core.PDTDebugTarget;
import com.ibm.debug.pdt.internal.core.model.DebuggeeThread;
import com.ibm.debug.pdt.internal.core.model.IdentifierParser;
import com.ibm.debug.pdt.internal.core.model.Location;
import com.ibm.debug.pdt.internal.core.model.StackFrame;
import com.ibm.debug.pdt.internal.core.model.ViewFile;
import com.ibm.debug.pdt.internal.core.util.PDTCoreUtils;
import com.ibm.debug.pdt.internal.epdc.EStdView;
import com.ibm.debug.pdt.internal.ui.EngineSuppliedViewEditorInput;
import com.ibm.debug.pdt.internal.ui.PICLDebugPlugin;
import com.ibm.debug.pdt.internal.ui.PICLDebugTarget;
import com.ibm.debug.pdt.internal.ui.editor.DebuggerEditor;
import com.ibm.debug.pdt.internal.ui.sourcelocator.PDTSourceNotFoundEditorInput;
import com.ibm.debug.pdt.internal.ui.sourcelocator.RemoteEnginePathContainer;
import com.ibm.debug.pdt.ui.IDebugHelp;
import com.ibm.lpex.alef.LpexAbstractTextEditor;
import com.ibm.lpex.core.LpexDocumentLocation;
import com.ibm.lpex.core.LpexView;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.debug.internal.ui.sourcelookup.SourceLookupFacility;
import org.eclipse.debug.internal.ui.sourcelookup.SourceLookupResult;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.sourcelookup.ISourceLookupResult;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.views.properties.PropertySheet;
import org.eclipse.ui.views.properties.PropertySheetPage;

public final class PICLUtils {
    public static final IWorkbenchWindow[] EMPTYWINDOWS = new IWorkbenchWindow[0];
    public static final String USER_ID = "userid";
    public static final String PASSWORD = "password";
    public static final String EMPTY_STRING = "";
    private static ImageRegistry imageRegistry;
    private static Object fImageRegistryLock;
    private static HashMap<String, ImageDescriptor> imageDescriptors;
    private static final String CVIEW = "cview16/";
    private static final String EVIEW = "eview16/";
    private static final String CLCL = "clcl16/";
    private static final String DLCL = "dlcl16/";
    private static final String ELCL = "elcl16/";
    private static final String OBJECT = "obj16/";
    private static final String WIZBAN = "wizban/";
    private static URL ICON_BASE_URL;

    static {
        fImageRegistryLock = new Object();
        ICON_BASE_URL = null;
        ICON_BASE_URL = PICLDebugPlugin.getPluginBundle().getEntry("icons/full/");
    }

    public static final String getHelpResourceString(String key) {
        Object helpKey = null;
        IDebugHelp helpClass = null;
        PICLDebugTarget pdt = null;
        try {
            pdt = PICLDebugPlugin.getCurrentPICLDebugTarget();
        }
        catch (SWTException sWTException) {
            // empty catch block
        }
        if (pdt != null) {
            helpClass = pdt.getHelpClass();
        }
        if (helpClass == null && Platform.getProduct() != null) {
            String productID = Platform.getProduct().getId();
            helpClass = PICLDebugPlugin.getHelpClass(productID);
        }
        if (helpClass != null) {
            helpKey = helpClass.lookUpHelpID(key);
        }
        if (helpKey == null) {
            helpKey = "com.ibm.debug.pdt.ui." + key;
        }
        return helpKey;
    }

    @Deprecated
    public static String getNonMnemonicString(String str) {
        int indexOfAmpersand = ((String)str).indexOf("&", 0);
        while (indexOfAmpersand >= 0) {
            str = ((String)str).substring(0, indexOfAmpersand) + "&" + ((String)str).substring(indexOfAmpersand, ((String)str).length());
            indexOfAmpersand += 2;
            indexOfAmpersand = ((String)str).indexOf("&", indexOfAmpersand);
        }
        return str;
    }

    public static String getVisualTextDisplayString(String value) {
        if (value == null || value.length() == 0) {
            return " ";
        }
        value = value.replace('\u200b', ' ');
        return value;
    }

    public static String postProcessVisualTextEditString(String value) {
        if (value == null || value.length() == 0) {
            return " ";
        }
        value = value.replaceAll(" \ufeb1", "\u200b\ufeb1");
        value = value.replaceAll(" \ufeb2", "\u200b\ufeb2");
        value = value.replaceAll(" \ufeb5", "\u200b\ufeb5");
        value = value.replaceAll(" \ufeb6", "\u200b\ufeb6");
        value = value.replaceAll(" \ufeb9", "\u200b\ufeb9");
        value = value.replaceAll(" \ufeba", "\u200b\ufeba");
        value = value.replaceAll(" \ufebd", "\u200b\ufebd");
        value = value.replaceAll(" \ufebe", "\u200b\ufebe");
        return value;
    }

    public static String getNullFreeDisplayString(String value) {
        if (value == null || value.length() == 0) {
            return EMPTY_STRING;
        }
        return value.replace('\u0000', '\u0001');
    }

    /*
     * Unable to fully structure code
     */
    public static String getLineBreakFreeString(String str) {
        block2: {
            curStr = null;
            toReplace = new String[]{"\n", System.getProperty("line.separator")};
            prefix = null;
            postfix = null;
            index = -1;
            if (str == null) break block2;
            curStr = str;
            i = 0;
            ** GOTO lbl16
            {
                prefix = curStr.substring(0, index);
                postfix = curStr.substring(index + 1, curStr.length());
                curStr = prefix + " " + postfix;
                do {
                    if ((index = curStr.indexOf(toReplace[i])) != -1) continue block0;
                    ++i;
lbl16:
                    // 2 sources

                } while (i < toReplace.length);
            }
        }
        return curStr;
    }

    public static final void logError(Exception e) {
        PICLUtils.logString(null, e.getMessage() != null ? e.getMessage() : e.toString(), 4, e);
    }

    public static final synchronized void logString(Object originator, String text, int severity) {
        PICLUtils.logString(originator, text, severity, null);
    }

    public static final synchronized void logString(Object originator, String text, int severity, Exception e) {
        StringBuffer buffer = new StringBuffer(PICLUtils.getTiming());
        buffer.append(" [" + Thread.currentThread().getName() + "]");
        if (originator != null) {
            buffer.append(PICLUtils.getBaseName(originator));
        }
        buffer.append(text);
        Status sts = new Status(severity, PICLDebugPlugin.getPluginID(), 0, buffer.toString(), (Throwable)e);
        try {
            PICLDebugPlugin.fLogFile.log((IStatus)sts);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public static final synchronized void logString(Object originator, String text) {
        PICLUtils.logString(originator, text, 1);
    }

    public static final void logEvent(String text, Object originator) {
        String msgText = "EVENT(" + PICLUtils.getBaseName(originator) + " <" + originator.hashCode() + ">)-> " + text;
        if (PICLDebugPlugin.fPDTEventStack) {
            PICLUtils.logString(null, msgText, 1, new Exception(msgText));
        } else {
            PICLUtils.logString(null, msgText);
        }
    }

    public static final String getBaseName(Object obj) {
        if (obj == null) {
            return "NULL";
        }
        String qualifiedClassName = obj.getClass().getName();
        return qualifiedClassName.substring(qualifiedClassName.lastIndexOf(".") + 1);
    }

    public static final String getModelIdentifier() {
        return "com.ibm.debug.pdt";
    }

    public static ImageRegistry getImageRegistry() {
        if (imageRegistry == null) {
            PICLUtils.initializeImageRegistry();
        }
        return imageRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImageRegistry initializeImageRegistry() {
        Object object = fImageRegistryLock;
        synchronized (object) {
            if (imageRegistry == null) {
                ImageRegistry tempImageRegistry = new ImageRegistry();
                HashMap<String, ImageDescriptor> tempImageDescriptors = new HashMap<String, ImageDescriptor>(30);
                PICLUtils.declareImages(tempImageRegistry, tempImageDescriptors);
                PICLUtils.declareBreakpointImages(tempImageRegistry, tempImageDescriptors);
                imageRegistry = tempImageRegistry;
                imageDescriptors = tempImageDescriptors;
            }
            return imageRegistry;
        }
    }

    private static final void declareRegistryImage(String key, String path, ImageRegistry tempImageRegistry, HashMap<String, ImageDescriptor> tempImageDescriptors) {
        ImageDescriptor desc = ImageDescriptor.getMissingImageDescriptor();
        try {
            desc = ImageDescriptor.createFromURL((URL)PICLUtils.makeIconFileURL(path));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        tempImageRegistry.put(key, desc);
        tempImageDescriptors.put(key, desc);
    }

    private static URL makeIconFileURL(String iconPath) throws MalformedURLException {
        if (ICON_BASE_URL == null) {
            throw new MalformedURLException();
        }
        return new URL(ICON_BASE_URL, iconPath);
    }

    public static ImageDescriptor getImageDescriptor(String key) {
        if (imageDescriptors == null) {
            PICLUtils.initializeImageRegistry();
        }
        return imageDescriptors.get(key);
    }

    public static Image getImage(String key) {
        if (imageRegistry == null) {
            PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    PICLUtils.initializeImageRegistry();
                }
            });
        }
        return PICLUtils.getImageRegistry().get(key);
    }

    private static void declareImages(ImageRegistry tempImageRegistry, HashMap<String, ImageDescriptor> tempImageDescriptors) {
        PICLUtils.declareRegistryImage("PICL_ICON_CVIEW_DEBUG_VIEW", "cview16/debug_view.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_CVIEW_EXCEPTION_DIALOG", "cview16/exception_misc.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_CVIEW_GDB_VIEW", "cview16/gdbView.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_CVIEW_MODULES_VIEW", "cview16/modules_view.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_CVIEW_MONITOR_VIEW", "cview16/monitor_view.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_CVIEW_REGISTER_VIEW", "cview16/register_view.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_CVIEW_SET_PREFERRED_SOURCE_VIEW", "cview16/setpreferredsourceview_ps.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_CVIEW_SOURCE_VIEW", "cview16/source_view.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_CVIEW_STORAGE_VIEW", "cview16/storage_view.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_CVIEW_STORAGEMAPPING_VIEW", "cview16/storagemapping_view.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_EVIEW_DEBUG_VIEW", "eview16/debug_view.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_EVIEW_EXCEPTION_DIALOG", "eview16/exception_misc.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_EVIEW_MODULES_VIEW", "eview16/modules_view.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_EVIEW_MONITOR_VIEW", "eview16/monitor_view.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_EVIEW_REGISTER_VIEW", "eview16/register_view.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_EVIEW_SET_PREFERRED_SOURCE_VIEW", "eview16/setpreferredsourceview_ps.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_EVIEW_SOURCE_VIEW", "eview16/source_view.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_EVIEW_STORAGE_VIEW", "eview16/storage_view.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_EVIEW_STORAGEMAPPING_VIEW", "eview16/storagemapping_view.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_CLCL_ADD_COMPILED_EXCEPTION", "clcl16/addcompiledexception_tsk.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_CLCL_COLLAPSE_ALL", "clcl16/collapseall_tsk.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_CLCL_COPY_VIEW_TO_CLIPBOARD", "clcl16/copyviewtoclipboard_tsk.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_CLCL_DISABLE_MONITOR", "clcl16/disablemonitor_tsk.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_CLCL_DISABLE_STORAGE", "clcl16/disablestorage_tsk.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_CLCL_EXPAND_ALL", "clcl16/expandall_tsk.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_CLCL_FILTER_MODULES", "clcl16/filtermodules_tsk.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_CLCL_MAP_STORAGE", "clcl16/mapstorage_tsk.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_CLCL_MONITOR_EXPRESSION", "clcl16/monitorexpression_tsk.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_CLCL_PRINT_VIEW", "clcl16/printview_tsk.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_CLCL_REMOVE_ALL_MONITORS", "clcl16/removeallmonitors_tsk.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_CLCL_REMOVE_MONITOR", "clcl16/removemonitor_tsk.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_CLCL_REMOVE_ALL_STORAGE", "clcl16/removeallstorage_tsk.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_CLCL_REMOVE_STORAGE", "clcl16/removestorage_tsk.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_CLCL_RETRY_EXCEPTION", "clcl16/retryexception_tsk.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_CLCL_RUN_EXCEPTION", "clcl16/runexception_tsk.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_CLCL_SHOW_DETAILS", "clcl16/showdetails_tsk.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_CLCL_SHOW_STORAGE_STYLES", "clcl16/showstoragestyles_tsk.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_CLCL_SHOW_TYPE_NAMES", "clcl16/showtypenames_tsk.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_CLCL_SORT_MODULES", "clcl16/sortmodules_tsk.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_CLCL_STEP_DEBUG", "clcl16/stepdebug_tsk.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_CLCL_STEP_EXCEPTION", "clcl16/stepexception_tsk.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_CLCL_STORAGE_RESET", "clcl16/storagereset_tsk.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_CLCL_THREAD_DISABLE", "clcl16/thread_dis_obj.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_CLCL_THREAD_ENABLE", "clcl16/thread_obj.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_CLCL_DEBUGCONSOLE_CLEAR", "clcl16/clear_co.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_CLCL_FILE_FIND", "clcl16/filefind_tsk.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_DLCL_ADD_COMPILED_EXCEPTION", "dlcl16/addcompiledexception_tsk.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_DLCL_COLLAPSE_ALL", "dlcl16/collapseall_tsk.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_DLCL_COPY_VIEW_TO_CLIPBOARD", "dlcl16/copyviewtoclipboard_tsk.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_DLCL_DISABLE_MONITOR", "dlcl16/disablemonitor_tsk.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_DLCL_DISABLE_STORAGE", "dlcl16/disablestorage_tsk.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_DLCL_EXPAND_ALL", "dlcl16/expandall_tsk.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_DLCL_FILTER_MODULES", "dlcl16/filtermodules_tsk.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_DLCL_MAP_STORAGE", "dlcl16/mapstorage_tsk.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_DLCL_MONITOR_EXPRESSION", "dlcl16/monitorexpression_tsk.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_DLCL_PRINT_VIEW", "dlcl16/printview_tsk.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_DLCL_REMOVE_ALL_MONITORS", "dlcl16/removeallmonitors_tsk.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_DLCL_REMOVE_MONITOR", "dlcl16/removemonitor_tsk.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_DLCL_REMOVE_ALL_STORAGE", "dlcl16/removeallstorage_tsk.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_DLCL_REMOVE_STORAGE", "dlcl16/removestorage_tsk.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_DLCL_RETRY_EXCEPTION", "dlcl16/retryexception_tsk.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_DLCL_RUN_EXCEPTION", "dlcl16/runexception_tsk.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_DLCL_SHOW_DETAILS", "dlcl16/showdetails_tsk.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_DLCL_SHOW_STORAGE_STYLES", "dlcl16/showstoragestyles_tsk.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_DLCL_SHOW_TYPE_NAMES", "dlcl16/showtypenames_tsk.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_DLCL_SORT_MODULES", "dlcl16/sortmodules_tsk.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_DLCL_STEP_DEBUG", "dlcl16/stepdebug_tsk.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_DLCL_STEP_EXCEPTION", "dlcl16/stepexception_tsk.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_DLCL_STORAGE_RESET", "dlcl16/storagereset_tsk.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_DLCL_THREAD_DISABLE", "dlcl16/thread_dis_obj.gif", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_DLCL_THREAD_ENABLE", "dlcl16/thread_obj.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_DLCL_DEBUGCONSOLE_CLEAR", "dlcl16/clear_co.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_DLCL_DEBUGCONSOLE_EXPORT_LOG", "dlcl16/export_log.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_DLCL_DEBUGCONSOLE_EXPORT_HISTORY", "dlcl16/export_history.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_DLCL_DEBUGCONSOLE_IMPORT_LOG", "dlcl16/import_log.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_DLCL_DEBUGCONSOLE_PLAY_ONE_CMD", "dlcl16/play_one_cmd.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_DLCL_DEBUGCONSOLE_PLAY_ALL_CMD", "dlcl16/play_all_cmd.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_DLCL_DEBUGCONSOLE_STOP_CMD", "dlcl16/stop_cmd.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_DLCL_DEBUGCONSOLE_DELETE_CMD", "dlcl16/delete_command.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_DLCL_DEBUGCONSOLE_CLEAR_CMD", "dlcl16/clear_commands.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_DLCL_FILE_FIND", "dlcl16/filefind_tsk.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_DLCL_HEX_ENABLE", "dlcl16/hex_dis.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_ELCL_ADD_COMPILED_EXCEPTION", "elcl16/addcompiledexception_tsk.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_ELCL_COLLAPSE_ALL", "elcl16/collapseall_tsk.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_ELCL_COPY_VIEW_TO_CLIPBOARD", "elcl16/copyviewtoclipboard_tsk.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_ELCL_DISABLE_MONITOR", "elcl16/disablemonitor_tsk.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_ELCL_DISABLE_STORAGE", "elcl16/disablestorage_tsk.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_ELCL_EXPAND_ALL", "elcl16/expandall_tsk.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_ELCL_FILTER_MODULES", "elcl16/filtermodules_tsk.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_ELCL_MAP_STORAGE", "elcl16/mapstorage_tsk.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_ELCL_MONITOR_EXPRESSION", "elcl16/monitorexpression_tsk.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_ELCL_PRINT_VIEW", "elcl16/printview_tsk.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_ELCL_REMOVE_ALL_MONITORS", "elcl16/removeallmonitors_tsk.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_ELCL_REMOVE_MONITOR", "elcl16/removemonitor_tsk.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_ELCL_REMOVE_ALL_STORAGE", "elcl16/removeallstorage_tsk.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_ELCL_REMOVE_STORAGE", "elcl16/removestorage_tsk.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_ELCL_RETRY_EXCEPTION", "elcl16/retryexception_tsk.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_ELCL_RUN_EXCEPTION", "elcl16/runexception_tsk.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_ELCL_SHOW_DETAILS", "elcl16/showdetails_tsk.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_ELCL_SHOW_STORAGE_STYLES", "elcl16/showstoragestyles_tsk.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_ELCL_SHOW_TYPE_NAMES", "elcl16/showtypenames_tsk.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_ELCL_SORT_MODULES", "elcl16/sortmodules_tsk.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_ELCL_STEP_DEBUG", "elcl16/stepdebug_tsk.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_ELCL_STEP_EXCEPTION", "elcl16/stepexception_tsk.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_ELCL_STORAGE_RESET", "elcl16/storagereset_tsk.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_ELCL_THREAD_DISABLE", "elcl16/thread_dis_obj.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_ELCL_THREAD_ENABLE", "elcl16/thread_obj.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_ELCL_DEBUGCONSOLE_CLEAR", "elcl16/clear_co.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_ELCL_DEBUGCONSOLE_EXPORT_LOG", "elcl16/export_log.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_ELCL_DEBUGCONSOLE_EXPORT_HISTORY", "elcl16/export_history.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_ELCL_DEBUGCONSOLE_IMPORT_LOG", "elcl16/import_log.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_ELCL_DEBUGCONSOLE_PLAY_ONE_CMD", "elcl16/play_one_cmd.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_ELCL_DEBUGCONSOLE_PLAY_ALL_CMD", "elcl16/play_all_cmd.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_ELCL_DEBUGCONSOLE_STOP_CMD", "elcl16/stop_cmd.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_ELCL_DEBUGCONSOLE_DELETE_CMD", "elcl16/delete_command.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_ELCL_DEBUGCONSOLE_INSERT_CMD", "elcl16/insert_command.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_ELCL_DEBUGCONSOLE_CLEAR_CMD", "elcl16/clear_commands.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_ELCL_FILE_FIND", "elcl16/filefind_tsk.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_ELCL_HEX_ENABLE", "elcl16/hex.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_ELCL_ASSIGN_VALUE", "elcl16/assignvalue.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_ACTIVE_BREAKPOINT", "obj16/activebreakpoint_obj.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_FILE", "obj16/file_obj.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_FUNCTION", "obj16/function_obj.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_MODULE", "obj16/module_obj.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_MODULE_WITH_SIDEFILE", "obj16/module_sidefile_obj.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_NO_FILE", "obj16/nofile_obj.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_PART", "obj16/part_obj.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_REGISTER", "obj16/register_obj.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_REGISTER_CHANGED", "obj16/registerchanged_obj.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_REGISTER_GROUP", "obj16/registergroup_obj.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_SOURCE", "obj16/source_obj.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_STORAGE_LAYOUT", "obj16/storagemapping_obj.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_STORAGE_ELEMENT", "obj16/genericvariable_obj.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_VARIABLE", "obj16/variable_obj.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_VARIABLE_CHANGED", "obj16/variablechanged_obj.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_VARIABLE_DISABLED", "obj16/variabledisabled_obj.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_THREAD_SUSPENDED_DISABLED", "obj16/threadsuspended_dis_obj.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_THREAD_RUNNING_DISABLED", "obj16/threadrunning_dis_obj.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_INSTRUCTION_POINTER_TOP", "obj16/inst_ptr_top.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_INSTRUCTION_POINTER", "obj16/inst_ptr.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_ATTACH_TAB", "obj16/attachconfig_obj.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_LOAD_TAB", "obj16/loadconfig_obj.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_DAEMON_TAB", "obj16/daemonconfig_obj.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_MORE", "obj16/show_more.png", tempImageRegistry, tempImageDescriptors);
        PICLUtils.declareRegistryImage("PICL_ICON_BREAKPOINT_WIZARD", "wizban/breakpoint_wiz.png", tempImageRegistry, tempImageDescriptors);
    }

    private static void declareBreakpointImages(ImageRegistry tempImageRegistry, HashMap<String, ImageDescriptor> tempImageDescriptors) {
        ImageDescriptor[] baseImages = new ImageDescriptor[]{DebugUITools.getImageDescriptor((String)"IMG_OBJS_BREAKPOINT"), DebugUITools.getImageDescriptor((String)"IMG_OBJS_BREAKPOINT"), DebugUITools.getImageDescriptor((String)"IMG_OBJS_BREAKPOINT_DISABLED"), DebugUITools.getImageDescriptor((String)"IMG_OBJS_BREAKPOINT_DISABLED")};
        int[] statusFlags = new int[]{3, 7, 1, 5};
        int[] nArray = new int[3];
        nArray[1] = 32;
        nArray[2] = 8;
        int[] typeFlags = nArray;
        String[][] finalImageKeys = new String[][]{{"PICL_ICON_BREAKPOINT_EI", "PICL_ICON_BREAKPOINT_EI_COND", "PICL_ICON_BREAKPOINT_DI", "PICL_ICON_BREAKPOINT_DI_COND"}, {"PICL_ICON_ADDRESS_BREAKPOINT_EI", "PICL_ICON_ADDRESS_BREAKPOINT_EI_COND", "PICL_ICON_ADDRESS_BREAKPOINT_DI", "PICL_ICON_ADDRESS_BREAKPOINT_DI_COND"}, {"PICL_ICON_ENTRY_BREAKPOINT_EI", "PICL_ICON_ENTRY_BREAKPOINT_EI_COND", "PICL_ICON_ENTRY_BREAKPOINT_DI", "PICL_ICON_ENTRY_BREAKPOINT_DI_COND"}};
        int i = 0;
        while (i < typeFlags.length && i < finalImageKeys.length) {
            int j = 0;
            while (j < baseImages.length && j < statusFlags.length && j < finalImageKeys[i].length) {
                PICLUtils.createBreakpointImage(baseImages[j], statusFlags[j] | typeFlags[i], finalImageKeys[i][j], tempImageRegistry, tempImageDescriptors);
                ++j;
            }
            ++i;
        }
    }

    private static void createBreakpointImage(ImageDescriptor baseImage, int statusFlag, String finalImageKey, ImageRegistry tempImageRegistry, HashMap<String, ImageDescriptor> tempImageDescriptors) {
        DebugImageDescriptor finalImage = new DebugImageDescriptor(baseImage, statusFlag);
        tempImageRegistry.put(finalImageKey, (ImageDescriptor)finalImage);
        tempImageDescriptors.put(finalImageKey, (ImageDescriptor)finalImage);
    }

    public static final void resetTiming() {
        PICLDebugPlugin.fElapsedTime = System.currentTimeMillis();
    }

    public static final String getTiming() {
        if (PICLDebugPlugin.fTiming) {
            long currTime = System.currentTimeMillis();
            Object msg = String.valueOf(currTime - PICLDebugPlugin.fElapsedTime);
            switch (((String)msg).length()) {
                case 1: {
                    msg = "    " + (String)msg;
                    break;
                }
                case 2: {
                    msg = "   " + (String)msg;
                    break;
                }
                case 3: {
                    msg = "  " + (String)msg;
                    break;
                }
                case 4: {
                    msg = " " + (String)msg;
                    break;
                }
            }
            msg = "[" + (String)msg + "ms] ";
            PICLDebugPlugin.fElapsedTime = currTime;
            return msg;
        }
        return EMPTY_STRING;
    }

    public static String getProfileSaveRestoreLocation() {
        IPath path = PICLDebugPlugin.getInstance().getStateLocation();
        File saveDir = (path = path.append("profiles")).toFile();
        if (!saveDir.exists() && !saveDir.mkdir()) {
            PICLUtils.logString(PICLUtils.class, "Uneable to create dir:" + String.valueOf(saveDir));
        }
        String saveRestorePath = path.toOSString();
        return saveRestorePath;
    }

    public static void refreshPropertiesView() {
        try {
            IPage page;
            IWorkbenchPage p = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            IViewPart view = null;
            view = p.findView("org.eclipse.ui.views.PropertySheet");
            if (view instanceof PropertySheet && (page = ((PropertySheet)view).getDefaultPage()) instanceof PropertySheetPage) {
                ((PropertySheetPage)page).refresh();
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public static String getWorkingSetName(IBreakpoint bp) {
        IWorkingSet[] workingSets = PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSets();
        if (workingSets == null) {
            return null;
        }
        int i = 0;
        while (i < workingSets.length) {
            IAdaptable[] setElements = workingSets[i].getElements();
            if (setElements != null) {
                int j = 0;
                while (j < setElements.length) {
                    if (setElements[j] == bp) {
                        return workingSets[i].getName();
                    }
                    ++j;
                }
            }
            ++i;
        }
        return null;
    }

    public static IMarker[] getAllSourceLineBreakpointMarkers() {
        IMarker[] bpMarkers = null;
        try {
            bpMarkers = ResourcesPlugin.getWorkspace().getRoot().findMarkers("com.ibm.debug.pdt.common.GenericLineBreakpointMarker", true, 2);
            IConfigurationElement[] sourceBPAdapters = PDTCorePlugin.getSourceBreakpointAdapters();
            if (sourceBPAdapters == null) {
                return bpMarkers;
            }
            IMarker[] adaptedMarkers = null;
            int i = 0;
            while (i < sourceBPAdapters.length) {
                Object adapterClass = sourceBPAdapters[i].createExecutableExtension("class");
                if (adapterClass instanceof ISourceBreakpointAdapter && (adaptedMarkers = ((ISourceBreakpointAdapter)adapterClass).getSourceLineBreakpointMarkers()) != null && adaptedMarkers.length > 0) {
                    IMarker[] tempMarkers = bpMarkers;
                    bpMarkers = new IMarker[tempMarkers.length + adaptedMarkers.length];
                    int j = 0;
                    while (j < tempMarkers.length) {
                        bpMarkers[j] = tempMarkers[j];
                        ++j;
                    }
                    int k = 0;
                    while (k < adaptedMarkers.length) {
                        bpMarkers[k + tempMarkers.length] = adaptedMarkers[k];
                        ++k;
                    }
                }
                ++i;
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return bpMarkers;
    }

    public static void updateSourceLineBreakpoint(final IMarker marker, final String moduleName, final String objectName) {
        try {
            IWorkspaceRunnable body = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    marker.setAttributes(new String[]{"moduleName", "objectName"}, (Object[])new String[]{moduleName, objectName});
                }
            };
            ResourcesPlugin.getWorkspace().run(body, (ISchedulingRule)marker.getResource(), 1, null);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    public static void updateResourceSourceLineBPInfoMarker(final IResource resource, final String moduleName, final String objectName) {
        try {
            IWorkspaceRunnable body = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    IMarker[] resourceMarkers = resource.findMarkers("com.ibm.debug.pdt.breakpointResourceInfoMarkerID", false, 0);
                    IMarker breakpointResourceMarker = resourceMarkers != null && resourceMarkers.length > 0 ? resourceMarkers[0] : resource.createMarker("com.ibm.debug.pdt.breakpointResourceInfoMarkerID");
                    breakpointResourceMarker.setAttributes(new String[]{"moduleName", "objectName"}, (Object[])new String[]{moduleName, objectName});
                }
            };
            ResourcesPlugin.getWorkspace().run(body, (ISchedulingRule)resource, 1, null);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    public static RemoteEnginePathContainer getDebugEnginePathContainer(ISourceLookupDirector director) {
        if (director == null) {
            return null;
        }
        ISourceContainer[] containers = director.getSourceContainers();
        if (containers == null) {
            return null;
        }
        int i = 0;
        while (i < containers.length) {
            if (containers[i] instanceof RemoteEnginePathContainer) {
                return (RemoteEnginePathContainer)containers[i];
            }
            ++i;
        }
        return null;
    }

    public static final IWorkbenchWindow[] getWorkbenchWindows() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null) {
            return workbench.getWorkbenchWindows();
        }
        return EMPTYWINDOWS;
    }

    public static final Shell getShell() {
        final Shell[] shell = new Shell[1];
        Display display = PlatformUI.getWorkbench().getDisplay();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                shell[0] = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            }
        });
        return shell[0];
    }

    public static void mkDir(IFolder folder) throws CoreException {
        if (folder == null || folder.exists()) {
            return;
        }
        IContainer parent = folder.getParent();
        if (parent.getType() == 2) {
            PICLUtils.mkDir((IFolder)parent);
        }
        folder.create(true, true, null);
    }

    public static ViewFile getViewFile(IEditorInput input) {
        if (input instanceof EngineSuppliedViewEditorInput) {
            return ((EngineSuppliedViewEditorInput)input).getViewFile();
        }
        if (input instanceof IFileEditorInput) {
            IFile file = ((IFileEditorInput)input).getFile();
            try {
                return (ViewFile)file.getSessionProperty(ViewFile.VIEWFILE_KEY);
            }
            catch (CoreException coreException) {
            }
        } else if (input instanceof PDTSourceNotFoundEditorInput) {
            return ((PDTSourceNotFoundEditorInput)input).getViewFile();
        }
        return null;
    }

    public static void resetEditor(Object artifact, IWorkbenchPage page, int lineNumber) {
        if (artifact == null) {
            return;
        }
        if (artifact instanceof StackFrame) {
            ((StackFrame)artifact).fireChangeEvent(512);
        } else if (page != null) {
            ISourceLocator sourceLocator = null;
            if (artifact instanceof PICLBreakpoint) {
                sourceLocator = ((PICLBreakpoint)artifact).getDebugTarget().getLaunch().getSourceLocator();
            }
            SourceLookupResult lookupResult = SourceLookupFacility.getDefault().lookup(artifact, sourceLocator, true);
            DebugUITools.displaySource((ISourceLookupResult)lookupResult, (IWorkbenchPage)page);
            IEditorPart editorPart = page.getActiveEditor();
            page.activate((IWorkbenchPart)editorPart);
            IEditorInput input = editorPart.getEditorInput();
            PICLUtils.resetViewFile(input, artifact);
            PICLUtils.positionEditor(page, lineNumber);
        }
    }

    public static void resetViewFile(IEditorInput input, Object artifact) {
        ViewFile viewfile;
        ViewFile viewFile = viewfile = artifact instanceof IDebugLocationProvider ? (viewfile = ((IDebugLocationProvider)artifact).getViewFile()) : null;
        if (viewfile != null && input instanceof IFileEditorInput) {
            IFile file = ((IFileEditorInput)input).getFile();
            try {
                file.setSessionProperty(ViewFile.VIEWFILE_KEY, (Object)viewfile);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
    }

    public static void positionEditor(IWorkbenchPage page, int lineNumber) {
        if (lineNumber < 1) {
            return;
        }
        IEditorPart editorPart = page.getActiveEditor();
        if (editorPart instanceof ITextEditor) {
            ITextEditor editor = (ITextEditor)editorPart;
            IEditorInput editorInput = editor.getEditorInput();
            IDocument document = editor.getDocumentProvider().getDocument((Object)editorInput);
            try {
                if (editor instanceof DebuggerEditor) {
                    ((DebuggerEditor)editor).gotoLine(lineNumber, true);
                } else {
                    IRegion region = document.getLineInformation(lineNumber - 1);
                    editor.selectAndReveal(region.getOffset(), region.getLength());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static int getLineNumber(IEditorPart editor) {
        int lineNumber = 0;
        if (editor instanceof ITextEditor) {
            final ISelectionProvider selProvider = ((ITextEditor)editor).getSelectionProvider();
            final ITextSelection[] selectionParm = new ITextSelection[1];
            if (selProvider != null) {
                Display display = PlatformUI.getWorkbench().getDisplay();
                display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        selectionParm[0] = (ITextSelection)selProvider.getSelection();
                    }
                });
                if (selectionParm[0] != null) {
                    lineNumber = selectionParm[0].getStartLine() + 1;
                    return PICLUtils.getRealLineNumber(editor.getEditorInput(), lineNumber);
                }
            }
        } else {
            StackFrame stackFrame = PICLDebugPlugin.getCurrentStackFrame();
            if (stackFrame != null) {
                try {
                    return stackFrame.getLineNumber();
                }
                catch (DebugException debugException) {
                    // empty catch block
                }
            }
        }
        return lineNumber;
    }

    public static int getRealLineNumber(IEditorInput ei, int lineNum) {
        if (ei instanceof EngineSuppliedViewEditorInput) {
            return ((EngineSuppliedViewEditorInput)ei).getRealLineNumber(lineNum);
        }
        return lineNum;
    }

    public static int getBufferedLineNumber(IEditorInput ei, int lineNum) {
        if (ei instanceof EngineSuppliedViewEditorInput) {
            return ((EngineSuppliedViewEditorInput)ei).getBufferedLineNumber(lineNum);
        }
        return lineNum;
    }

    public static void addCredentialToSecureStorage(ISecurePreferences securePreferences, String hostIP, String userID, char[] pwd) {
        ISecurePreferences thisNode = null;
        if (securePreferences.nodeExists(hostIP)) {
            thisNode = securePreferences.node(hostIP);
            thisNode.removeNode();
        }
        thisNode = securePreferences.node(hostIP);
        try {
            thisNode.put(USER_ID, userID, true);
            thisNode.put(PASSWORD, String.valueOf(pwd), true);
        }
        catch (StorageException e) {
            PICLUtils.logError((Exception)((Object)e));
        }
    }

    public static void removeCredentialFromSecureStorage(ISecurePreferences securePreferences, String hostIP) {
        if (securePreferences.nodeExists(hostIP)) {
            ISecurePreferences thisNode = securePreferences.node(hostIP);
            thisNode.removeNode();
        }
    }

    public static String getUserIDFromSecureStorage(ISecurePreferences securePreferences) {
        String result = null;
        try {
            result = securePreferences.get(USER_ID, EMPTY_STRING);
        }
        catch (StorageException e) {
            PICLUtils.logError((Exception)((Object)e));
        }
        return result;
    }

    public static char[] getPasswordFromSecureStorage(ISecurePreferences securePreferences) {
        try {
            return securePreferences.get(PASSWORD, EMPTY_STRING).toCharArray();
        }
        catch (StorageException e) {
            PICLUtils.logError((Exception)((Object)e));
            return null;
        }
    }

    public static String getAddrOrExprFromActiveEditor() {
        IdentifierParser parser;
        int eolpos;
        String adrTxt;
        ITextSelection txtSel;
        ITextEditor editor;
        try {
            editor = PICLDebugPlugin.getActiveTextEditor();
            txtSel = (ITextSelection)editor.getSelectionProvider().getSelection();
            adrTxt = txtSel.getText();
        }
        catch (NullPointerException npe) {
            return null;
        }
        if (!PDTCoreUtils.isEmpty((String)adrTxt) && (eolpos = (adrTxt = adrTxt.trim()).indexOf(10)) > 0) {
            adrTxt = adrTxt.substring(0, eolpos);
        }
        ITextViewer viewer = (ITextViewer)editor.getAdapter(ITextOperationTarget.class);
        IEditorInput ei = editor.getEditorInput();
        short viewInfoID = 2;
        if (ei instanceof EngineSuppliedViewEditorInput) {
            EngineSuppliedViewEditorInput eei = (EngineSuppliedViewEditorInput)ei;
            viewInfoID = eei.getViewInformation().getKind();
        }
        ViewFile viewFile = PICLDebugPlugin.getViewFile(editor);
        try {
            parser = viewFile.getPart().getLanguage().getIdentifierParser();
            parser.setViewInfoID(viewInfoID);
        }
        catch (NullPointerException npe) {
            return adrTxt;
        }
        if (PDTCoreUtils.isEmpty((String)adrTxt)) {
            int[] posns;
            String line;
            block14: {
                block13: {
                    int offset = txtSel.getOffset();
                    IDocument doc = viewer.getDocument();
                    try {
                        IRegion lineRegion = doc.getLineInformationOfOffset(offset);
                        line = doc.get(lineRegion.getOffset(), lineRegion.getLength());
                        posns = parser.identifierInString(line, offset - lineRegion.getOffset());
                        if (posns != null && posns.length >= 2) break block13;
                        return EMPTY_STRING;
                    }
                    catch (BadLocationException e) {
                        return EMPTY_STRING;
                    }
                }
                if (posns[0] != -1 && posns[1] != -1) break block14;
                return EMPTY_STRING;
            }
            adrTxt = line.substring(posns[0], posns[1] + 1);
        }
        if (parser.isTokenProcessingRequired() && editor instanceof LpexAbstractTextEditor) {
            if (ei instanceof EngineSuppliedViewEditorInput) {
                int prefixLength = ((EngineSuppliedViewEditorInput)ei).getPrefixLength();
                parser.setPrefixLength(prefixLength);
            }
            LpexView lpexView = ((LpexAbstractTextEditor)editor).getLpexView();
            LpexDocumentLocation cursorLoc = lpexView.documentLocation();
            String lineText = lpexView.elementText(cursorLoc.element);
            adrTxt = parser.doLanguageSpecifics(adrTxt, lineText, cursorLoc.position - 1);
        }
        return adrTxt;
    }

    private static int getViewFileLineNumber() {
        ITextEditor editor = PICLDebugPlugin.getActiveTextEditor();
        if (editor != null && editor.getEditorInput() instanceof EngineSuppliedViewEditorInput) {
            return ((DebuggerEditor)editor).getCurrentExecutionPointLineNumber();
        }
        return 0;
    }

    public static EStdView getEStdViewForActiveEditor(PDTDebugTarget fDebugTarget) {
        ViewFile vf = PICLDebugPlugin.getViewFile(PICLDebugPlugin.getActiveTextEditor());
        Location loc = null;
        if (vf != null) {
            loc = new Location(vf, PICLUtils.getViewFileLineNumber());
        }
        if (loc == null) {
            DebuggeeThread stopper = fDebugTarget.getStoppingThread();
            loc = stopper.getLocation();
        }
        return loc == null ? null : loc.getEStdView();
    }

    public static String getPreferencePageXML(ILaunchConfiguration launchConfig) throws CoreException {
        return launchConfig.getAttribute("com.ibm.debug.pdt.event_prefPage_XML", null);
    }
}

