/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui;

import com.ibm.debug.pdt.internal.core.PDTDebugTarget;
import com.ibm.debug.pdt.internal.core.model.DebuggeeThread;
import com.ibm.debug.pdt.internal.core.model.EngineRequestException;
import com.ibm.debug.pdt.internal.core.model.GlobalVariable;
import com.ibm.debug.pdt.internal.core.model.Location;
import com.ibm.debug.pdt.internal.ui.dialogs.ICheckedListItem;
import org.eclipse.swt.graphics.Image;

public class GlobalVariableItem
implements ICheckedListItem {
    private GlobalVariable fGlobalVariable;
    private boolean fEnabled;
    private PDTDebugTarget fDebugTarget;

    public GlobalVariableItem(GlobalVariable globalVariable, PDTDebugTarget debugTarget) {
        this.fGlobalVariable = globalVariable;
        this.fEnabled = false;
        this.fDebugTarget = debugTarget;
    }

    @Override
    public boolean isEnabled() {
        return this.fEnabled;
    }

    @Override
    public String getLabel() {
        return this.fGlobalVariable.getName();
    }

    @Override
    public void setEnabled(boolean state) {
        this.fEnabled = state;
    }

    @Override
    public Image getImage() {
        return null;
    }

    public GlobalVariable getGlobalVariable() {
        return this.fGlobalVariable;
    }

    @Override
    public void setDefaultEnabledState() {
        this.fEnabled = false;
    }

    public void process() throws EngineRequestException {
        if (this.isEnabled()) {
            DebuggeeThread t = this.fDebugTarget.getStoppingThread();
            Location loc = t.getLocation();
            t.monitorExpression(loc, this.fGlobalVariable.getExpression());
        }
    }

    @Override
    public int compareTo(ICheckedListItem o) {
        if (o instanceof GlobalVariableItem) {
            return this.fGlobalVariable.getName().compareTo(((GlobalVariableItem)o).getGlobalVariable().getName());
        }
        return 0;
    }
}

