/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui;

import com.ibm.debug.pdt.internal.core.AbstractEditorFile;
import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.core.PICLMessages;
import com.ibm.debug.pdt.internal.core.model.ViewFile;
import com.ibm.debug.pdt.internal.core.model.ViewInformation;
import com.ibm.debug.pdt.internal.ui.PICLDebugPlugin;
import com.ibm.debug.pdt.internal.ui.PICLDebugTarget;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import com.ibm.debug.pdt.internal.ui.preferences.PreferenceUI;
import com.ibm.debug.pdt.internal.ui.util.StatusInfo;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IStorageEditorInput;

public class EngineSuppliedViewEditorInput
extends PlatformObject
implements IStorageEditorInput {
    public static final int MIN_LINES_BEFORE = 50;
    public static final int MIN_LINES_AFTER = 50;
    public static final int LINES_TO_REQUEST_BEFORE = 199;
    public static final int LINES_TO_REQUEST_AFTER = 200;
    private AbstractEditorFile fEngineSuppliedFile;
    private ViewFile fViewFile;
    private boolean fCurrentlyDisplayed;
    private int fInitialLine = 1;
    private boolean fIsDynamic;
    private int fDynamicBufferSize = -1;

    public int getInitialLine() {
        return this.fInitialLine;
    }

    public void setInitialLine(int initialLine) {
        this.fInitialLine = initialLine;
    }

    public EngineSuppliedViewEditorInput(AbstractEditorFile engineFile, ViewFile viewFile) {
        this.fViewFile = viewFile;
        this.fIsDynamic = this.fViewFile.isDynamic();
        this.fEngineSuppliedFile = engineFile;
    }

    public void setCurrentlyDisplayed(boolean value) {
        this.fCurrentlyDisplayed = value;
    }

    public boolean isCurrentlyDisplayed() {
        return this.fCurrentlyDisplayed;
    }

    public IStorage getStorage() throws CoreException {
        return this.fEngineSuppliedFile;
    }

    public Object getContext() {
        return this.fViewFile.getContext();
    }

    private void loadLinesFromViewFile(int startLine, int endLine) throws DebugException {
        if (PICLDebugPlugin.fPDT) {
            PICLUtils.logString((Object)this, String.format(".loadLinesFromViewFile(start: %d, end: %d)", startLine, endLine));
        }
        if (this.fEngineSuppliedFile.loadLines(startLine, endLine) <= 0) {
            StatusInfo status = new StatusInfo();
            status.setError(PICLMessages.EngineSuppliedViewEditorInput_ErrorLoadingContent);
            throw new DebugException((IStatus)status);
        }
        PICLDebugPlugin.getInstance().getDebuggerEditorDocumentProvider().elementAboutToChange(this.fEngineSuppliedFile);
        PICLDebugPlugin.getInstance().getDebuggerEditorDocumentProvider().elementChanged(this.fEngineSuppliedFile);
    }

    public void ensureRange(int currentLine) throws DebugException {
        if (currentLine < this.getFileStartLine() || currentLine > this.getFileEndLine()) {
            currentLine = this.getFileStartLine();
        }
        if (this.fIsDynamic) {
            int startLine = 0;
            int endLine = 0;
            if (this.fDynamicBufferSize > 0) {
                startLine = Math.max(currentLine - this.fDynamicBufferSize, this.getFileStartLine());
                endLine = Math.min(currentLine + this.fDynamicBufferSize, this.getFileEndLine());
            } else {
                startLine = Math.max(currentLine - 199, this.getFileStartLine());
                endLine = Math.min(currentLine + 200, this.getFileEndLine());
            }
            this.loadLinesFromViewFile(startLine, endLine);
        } else {
            int endLine;
            int startLine;
            int linesBefore = Math.max(currentLine - 50, this.getFileStartLine());
            int linesAfter = Math.min(currentLine + 50, this.getFileEndLine());
            if (linesBefore >= this.getBufferStartLine() && linesAfter <= this.getBufferEndLine()) {
                return;
            }
            if (PreferenceUI.isLoadEntireFile() && this.getViewFile().isSourceView()) {
                startLine = this.getFileStartLine();
                endLine = this.getFileEndLine();
            } else {
                startLine = Math.max(currentLine - 199, this.getFileStartLine());
                endLine = Math.min(currentLine + 200, this.getFileEndLine());
            }
            this.loadLinesFromViewFile(startLine, endLine);
        }
    }

    public void loadEntireFile() throws DebugException {
        this.loadLinesFromViewFile(this.getFileStartLine(), this.getFileEndLine());
    }

    public boolean exists() {
        return false;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getName() {
        if (this.fEngineSuppliedFile == null) {
            return PICLLabels.EngineSuppliedView_labelUnknown;
        }
        return this.fEngineSuppliedFile.getName();
    }

    public int getBufferStartLine() {
        return this.fEngineSuppliedFile.getBufferStartLine();
    }

    public int getBufferEndLine() {
        return this.fEngineSuppliedFile.getBufferEndLine();
    }

    public int getFileStartLine() {
        return this.fEngineSuppliedFile.getFileStartLine();
    }

    public int getFileEndLine() {
        return this.fEngineSuppliedFile.getFileEndLine();
    }

    public String getToolTipText() {
        if (this.fEngineSuppliedFile == null) {
            return PICLLabels.EngineSuppliedView_labelUnknown;
        }
        return this.fEngineSuppliedFile.getFullPathName();
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IProject.class) {
            return this.getResource();
        }
        if (adapter == IResource.class) {
            return this.getResource();
        }
        return super.getAdapter(adapter);
    }

    public boolean isLineExecutable(int bufferedLineNumber) {
        return this.fEngineSuppliedFile.isLineExecutable(bufferedLineNumber);
    }

    public IResource getResource() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public int getPrefixLength() {
        if (this.fViewFile != null) {
            return this.fViewFile.getPrefixLength() + 2;
        }
        return 0;
    }

    public ViewFile getViewFile() {
        return this.fViewFile;
    }

    public ViewInformation getViewInformation() {
        if (this.fViewFile != null) {
            return this.fViewFile.getView().getViewInformation();
        }
        return null;
    }

    public boolean supportsFileSwitch() {
        return this.fViewFile != null && this.fViewFile.canFileNameBeOverridden();
    }

    public PICLDebugTarget getPICLDebugTarget() {
        return PICLDebugPlugin.getPICLDebugTarget((IDebugElement)this.fViewFile);
    }

    public boolean equals(Object o) {
        if (o instanceof EngineSuppliedViewEditorInput) {
            try {
                return this.getStorage().equals(((EngineSuppliedViewEditorInput)((Object)o)).getStorage());
            }
            catch (CoreException e) {
                return false;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.fViewFile.hashCode();
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    int getRealLineNumber(int bufferedLineNumber) {
        return bufferedLineNumber + (this.getBufferStartLine() - this.getFileStartLine());
    }

    int getBufferedLineNumber(int realLineNumber) {
        return realLineNumber - (this.getBufferStartLine() - this.getFileStartLine());
    }

    public void setDynamicBufferSize(int size) {
        this.fDynamicBufferSize = 100 + size;
    }
}

