/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.ui.profile.internal.view;

import com.ibm.debug.pdt.internal.ui.PICLDebugPlugin;
import com.ibm.debug.pdt.profile.internal.ProfileMessages;
import com.ibm.debug.pdt.profile.internal.cc.CodeCoverageUtils;
import com.ibm.debug.pdt.profile.internal.connection.Connection;
import com.ibm.debug.pdt.profile.internal.model.DebugProfile;
import com.ibm.debug.pdt.profile.internal.model.DebugProfileRoot;
import com.ibm.debug.pdt.profile.internal.model.IDebugProfileConstants;
import com.ibm.debug.pdt.ui.profile.internal.Activator;
import com.ibm.debug.pdt.ui.profile.internal.ProfileLabels;
import com.ibm.debug.pdt.ui.profile.internal.ProfileUtils;
import com.ibm.debug.pdt.ui.profile.internal.editor.ProfileEditorInput;
import com.ibm.debug.pdt.ui.profile.internal.extensions.DebugProfileRSEUtils;
import com.ibm.debug.pdt.ui.profile.internal.extensions.RSEEventListener;
import com.ibm.debug.pdt.ui.profile.internal.migration.DebugProfileMigrationUtils;
import com.ibm.debug.pdt.ui.profile.internal.migration.IDebugProfileMigrationListener;
import com.ibm.debug.pdt.ui.profile.internal.view.DebugProfileConnectionLabelDecorator;
import com.ibm.debug.pdt.ui.profile.internal.view.DebugProfileContentProvider;
import com.ibm.debug.pdt.ui.profile.internal.view.DebugProfileLabelDecorator;
import com.ibm.debug.pdt.ui.profile.internal.view.DebugProfileLabelProvider;
import com.ibm.debug.pdt.ui.profile.internal.view.DebugProfileLocationDecorator;
import com.ibm.debug.pdt.ui.profile.internal.view.DebugProfileTableComparator;
import com.ibm.debug.pdt.ui.profile.internal.view.DebugProfileViewToolTipSupport;
import com.ibm.debug.pdt.ui.profile.internal.view.FilterLabelProvider;
import com.ibm.debug.pdt.ui.profile.internal.view.ProfileModeEditingSupport;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.ui.AbstractDebugView;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.util.ConfigureColumns;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DecoratingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jface.wizard.ProgressMonitorPart;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.part.PageBook;

public class DebugProfileView
extends AbstractDebugView
implements IDoubleClickListener,
IDebugProfileConstants {
    private static final String HIDE_WELCOME_VIEW_SETTING = "HIDE_WELCOME";
    private static final String VIEW_CONTEXT_ID = "com.ibm.debug.pdt.ui.profile.eclipse.context.profileView";
    private static final String COLUMN_ORDER_PREFIX = "COLUMN_ORDER_";
    private static final String COLUMN_WIDTH_PREFIX = "COLUMN_WIDTH_";
    protected TreeViewer fTreeViewer;
    static final int COLUMN_NAME = 0;
    static final int COLUMN_STATE = 1;
    static final int COLUMN_MODE = 2;
    static final int COLUMN_LOCATION = 3;
    static final int COLUMN_CONNECTION = 4;
    static final int COLUMN_DESCRIPTION = 5;
    static final int COLUMN_LOADMOD_CU = 6;
    static final int COLUMN_TRANSACTION = 7;
    static final int COLUMN_USERID = 8;
    static final int COLUMN_SYSID = 9;
    static final int COLUMN_NET_NAME = 10;
    static final int COLUMN_IP = 11;
    static final int COLUMN_TERM_ID = 12;
    static final int COLUMN_JOBNAME = 13;
    static final int COLUMN_STEPNAME = 14;
    static final int COLUMN_IMS_ID = 15;
    static final int NUM_COLUMNS = 16;
    private static IContextActivation fContext;
    private DebugProfileRoot.DebugProfileEventListener fEventListener = new DebugProfileRoot.DebugProfileEventListener(){

        public void handleEvent(DebugProfile source, int eventType) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (!(this).DebugProfileView.this.fTreeViewer.getTree().isDisposed() && (this).DebugProfileView.this.fTreeViewer.getTree().getParent().isVisible() && !(this).DebugProfileView.this.fTreeViewer.isBusy()) {
                            (this).DebugProfileView.this.fTreeViewer.refresh();
                        }
                    }
                    catch (Exception e) {
                        Activator.log(e);
                    }
                }
            });
        }
    };
    private RSEEventListener fRSEEventListener = new RSEEventListener(){

        @Override
        public void handleEvent(Connection source, int eventType, String oldName) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!(this).DebugProfileView.this.fTreeViewer.getTree().isDisposed() && (this).DebugProfileView.this.fTreeViewer.getTree().getParent().isVisible() && !(this).DebugProfileView.this.fTreeViewer.isBusy()) {
                        (this).DebugProfileView.this.fTreeViewer.refresh();
                    }
                }
            });
        }
    };
    private DebugProfileViewToolTipSupport fTooltipSupport;
    private IPartListener2 fPartListener = new IPartListener2(){

        public void partVisible(IWorkbenchPartReference partRef) {
        }

        public void partOpened(IWorkbenchPartReference partRef) {
        }

        public void partInputChanged(IWorkbenchPartReference partRef) {
        }

        public void partHidden(IWorkbenchPartReference partRef) {
            if (partRef.getId().equals("com.ibm.debug.pdt.ui.profile.view.DebugProfileView")) {
                DebugProfileView.this.disableContext();
            }
        }

        public void partDeactivated(IWorkbenchPartReference partRef) {
            if (partRef.getId().equals("com.ibm.debug.pdt.ui.profile.view.DebugProfileView")) {
                DebugProfileView.this.disableContext();
            }
        }

        public void partClosed(IWorkbenchPartReference partRef) {
            if (partRef.getId().equals("com.ibm.debug.pdt.ui.profile.view.DebugProfileView")) {
                DebugProfileView.this.disableContext();
            }
        }

        public void partBroughtToTop(IWorkbenchPartReference partRef) {
        }

        public void partActivated(IWorkbenchPartReference partRef) {
        }
    };

    protected void configureToolBar(IToolBarManager tbm) {
    }

    protected void createActions() {
    }

    protected Viewer createViewer(Composite parent) {
        GridLayoutFactory.fillDefaults().applyTo(parent);
        Composite treeParent = parent;
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)treeParent);
        TreeColumnLayout layout = new TreeColumnLayout(false);
        PatternFilter pattern = new PatternFilter();
        pattern.setIncludeLeadingWildcard(true);
        FilteredTree filteredTree = new FilteredTree(treeParent, 66306, pattern, true, false);
        this.fTreeViewer = filteredTree.getViewer();
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)new FilterLabelProvider(this.fTreeViewer));
        Tree tree = this.fTreeViewer.getTree();
        parent.setBackground(tree.getBackground());
        tree.getParent().setLayout((Layout)layout);
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        this.fTreeViewer.setComparator((ViewerComparator)new DebugProfileTableComparator());
        this.createColumn(0, CodeCoverageUtils.isCodeCoverageClient() ? 22 : 24, 250, ProfileLabels.profile_table_column_name, filteredTree, layout, new DebugProfileLabelDecorator(), false);
        this.createColumn(1, CodeCoverageUtils.isCodeCoverageClient() ? 9 : 10, 100, ProfileLabels.profile_table_column_state, filteredTree, layout, null, false);
        this.createColumn(2, CodeCoverageUtils.isCodeCoverageClient() ? 9 : 0, CodeCoverageUtils.isCodeCoverageClient() ? 100 : 0, ProfileLabels.profile_table_column_mode, filteredTree, layout, null, true);
        this.createColumn(3, CodeCoverageUtils.isCodeCoverageClient() ? 17 : 19, 200, ProfileLabels.profile_table_column_location, filteredTree, layout, new DebugProfileLocationDecorator(), false);
        this.createColumn(4, CodeCoverageUtils.isCodeCoverageClient() ? 17 : 19, 200, ProfileLabels.profile_table_column_connection, filteredTree, layout, new DebugProfileConnectionLabelDecorator(), false);
        this.createColumn(5, CodeCoverageUtils.isCodeCoverageClient() ? 26 : 28, 300, ProfileLabels.profile_table_column_description, filteredTree, layout, null, false);
        this.createColumn(6, 0, 0, ProfileLabels.profile_table_column_loadmod_cu, filteredTree, layout, null, false);
        this.createColumn(7, 0, 0, ProfileLabels.profile_table_column_transaction, filteredTree, layout, null, false);
        this.createColumn(8, 0, 0, ProfileLabels.profile_table_column_user_id, filteredTree, layout, null, false);
        this.createColumn(9, 0, 0, ProfileLabels.profile_table_column_sys_id, filteredTree, layout, null, false);
        this.createColumn(10, 0, 0, ProfileLabels.profile_table_column_net_name, filteredTree, layout, null, false);
        this.createColumn(11, 0, 0, ProfileLabels.profile_table_column_ip, filteredTree, layout, null, false);
        this.createColumn(12, 0, 0, ProfileLabels.profile_table_column_terminal_id, filteredTree, layout, null, false);
        this.createColumn(13, 0, 0, ProfileLabels.profile_table_column_job_name, filteredTree, layout, null, false);
        this.createColumn(14, 0, 0, ProfileLabels.profile_table_column_step_name, filteredTree, layout, null, false);
        this.createColumn(15, 0, 0, ProfileLabels.profile_table_column_IMS_subsystem, filteredTree, layout, null, false);
        this.setupColumns();
        this.fTreeViewer.setContentProvider((IContentProvider)new DebugProfileContentProvider());
        this.getSite().setSelectionProvider((ISelectionProvider)this.fTreeViewer);
        this.fTreeViewer.addDoubleClickListener((IDoubleClickListener)this);
        this.fTreeViewer.setInput((Object)DebugProfileRoot.getInstance());
        this.fTreeViewer.getTree().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                DebugProfileView.this.saveColumns();
            }
        });
        DebugProfileRoot.getInstance().addProfileEventListener(this.fEventListener);
        this.getSite().getPage().addPartListener(this.fPartListener);
        new DebugProfileViewToolTipSupport((ColumnViewer)this.fTreeViewer, false);
        DebugProfileRSEUtils.getInstance().addRSEEventListener(this.fRSEEventListener);
        this.fTreeViewer.refresh(true);
        return this.fTreeViewer;
    }

    private void createColumn(int columnIdx, int widthPixels, int widthPercent, String columnName, FilteredTree filteredTree, TreeColumnLayout layout, ILabelDecorator labelDecorator, boolean addEditingSupport) {
        TreeViewerColumn column = new TreeViewerColumn(this.fTreeViewer, 0, columnIdx);
        layout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnWeightData(widthPercent, widthPixels, true));
        column.getColumn().setText(columnName);
        column.getColumn().setMoveable(true);
        Object labelProvider = labelDecorator != null ? new DecoratingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new DebugProfileLabelProvider(columnIdx, filteredTree), labelDecorator, null) : new DebugProfileLabelProvider(columnIdx, filteredTree);
        column.setLabelProvider((CellLabelProvider)labelProvider);
        column.getColumn().addSelectionListener(this.getColumnSelectionListener(column.getColumn(), columnIdx, (CellLabelProvider)labelProvider));
        if (addEditingSupport) {
            column.setEditingSupport((EditingSupport)new ProfileModeEditingSupport((ColumnViewer)this.fTreeViewer));
        }
        if (columnIdx == 0) {
            DebugProfileTableComparator c = (DebugProfileTableComparator)this.fTreeViewer.getComparator();
            c.setDefaultLabelProvider((CellLabelProvider)labelProvider);
        }
    }

    protected SelectionListener getColumnSelectionListener(final TreeColumn column, final int columnIdx, final CellLabelProvider labelProvider) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (DebugProfileView.this.fTreeViewer != null) {
                    DebugProfileTableComparator c = (DebugProfileTableComparator)DebugProfileView.this.fTreeViewer.getComparator();
                    c.setColumn(columnIdx, labelProvider);
                    column.getParent().setSortColumn(column);
                    column.getParent().setSortDirection(c.getSortDirection());
                    DebugProfileView.this.fTreeViewer.refresh();
                    super.widgetSelected(e);
                }
            }
        };
    }

    protected String getHelpContextId() {
        return "com.ibm.debug.pdt.ui.profile.eclipse.profile_view";
    }

    public void doubleClick(DoubleClickEvent event) {
        ISelection selection = event.getSelection();
        if (selection instanceof StructuredSelection) {
            StructuredSelection ss = (StructuredSelection)selection;
            for (Object item : ss) {
                if (!(item instanceof DebugProfile)) continue;
                this.openEditorOnDebugProfile((DebugProfile)item);
            }
        }
    }

    private void openEditorOnDebugProfile(DebugProfile profile) {
        IWorkbenchPage activePage = ProfileUtils.getActiveWorkbenchPage();
        if (activePage == null) {
            return;
        }
        IEditorReference editorRef = ProfileUtils.findOpenedEditorForProfile(profile);
        if (editorRef != null) {
            activePage.activate((IWorkbenchPart)editorRef.getEditor(true));
        } else {
            ProfileEditorInput input = new ProfileEditorInput(profile);
            try {
                activePage.openEditor((IEditorInput)input, "com.ibm.debug.pdt.idz.launches.common.profile.editor.DebugProfileEditor");
            }
            catch (PartInitException ex) {
                Activator.log(ex);
            }
        }
    }

    public void dispose() {
        super.dispose();
        DebugProfileRoot.getInstance().removeProfileEventListener(this.fEventListener);
        DebugProfileRSEUtils.getInstance().removeRSEEventListener(this.fRSEEventListener);
        this.fTooltipSupport = null;
        this.getSite().getPage().removePartListener(this.fPartListener);
        this.disableContext();
    }

    private void enableContext() {
        if (fContext == null && !DebugProfileView.isWelcomeVisible()) {
            IContextService contextService = (IContextService)PlatformUI.getWorkbench().getService(IContextService.class);
            fContext = contextService.activateContext(VIEW_CONTEXT_ID);
        }
    }

    protected IPage createDefaultPage(PageBook book) {
        ProfileViewPage page = new ProfileViewPage();
        page.createControl((Composite)book);
        this.initPage((IPageBookViewPage)page);
        return page;
    }

    private static IDialogSettings getViewSettings() {
        IDialogSettings result = Activator.getDefault().getDialogSettings().getSection("com.ibm.debug.pdt.ui.profile.view.DebugProfileView");
        if (result == null) {
            result = Activator.getDefault().getDialogSettings().addNewSection("com.ibm.debug.pdt.ui.profile.view.DebugProfileView");
        }
        return result;
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        GridDataFactory.fillDefaults().hint(0, 0).applyTo(this.getMessagePage().getControl());
    }

    protected void fillContextMenu(IMenuManager menu) {
    }

    public static boolean isWelcomeVisible() {
        return !DebugProfileView.getViewSettings().getBoolean(HIDE_WELCOME_VIEW_SETTING);
    }

    public DebugProfileViewToolTipSupport getTooltipSupport() {
        if (this.fTooltipSupport == null) {
            this.fTooltipSupport = new DebugProfileViewToolTipSupport((ColumnViewer)this.getViewer(), true);
        }
        return this.fTooltipSupport;
    }

    private void disableContext() {
        if (fContext != null) {
            IContextService contextService = (IContextService)PlatformUI.getWorkbench().getService(IContextService.class);
            contextService.deactivateContext(fContext);
            fContext = null;
        }
    }

    public void showConfigureColumnsDialog() {
        if (ConfigureColumns.forTree((Tree)this.fTreeViewer.getTree(), (IShellProvider)new IShellProvider(){

            public Shell getShell() {
                return DebugProfileView.this.fTreeViewer.getTree().getShell();
            }
        })) {
            this.saveColumns();
            this.fTreeViewer.refresh(true);
        }
    }

    private void saveColumns() {
        int[] columnOrder = this.fTreeViewer.getTree().getColumnOrder();
        int i = 0;
        while (i < columnOrder.length) {
            DebugProfileView.getViewSettings().put(COLUMN_ORDER_PREFIX + i, columnOrder[i]);
            DebugProfileView.getViewSettings().put(COLUMN_WIDTH_PREFIX + i, this.fTreeViewer.getTree().getColumn(i).getWidth());
            ++i;
        }
    }

    private void setupColumns() {
        int numColumns = this.fTreeViewer.getTree().getColumnCount();
        int i = 0;
        while (i < numColumns) {
            try {
                int width = DebugProfileView.getViewSettings().getInt(COLUMN_WIDTH_PREFIX + i);
                this.fTreeViewer.getTree().getColumn(i).setWidth(width);
            }
            catch (NumberFormatException width) {
                // empty catch block
            }
            ++i;
        }
        int[] orderList = new int[16];
        int i2 = 0;
        while (i2 < orderList.length) {
            try {
                orderList[i2] = DebugProfileView.getViewSettings().getInt(COLUMN_ORDER_PREFIX + i2);
            }
            catch (NumberFormatException e) {
                orderList[i2] = i2;
            }
            ++i2;
        }
        this.fTreeViewer.getTree().setColumnOrder(orderList);
    }

    public void setFocus() {
        super.setFocus();
        this.enableContext();
    }

    class ProfileViewPage
    extends Page
    implements IDebugProfileMigrationListener {
        Composite fMain;
        private Label fMigrationMessage;
        private ProgressMonitorPart fMigrationProgressMonitor;
        private Label fMigrationMessage2;

        ProfileViewPage() {
        }

        public void createControl(final Composite parent) {
            boolean showWelcome = !DebugProfileView.getViewSettings().getBoolean(DebugProfileView.HIDE_WELCOME_VIEW_SETTING);
            GridLayoutFactory.fillDefaults().margins(0, 0).spacing(0, 0).applyTo(parent);
            GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)parent);
            this.fMain = new Composite(parent, 0);
            GridLayoutFactory.fillDefaults().margins(0, 0).spacing(0, 0).applyTo(this.fMain);
            GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.fMain);
            final Composite viewerComposite = new Composite(this.fMain, 0);
            GridLayoutFactory.fillDefaults().margins(0, 0).spacing(0, 0).applyTo(viewerComposite);
            Viewer viewer = DebugProfileView.this.createViewer(viewerComposite);
            DebugProfileView.this.setViewer(viewer);
            int width = -1;
            if (showWelcome) {
                viewerComposite.setVisible(false);
                GridDataFactory.fillDefaults().hint(0, 0).applyTo((Control)viewerComposite);
                final ScrolledComposite welcomeParent = new ScrolledComposite(this.fMain, 768);
                GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)welcomeParent);
                GridLayoutFactory.fillDefaults().applyTo((Composite)welcomeParent);
                welcomeParent.setExpandHorizontal(true);
                welcomeParent.setExpandVertical(true);
                Composite welcome = new Composite((Composite)welcomeParent, 0);
                welcome.setBackground(Display.getCurrent().getSystemColor(25));
                GridLayoutFactory.swtDefaults().applyTo(welcome);
                GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)welcome);
                Label l = new Label(welcome, 64);
                l.setBackground(Display.getCurrent().getSystemColor(25));
                l.setText(ProfileLabels.WELCOME);
                GridDataFactory.fillDefaults().hint(-1, -1).grab(true, false).applyTo((Control)l);
                l = new Label(welcome, 64);
                l.setBackground(Display.getCurrent().getSystemColor(25));
                l.setText(ProfileLabels.WELCOME_1.trim() + " " + ProfileLabels.WELCOME_2.trim() + " " + ProfileLabels.WELCOME_3);
                GridDataFactory.fillDefaults().hint(width, -1).grab(true, false).applyTo((Control)l);
                if (DebugProfileMigrationUtils.getNumberOfProfilesToMigrate() > 0) {
                    this.fMigrationProgressMonitor = new ProgressMonitorPart(welcome, null, 10);
                    this.fMigrationProgressMonitor.setBackground(Display.getCurrent().getSystemColor(25));
                    GridDataFactory.fillDefaults().hint(width, -1).grab(true, false).applyTo((Control)this.fMigrationProgressMonitor);
                    this.fMigrationProgressMonitor.setVisible(true);
                    this.fMigrationMessage = new Label(welcome, 64);
                    this.fMigrationMessage.setBackground(Display.getCurrent().getSystemColor(25));
                    GridDataFactory.fillDefaults().hint(width, 0).grab(true, false).applyTo((Control)this.fMigrationMessage);
                    this.fMigrationMessage.setVisible(false);
                    DebugProfileMigrationUtils.migrate((IProgressMonitor)this.fMigrationProgressMonitor, this);
                    this.fMigrationMessage2 = new Label(welcome, 64);
                    this.fMigrationMessage2.setText(ProfileLabels.POST_MIGRATE_INFO);
                    this.fMigrationMessage2.setBackground(Display.getCurrent().getSystemColor(25));
                    GridDataFactory.fillDefaults().hint(0, 0).grab(true, false).applyTo((Control)this.fMigrationMessage2);
                }
                Link link = new Link(welcome, 64);
                link.setText(ProfileLabels.WELCOME_LINK);
                link.setBackground(Display.getCurrent().getSystemColor(25));
                GridDataFactory.fillDefaults().hint(width, -1).grab(true, false).applyTo((Control)link);
                link.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent arg0) {
                        welcomeParent.dispose();
                        viewerComposite.setVisible(true);
                        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)viewerComposite);
                        ProfileViewPage.this.fMain.layout(true, true);
                        DebugProfileView.getViewSettings().put(DebugProfileView.HIDE_WELCOME_VIEW_SETTING, true);
                        DebugProfileView.this.enableContext();
                    }

                    public void widgetDefaultSelected(SelectionEvent arg0) {
                    }
                });
                welcomeParent.setContent((Control)welcome);
                welcomeParent.setMinSize(welcome.computeSize(750, -1));
            } else {
                final int phase2Profiles = DebugProfileMigrationUtils.getNumberOfIMSIsolationProfilesToMigrate();
                if (phase2Profiles > 0) {
                    final int successful = DebugProfileMigrationUtils.doIMSIsolationMigration();
                    FocusListener listener = new FocusListener(){

                        public void focusGained(FocusEvent arg0) {
                            String message = null;
                            int messageType = 0;
                            if (successful != phase2Profiles) {
                                messageType = 2;
                                message = NLS.bind((String)ProfileMessages.CRRDG9163, (Object)successful);
                            } else {
                                messageType = 1;
                                message = NLS.bind((String)ProfileMessages.CRRDG9164, (Object)(phase2Profiles - successful));
                            }
                            PICLDebugPlugin.showMessageDialog((Shell)parent.getShell(), (int)messageType, (String)ProfileLabels.MIGRATE_TITLE, (String)message, (boolean)false);
                            parent.removeFocusListener((FocusListener)this);
                        }

                        public void focusLost(FocusEvent arg0) {
                        }
                    };
                    parent.addFocusListener(listener);
                }
                GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)viewerComposite);
                this.fMain.layout(true, true);
            }
        }

        public Control getControl() {
            return this.fMain;
        }

        public void setFocus() {
            Control c;
            Viewer viewer = DebugProfileView.this.getViewer();
            if (viewer != null && !(c = viewer.getControl()).isFocusControl()) {
                c.setFocus();
            }
        }

        @Override
        public void migrationComplete(final int numProfiles, final int numSuccessful) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    if (ProfileViewPage.this.fMigrationProgressMonitor != null) {
                        ProfileViewPage.this.fMigrationProgressMonitor.dispose();
                    }
                    if (ProfileViewPage.this.fMigrationMessage != null) {
                        String message1 = NLS.bind((String)(numSuccessful == 1 ? ProfileLabels.POST_MIGRATE_SUCCESSFUL : ProfileLabels.POST_MIGRATE_MANY_SUCCESSFUL), (Object)numSuccessful);
                        String message2 = numProfiles == numSuccessful ? null : NLS.bind((String)(numProfiles - numSuccessful == 1 ? ProfileLabels.POST_MIGRATE_UNSUCCESSFUL : ProfileLabels.POST_MIGRATE_MANY_UNSUCCESSFUL), (Object)(numProfiles - numSuccessful));
                        ProfileViewPage.this.fMigrationMessage.setText(message1 + (String)(message2 == null ? "" : " " + message2));
                        GridDataFactory.fillDefaults().hint(100, -1).grab(true, false).applyTo((Control)ProfileViewPage.this.fMigrationMessage);
                        ProfileViewPage.this.fMigrationMessage.setVisible(true);
                        ProfileViewPage.this.fMigrationMessage.getParent().layout(true);
                    }
                    if (ProfileViewPage.this.fMigrationMessage2 != null) {
                        GridDataFactory.fillDefaults().hint(100, -1).grab(true, false).applyTo((Control)ProfileViewPage.this.fMigrationMessage2);
                        ProfileViewPage.this.fMigrationMessage2.setVisible(true);
                        ProfileViewPage.this.fMigrationMessage2.getParent().getParent().layout(true);
                    }
                    ((ProfileViewPage)ProfileViewPage.this).DebugProfileView.this.fTreeViewer.refresh();
                }
            });
        }
    }
}

