/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.ui.profile.internal.outline;

import com.ibm.debug.pdt.profile.internal.model.IDebugProfileConstants;
import com.ibm.debug.pdt.ui.profile.internal.Activator;
import com.ibm.debug.pdt.ui.profile.internal.ProfileLabels;
import com.ibm.debug.pdt.ui.profile.internal.editor.DebugProfileEditor;
import com.ibm.debug.pdt.ui.profile.internal.editor.IDebugProfileEditorConstants;
import com.ibm.debug.pdt.ui.profile.internal.editor.ProfileEditorInput;
import com.ibm.debug.pdt.ui.profile.internal.outline.DebugProfileOutlineContentProvider;
import com.ibm.debug.pdt.ui.profile.internal.outline.DebugProfileOutlineLabelProvider;
import com.ibm.debug.pdt.ui.profile.internal.outline.DebugProfileOutlinePage;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.forms.FormColors;

public class DebugProfileQuickOutline
extends PopupDialog
implements IDebugProfileConstants {
    private static final int STYLE = 16;
    private static final int VIEWER_STYLE = 770;
    private static final boolean TAKE_FOCUS_ON_OPEN = true;
    private static final boolean PERSIST_SIZE = true;
    private static final boolean PERSIST_LOCATION = true;
    private static final boolean SHOW_DIALOG_MENU = true;
    private static final boolean SHOW_PERSIST_ACTIONS = true;
    private static final int MAX_HEIGHT = 500;
    private static final int EXPAND_LEVEL = 2;
    private static final char REGEX_START_ANCHOR = '^';
    private static final char REGEX_END_ANCHOR = '$';
    private static final char REGEX_QUESTION_MARK = '?';
    private static final char REGEX_DOT = '.';
    private static final char REGEX_ASTERISK = '*';
    private static final char ZOS_WILD_CHAR = '*';
    private static final String REGEX_SPECIAL_STR = "$<>+{}()|!=:^[]\\";
    private DebugProfileEditor fEditor;
    private DebugProfileOutlinePage fContentOutlinePage = null;
    private Object fOutlineInput;
    private TreeViewer fViewer;
    private Text fFilterText;
    private DebugProfileOutlineContentProvider fContentProvider;
    private FormColors fBgColors;

    public DebugProfileQuickOutline(Shell parent, DebugProfileEditor debugProfileEditor) {
        super(parent, 16, true, true, true, true, true, ProfileLabels.outline_title, ProfileLabels.outline_description);
        this.fEditor = debugProfileEditor;
        this.fContentOutlinePage = this.fEditor.getContentOutlinePage();
        this.fOutlineInput = this.fContentOutlinePage.getOutlineInput();
    }

    protected Control createDialogArea(Composite parent) {
        this.fBgColors = new FormColors(parent.getDisplay());
        this.fViewer = this.createTreeViewer(parent);
        this.fViewer.setContentProvider((IContentProvider)this.fContentOutlinePage.getContentProvider());
        this.fViewer.setLabelProvider((IBaseLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new DebugProfileOutlineLabelProvider(this.fContentOutlinePage.getProfileType())));
        this.fViewer.expandToLevel(2);
        Tree tree = this.fViewer.getTree();
        tree.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                DebugProfileQuickOutline.this.fContentOutlinePage.itemSelectedAction(e);
                DebugProfileQuickOutline.this.close();
            }

            public void widgetSelected(SelectionEvent e) {
                DebugProfileQuickOutline.this.fContentOutlinePage.itemSelectedAction(e);
                DebugProfileQuickOutline.this.close();
            }
        });
        this.fViewer.addFilter(this.getFilter());
        return this.fViewer.getControl();
    }

    protected Color getBackground() {
        if (this.fBgColors != null) {
            return this.fBgColors.getBackground();
        }
        return null;
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = Activator.getDefault().getDialogSettings().getSection("com.ibm.debug.pdt.ui.profile.outline.DebugProfileQuickOutline");
        if (settings == null) {
            settings = Activator.getDefault().getDialogSettings().addNewSection("com.ibm.debug.pdt.ui.profile.outline.DebugProfileQuickOutline");
        }
        return settings;
    }

    protected Point getInitialSize() {
        Point result = super.getInitialSize();
        IDialogSettings settings = this.getDialogSettings();
        try {
            if (settings.getInt("com.ibm.debug.pdt.ui.profile.outline.DebugProfileQuickOutlineDIALOG_HEIGHT") != result.y) {
                result.y = Math.min(result.y, 500);
            }
        }
        catch (Exception e) {
            result.y = Math.min(result.y, 500);
        }
        return result;
    }

    protected Control createTitleControl(Composite parent) {
        this.fFilterText = new Text(parent, 0);
        GridData data = new GridData(768);
        data.horizontalAlignment = 4;
        data.verticalAlignment = 2;
        this.fFilterText.setLayoutData((Object)data);
        this.fFilterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                DebugProfileQuickOutline.this.fViewer.refresh();
                DebugProfileQuickOutline.this.fViewer.expandAll();
            }
        });
        return this.fFilterText;
    }

    protected Control getFocusControl() {
        return this.fFilterText;
    }

    private TreeViewer createTreeViewer(Composite parent) {
        TreeViewer treeViewer = new TreeViewer(parent, 770);
        this.fContentProvider = new DebugProfileOutlineContentProvider();
        treeViewer.setContentProvider((IContentProvider)this.fContentProvider);
        IDebugProfileEditorConstants.PROFILE_TYPE type = ((ProfileEditorInput)this.fEditor.getEditorInput()).getProfileType();
        treeViewer.setLabelProvider((IBaseLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new DebugProfileOutlineLabelProvider(type)));
        treeViewer.setInput(this.fOutlineInput);
        return treeViewer;
    }

    private ViewerFilter getFilter() {
        ViewerFilter filter = new ViewerFilter(){

            public boolean select(Viewer viewer, Object parent, Object element) {
                Object filterText = DebugProfileQuickOutline.this.fFilterText.getText();
                if (viewer instanceof TreeViewer) {
                    TreeViewer treeViewer = (TreeViewer)viewer;
                    IBaseLabelProvider labelProvider = treeViewer.getLabelProvider();
                    if (filterText != null && ((String)filterText).trim().length() > 0 && !((String)filterText).equals("*") && labelProvider instanceof DelegatingStyledCellLabelProvider) {
                        Pattern pattern;
                        Matcher matcher;
                        String label = ((DelegatingStyledCellLabelProvider)labelProvider).getStyledStringProvider().getStyledText(element).getString().toUpperCase();
                        if (((String)filterText).charAt(0) != '*') {
                            filterText = "*" + (String)filterText;
                        }
                        if (!((String)filterText).endsWith("*")) {
                            filterText = (String)filterText + "*";
                        }
                        if ((matcher = (pattern = Pattern.compile((String)(filterText = DebugProfileQuickOutline.convertSimplePattern(((String)filterText).toUpperCase())))).matcher(label)).find()) {
                            return true;
                        }
                        IContentProvider contentProvider = treeViewer.getContentProvider();
                        if (contentProvider instanceof ITreeContentProvider && ((ITreeContentProvider)contentProvider).hasChildren(element)) {
                            Object[] children;
                            Object[] objectArray = children = ((ITreeContentProvider)contentProvider).getChildren(element);
                            int n = children.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Object child = objectArray[n2];
                                if (this.select(viewer, parent, child)) {
                                    return true;
                                }
                                ++n2;
                            }
                        }
                        return false;
                    }
                }
                return true;
            }
        };
        return filter;
    }

    private static String convertSimplePattern(String patternText) {
        StringBuilder result = new StringBuilder();
        result.append('^');
        int i = 0;
        while (i < patternText.length()) {
            char c = patternText.charAt(i);
            if (c == '?') {
                result.append('.');
            } else if (c == '*') {
                result.append(".*");
            } else if (REGEX_SPECIAL_STR.indexOf(c) > -1) {
                result.append("\"\"");
                result.append(c);
            } else {
                result.append(c);
            }
            ++i;
        }
        result.append('$');
        return result.toString();
    }
}

