/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.ui.profile.internal.outline;

import com.ibm.debug.pdt.profile.internal.model.IDebugProfileConstants;
import com.ibm.debug.pdt.ui.profile.internal.editor.DebugProfileEditor;
import com.ibm.debug.pdt.ui.profile.internal.editor.IDebugProfileEditorConstants;
import com.ibm.debug.pdt.ui.profile.internal.outline.DebugProfileOutlineContentProvider;
import com.ibm.debug.pdt.ui.profile.internal.outline.DebugProfileOutlineLabelProvider;
import com.ibm.debug.pdt.ui.profile.internal.outline.DebugProfileOutlineUtils;
import java.util.List;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;

public class DebugProfileOutlinePage
extends ContentOutlinePage
implements IDebugProfileConstants {
    private Object fOutlineInput;
    IDebugProfileEditorConstants.PROFILE_TYPE fType;
    private TreeViewer fViewer;
    private DebugProfileOutlineContentProvider fContentProvider;
    private DelegatingStyledCellLabelProvider fLabelProvider;

    public DebugProfileOutlinePage(DebugProfileEditor debugProfileEditor, Object outlineInput, IDebugProfileEditorConstants.PROFILE_TYPE type) {
        this.fOutlineInput = outlineInput;
        this.fType = type;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.fViewer = this.getTreeViewer();
        this.fViewer.setContentProvider((IContentProvider)this.getContentProvider());
        this.fViewer.setLabelProvider((IBaseLabelProvider)this.getLabelProvider());
        this.fViewer.setAutoExpandLevel(-1);
        this.fViewer.setInput(this.fOutlineInput);
        Tree tree = this.fViewer.getTree();
        tree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DebugProfileOutlineUtils.itemSelectedAction(e);
            }
        });
        this.updateViewer();
    }

    protected TreeViewer getViewer() {
        return this.fViewer;
    }

    public void handleCollapseAll() {
        this.fViewer.collapseAll();
    }

    protected ITreeContentProvider getContentProvider() {
        if (this.fContentProvider == null) {
            this.fContentProvider = new DebugProfileOutlineContentProvider();
        }
        return this.fContentProvider;
    }

    private DelegatingStyledCellLabelProvider getLabelProvider() {
        if (this.fLabelProvider == null) {
            this.fLabelProvider = new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new DebugProfileOutlineLabelProvider(this.fType));
        }
        return this.fLabelProvider;
    }

    protected IDebugProfileEditorConstants.PROFILE_TYPE getProfileType() {
        return this.fType;
    }

    protected void itemSelectedAction(SelectionEvent e) {
        if (e.item instanceof TreeItem) {
            TreeItem item = (TreeItem)e.item;
            DebugProfileOutlineUtils.itemSelectedAction((Control)item.getData());
        }
    }

    public void updateViewer() {
        if (this.fViewer != null) {
            List<Object> objects = this.fContentProvider.getAllElements(this.fOutlineInput);
            for (Object object : objects) {
                this.fViewer.update(object, null);
            }
        }
    }

    protected Object getOutlineInput() {
        return this.fOutlineInput;
    }
}

