/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.ui.profile.internal.handlers;

import com.ibm.debug.pdt.profile.internal.connection.Connection;
import com.ibm.debug.pdt.profile.internal.connection.ConnectionUtilities;
import com.ibm.debug.pdt.profile.internal.model.DebugProfile;
import com.ibm.debug.pdt.profile.internal.model.DebugProfileDTCN;
import com.ibm.debug.pdt.profile.internal.model.IDebugProfileConstants;
import com.ibm.debug.pdt.ui.profile.internal.editor.DebugProfileEditor;
import com.ibm.debug.pdt.ui.profile.internal.editor.IDebugProfileEditorConstants;
import com.ibm.debug.pdt.ui.profile.internal.editor.ProfileEditorInput;
import com.ibm.debug.pdt.ui.profile.internal.view.DebugProfileView;
import org.eclipse.core.expressions.PropertyTester;

public class DebugProfilePropertyTester
extends PropertyTester
implements IDebugProfileConstants {
    private static final String ACTIVATE_DEBUG_PROPERTY = "canActivateDebug";
    private static final String ACTIVATE_CODE_COVERAGE_PROPERTY = "canActivateCodeCoverage";
    private static final String INACTIVATE_PROPERTY = "canInactivate";
    private static final String CREATE_PROPERTY = "canCreate";
    private static final String IS_CICS = "isCICS";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (property.equals(INACTIVATE_PROPERTY)) {
            return this.testInactivate(receiver, expectedValue);
        }
        if (property.equals(ACTIVATE_DEBUG_PROPERTY)) {
            return this.testActivateDebug(receiver, expectedValue);
        }
        if (property.equals(ACTIVATE_CODE_COVERAGE_PROPERTY)) {
            return this.testActivateCC(receiver, expectedValue);
        }
        if (property.equals(CREATE_PROPERTY)) {
            return this.testCreateProfile(receiver, expectedValue);
        }
        if (property.equals(IS_CICS)) {
            return this.testIsCICS(receiver, expectedValue);
        }
        return false;
    }

    private boolean testActivateDebug(Object receiver, Object expectedValue) {
        if (receiver instanceof DebugProfile) {
            boolean isActive = ((DebugProfile)receiver).getState() == 1;
            boolean activeModeCC = ((DebugProfile)receiver).getMode() == 2;
            boolean isValid = ((DebugProfile)receiver).isValid();
            return expectedValue.equals(isValid && (!isActive || activeModeCC));
        }
        return false;
    }

    private boolean testActivateCC(Object receiver, Object expectedValue) {
        if (receiver instanceof DebugProfile) {
            boolean isActive = ((DebugProfile)receiver).getState() == 1;
            boolean activeModeDebug = ((DebugProfile)receiver).getMode() == 1;
            boolean isValid = ((DebugProfile)receiver).isValid();
            boolean isCICS = receiver instanceof DebugProfileDTCN;
            boolean isCCAllowed = isCICS || DebugProfilePropertyTester.isConnectionSupportsDebugProfileServiceAPI((DebugProfile)receiver);
            return expectedValue.equals(isValid && isCCAllowed && (!isActive || activeModeDebug));
        }
        return false;
    }

    public static boolean isConnectionSupportsDebugProfileServiceAPI(DebugProfile profile) {
        Connection c = ConnectionUtilities.getConnection((String)profile.getConnectionName(), (boolean)false);
        return c != null && c.getAPIServerURL() != null && c.getErrorState() != Connection.ERROR_STATE.BACK_LEVEL && c.getErrorState() != Connection.ERROR_STATE.CICS_ONLY;
    }

    private boolean testIsCICS(Object receiver, Object expectedValue) {
        if (receiver instanceof DebugProfileEditor) {
            ProfileEditorInput editorInput = ((DebugProfileEditor)receiver).getProfileEditorInput();
            boolean isCICS = editorInput.getProfileType() == IDebugProfileEditorConstants.PROFILE_TYPE.PROFILE_CICS;
            return expectedValue.equals(isCICS);
        }
        return false;
    }

    private boolean testInactivate(Object receiver, Object expectedValue) {
        if (receiver instanceof DebugProfile) {
            boolean canInactivate = ((DebugProfile)receiver).getState() == 1;
            return expectedValue.equals(canInactivate);
        }
        return false;
    }

    private boolean testCreateProfile(Object receiver, Object expectedValue) {
        return expectedValue.equals(!DebugProfileView.isWelcomeVisible());
    }
}

