/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.ui.profile.internal.extensions;

import com.ibm.debug.daemon.internal.core.DaemonCore;
import com.ibm.debug.pdt.profile.internal.Labels;
import com.ibm.debug.pdt.profile.internal.LogUtils;
import com.ibm.debug.pdt.profile.internal.ProfilePlugin;
import com.ibm.debug.pdt.profile.internal.connection.Connection;
import com.ibm.debug.pdt.profile.internal.connection.IConnectionInfo;
import com.ibm.debug.pdt.ui.profile.internal.extensions.DebugProfileRSEUtils;
import com.ibm.debug.pdt.ui.profile.internal.extensions.RSEEventListener;
import com.ibm.ftt.configurations.store.IJWTProvider;
import com.ibm.ftt.configurations.store.JWTResource;
import com.ibm.ftt.rse.debug.subsystems.DebugSubSystem;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import java.util.Date;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.dstore.core.model.DataStore;
import org.eclipse.dstore.core.util.ssl.IDataStoreTrustManager;
import org.eclipse.dstore.internal.core.util.ssl.DStoreSSLContext;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.rse.connectorservice.dstore.DStoreConnectorService;
import org.eclipse.rse.core.model.SystemSignonInformation;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.ui.messages.SystemMessageDialog;

public class RSEConnectionInfo
implements IConnectionInfo {
    private static final String PREFERENCE_PLUGIN_ID = "com.ibm.debug.pdt.profile.eclipse";
    private static final String JWT = "jwt";
    private static final String JWT_NODE = "keystore_jwt";
    private final Object fJWTSyncObject = new Object();
    private static ISecurePreferences fSecurePreferences;
    private static Object fPrefLock;
    private IConnectorService fConnectorService;
    private IJWTProvider fJwtProvider;
    private Date fJwtExpireDate = null;
    private boolean fIsJWTErrorLogged = false;

    static {
        fPrefLock = new Object();
    }

    public RSEConnectionInfo(IConnectorService c) {
        this.fConnectorService = c;
    }

    public String getConnectionName() {
        if (this.fConnectorService != null) {
            return this.fConnectorService.getHost().getName();
        }
        return null;
    }

    public String getHostName() {
        if (this.fConnectorService != null) {
            return this.fConnectorService.getHostName();
        }
        return null;
    }

    public String getUserId() {
        if (this.fConnectorService != null) {
            return this.fConnectorService.getUserId();
        }
        return null;
    }

    public char[] getUserPassword() {
        SystemSignonInformation s = DebugProfileRSEUtils.getSignonInformation(this.fConnectorService);
        if (s != null && s.getPasswordAsCharArray() != null) {
            return s.getPasswordAsCharArray();
        }
        return null;
    }

    public boolean isConnected() {
        return this.fConnectorService != null && this.fConnectorService.isConnected();
    }

    public boolean isUsingDBM() {
        if (this.fConnectorService != null && this.fConnectorService.isConnected()) {
            ISubSystem[] iSubSystemArray = this.fConnectorService.getSubSystems();
            int n = iSubSystemArray.length;
            int n2 = 0;
            while (n2 < n) {
                ISubSystem ss = iSubSystemArray[n2];
                if (ss instanceof DebugSubSystem) {
                    return ((DebugSubSystem)ss).readyToDebug();
                }
                ++n2;
            }
        }
        return false;
    }

    public String getLocalClientIP() {
        String localClientIP = null;
        try {
            localClientIP = DebugProfileRSEUtils.getWorkstationIPAddressUsingZOSConnection(false, this.fConnectorService);
            if (localClientIP == null || localClientIP.isEmpty()) {
                InetAddress[] addrs;
                InetAddress[] inetAddressArray = addrs = DaemonCore.getLocalAddress();
                int n = addrs.length;
                int n2 = 0;
                while (n2 < n) {
                    InetAddress a = inetAddressArray[n2];
                    if (!a.isLoopbackAddress()) {
                        return a.getHostAddress();
                    }
                    ++n2;
                }
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return localClientIP;
    }

    public IStatus connect() throws Exception {
        ISubSystem[] subsystems;
        if (this.isConnected()) {
            return Status.OK_STATUS;
        }
        if (fSecurePreferences != null) {
            this.removeJwtFromSecureStorage(fSecurePreferences);
        }
        final RSELoginNotifier rseLoginEventNotifier = new RSELoginNotifier();
        RSEEventListener listener = new RSEEventListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleEvent(Connection source, int eventType, String oldName) {
                if (source.getConnectionName() != null && source.getConnectionName().equals(RSEConnectionInfo.this.getConnectionName()) && eventType == 3) {
                    DebugProfileRSEUtils.getInstance().removeRSEEventListener(this);
                    RSELoginNotifier rSELoginNotifier = rseLoginEventNotifier;
                    synchronized (rSELoginNotifier) {
                        rseLoginEventNotifier.state = RSELoginNotifier.STATES.COMPLETE;
                        rseLoginEventNotifier.notifyAll();
                    }
                }
            }
        };
        DebugProfileRSEUtils.getInstance().addRSEEventListener(listener);
        ISubSystem[] iSubSystemArray = subsystems = this.fConnectorService.getSubSystems();
        int n = subsystems.length;
        int n2 = 0;
        while (n2 < n) {
            ISubSystem subsystem = iSubSystemArray[n2];
            if (!subsystem.isConnected() && subsystem.getSubSystemConfiguration().supportsSubSystemConnect()) {
                try {
                    subsystem.connect((IProgressMonitor)new NullProgressMonitor(), false);
                }
                catch (Exception e) {
                    if (!this.isConnected()) {
                        DebugProfileRSEUtils.getInstance().removeRSEEventListener(listener);
                    }
                    if (e instanceof InterruptedException || e instanceof OperationCanceledException) {
                        return Status.CANCEL_STATUS;
                    }
                    if (!(e instanceof SystemMessageException)) break;
                    SystemMessageDialog.displayMessage((SystemMessageException)((SystemMessageException)((Object)e)));
                    return new Status(4, PREFERENCE_PLUGIN_ID, e.getMessage());
                }
            }
            ++n2;
        }
        Job j = new Job(Labels.JOB_WAIT_RSE){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected IStatus run(IProgressMonitor pm) {
                RSELoginNotifier rSELoginNotifier = rseLoginEventNotifier;
                synchronized (rSELoginNotifier) {
                    while (rseLoginEventNotifier.state == RSELoginNotifier.STATES.WAITING) {
                        try {
                            if (pm.isCanceled()) {
                                return Status.CANCEL_STATUS;
                            }
                            rseLoginEventNotifier.wait(1000L);
                        }
                        catch (InterruptedException e) {
                            return Status.CANCEL_STATUS;
                        }
                    }
                }
                return Status.OK_STATUS;
            }
        };
        j.schedule();
        j.join(120000L, (IProgressMonitor)new NullProgressMonitor());
        if (j.getResult() == null) {
            j.cancel();
            return Status.CANCEL_STATUS;
        }
        return j.getResult();
    }

    public SSLContext getSSLContext(X509TrustManager mgr) throws Exception {
        DataStore dstore = this.getDataStore();
        SSLContext sslcontext = null;
        if (dstore != null && mgr instanceof IDataStoreTrustManager) {
            sslcontext = DStoreSSLContext.getClientSSLContext((String)dstore.getKeyStoreLocation(), (String)dstore.getKeyStorePassword(), (IDataStoreTrustManager)((IDataStoreTrustManager)mgr));
        } else {
            sslcontext = SSLContext.getInstance("TLS");
            sslcontext.init(null, new TrustManager[]{mgr}, new SecureRandom());
        }
        return sslcontext;
    }

    private DataStore getDataStore() {
        if (this.fConnectorService instanceof DStoreConnectorService) {
            return ((DStoreConnectorService)this.fConnectorService).getDataStore();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getJwt() {
        Object object = this.fJWTSyncObject;
        synchronized (object) {
            if (this.fJwtProvider == null) return null;
            if (this.fIsJWTErrorLogged) return null;
            try {
                String jwt = null;
                if (this.newJwtNeeded()) {
                    ProfilePlugin.getTrace().trace("/debug", "Requesting a new JWT from the provider.");
                    JWTResource jwtResource = this.fJwtProvider.getJWTResource();
                    this.fJwtExpireDate = jwtResource.getExpiration();
                    jwt = jwtResource.getJWT();
                    this.saveJwtToSecureStorage(this.getSecurePreferences(), jwt);
                } else {
                    jwt = this.getJwtFromSecureStorage(this.getSecurePreferences());
                }
                if (jwt == null) {
                    return null;
                }
                String[] splitJwt = jwt.split("\\.");
                if (splitJwt.length <= 3) return jwt;
                String jwtHeader = splitJwt[0];
                int secondHeaderIndex = jwt.indexOf(jwtHeader, jwtHeader.length());
                if (secondHeaderIndex <= 0) return jwt;
                return jwt.substring(0, secondHeaderIndex);
            }
            catch (Exception e) {
                if (this.fIsJWTErrorLogged) return null;
                LogUtils.log((int)4, (String)(this.getConnectionName() + ": " + e.getMessage()), (Throwable)e);
                this.fIsJWTErrorLogged = true;
                return null;
            }
        }
    }

    IConnectorService getConnectorService() {
        return this.fConnectorService;
    }

    void setJwtProvider(IJWTProvider jwtProvider) {
        this.fJwtProvider = jwtProvider;
    }

    protected void removeJwtFromSecureStorage(ISecurePreferences securePreferences) {
        if (securePreferences.nodeExists(JWT_NODE)) {
            ISecurePreferences jwtNode = fSecurePreferences.node(JWT_NODE);
            jwtNode.removeNode();
        }
    }

    public void clearJwtToken() {
        ProfilePlugin.getTrace().trace("/debug", "Removing an existing JWT.");
        this.fJwtExpireDate = null;
        if (fSecurePreferences != null) {
            this.removeJwtFromSecureStorage(fSecurePreferences);
        }
        this.fIsJWTErrorLogged = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ISecurePreferences getSecurePreferences() {
        Object object = fPrefLock;
        synchronized (object) {
            if (fSecurePreferences == null) {
                fSecurePreferences = SecurePreferencesFactory.getDefault().node(PREFERENCE_PLUGIN_ID);
            }
        }
        return fSecurePreferences;
    }

    private String getJwtFromSecureStorage(ISecurePreferences securePreferences) {
        if (fSecurePreferences.nodeExists(JWT_NODE)) {
            try {
                ISecurePreferences thisNode = securePreferences.node(JWT_NODE);
                return thisNode.get(JWT, null);
            }
            catch (StorageException e) {
                LogUtils.log((Throwable)e);
            }
        }
        return null;
    }

    protected void saveJwtToSecureStorage(ISecurePreferences securePreferences, String jwtString) {
        if (jwtString == null) {
            return;
        }
        ISecurePreferences thisNode = null;
        if (securePreferences.nodeExists(JWT_NODE)) {
            thisNode = fSecurePreferences.node(JWT_NODE);
            thisNode.removeNode();
        }
        thisNode = securePreferences.node(JWT_NODE);
        try {
            thisNode.put(JWT, jwtString, true);
        }
        catch (StorageException e) {
            LogUtils.log((Throwable)e);
        }
    }

    private boolean newJwtNeeded() {
        if (this.fJwtExpireDate != null) {
            Date currentDate = new Date();
            if (this.fJwtExpireDate.after(currentDate)) {
                return false;
            }
            ProfilePlugin.getTrace().trace("/debug", "Existing JWT has been expired.");
        }
        return true;
    }

    public URI getAPIServerURL() {
        return null;
    }

    static class RSELoginNotifier {
        STATES state = STATES.WAITING;

        RSELoginNotifier() {
        }

        static enum STATES {
            WAITING,
            CANCELLED,
            COMPLETE;

        }
    }
}

