/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.ui.profile.internal.extensions;

import com.ibm.debug.pdt.launch.internal.zpicl.preferences.LaunchzPICLPreferences;
import com.ibm.debug.pdt.profile.internal.Labels;
import com.ibm.debug.pdt.profile.internal.LogUtils;
import com.ibm.debug.pdt.profile.internal.ProfileMessages;
import com.ibm.debug.pdt.profile.internal.ProfilePlugin;
import com.ibm.debug.pdt.profile.internal.connection.Connection;
import com.ibm.debug.pdt.profile.internal.connection.ConnectionUtilities;
import com.ibm.debug.pdt.profile.internal.connection.IConnectionInfo;
import com.ibm.debug.pdt.profile.internal.model.IDebugProfileConstants;
import com.ibm.debug.pdt.ui.profile.internal.extensions.RSEConnectionInfo;
import com.ibm.debug.pdt.ui.profile.internal.extensions.RSEEventListener;
import com.ibm.etools.zseries.util.DStoreWithSSHConnectorService;
import com.ibm.ftt.configurations.store.IJWTProvider;
import com.ibm.ftt.resource.utils.PBResourceUtils;
import com.ibm.ftt.resources.core.physical.IOSImage;
import com.ibm.ftt.resources.core.physicalfactory.PhysicalSystemRegistryFactory;
import com.ibm.ftt.resources.zos.PBResourceMvsUtils;
import com.ibm.ftt.resources.zos.zosphysical.IZOSSystemImage;
import com.ibm.ftt.rse.debug.subsystems.DebugSubSystem;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.events.ISystemModelChangeEvent;
import org.eclipse.rse.core.events.ISystemModelChangeListener;
import org.eclipse.rse.core.model.Host;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.core.model.SystemSignonInformation;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.core.subsystems.ISubSystem;

public class DebugProfileRSEUtils
implements IDebugProfileConstants,
ISystemModelChangeListener {
    private static final DebugProfileRSEUtils fInstance = new DebugProfileRSEUtils();
    private ArrayList<RSEEventListener> fListeners = new ArrayList();

    public static DebugProfileRSEUtils getInstance() {
        return fInstance;
    }

    private DebugProfileRSEUtils() {
        ISystemRegistry registry = RSECorePlugin.getTheSystemRegistry();
        registry.addSystemModelChangeListener((ISystemModelChangeListener)this);
        List<IConnectorService> rseConnections = DebugProfileRSEUtils.getRSEConnections();
        for (IConnectorService c : rseConnections) {
            this.registerConnection(c);
        }
    }

    private void registerConnection(IConnectorService c) {
        if (c != null) {
            if (!c.isConnected()) {
                Connection connection = ConnectionUtilities.getConnection((String)c.getHost().getName());
                if (connection == null) {
                    RSEConnectionInfo info = new RSEConnectionInfo(c);
                    connection = ConnectionUtilities.getConnection((IConnectionInfo)info);
                    connection.setErrorMessage(NLS.bind((String)ProfileMessages.CRRDG9111, (Object)c.getHost().getName()));
                } else {
                    connection.setErrorMessage(NLS.bind((String)ProfileMessages.CRRDG9111, (Object)c.getHost().getName()));
                }
                connection.setErrorState(Connection.ERROR_STATE.NOT_CONNECTED);
            } else {
                Connection connection = this.createConnectionFromDebugSubsystem(c);
                IConnectionInfo info = connection.getConnectionInfo();
                if (info instanceof RSEConnectionInfo) {
                    this.addJwtProvider((RSEConnectionInfo)info);
                }
            }
        }
    }

    private void addJwtProvider(RSEConnectionInfo conn) {
        ISubSystem[] subsystems;
        ISubSystem[] iSubSystemArray = subsystems = conn.getConnectorService().getSubSystems();
        int n = subsystems.length;
        int n2 = 0;
        while (n2 < n) {
            ISubSystem ss = iSubSystemArray[n2];
            if (ss instanceof IJWTProvider) {
                conn.setJwtProvider((IJWTProvider)ss);
                break;
            }
            ++n2;
        }
    }

    Connection getConnection(String name, boolean forceConnection) {
        Connection connection = ConnectionUtilities.getConnection((String)name);
        if (forceConnection && connection != null && !connection.isConnected()) {
            try {
                Connection newConnection = this.connect(connection);
                return newConnection;
            }
            catch (Exception e) {
                LogUtils.log((Throwable)e);
            }
        }
        return connection;
    }

    private static List<IConnectorService> getRSEConnections() {
        Object[] systems;
        ArrayList<IConnectorService> connections = new ArrayList<IConnectorService>();
        Object[] objectArray = systems = PhysicalSystemRegistryFactory.getSingleton().getSystems(2);
        int n = systems.length;
        int n2 = 0;
        while (n2 < n) {
            Object si;
            Object s = objectArray[n2];
            if (s instanceof IZOSSystemImage && (si = ((IZOSSystemImage)s).getSystemImplementation()) instanceof ISubSystem && ((ISubSystem)si).getConnectorService() instanceof DStoreWithSSHConnectorService) {
                connections.add(((ISubSystem)si).getConnectorService());
            }
            ++n2;
        }
        return connections;
    }

    static SystemSignonInformation getSignonInformation(IConnectorService service) {
        if (service instanceof DStoreWithSSHConnectorService) {
            return ((DStoreWithSSHConnectorService)service).getPasswordInformation();
        }
        return null;
    }

    private static boolean supportsPassword(IConnectorService service) {
        if (service instanceof DStoreWithSSHConnectorService) {
            return ((DStoreWithSSHConnectorService)service).supportsPassword();
        }
        return false;
    }

    private static String validateServerInfo(DebugSubSystem.APIServerInfo serverInfo, IConnectorService c) {
        int port = -1;
        int secureport = -1;
        String contextroot = serverInfo.contextroot;
        try {
            port = Integer.parseInt(serverInfo.port);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            secureport = Integer.parseInt(serverInfo.secureport);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (port < 0 && secureport < 0) {
            return ProfileMessages.CRRDG9112;
        }
        if (contextroot == null || contextroot.isEmpty()) {
            return ProfileMessages.CRRDG9112;
        }
        if (c.isUsingSSL() && secureport < 0) {
            return ProfileMessages.CRRDG9107;
        }
        if (!c.isUsingSSL() && port < 0) {
            LogUtils.log((int)1, (String)NLS.bind((String)"Debug Profile Service not available:  Remote System Explorer connection {0} is not secured and DPS is only configured for secured connections.", (Object)c.getName()));
        }
        if (!DebugProfileRSEUtils.supportsPassword(c)) {
            return ProfileMessages.CRRDG9109;
        }
        if (DebugProfileRSEUtils.getSignonInformation(c) == null || DebugProfileRSEUtils.getSignonInformation(c).getPasswordAsCharArray() == null || DebugProfileRSEUtils.getSignonInformation(c).getPasswordAsCharArray().length == 0) {
            return ProfileMessages.CRRDG9110;
        }
        return null;
    }

    public static String getErrorMessageForHostErrorCode(String hostErrorCode, String connectionName) {
        if ("ERROR_NOT_CONNECTED".equals(hostErrorCode)) {
            return NLS.bind((String)ProfileMessages.CRRDG9111, (Object)connectionName);
        }
        return NLS.bind((String)ProfileMessages.CRRDG9115, (Object)hostErrorCode);
    }

    static String getWorkstationIPAddressUsingZOSConnection(boolean connect, IConnectorService connectorService) {
        IZOSSystemImage definedButNotConnectedSystem = null;
        IZOSSystemImage definedConnectedSystem = null;
        IZOSSystemImage[] systems = PBResourceMvsUtils.getAllMVSSubSystems();
        int i = 0;
        while (i < systems.length) {
            IZOSSystemImage systemImage = systems[i];
            if (systemImage.isConnected() && connectorService.getHostName().equalsIgnoreCase(systemImage.getName())) {
                return PBResourceUtils.getClientIPAddress((IOSImage)systemImage);
            }
            if (systemImage.isConnected()) {
                definedConnectedSystem = systemImage;
            } else {
                definedButNotConnectedSystem = systemImage;
            }
            ++i;
        }
        if (definedConnectedSystem != null) {
            return PBResourceUtils.getClientIPAddress(definedConnectedSystem);
        }
        if (connect && definedButNotConnectedSystem != null) {
            try {
                definedButNotConnectedSystem.connect();
                if (definedButNotConnectedSystem.isConnected()) {
                    return PBResourceUtils.getClientIPAddress((IOSImage)definedButNotConnectedSystem);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Connection connect(Connection c) throws Exception {
        Connection connection;
        Connection connection2;
        block15: {
            Connection result;
            if (c.isConnected()) break block15;
            c.connect();
            IConnectionInfo info = c.getConnectionInfo();
            if (!(info instanceof RSEConnectionInfo) || (result = ConnectionUtilities.getConnection((IConnectionInfo)info)) == null) break block15;
            Connection connection3 = result;
            Connection connection4 = c;
            synchronized (connection4) {
                while (c.isConnected() && !c.isSynchronized() && LaunchzPICLPreferences.getisSynchronizeProfiles()) {
                    c.wait();
                }
            }
            return connection3;
        }
        try {
            connection2 = c;
            connection = c;
        }
        catch (Throwable throwable) {
            Connection connection5 = c;
            synchronized (connection5) {
                while (c.isConnected() && !c.isSynchronized() && LaunchzPICLPreferences.getisSynchronizeProfiles()) {
                    c.wait();
                }
            }
        }
        synchronized (connection) {
            while (c.isConnected() && !c.isSynchronized() && LaunchzPICLPreferences.getisSynchronizeProfiles()) {
                c.wait();
            }
        }
        return connection2;
        throw throwable;
    }

    private Connection createConnectionFromDebugSubsystem(IConnectorService c) {
        String name = c.getHost().getName();
        Connection connection = ConnectionUtilities.getConnection((String)name);
        boolean overrideDPSConnection = Boolean.parseBoolean(System.getProperty("overrideDPSconnection." + c.getHostName()));
        if (overrideDPSConnection) {
            String portOverride = System.getProperty("overrideDPSconnectionPort." + c.getHostName());
            String secureportOverride = System.getProperty("overrideDPSconnectionSecurePort." + c.getHostName());
            String contextrootOverride = System.getProperty("overrideDPSconnectionContextRoot." + c.getHostName());
            int port = -1;
            int secureport = -1;
            String contextroot = "/api/v1";
            if (portOverride != null && !portOverride.trim().isEmpty()) {
                try {
                    port = Integer.parseInt(portOverride.trim());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (secureportOverride != null && !secureportOverride.trim().isEmpty()) {
                try {
                    secureport = Integer.parseInt(secureportOverride.trim());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (contextrootOverride != null && !contextrootOverride.trim().isEmpty()) {
                contextroot = contextrootOverride;
            }
            ProfilePlugin.getTrace().trace("/rseEvents", "Overriding DPS connection info: [" + port + ", " + secureport + ", " + contextroot + "]");
            if (connection == null) {
                RSEConnectionInfo info = new RSEConnectionInfo(c);
                connection = ConnectionUtilities.getConnection((IConnectionInfo)info);
            }
            connection.setConnectionInfo(port, secureport, contextroot);
            connection.setErrorState(Connection.ERROR_STATE.NONE);
            connection.setErrorMessage(null);
            return connection;
        }
        ISubSystem[] iSubSystemArray = c.getSubSystems();
        int n = iSubSystemArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISubSystem ss = iSubSystemArray[n2];
            if (ss instanceof DebugSubSystem) {
                DebugSubSystem dss = (DebugSubSystem)ss;
                if (dss.supportsCommand("C_GET_API_SERVER_INFO")) {
                    try {
                        DebugSubSystem.APIServerInfo serverInfo = dss.getAPIServerInfo();
                        String errorMessage = DebugProfileRSEUtils.validateServerInfo(serverInfo, c);
                        if (errorMessage == null) {
                            int port = -1;
                            int secureport = -1;
                            try {
                                port = Integer.parseInt(serverInfo.port);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                            try {
                                secureport = Integer.parseInt(serverInfo.secureport);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                            if (connection == null) {
                                RSEConnectionInfo info = new RSEConnectionInfo(c);
                                connection = ConnectionUtilities.getConnection((IConnectionInfo)info);
                            }
                            connection.setConnectionInfo(port, secureport, serverInfo.contextroot);
                            connection.setErrorState(Connection.ERROR_STATE.NONE);
                            connection.setErrorMessage(errorMessage);
                            return connection;
                        }
                        if (connection == null) {
                            RSEConnectionInfo info = new RSEConnectionInfo(c);
                            connection = ConnectionUtilities.getConnection((IConnectionInfo)info);
                        }
                        connection.setErrorMessage(errorMessage);
                        connection.setErrorState(Connection.ERROR_STATE.CLIENT_ERROR);
                        return connection;
                    }
                    catch (DebugSubSystem.ServerInfoException e) {
                        String errorMessage = DebugProfileRSEUtils.getErrorMessageForHostErrorCode(e.getErrorID(), name);
                        if (connection == null) {
                            RSEConnectionInfo info = new RSEConnectionInfo(c);
                            connection = ConnectionUtilities.getConnection((IConnectionInfo)info);
                        }
                        connection.setErrorMessage(errorMessage);
                        connection.setErrorState(Connection.ERROR_STATE.HOST_ERROR);
                        return connection;
                    }
                }
                if (connection == null) {
                    RSEConnectionInfo info = new RSEConnectionInfo(c);
                    connection = ConnectionUtilities.getConnection((IConnectionInfo)info);
                }
                connection.setErrorMessage(ProfileMessages.CRRDG9119);
                connection.setErrorState(Connection.ERROR_STATE.BACK_LEVEL);
                return connection;
            }
            ++n2;
        }
        return null;
    }

    public void systemModelResourceChanged(final ISystemModelChangeEvent event) {
        Job j = new Job(Labels.JOB_UPDATE_STATUS){

            protected IStatus run(IProgressMonitor pm) {
                if (event.getResource() instanceof Host) {
                    Connection c;
                    if (event.getEventType() == 1) {
                        DebugProfileRSEUtils.this.registerConnection(DebugProfileRSEUtils.this.getConnectorService((Host)event.getResource()));
                        DebugProfileRSEUtils.this.fireRSEEvent(DebugProfileRSEUtils.this.getConnection(((Host)event.getResource()).getName(), false), 0);
                    }
                    if (event.getEventType() == 2 && (c = ConnectionUtilities.getConnection((String)((Host)event.getResource()).getName(), (boolean)false)) != null) {
                        ConnectionUtilities.removeConnection((Connection)c);
                        DebugProfileRSEUtils.this.fireRSEEvent(c, 1);
                    }
                    if (event.getEventType() == 8) {
                        c = ConnectionUtilities.getConnection((String)event.getOldName(), (boolean)false);
                        if (c != null) {
                            ConnectionUtilities.removeConnection((String)event.getOldName());
                        }
                        DebugProfileRSEUtils.this.fireRSEEvent(DebugProfileRSEUtils.this.getConnection(((Host)event.getResource()).getName(), false), 2, event.getOldName());
                    }
                }
                if (event.getResource() instanceof DebugSubSystem) {
                    if (event.getEventType() == 4) {
                        DebugProfileRSEUtils.this.registerConnection(((DebugSubSystem)event.getResource()).getConnectorService());
                        DebugProfileRSEUtils.this.fireRSEEvent(DebugProfileRSEUtils.this.getConnection(((DebugSubSystem)event.getResource()).getHost().getName(), false), 3);
                    }
                    if (event.getEventType() == 16) {
                        DebugProfileRSEUtils.this.registerConnection(((DebugSubSystem)event.getResource()).getConnectorService());
                        DebugProfileRSEUtils.this.fireRSEEvent(DebugProfileRSEUtils.this.getConnection(((DebugSubSystem)event.getResource()).getHost().getName(), false), 4);
                    }
                }
                return Status.OK_STATUS;
            }
        };
        j.schedule();
    }

    private IConnectorService getConnectorService(Host host) {
        ISubSystem[] iSubSystemArray = host.getSubSystems();
        int n = iSubSystemArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISubSystem ss = iSubSystemArray[n2];
            if (ss instanceof DebugSubSystem) {
                return ((DebugSubSystem)ss).getConnectorService();
            }
            ++n2;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRSEEventListener(RSEEventListener l) {
        ArrayList<RSEEventListener> arrayList = this.fListeners;
        synchronized (arrayList) {
            this.fListeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRSEEventListener(RSEEventListener l) {
        ArrayList<RSEEventListener> arrayList = this.fListeners;
        synchronized (arrayList) {
            this.fListeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireRSEEvent(Connection source, int eventType) {
        ArrayList<RSEEventListener> arrayList = this.fListeners;
        synchronized (arrayList) {
            this.fireRSEEvent(source, eventType, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireRSEEvent(final Connection source, final int eventType, final String oldName) {
        ArrayList<RSEEventListener> arrayList = this.fListeners;
        synchronized (arrayList) {
            if (source != null) {
                String logmsg = "RSEEventListener: " + RSEEventListener.eventNames[eventType] + "  " + source.getConnectionName() + (String)(oldName != null ? "  (oldname: " + oldName + ")" : "") + System.lineSeparator() + this.getConnectionSummary();
                ProfilePlugin.getTrace().trace("/rseEvents", logmsg);
            }
            final RSEEventListener[] listeners = this.fListeners.toArray(new RSEEventListener[0]);
            Job j = new Job(Labels.JOB_NOTIFY_RSE){

                protected IStatus run(IProgressMonitor pm) {
                    ProfilePlugin.getTrace().trace("/rseEvents", "Number of RSE Listeners:" + listeners.length);
                    RSEEventListener[] rSEEventListenerArray = listeners;
                    int n = listeners.length;
                    int n2 = 0;
                    while (n2 < n) {
                        RSEEventListener l = rSEEventListenerArray[n2];
                        try {
                            ProfilePlugin.getTrace().trace("/rseEvents", "Listener about to be notified:" + String.valueOf(l));
                            l.handleEvent(source, eventType, oldName);
                        }
                        catch (Exception e) {
                            LogUtils.log((Throwable)e);
                        }
                        ++n2;
                    }
                    return Status.OK_STATUS;
                }
            };
            j.schedule();
        }
    }

    private String getConnectionSummary() {
        StringBuilder sb = new StringBuilder();
        for (Connection c : ConnectionUtilities.getConnections()) {
            sb.append("\t").append(c.toString());
        }
        return sb.toString();
    }
}

