/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.ui.profile.internal.editor.actions;

import com.ibm.debug.pdt.profile.IAdditionalCICSFilters;
import com.ibm.debug.pdt.profile.internal.model.DebugProfile;
import com.ibm.debug.pdt.profile.internal.model.DebugProfileDTCN;
import com.ibm.debug.pdt.profile.internal.model.DebugProfileNameUtils;
import com.ibm.debug.pdt.ui.profile.internal.editor.ProfileEditorInput;
import com.ibm.ftt.debug.ui.DebugLaunchUtils;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public abstract class AbstractCICSDebugProfileAction
extends AbstractHandler {
    public static final String EMPTY = "";
    private ISelection selection;
    private String regionName = "";
    private String transactionName = "";
    private String programName = "";
    private String userId = "";

    public abstract void setDebugProperties(ISelection var1);

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.selectionChanged(null, HandlerUtil.getActiveMenuSelection((ExecutionEvent)event));
        if (DebugLaunchUtils.isIDzAdvancedLicense((boolean)false)) {
            IWorkbenchPage activePage;
            this.setDebugProperties(this.selection);
            String name = this.transactionName.isEmpty() ? this.programName : this.transactionName;
            name = DebugProfileNameUtils.isNameInUse((String)name) ? DebugProfileNameUtils.generateNewName((String)name) : name;
            DebugProfileDTCN profile = new DebugProfileDTCN(name);
            profile.setRegion(this.regionName);
            profile.setTransaction(this.transactionName);
            this.addLoadModules(profile);
            profile.setAdditionalCICSFilters((IAdditionalCICSFilters)new DebugProfileDTCN.AdditionalCICSFilters(this.userId, null, null, null, null));
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (window != null && (activePage = window.getActivePage()) != null) {
                try {
                    activePage.openEditor((IEditorInput)new ProfileEditorInput((DebugProfile)profile), "com.ibm.debug.pdt.idz.launches.common.profile.editor.DebugProfileEditor");
                }
                catch (PartInitException ex) {
                    throw new ExecutionException(ex.getMessage(), (Throwable)ex);
                }
            }
        }
        return null;
    }

    private void addLoadModules(DebugProfileDTCN profile) {
        String[] loadmod;
        String[] stringArray = loadmod = this.programName.split(",");
        int n = loadmod.length;
        int n2 = 0;
        while (n2 < n) {
            String l = stringArray[n2];
            profile.addLoadModulePair(l, "*");
            ++n2;
        }
    }

    public void setRegionName(String regionName) {
        this.regionName = regionName;
    }

    public void setTransactionName(String transactionName) {
        this.transactionName = transactionName;
    }

    public void setProgramName(String programName) {
        this.programName = programName;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }
}

