/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.ui.profile.internal.editor;

import com.ibm.debug.pdt.launch.internal.zpicl.preferences.LaunchzPICLPreferences;
import com.ibm.debug.pdt.profile.internal.ProfileMessages;
import com.ibm.debug.pdt.profile.internal.connection.Connection;
import com.ibm.debug.pdt.profile.internal.model.DTCNForceSettings;
import com.ibm.debug.pdt.profile.internal.model.DebugProfile;
import com.ibm.debug.pdt.profile.internal.model.DebugProfileNameUtils;
import com.ibm.debug.pdt.ui.profile.internal.editor.DebugProfileEditorPage;
import com.ibm.debug.pdt.ui.profile.internal.editor.IDebugProfileEditorConstants;
import com.ibm.debug.pdt.ui.profile.internal.editor.MessageManagerHelper;
import com.ibm.ftt.debug.ui.Labels;
import com.ibm.ftt.debug.ui.composites.DebugOptionsComposite;
import com.ibm.ftt.debug.ui.composites.dlydbg.DebugItem;
import com.ibm.ftt.debug.ui.composites.dlydbg.DelayDebugComposite;
import com.ibm.ftt.debug.ui.util.DebugLaunchUIUtils;
import com.ibm.ftt.resources.core.physical.util.OperationFailedException;
import com.ibm.ftt.resources.core.physicalfactory.PhysicalSystemRegistryFactory;
import com.ibm.ftt.resources.zos.zosphysical.IZOSCatalog;
import com.ibm.ftt.resources.zos.zosphysical.IZOSSystemImage;
import com.ibm.ftt.resources.zos.zosphysical.impl.ZOSSequentialDataSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.subsystems.files.core.model.RemoteFileUtility;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class Validator
implements IDebugProfileEditorConstants {
    private static final String VERSION_REGEX = "\\d{1,8}\\.\\d{1,8}\\.\\d{1,8}";
    private static final String VADSCP_FORMAT = "^(?i)VADSCP\\d{1,5}$";
    private MessageManagerHelper helper;

    public Validator(MessageManagerHelper helper) {
        this.helper = helper;
    }

    public boolean validateValueSpecified(Text field, String errorMessage) {
        this.helper.clearMessages((Control)field);
        String value = field.getText();
        if (value == null || value.trim().equals("")) {
            this.helper.displayErrorMessage(errorMessage, (Control)field);
            return false;
        }
        return true;
    }

    public boolean validateValueSpecified(CCombo field, String errorMessage) {
        return this.validateValueSpecified(field, errorMessage, true);
    }

    public boolean validateValueSpecified(CCombo field, String errorMessage, boolean clearMessages) {
        String value;
        if (clearMessages) {
            this.helper.clearMessages((Control)field);
        }
        if ((value = field.getText()) == null || value.trim().equals("")) {
            this.helper.displayErrorMessage(errorMessage, (Control)field);
            return false;
        }
        return true;
    }

    public boolean validateSpecialChar(Text field, String message) {
        this.helper.clearMessages((Control)field);
        String value = field.getText();
        Pattern specialChar = Pattern.compile("[@!#$%^&*`()<>?/\\|}{~:]");
        Matcher matcher = specialChar.matcher(value.trim());
        if (matcher.find()) {
            this.helper.displayErrorMessage(NLS.bind((String)message, (Object)value), (Control)field);
            return false;
        }
        return true;
    }

    public boolean validateProfileNameNotExists(Text field, String message, boolean isExistingProfileName) {
        this.helper.clearMessages((Control)field);
        String value = field.getText();
        if (DebugProfileNameUtils.isNameInUse((String)value.trim())) {
            if (isExistingProfileName) {
                return true;
            }
            this.helper.displayErrorMessage(NLS.bind((String)message, (Object)value), (Control)field);
            return false;
        }
        return true;
    }

    public boolean validateTextWithoutDisplayMsg(Text field) {
        String value = field.getText();
        return value != null && !value.trim().equals("");
    }

    public boolean validateCICSLoadModuleComposite(DelayDebugComposite fLoadModuleComposite) {
        return fLoadModuleComposite.getDebugItems().size() > 1;
    }

    public boolean validateNonCICSLoadModuleComposite(DelayDebugComposite fLoadModuleComposite) {
        this.helper.clearMessages((Control)fLoadModuleComposite);
        if (fLoadModuleComposite.getDebugItems().size() <= 1) {
            this.helper.displayErrorMessage(ProfileMessages.CRRDG9105, (Control)fLoadModuleComposite);
            return false;
        }
        return true;
    }

    public boolean validatePort(CCombo field, String message) {
        return Validator.validatePort(field, message, this.helper);
    }

    private static boolean validatePort(CCombo field, String message, MessageManagerHelper helper) {
        helper.clearMessages((Control)field);
        String value = field.getText();
        if (value == null || value.trim().equals("")) {
            helper.displayErrorMessage(message, (Control)field);
            return false;
        }
        if (!value.matches("^\\d+$")) {
            helper.displayErrorMessage(message, (Control)field);
            return false;
        }
        return true;
    }

    public boolean validateProfileName(Text field, boolean isExistingProfileName) {
        if (!this.validateValueSpecified(field, ProfileMessages.CRRDG9101)) {
            return false;
        }
        if (!this.validateSpecialChar(field, ProfileMessages.CRRDG9120)) {
            return false;
        }
        return this.validateProfileNameNotExists(field, ProfileMessages.CRRDG9121, isExistingProfileName);
    }

    public boolean validateCICSDebugFormInput(boolean isExistingProfile, Text profile, CCombo connect, DebugProfileEditorPage.REGION_STATE regionState, CCombo region, Text fTransactionNameText, Text fUserIdText, Text fNetNameText, Text fIpText, Text fTermIDText, DelayDebugComposite fLoadModuleComposite, DTCNForceSettings settings) {
        boolean valid = true;
        if (!this.validateProfileName(profile, isExistingProfile)) {
            valid = false;
        }
        if (!this.validateValueSpecified(connect, ProfileMessages.CRRDG9102, false)) {
            valid = false;
        }
        valid = regionState == DebugProfileEditorPage.REGION_STATE.PORT ? this.validatePort(region, ProfileMessages.CRRDG9117) : this.validateValueSpecified(region, ProfileMessages.CRRDG9103);
        valid = this.validateCICSDebugConjunctionFields(fTransactionNameText, fUserIdText, fNetNameText, fIpText, fTermIDText, fLoadModuleComposite, settings);
        return valid;
    }

    public boolean validateNonCICSDebugFormInput(boolean isExistingProfile, Text profile, CCombo connect, CCombo location, DelayDebugComposite fLoadModuleComposite, Text fJobNameText, Text fStepNameText, Text fSubsystemIDText, Text fTransactionIDText) {
        boolean valid = true;
        if (!this.validateProfileName(profile, isExistingProfile)) {
            valid = false;
        }
        if (!this.validateValueSpecified(connect, ProfileMessages.CRRDG9102)) {
            valid = false;
        }
        if (valid = this.validateNonCICSLoadModuleComposite(fLoadModuleComposite)) {
            this.validateGenericNonCICSFields(fLoadModuleComposite, fJobNameText, fStepNameText, fSubsystemIDText, fTransactionIDText);
        }
        return valid;
    }

    public boolean validateCICSDebugConjunctionFields(Text fTransactionNameText, Text fUserIdText, Text fNetNameText, Text fIpText, Text fTermIDText, DelayDebugComposite fLoadModuleComposite, DTCNForceSettings settings) {
        this.helper.clearMessages((Control)fTransactionNameText);
        if (this.validateTextWithoutDisplayMsg(fTransactionNameText) || this.validateTextWithoutDisplayMsg(fUserIdText) || this.validateTextWithoutDisplayMsg(fNetNameText) || this.validateTextWithoutDisplayMsg(fIpText) || this.validateTextWithoutDisplayMsg(fTermIDText) || this.validateCICSLoadModuleComposite(fLoadModuleComposite)) {
            return true;
        }
        if (this.validateDTCNFORCE(fTransactionNameText, fUserIdText, fNetNameText, fIpText, fTermIDText, fLoadModuleComposite, settings, true)) {
            this.helper.displayErrorMessage(ProfileMessages.CRRDG9104, (Control)fTransactionNameText);
        }
        return false;
    }

    public boolean validateConnection(Combo field, Connection c) {
        this.helper.clearMessages((Control)field);
        if (c.getErrorMessage() != null) {
            this.helper.displayErrorMessage(c.getErrorMessage(), (Control)field);
            return false;
        }
        return true;
    }

    public void validateAuthCertificate(String connName, Text fAuthCertificateText) {
        this.helper.clearMessages((Control)fAuthCertificateText);
        if (fAuthCertificateText.getText().startsWith("/")) {
            IHost host = DebugOptionsComposite.getHost((String)connName);
            IRemoteFileSubSystem fs = RemoteFileUtility.getFileSubSystem((IHost)host);
            try {
                IRemoteFile f = fs.getRemoteFileObject(fAuthCertificateText.getText(), (IProgressMonitor)new NullProgressMonitor());
                if (f == null || !f.exists()) {
                    this.helper.displayErrorMessage(NLS.bind((String)ProfileMessages.CRRDG9187, (Object)fAuthCertificateText.getText()), (Control)fAuthCertificateText);
                } else if (!f.canRead()) {
                    this.helper.displayErrorMessage(NLS.bind((String)ProfileMessages.CRRDG9190, (Object)fAuthCertificateText.getText()), (Control)fAuthCertificateText);
                } else if (f.toString().length() > 254) {
                    this.helper.displayErrorMessage(ProfileMessages.CRRDG9188, (Control)fAuthCertificateText);
                } else if (!f.isFile()) {
                    this.helper.displayErrorMessage(ProfileMessages.CRRDG9189, (Control)fAuthCertificateText);
                }
            }
            catch (SystemMessageException e) {
                this.helper.displayErrorMessage(NLS.bind((String)ProfileMessages.CRRDG9187, (Object)fAuthCertificateText.getText()), (Control)fAuthCertificateText);
            }
        } else {
            String dsName = fAuthCertificateText.getText();
            if (dsName != null && !dsName.trim().isEmpty()) {
                String msg = DebugLaunchUIUtils.validateDatasetOrMemberName((String)connName, (String)dsName);
                if (msg != null) {
                    this.helper.displayErrorMessage(msg, (Control)fAuthCertificateText);
                } else {
                    IZOSSystemImage connection = (IZOSSystemImage)PhysicalSystemRegistryFactory.getSingleton().find(connName, 2);
                    IZOSCatalog root = (IZOSCatalog)connection.getRoot();
                    if (root != null) {
                        IAdaptable dsm;
                        String name = fAuthCertificateText.getText();
                        int dsIndex = name.indexOf(40);
                        IAdaptable iAdaptable = dsm = dsIndex == -1 ? root.findMember(name) : root.findMember(name.substring(0, dsIndex));
                        if (dsm instanceof ZOSSequentialDataSet) {
                            try {
                                ((ZOSSequentialDataSet)dsm).getContents();
                            }
                            catch (OperationFailedException e) {
                                this.helper.displayErrorMessage(NLS.bind((String)ProfileMessages.CRRDG9190, (Object)name), (Control)fAuthCertificateText);
                            }
                        } else {
                            this.helper.displayErrorMessage(ProfileMessages.CRRDG9189, (Control)fAuthCertificateText);
                        }
                    }
                }
            }
        }
    }

    public void updateMessage(CCombo field, String messages, String type) {
        this.helper.clearMessages((Control)field);
        switch (type) {
            case "warn": {
                this.helper.displayWarningMessage(messages, (Control)field);
                break;
            }
            case "error": {
                this.helper.displayErrorMessage(messages, (Control)field);
                break;
            }
            case "info": {
                this.helper.displayInfoMessage(messages, (Control)field);
                break;
            }
        }
    }

    public void updateMessage(Text field, String messages, String type) {
        this.helper.clearMessages((Control)field);
        switch (type) {
            case "warn": {
                this.helper.displayWarningMessage(messages, (Control)field);
                break;
            }
            case "error": {
                this.helper.displayErrorMessage(messages, (Control)field);
                break;
            }
            case "info": {
                this.helper.displayInfoMessage(messages, (Control)field);
                break;
            }
        }
    }

    public void updateMessage(Composite field, String messages, String type) {
        this.helper.clearMessages((Control)field);
        switch (type) {
            case "warn": {
                this.helper.displayWarningMessage(messages, (Control)field);
                break;
            }
            case "error": {
                this.helper.displayErrorMessage(messages, (Control)field);
                break;
            }
            case "info": {
                this.helper.displayInfoMessage(messages, (Control)field);
                break;
            }
        }
    }

    public void clearMessages(CCombo field) {
        this.helper.clearMessages((Control)field);
    }

    public void clearMessages(Composite field) {
        this.helper.clearMessages((Control)field);
    }

    public boolean checkIfEqualExistingProfileName(DebugProfile profile, Text fProfileNameText) {
        if (profile != null) {
            return profile.getName().equalsIgnoreCase(fProfileNameText.getText());
        }
        return false;
    }

    public void validateRegionCombo(CCombo fRegionCombo, DebugProfileEditorPage.REGION_STATE regionState, Connection c) {
        this.helper.clearMessages((Control)fRegionCombo);
        switch (regionState) {
            case PORT: {
                this.validatePort(fRegionCombo, ProfileMessages.CRRDG9117);
                break;
            }
            case LOCATION: {
                this.validateValueSpecified(fRegionCombo, ProfileMessages.CRRDG9142);
                break;
            }
            case REGION: {
                if (!fRegionCombo.getText().equals("")) {
                    String region = fRegionCombo.getText().toLowerCase();
                    if (!c.getAuthInvalidCicsRegions().contains(region)) break;
                    this.helper.clearMessages((Control)fRegionCombo);
                    this.helper.displayErrorMessage(c.getAuthInvalidCicsRegionErrorMessage(region), (Control)fRegionCombo);
                    break;
                }
                this.validateValueSpecified(fRegionCombo, ProfileMessages.CRRDG9103);
                break;
            }
            default: {
                this.validateValueSpecified(fRegionCombo, ProfileMessages.CRRDG9103);
            }
        }
    }

    public boolean validateAdvanceConnectionOptions(Button fConnectWithClientInfoButton, Text fConnectIPText, Text fConnectPortText, Text fConnectUserIDText) {
        String ip = fConnectIPText.getText();
        String port = fConnectPortText.getText();
        String id = fConnectUserIDText.getText();
        if (fConnectWithClientInfoButton.getSelection()) {
            if ((ip.trim().equals("") || port.trim().equals("")) && id.trim().equals("")) {
                if (ip.trim().equals("")) {
                    this.updateMessage(fConnectIPText, ProfileMessages.CRRDG9143, "error");
                }
                if (port.trim().equals("")) {
                    this.updateMessage(fConnectPortText, ProfileMessages.CRRDG9143, "error");
                }
                return false;
            }
        } else {
            this.helper.clearMessages((Control)fConnectIPText);
            this.helper.clearMessages((Control)fConnectPortText);
        }
        return true;
    }

    public void validateApplicationVersion(Text applicationVersionText) {
        this.helper.clearMessages((Control)applicationVersionText);
        String version = applicationVersionText.getText();
        if (version != null && !version.trim().isEmpty() && !version.matches(VERSION_REGEX)) {
            this.helper.displayErrorMessage(ProfileMessages.CRRDG9129, (Control)applicationVersionText);
        }
    }

    public void validateDataset(String connectionName, Text datasetEntry) {
        String msg;
        this.helper.clearMessages((Control)datasetEntry);
        String dsName = datasetEntry.getText();
        if (dsName != null && !dsName.trim().isEmpty() && (msg = DebugLaunchUIUtils.validateDatasetOrMemberName((String)connectionName, (String)dsName)) != null) {
            this.helper.displayErrorMessage(msg, (Control)datasetEntry);
        }
    }

    public void validateCommandEntry(String connectionName, Text datasetEntry) {
        String entry = datasetEntry.getText();
        if (entry == null || entry.trim().isEmpty() || this.isValidVADSCP(entry.trim())) {
            this.helper.clearMessages((Control)datasetEntry);
        } else {
            this.validateDataset(connectionName, datasetEntry);
        }
    }

    private boolean isValidVADSCP(String entry) {
        return entry.matches(VADSCP_FORMAT);
    }

    public boolean validateGenericCICSFields(Text fTransactionNameText, Text fUserIdText, Text fNetNameText, Text fIpText, Text fTermIDText, DelayDebugComposite fLoadModuleComposite, DTCNForceSettings settings) {
        if (LaunchzPICLPreferences.getIsGenericEditorWarningNeeded()) {
            this.helper.clearMessages((Control)fLoadModuleComposite);
            this.helper.clearMessages((Control)fUserIdText);
            this.helper.clearMessages((Control)fTermIDText);
            this.helper.clearMessages((Control)fIpText);
            this.helper.clearMessages((Control)fTransactionNameText);
            boolean isUserIDGeneric = fUserIdText.getText().trim().isEmpty() || fUserIdText.getText().trim().equals("*");
            boolean isTransactionGeneric = fTransactionNameText.getText().trim().isEmpty() || fTransactionNameText.getText().trim().equals("*");
            boolean isIPGeneric = fIpText.getText().trim().isEmpty();
            boolean isTerminalGeneric = fTermIDText.getText().trim().isEmpty();
            boolean isLoadModuleProgramGeneric = this.isGenericLoadModuleProgram(fLoadModuleComposite);
            if (isUserIDGeneric && isTerminalGeneric && isIPGeneric) {
                if (!isTransactionGeneric || !isLoadModuleProgramGeneric) {
                    this.helper.displayWarningMessage(ProfileMessages.CRRDG9157, (Control)fUserIdText);
                    this.helper.displayWarningMessage(ProfileMessages.CRRDG9157, (Control)fTermIDText);
                    this.helper.displayWarningMessage(ProfileMessages.CRRDG9157, (Control)fIpText);
                    this.validateDTCNFORCE(fTransactionNameText, fUserIdText, fNetNameText, fIpText, fTermIDText, fLoadModuleComposite, settings, false);
                    return false;
                }
                this.helper.displayWarningMessage(ProfileMessages.CRRDG9161, (Control)fLoadModuleComposite);
                this.helper.displayWarningMessage(ProfileMessages.CRRDG9161, (Control)fUserIdText);
                this.helper.displayWarningMessage(ProfileMessages.CRRDG9161, (Control)fTermIDText);
                this.helper.displayWarningMessage(ProfileMessages.CRRDG9161, (Control)fIpText);
                this.helper.displayWarningMessage(ProfileMessages.CRRDG9161, (Control)fTransactionNameText);
                this.validateDTCNFORCE(fTransactionNameText, fUserIdText, fNetNameText, fIpText, fTermIDText, fLoadModuleComposite, settings, false);
                return false;
            }
            if (isLoadModuleProgramGeneric && isTransactionGeneric) {
                this.helper.displayWarningMessage(ProfileMessages.CRRDG9159, (Control)fLoadModuleComposite);
                this.helper.displayWarningMessage(ProfileMessages.CRRDG9159, (Control)fTransactionNameText);
                this.validateDTCNFORCE(fTransactionNameText, fUserIdText, fNetNameText, fIpText, fTermIDText, fLoadModuleComposite, settings, false);
                return false;
            }
        }
        return this.validateDTCNFORCE(fTransactionNameText, fUserIdText, fNetNameText, fIpText, fTermIDText, fLoadModuleComposite, settings, true);
    }

    public boolean validateDTCNFORCE(Text fTransactionNameText, Text fUserIdText, Text fNetNameText, Text fIpText, Text fTermIDText, DelayDebugComposite fLoadModuleComposite, DTCNForceSettings settings, boolean clearMessages) {
        if (settings.isConfigured()) {
            String termID;
            String ip;
            String userid;
            boolean result = true;
            if (clearMessages) {
                if (fLoadModuleComposite != null) {
                    this.helper.clearMessages((Control)fLoadModuleComposite);
                }
                this.helper.clearMessages((Control)fNetNameText);
                this.helper.clearMessages((Control)fUserIdText);
                this.helper.clearMessages((Control)fTermIDText);
                this.helper.clearMessages((Control)fIpText);
                this.helper.clearMessages((Control)fTransactionNameText);
            }
            if (settings.isTransactionRequired()) {
                this.helper.clearMessages((Control)fTransactionNameText);
                String transaction = fTransactionNameText.getText().trim();
                if (transaction.equals("") || transaction.equals("*")) {
                    this.helper.clearMessages((Control)fTransactionNameText);
                    this.helper.displayErrorMessage(ProfileMessages.CRRDG9174, (Control)fTransactionNameText);
                    result = false;
                }
            }
            if (settings.isUserIDRequired() && ((userid = fUserIdText.getText().trim()).equals("") || userid.equals("*"))) {
                this.helper.clearMessages((Control)fUserIdText);
                this.helper.displayErrorMessage(ProfileMessages.CRRDG9175, (Control)fUserIdText);
                result = false;
            }
            if (settings.isIPRequired() && ((ip = fIpText.getText().trim()).equals("") || ip.equals("*"))) {
                this.helper.clearMessages((Control)fIpText);
                this.helper.displayErrorMessage(ProfileMessages.CRRDG9177, (Control)fIpText);
                result = false;
            }
            if (settings.isNetNameRequired() && ((ip = fIpText.getText().trim()).equals("") || ip.equals("*"))) {
                this.helper.clearMessages((Control)fNetNameText);
                this.helper.displayErrorMessage(ProfileMessages.CRRDG9177, (Control)fNetNameText);
                result = false;
            }
            if (fLoadModuleComposite != null && (settings.isLoadModRequired() || settings.isCURequired())) {
                List list = fLoadModuleComposite.getDebugItems();
                boolean hasCU = !settings.isCURequired();
                boolean hasLoadModule = !settings.isLoadModRequired();
                for (DebugItem item : list) {
                    if (item.getModule().equals(Labels.ADD_NEW_ITEM)) continue;
                    if (!(hasLoadModule || item.getModule().equals("") || item.getModule().equals("*"))) {
                        hasLoadModule = true;
                    }
                    if (hasCU || item.getProgram().equals("") || item.getProgram().equals("*")) continue;
                    hasCU = true;
                }
                if (!hasCU && settings.isCURequired() || !hasLoadModule && settings.isLoadModRequired()) {
                    result = false;
                    this.helper.clearMessages((Control)fLoadModuleComposite);
                    if (!hasCU && settings.isCURequired()) {
                        this.helper.displayErrorMessage(ProfileMessages.CRRDG9178, (Control)fLoadModuleComposite);
                    }
                    if (!hasLoadModule && settings.isLoadModRequired()) {
                        this.helper.displayErrorMessage(ProfileMessages.CRRDG9179, (Control)fLoadModuleComposite);
                    }
                }
            }
            if (settings.isTerminalIDRequired() && ((termID = fTermIDText.getText().trim()).equals("") || termID.equals("*"))) {
                this.helper.clearMessages((Control)fTermIDText);
                this.helper.displayErrorMessage(ProfileMessages.CRRDG9180, (Control)fTermIDText);
                result = false;
            }
            return result;
        }
        return true;
    }

    public boolean validateGenericNonCICSFields(DelayDebugComposite fLoadModuleComposite, Text fJobNameText, Text fStepNameText, Text fSubsystemIDText, Text fTransactionIDText) {
        if (LaunchzPICLPreferences.getIsGenericEditorWarningNeeded()) {
            this.helper.clearMessages((Control)fLoadModuleComposite);
            if (fJobNameText != null && fJobNameText.getText().trim().isEmpty() && fStepNameText != null && fStepNameText.getText().trim().isEmpty() && fSubsystemIDText != null && fSubsystemIDText.getText().trim().isEmpty() && fTransactionIDText != null && fTransactionIDText.getText().trim().isEmpty() && this.isGenericLoadModuleProgram(fLoadModuleComposite)) {
                this.helper.displayWarningMessage(ProfileMessages.CRRDG9155, (Control)fLoadModuleComposite);
                return false;
            }
        }
        return true;
    }

    private boolean isGenericLoadModuleProgram(DelayDebugComposite fLoadModuleComposite) {
        List items = fLoadModuleComposite.getDebugItems();
        if (items != null) {
            if (items.size() == 1) {
                return true;
            }
            for (DebugItem item : items) {
                if (!item.getModule().equals("*") || !item.getProgram().equals("*")) continue;
                return true;
            }
        }
        return false;
    }

    public static void validateDPS(boolean connected, boolean enabled, CCombo fConnectionCombo, MessageManagerHelper helper) {
        if (!enabled) {
            helper.displayErrorMessage(ProfileMessages.CRRDG9166, (Control)fConnectionCombo);
        }
    }
}

